<!--
	Files(WEBե붦ͭPHPץ)

	̥֥롼󡦥ե

  	files_com.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004 Technoworks Co., Ltd. All rights reserved.

	Last Update:	2004/05/23
-->
<?php

error_reporting(E_ERROR);

$FILES_PROGRAM_NAME = "Files";

$FILES_VERSION_NO = "1.0.3";

$FILES_COPYRIGHT_STR =  "Copyright (c) 2004" .
			" Technoworks Co., Ltd." .
			" All right reserved";

$MY_HOME_PAGE_URL = "http://www.technoworks.co.jp/";

#$DEBUG_LOG = TRUE;
$DEBUG_LOG = FALSE;

function get_version_no()
{
	return $GLOBALS["FILES_VERSION_NO"];
}

function get_copyright_str()
{
	return $GLOBALS["FILES_COPYRIGHT_STR"];
}

function get_program_name()
{
	return $GLOBALS["FILES_PROGRAM_NAME"];
}

function get_homepage()
{
	return $GLOBALS["MY_HOME_PAGE_URL"];
}

function disp_message($conf, $msg)
{
	$bgstr = get_body_bg_str($conf);
	echo "<HTML><HEAD>\n";
	echo "<META http-equiv=Content-Type content=\"text/html; CHARSET=euc-jp\">";
	echo "<TITLE>" . $conf["HEADER_TITLE"] . "</TITLE></HEAD>";
	echo "<BODY " . $bgstr . ">";
	echo $msg . "<BR>\n";
	echo "</BODY></HTML>\n";
}

function get_post_get_val($val_name)
{
	$val = "";

	if (isset($$val_name)) {
		$val = $$val_name;
	} else {
		if (isset($_POST) && isset($_POST[$val_name])) {
			$val = $_POST[$val_name];
		} else if (isset($_GET) && isset($_GET[$val_name])) {
			$val = $_GET[$val_name];
		} else if (isset($HTTP_POST_VARS) && isset($HTTP_POST_VARS[$val_name])) {
			$val = $HTTP_POST_VARS[$val_name];
		} else if (isset($HTTP_GET_VARS) && isset($HTTP_GET_VARS[$val_name])) {
			$val = $HTTP_GET_VARS[$val_name];
		} else if (isset($GLOBALS) && isset($GLOBALS[$val_name])) {
			$val = $GLOBALS[$val_name];
		}
	}
	if (get_magic_quotes_gpc()) {
		$val = stripslashes($val);
	}
	return $val;
}

function get_env_val($val_name)
{
	$val = "";

	if (isset($$val_name)) {
		$val = $$val_name;
	} else {
		if (isset($_ENV) && isset($_ENV[$val_name])) {
			$val = $_POST[$val_name];
		} else if (isset($HTTP_ENV_VARS) && isset($HTTP_ENV_VARS[$val_name])) {
			$val = $HTTP_ENV_VARS[$val_name];
		} else if (isset($GLOBALS) && isset($GLOBALS[$val_name])) {
			$val = $GLOBALS[$val_name];
		}
	}
	if (get_magic_quotes_gpc()) {
		$val = stripslashes($val);
	}
	return $val;
}

function get_session_value($val_name)
{
	if (isset($_SESSION) && $_SESSION[$val_name]) {
		return $_SESSION[$val_name];
	}
	if (isset($HTTP_SESSION_VARS) && $HTTP_SESSION_VARS[$val_name]) {
		return $HTTP_SESSION_VARS[$val_name];
	}
	return "";
}

function set_session_value($val_name, $value)
{
	if (isset($_SESSION)) {
		$_SESSION[$val_name] = $value;
	} else if ($HTTP_SESSION_VARS) {
		$HTTP_SESSION_VARS[$val_name] = $value;
	}
}

//ѥɤMD5ϥå岽뤫
function is_md5_use($conf)
{
	//ѥɤMD5ϥåѤ뤫
	if (strcasecmp($conf["MD5_PASSWD_USE"], "NO") == 0) {
		return FALSE;
	} elseif (strcasecmp($conf["MD5_PASSWD_USE"], "NO_MAC") == 0) {
		$chk_val = get_env_val("HTTP_UA_OS");
		if (isset($chk_val) && $chk_val != "") {
			if (stristr($chk_val, "MacOS") != FALSE) {
				return TRUE;
			}
		} else {
			$chk_val = get_env_val("HTTP_USER_AGENT");
			if (stristr($chk_val, "Mac") != FALSE) {
				return FALSE;
			}
		}
	}
	return TRUE;
}

// եURLܸ줬äƤʸɤʸѴ
function conv_url_code($srcurl)
{
	$ret_url = "";

/*****	ޥХʸؿmbstringˤȤ
	$len = mb_strlen($srcurl);
	for ($i = 0; $i < $len; $i++) {
		$char = mb_substr($srcurl, $i, 1);
		if (mb_detect_encoding($char) == "ASCII") {
			$ret_url .= $char;
		} else {
			$ret_url .= urlencode($char);
		}
	}
*****/
	$len = strlen($srcurl);
	$i = 0;
	while ($i < $len) {
		$char = substr($srcurl, $i++, 1);
		if (ord($char) <= 0x7f) {
			$ret_url .= $char;
		} else {
			if ($i < $len) {
				$char .= substr($srcurl, $i++, 1);
			}
			$ret_url .= urlencode($char);
		}
	}
/****/
	return $ret_url;
}

//å
function lock_files($lockfname)
{
	if (($lock_fp = fopen($lockfname, "w"))) {
		flock($lock_fp, 2);
		return $lock_fp;
	}
	return 0;
}

//å
function unlock_files($fp, $lockfname)
{
	flock($fp, 3);
	fclose($fp);
	unlink($lockfname);
}

//ѥΥե̾ʬΤߤФ
function get_filename($dir)
{
	$flds = split("/", $dir);
	$filename = array_pop($flds);

	return $filename;
}

//ѥΥǥ쥯ȥѥʬΤߤФ
//ʥѥǥ쥯ȥ̾ξϾ̥ǥ쥯ȥΥѥ֤
function get_dirpath($dir)
{
	$flds = split("/", $dir);
	if (count($flds) > 0) {
		$tmp = array_pop($flds);
		$num = count($flds);
		if ($num > 1) {
			$updir = join("/", $flds);
		} elseif ($num > 0) {
			$updir = $flds[0];
		} else {
			$updir = "";
		}
	} else {
		$updir = "";
	}
	return $updir;
}

//եѥȤΩƤ
function make_path($basedir, $dir, $fname)
{
	$path = $basedir;

	if ($dir != "") {
		if ($path != "") {
			$path .= "/";
		}
		$path .= $dir;
	}
	if ($fname != "") {
		if ($path != "") {
			$path .= "/";
		}
		$path .= $fname;
	}

	return $path;
}

//Υ̾¸ߥå
function is_key_exist($keyname, $arry)
{
	foreach(array_keys($arry) as $key) {
		if ($key == $keyname) {
			return TRUE;
		}
	}
	return FALSE;
}

// ǥ쥯ȥΥե륵ιפ
function get_dir_use_size($top_dir)
{
	$dir_size = 0;

	if ($dir = @opendir($top_dir)) {
		while (($file = readdir($dir)) !== false) {
			if (strcmp($file, ".") != 0 && strcmp($file, "..") != 0) {
				$filepath = make_path($top_dir, "", $file);
				if (is_dir($filepath)) {
					$dir_size += get_dir_use_size($filepath);
				} else {
					$dir_size += filesize($filepath);
				}
			}
		}  
		closedir($dir);
	}
	return $dir_size;
}

// ޶ڤʸΥޤ
function conv_comma_val($comma_val)
{
	$valstr = "";

	$vals = split(",", $comma_val);

	foreach($vals as $val) {
		$valstr .= $val;
	}
	return $valstr;
}

// ͤ3ŤĤΥ޶ڤˤ
function make_comma_val($val)
{
	$tmpstr = "";
	$valstr = "";

	$len = strlen($val);
	for ($i = 0, $p = $len - 1; $i < $len; $i++, $p--) {
		if ($i > 0 && $i % 3 == 0) {
			$tmpstr .= ",";
		}
		$tmpstr .= substr($val, $p, 1);
	}
	$len = strlen($tmpstr);
	for ($i = 0, $p = $len - 1; $i < $len; $i++, $p--) {
		$valstr .= substr($tmpstr, $p, 1);
	}
	return $valstr;
}

// ե륵ɽѤʸ123MB123KBˤ
function get_filesize_str($filesize)
{
	$filesize_str = "";

	if ($filesize >= 1000) {
		$filesize_str = (int)($filesize / 1000);
		$filesize_str = make_comma_val($filesize_str);
		$filesize_str .= "K";
	} else {
		$filesize_str = $filesize;
		$filesize_str = make_comma_val($filesize_str);
	}
	return $filesize_str;
}

// եΥ󥤥᡼̾
function get_file_image($dir, $fname)
{
	$ftype_img = array(
		"xls" => "excel.png",
		"csv" => "excel.png",
		"doc" => "word.png",
		"rtf" => "word.png",
		"wri" => "wordpad.png",
		"lzh" => "lzh.png",
		"zip" => "lzh.png",
		"z" => "lzh.png",
		"gz" => "lzh.png",
		"tar" => "lzh.png",
		"tgz" => "lzh.png",
		"tz" => "lzh.png",
		"bz2" => "lzh.png",
		"pdf" => "pdf.png",
		"txt" => "text.png",
		"log" => "text.png",
		"pl" => "text.png",
		"pm" => "text.png",
		"sql" => "text.png",
		"eml" => "mail.png",
		"htm" => "html.png",
		"html" => "html.png",
		"php" => "html.png",
		"bmp" => "bmp.png",
		"gif" => "gif.png",
		"jpg" => "gif.png",
		"jpeg" => "gif.png",
		"tif" => "gif.png",
		"tiff" => "gif.png",
		"png" => "gif.png",
		"wav" => "wav.png",
		"ra" => "wav.png",
		"ram" => "wav.png",
		"rm" => "wav.png",
		"mp3" => "wav.png",
		"au" => "wav.png",
		"snd" => "wav.png",
		"mid" => "sound.png",
		"midi" => "sound.png",
		"avi" => "movie.png",
		"mpg" => "movie.png",
		"mpg2" => "movie.png",
		"mpeg" => "movie.png",
		"mpeg2" => "movie.png",
		"mov" => "movie.png",
		"movie" => "movie.png",
		"qt" => "movie.png",
		"exe" => "lzh.png",
		"dir" => "folder.png",
		"updir" => "up.png",
		"unknown" => "unknown.png"
	);

	$path = make_path($dir, "", $fname);

	//󥤥᡼
	if ($fname == "..") {
		//̥ǥ쥯ȥξ
		$img = $ftype_img["updir"];
	} elseif ($fname == ".") {
		//ȥǥ쥯ȥξ
		$img = $ftype_img["dir"];
	} elseif (is_dir($path)) {
		//ǥ쥯ȥξ
		$img = $ftype_img["dir"];
	} else {
		//ĥҤФ
		$arr_ext = split("\.", $fname);
		if (count($arr_ext) > 0) {
			//ĥҤ
			$ext = array_pop($arr_ext);
			$ext = strtolower($ext);
			if (is_key_exist($ext, $ftype_img)) {
				//̥᡼
				$img = $ftype_img[$ext];
			} else {
				//̥᡼ʤ
				$img = $ftype_img["unknown"];
			}
		} else {
			//ĥҤʤξ
			$img = $ftype_img["unknown"];
		}
	}
	return $img;
}

// եɤ߹
function read_conf_file($conffile)
{
	//եǤ
	$topdir = getcwd();
	$conf = array(
		"CONFIG_DIR" => 0,
		"CONFIG_DIR_URL" => "",
		"CONFIG_TOP_DIR" => "./config",
		"CONFIG_TOP_URL" => "./config",
		"SCRIPT_DIR_URL" => "",
		"LISTFILE" => ".files.lst",
		"LOCKFILE" => ".lock_files.lock",
		"LOGFILE" => "./files.log",
		"OUTPUT_LOG" => 0,
		"PASSWD_FILE" => "",
		"IMGDIR" => "./images",
		"TOPDIR" => ".",
		"TOPURL" => ".",
		"CUTDIR" => "",
		"CUTURL" => "",
		"HEADER_TITLE" => "ե",
		"TITLEIMG" => "",
		"ptitleimg_h" => "200",
		"ptitleimg_w" => "35",
		"TITLESTR" => "ե",
		"TITLE_COMMENT_LOGIN" => "",
		"TITLE_COMMENT_FILES" => "",
		"TITLE_COMMENT_EDIT" => "",
		"TITLE_COMMENT_DELETE" => "",
		"TITLE_COMMENT_MKDIR" => "",
		"TITLE_COMMENT_UPLOAD" => "",
		"LOGIN_TITLE" => "",
		"RETURL1" => "",
		"returntitle1" => "",
		"RETURL2" => "",
		"returntitle2" => "",
		"FILES_SCRIPT" => "files.php",
		"EDIT_SCRIPT" => "edit.php",
		"DELETE_SCRIPT" => "delete.php",
		"COPY_SCRIPT" => "cut.php",
		"CUT_SCRIPT" => "cut.php",
		"PASTE_SCRIPT" => "paste.php",
		"MKDIR_SCRIPT" => "mkdir.php",
		"UPLOAD_SCRIPT" => "upload.php",
		"ATTR_SCRIPT" => "attr.php",
		"LOGIN_SCRIPT" => "login.php",
		"PASSWD_SCRIPT" => "passwd.php",
		"CONFMENU_SCRIPT" => "confmenu.php",
		"NEWCONF_SCRIPT" => "newconf.php",
		"DELCONF_SCRIPT" => "delconf.php",
		"MODCONF_SCRIPT" => "modconf.php",
		"DIRLIST_SCRIPT" => "dirlist.php",
		"UPLOAD_CGI" => "upload.php",
		"DIR_IMAGE" => "folder.png",
		"UP_IMAGE" => "up.png",
		"UP_TITLE" => "̤Υե",
		"EDIT_IMAGE" => "edit.png",
		"DELETE_IMAGE" => "delete.png",
		"COPY_IMAGE" => "copy.png",
		"CUT_IMAGE" => "cut.png",
		"PASTE_IMAGE" => "paste.png",
		"BG_IMAGE" => "",
		"BG_COLOR" => "",
		"ICONSIZE" => "24",
		"ICON_W" => "20",
		"ICON_H" => "24",
		"CALLER_URL" => "",
		"MAX_UPLOAD_SIZE" => 10000000,
		"MAX_TOTAL_SIZE" => 500000000,
		"SORT_KEY" => "time",
		"REVERSE_SORT" => 1,
		"LIST_TITLE_BG" => "#cfccf0",
		"LIST_HEAD_BG" => "#a00ca4",
		"LIST_TITLE_BG2" => "#f0cccf",
		"LIST_HEAD_BG2" => "#a00ca4",
		"ADMIN_USERID" => "",
		"MD5_PASSWD_USE" => "",
		"curdir" => "",
		"cururl" => "",
		"returl" => "",
		"title" => "",
		"config" => "./files.conf"
	);

	$conf["config"] = $conffile;

	// ե̾̾Ф
	$conf["name"] = basename($conffile, ".conf");

	if (! file_exists($conffile)) {
		echo "config file ($conffile) not exist\n";
		exit;
	}
	if (!($fp = fopen ($conffile, "r"))) {
		echo "config file ($conffile) ca not open\n";
		exit;
	}
	flock($fp, 2);

	while (!feof ($fp)) {
		//ɤ߹
		$buffer = fgets($fp, 4096);
		$buffer = chop($buffer);

		if (strlen($buffer) < 3) {	//㣲ܤʤΤǣʸʲιԤϼΤƤ
			continue;
		}
		if (substr($buffer, 0, 1) == "#") {	//ȹԤϥå
			continue;
		}
		//Ԥԣ¤ʬ
		$flds = split("\t", $buffer);

		//եɤ뤳
		if ($flds[0] != "") {
			switch ($flds[0]) {
			case "CONFIG_DIR":	//ѥǥ쥯ȥ꤫
				$conf["CONFIG_DIR"] = $flds[1];
				break;
			case "CONFIG_TOP_DIR":	//եǥ쥯ȥδ
				$conf["CONFIG_TOP_DIR"] = $flds[1];
				break;
			case "CONFIG_TOP_URL":	//եǥ쥯ȥδգң
				$conf["CONFIG_TOP_URL"] = $flds[1];
				break;
			case "LISTFILE":	//ꥹȥե̾
				$conf["LISTFILE"] = $flds[1];
				break;
			case "LOCKFILE":	//åե̾
				$conf["LOCKFILE"] = $flds[1];
				break;
			case "LOGFILE":		//ե̾
				$conf["LOGFILE"] = $flds[1];
				break;
			case "OUTPUT_LOG":	//Ϥ뤫
				$conf["OUTPUT_LOG"] = $flds[1];
				break;
			case "PASSWD_FILE":		//ѥɥե
				$conf["PASSWD_FILE"] = $flds[1];
				break;
			case "IMGDIR":		//᡼ǥ쥯ȥ
				$conf["IMGDIR"] = $flds[1];
				break;
			case "CUTDIR":		//åȥХåեΥǥ쥯ȥ
				$conf["CUTDIR"] = $flds[1];
				break;
			case "CUTURL":		//åȥХåեǥ쥯ȥURL
				$conf["CUTURL"] = $flds[1];
				break;
			case "TOPDIR":		//ԣϣХǥ쥯ȥ
				$conf["TOPDIR"] = $flds[1];
				if ($flds[2] != "") {
					$conf["toptitle"] = $flds[2];
				}
				break;
			case "TOPURL":		//ԣϣХǥ쥯ȥΣգң
				$conf["TOPURL"] = $flds[1];
				break;
			case "HEADER_TITLE":	//إåΥȥ
				$conf["HEADER_TITLE"] = $flds[1];
				break;
			case "TITLEIMG":	//ȥ륤᡼
				$conf["TITLEIMG"] = $flds[1];
				if ($flds[2] != "") {
					$conf["ptitleimg_w"] = $flds[2];
				}
				if ($flds[3] != "") {
					$conf["ptitleimg_h"] = $flds[3];
				}
				break;
			case "TITLESTR":	//ȥʸ
				$conf["TITLESTR"] = $flds[1];
				break;
			case "TITLE_COMMENT_LOGIN":	//̤Υȹ
				$conf["TITLE_COMMENT_LOGIN"] = $flds[1];
				break;
			case "TITLE_COMMENT_FILES":	//ե̤Υȹ
				$conf["TITLE_COMMENT_FILES"] = $flds[1];
				break;
			case "TITLE_COMMENT_EDIT":	//Խ̤Υȹ
				$conf["TITLE_COMMENT_EDIT"] = $flds[1];
				break;
			case "TITLE_COMMENT_DELETE":	//̤Υȹ
				$conf["TITLE_COMMENT_DELETE"] = $flds[1];
				break;
			case "TITLE_COMMENT_MKDIR":	//ե̤Υȹ
				$conf["TITLE_COMMENT_MKDIR"] = $flds[1];
				break;
			case "TITLE_COMMENT_UPLOAD":	//åץɲ̤Υȹ
				$conf["TITLE_COMMENT_UPLOAD"] = $flds[1];
				break;
			case "LOGIN_TITLE":	//󡦥ȥ
				$conf["LOGIN_TITLE"] = $flds[1];
				break;
			case "RETURL1":		//URL
				$conf["RETURL1"] = $flds[1];
				if ($flds[2] != "") {
					$conf["returntitle1"] = $flds[2];
				} else {
					$conf["returntitle1"] = $flds[1];
				}
				break;
			case "RETURL2":		//URL
				$conf["RETURL2"] = $flds[1];
				if ($flds[2] != "") {
					$conf["returntitle2"] = $flds[2];
				} else {
					$conf["returntitle2"] = $flds[1];
				}
				break;
			case "FILES_SCRIPT":	//եץ
				$conf["FILES_SCRIPT"] = $flds[1];
				break;
			case "EDIT_SCRIPT":		//Խץ
				$conf["EDIT_SCRIPT"] = $flds[1];
				break;
			case "DELETE_SCRIPT":	//ץ
				$conf["DELETE_SCRIPT"] = $flds[1];
				break;
			case "COPY_SCRIPT":		//ʣ̥ץ
				$conf["COPY_SCRIPT"] = $flds[1];
				break;
			case "CUT_SCRIPT":		//ڼꥹץ
				$conf["CUT_SCRIPT"] = $flds[1];
				break;
			case "PASTE_SCRIPT":	//Žդץ
				$conf["PASTE_SCRIPT"] = $flds[1];
				break;
			case "MKDIR_SCRIPT":	//եץ
				$conf["MKDIR_SCRIPT"] = $flds[1];
				break;
			case "UPLOAD_SCRIPT":	//ե륢åץɥץ
				$conf["UPLOAD_SCRIPT"] = $flds[1];
				break;
			case "ATTR_SCRIPT":		//ե°ѹץ
				$conf["ATTR_SCRIPT"] = $flds[1];
				break;
			case "LOGIN_SCRIPT":	//󥹥ץ
				$conf["LOGIN_SCRIPT"] = $flds[1];
				break;
			case "PASSWD_SCRIPT":	//ѥꥹץ
				$conf["PASSWD_SCRIPT"] = $flds[1];
				break;
			case "CONFMENU_SCRIPT":	//˥塼ץ
				$conf["CONFMENU_SCRIPT"] = $flds[1];
				break;
			case "NEWCONF_SCRIPT":	//ͭեץ
				$conf["NEWCONF_SCRIPT"] = $flds[1];
				break;
			case "DELCONF_SCRIPT":	//ͭեץ
				$conf["DELCONF_SCRIPT"] = $flds[1];
				break;
			case "MODCONF_SCRIPT":	//ͭե깹ץ
				$conf["MODCONF_SCRIPT"] = $flds[1];
				break;
			case "DIRLIST_SCRIPT":	//ͭեץ
				$conf["DIRLIST_SCRIPT"] = $flds[1];
				break;
			case "UPLOAD_CGI":	//ե륢åץCGI
				$conf["UPLOAD_CGI"] = $flds[1];
				break;
			case "DIR_IMAGE":		//ե᡼
				$conf["DIR_IMAGE"] = $flds[1];
				break;
			case "UP_IMAGE":		//̥ե᡼
				$conf["UP_IMAGE"] = $flds[1];
				break;
			case "UP_TITLE":		//̥եؤΥȥʸ
				$conf["UP_TITLE"] = $flds[1];
				break;
			case "EDIT_IMAGE":		//Խ᡼
				$conf["EDIT_IMAGE"] = $flds[1];
				break;
			case "DELETE_IMAGE":	//ե᡼
				$conf["DELETE_IMAGE"] = $flds[1];
				break;
			case "COPY_IMAGE":		//եʣ̥᡼
				$conf["COPY_IMAGE"] = $flds[1];
				break;
			case "CUT_IMAGE":		//եڼꥤ᡼
				$conf["CUT_IMAGE"] = $flds[1];
				break;
			case "PASTE_IMAGE":		//եŽդ᡼
				$conf["PASTE_IMAGE"] = $flds[1];
				break;
			case "BG_IMAGE":	//طʥ᡼
				$conf["BG_IMAGE"] = $flds[1];
				break;
			case "BG_COLOR":	//طʿ
				$conf["BG_COLOR"] = $flds[1];
				break;
			case "ICONSIZE":		//󥵥
				$conf["ICONSIZE"] = $flds[1];
				break;
			case "ICON_W":		//󥵥
				$conf["ICON_W"] = $flds[1];
				break;
			case "ICON_H":		//󥵥⤵
				$conf["ICON_H"] = $flds[1];
				break;
			case "CALLER_URL":		//ƤӽФգң
				$conf["CALLER_URL"] = $flds[1];
				break;
			case "MAX_UPLOAD_SIZE":	//åץɥեMAX
				if ($flds[1] != "") {
					$conf["MAX_UPLOAD_SIZE"] = conv_comma_val($flds[1]);
				}
				break;
			case "MAX_TOTAL_SIZE":	//̤MAX
				if ($flds[1] != "") {
					$conf["MAX_TOTAL_SIZE"] = conv_comma_val($flds[1]);
				}
				break;
			case "SORT_KEY":		//ǥեȤΥȥ
				$conf["SORT_KEY"] = $flds[1];
				break;
			case "REVERSE_SORT":	//Ƚ
				$conf["REVERSE_SORT"] = $flds[1];
				break;
			case "LIST_TITLE_BG":	//ɽΥȥطʿ
				$conf["LIST_TITLE_BG"] = $flds[1];
				break;
			case "LIST_HEAD_BG":	//ɽΥإåطʿ
				$conf["LIST_HEAD_BG"] = $flds[1];
				break;
			case "LIST_TITLE_BG2":	//ɽΥȥطʿ
				$conf["LIST_TITLE_BG2"] = $flds[1];
				break;
			case "LIST_HEAD_BG2":	//ɽΥإåطʿ
				$conf["LIST_HEAD_BG2"] = $flds[1];
				break;
			case "ADMIN_USERID":	//ID
				$conf["ADMIN_USERID"] = $flds[1];
				break;
			case "MD5_PASSWD_USE":	//ѥɤMD5ϥåѤ뤫
				$conf["MD5_PASSWD_USE"] = $flds[1];
				break;
			}
		}
	}
	flock($fp, 3);
	fclose($fp);

	$conf["SCRIPT_DIR_URL"] = dirname($_SERVER['SCRIPT_NAME']);

	//եΤǥ쥯ȥURL
	$conf["CONFIG_DIR_URL"] = get_conf_top_url($conf) . "/" . $conf["name"];

	if ($conf["CUTDIR"] == "" && $conf["TOPDIR"] != "") {
		$conf["CUTDIR"] = $conf["TOPDIR"] . "/.cutbuf";
	}
	if ($conf["CUTURL"] == "" && $conf["TOPURL"] != "") {
		$conf["CUTURL"] = $conf["TOPURL"] . "/.cutbuf";
	}

	return $conf;
}

// ե񤭹
function write_conf_file($conf, $new_conf, $new_conffile)
{
	if (! file_exists($conf["config"])) {
		echo "config file (" . $conf["config"] . ") not exist\n";
		return FALSE;
	}
	// ե롦ץ
	if (!($ifp = fopen ($conf["config"], "r"))) {
		echo "config file ($conffile) can not open\n";
		return FALSE;
	}
	flock($ifp, 2);

	// ե롦ץ
	if (!($ofp = fopen ($new_conffile, "w"))) {
		echo "new config file ($new_conffile) can not open\n";
		return FALSE;
	}
	flock($ofp, 2);

	while (!feof ($ifp)) {
		//ɤ߹
		$buffer = fgets($ifp, 4096);
		$buffer = chop($buffer);

		$str = "";
		if (substr($buffer, 0, 1) == "#") {
			//ȹԤϤΤޤ޽
			$str = $buffer;
		} else if (strlen($buffer) < 3) {
			//㣲ܤʤΤǣʸʲιԤϤΤޤ޽
			$str = $buffer;
		} else {
			//Ԥԣ¤ʬ
			$flds = split("\t", $buffer);

			//եɤ̵ԤϤΤޤ޽
			if ($flds[0] == "") {
				$str = $buffer;
			} else {
				switch ($flds[0]) {
				case "CONFIG_DIR":
					$str = $flds[0] . "\t" . $new_conf["CONFIG_DIR"];
					break;
				case "CONFIG_TOP_DIR":	//եǥ쥯ȥδ
					$str = $flds[0] . "\t" . $new_conf["CONFIG_TOP_DIR"];
					break;
				case "CONFIG_TOP_URL":	//եǥ쥯ȥδգң
					$str = $flds[0] . "\t" . $new_conf["CONFIG_TOP_URL"];
					break;
				case "LISTFILE":	//ꥹȥե̾
					$str = $flds[0] . "\t" . $new_conf["LISTFILE"];
					break;
				case "LOCKFILE":	//åե̾
					$str = $flds[0] . "\t" . $new_conf["LOCKFILE"];
					break;
				case "LOGFILE":		//ե̾
					$str = $flds[0] . "\t" . $new_conf["LOGFILE"];
					break;
				case "OUTPUT_LOG":	//Ϥ뤫
					$str = $flds[0] . "\t" . $new_conf["OUTPUT_LOG"];
					break;
				case "PASSWD_FILE":		//ѥɥե
					$str = $flds[0] . "\t" . $new_conf["PASSWD_FILE"];
					break;
				case "IMGDIR":		//᡼ǥ쥯ȥ
					$str = $flds[0] . "\t" . $new_conf["IMGDIR"];
					break;
				case "CUTDIR":		//åȥХåեΥǥ쥯ȥ
					$str = $flds[0] . "\t" . $new_conf["CUTDIR"];
					break;
				case "CUTURL":		//åȥХåեǥ쥯ȥURL
					$str = $flds[0] . "\t" . $new_conf["CUTURL"];
					break;
				case "TOPDIR":		//ԣϣХǥ쥯ȥ
					$str = $flds[0] . "\t" . $new_conf["TOPDIR"];
					$str .= "\t" . $new_conf["toptitle"];
					break;
				case "TOPURL":		//ԣϣХǥ쥯ȥΣգң
					$str = $flds[0] . "\t" . $new_conf["TOPURL"];
					break;
				case "HEADER_TITLE":	//إåΥȥ
					$str = $flds[0] . "\t" . $new_conf["HEADER_TITLE"];
					break;
				case "TITLEIMG":	//ȥ륤᡼
					$str = $flds[0] . "\t" . $new_conf["TITLEIMG"];
					$str .= "\t" . $new_conf["ptitleimg_w"];
					$str .= "\t" . $new_conf["ptitleimg_h"];
					break;
				case "TITLESTR":	//ȥʸ
					$str = $flds[0] . "\t" . $new_conf["TITLESTR"];
					break;
				case "TITLE_COMMENT_LOGIN":	//̤Υȹ
					$str = $flds[0] . "\t" . $new_conf["TITLE_COMMENT_LOGIN"];
					break;
				case "TITLE_COMMENT_FILES":	//ե̤Υȹ
					$str = $flds[0] . "\t" . $new_conf["TITLE_COMMENT_FILES"];
					break;
				case "TITLE_COMMENT_EDIT":	//Խ̤Υȹ
					$str = $flds[0] . "\t" . $new_conf["TITLE_COMMENT_EDIT"];
					break;
				case "TITLE_COMMENT_DELETE":	//̤Υȹ
					$str = $flds[0] . "\t" . $new_conf["TITLE_COMMENT_DELETE"];
					break;
				case "TITLE_COMMENT_MKDIR":	//ե̤Υȹ
					$str = $flds[0] . "\t" . $new_conf["TITLE_COMMENT_MKDIR"];
					break;
				case "TITLE_COMMENT_UPLOAD":	//åץɲ̤Υȹ
					$str = $flds[0] . "\t" . $new_conf["TITLE_COMMENT_UPLOAD"];
					break;
				case "LOGIN_TITLE":	//󡦥ȥ
					$str = $flds[0] . "\t" . $new_conf["LOGIN_TITLE"];
					break;
				case "RETURL1":		//URL
					$str = $flds[0] . "\t" . $new_conf["RETURL1"];
					$str .= "\t" . $new_conf["returntitle1"];
					break;
				case "RETURL2":		//URL
					$str = $flds[0] . "\t" . $new_conf["RETURL2"];
					$str .= "\t" . $new_conf["returntitle2"];
					break;
				case "FILES_SCRIPT":	//եץ
					$str = $flds[0] . "\t" . $new_conf["FILES_SCRIPT"];
					break;
				case "EDIT_SCRIPT":		//Խץ
					$str = $flds[0] . "\t" . $new_conf["EDIT_SCRIPT"];
					break;
				case "DELETE_SCRIPT":	//ץ
					$str = $flds[0] . "\t" . $new_conf["DELETE_SCRIPT"];
					break;
				case "COPY_SCRIPT":		//ʣ̥ץ
					$str = $flds[0] . "\t" . $new_conf["COPY_SCRIPT"];
					break;
				case "CUT_SCRIPT":		//ڼꥹץ
					$str = $flds[0] . "\t" . $new_conf["CUT_SCRIPT"];
					break;
				case "PASTE_SCRIPT":	//Žդץ
					$str = $flds[0] . "\t" . $new_conf["PASTE_SCRIPT"];
					break;
				case "MKDIR_SCRIPT":	//եץ
					$str = $flds[0] . "\t" . $new_conf["MKDIR_SCRIPT"];
					break;
				case "UPLOAD_SCRIPT":	//ե륢åץɥץ
					$str = $flds[0] . "\t" . $new_conf["UPLOAD_SCRIPT"];
					break;
				case "ATTR_SCRIPT":		//ե°ѹץ
					$str = $flds[0] . "\t" . $new_conf["ATTR_SCRIPT"];
					break;
				case "LOGIN_SCRIPT":	//󥹥ץ
					$str = $flds[0] . "\t" . $new_conf["LOGIN_SCRIPT"];
					break;
				case "PASSWD_SCRIPT":	//ѥꥹץ
					$str = $flds[0] . "\t" . $new_conf["PASSWD_SCRIPT"];
					break;
				case "CONFMENU_SCRIPT":	//˥塼ץ
					$str = $flds[0] . "\t" . $new_conf["CONFMENU_SCRIPT"];
					break;
				case "NEWCONF_SCRIPT":	//ͭեץ
					$str = $flds[0] . "\t" . $new_conf["NEWCONF_SCRIPT"];
					break;
				case "DELCONF_SCRIPT":	//ͭեץ
					$str = $flds[0] . "\t" . $new_conf["DELCONF_SCRIPT"];
					break;
				case "MODCONF_SCRIPT":	//ͭե깹ץ
					$str = $flds[0] . "\t" . $new_conf["MODCONF_SCRIPT"];
					break;
				case "DIRLIST_SCRIPT":	//ͭեץ
					$str = $flds[0] . "\t" . $new_conf["DIRLIST_SCRIPT"];
					break;
				case "UPLOAD_CGI":	//ե륢åץCGI
					$str = $flds[0] . "\t" . $new_conf["UPLOAD_CGI"];
					break;
				case "DIR_IMAGE":		//ե᡼
					$str = $flds[0] . "\t" . $new_conf["DIR_IMAGE"];
					break;
				case "UP_IMAGE":		//̥ե᡼
					$str = $flds[0] . "\t" . $new_conf["UP_IMAGE"];
					break;
				case "UP_TITLE":		//̥եؤΥȥʸ
					$str = $flds[0] . "\t" . $new_conf["UP_TITLE"];
					break;
				case "EDIT_IMAGE":		//Խ᡼
					$str = $flds[0] . "\t" . $new_conf["EDIT_IMAGE"];
					break;
				case "DELETE_IMAGE":	//ե᡼
					$str = $flds[0] . "\t" . $new_conf["DELETE_IMAGE"];
					break;
				case "COPY_IMAGE":		//եʣ̥᡼
					$str = $flds[0] . "\t" . $new_conf["COPY_IMAGE"];
					break;
				case "CUT_IMAGE":		//եڼꥤ᡼
					$str = $flds[0] . "\t" . $new_conf["CUT_IMAGE"];
					break;
				case "PASTE_IMAGE":		//եŽդ᡼
					$str = $flds[0] . "\t" . $new_conf["PASTE_IMAGE"];
					break;
				case "BG_IMAGE":	//طʥ᡼
					$str = $flds[0] . "\t" . $new_conf["BG_IMAGE"];
					break;
				case "BG_COLOR":	//طʿ
					$str = $flds[0] . "\t" . $new_conf["BG_COLOR"];
					break;
				case "ICONSIZE":		//󥵥
					$str = $flds[0] . "\t" . $new_conf["ICONSIZE"];
					break;
				case "ICON_W":		//󥵥
					$str = $flds[0] . "\t" . $new_conf["ICON_W"];
					break;
				case "ICON_H":		//󥵥⤵
					$str = $flds[0] . "\t" . $new_conf["ICON_H"];
					break;
				case "CALLER_URL":		//ƤӽФգң
					$str = $flds[0] . "\t" . $new_conf["CALLER_URL"];
					break;
				case "MAX_UPLOAD_SIZE":	//åץɥեMAX
					$str = $flds[0] . "\t" . $new_conf["MAX_UPLOAD_SIZE"];
					break;
				case "MAX_TOTAL_SIZE":	//̤MAX
					$str = $flds[0] . "\t" . $new_conf["MAX_TOTAL_SIZE"];
					break;
				case "SORT_KEY":		//ǥեȤΥȥ
					$str = $flds[0] . "\t" . $new_conf["SORT_KEY"];
					break;
				case "REVERSE_SORT":	//Ƚ
					$str = $flds[0] . "\t" . $new_conf["REVERSE_SORT"];
					break;
				case "LIST_TITLE_BG":	//ɽΥȥطʿ
					$str = $flds[0] . "\t" . $new_conf["LIST_TITLE_BG"];
					break;
				case "LIST_HEAD_BG":	//ɽΥإåطʿ
					$str = $flds[0] . "\t" . $new_conf["LIST_HEAD_BG"];
					break;
				case "LIST_TITLE_BG2":	//ɽΥȥطʿ
					$str = $flds[0] . "\t" . $new_conf["LIST_TITLE_BG2"];
					break;
				case "LIST_HEAD_BG2":	//ɽΥإåطʿ
					$str = $flds[0] . "\t" . $new_conf["LIST_HEAD_BG2"];
					break;
				case "ADMIN_USERID":	//ID
					$str = $flds[0] . "\t" . $new_conf["ADMIN_USERID"];
					break;
				case "MD5_PASSWD_USE":	//ѥɤMD5ϥåѤ뤫
					$str = $flds[0] . "\t" . $new_conf["MD5_PASSWD_USE"];
					break;
				case "toptitle":
				case "ptitleimg_h":
				case "ptitleimg_w":
				case "returntitle1":
				case "returntitle2":
				case "curdir":
				case "cururl":
				case "returl":
				case "title":
				case "config":
					continue;
					break;
				default:
					$str = $buffer;
					break;
				}
			}
		}
		fputs($ofp, "$str\n");
	}
	flock($ifp, 3);
	fclose($ifp);

	flock($ofp, 3);
	fclose($ofp);

	chmod($new_conffile, 0664);

	return TRUE;
}

// ͭեγǼѥǥ쥯ȥ
function get_conf_top_dir($conf)
{
	$conftop = $conf["CONFIG_TOP_DIR"];
	return $conftop;
}

// ͭեγǼѥǥ쥯ȥURL
function get_conf_top_url($conf)
{
	$conftop = $conf["CONFIG_TOP_URL"];
	return $conftop;
}

// եꥹȡեɤ߹
function read_folder_list($conf)
{
	$folder_list = array();
	$val = array();

	$conftop = get_conf_top_dir($conf);

	// եѤΥǥ쥯ȥ꤬ߤ뤫
	if (!file_exists($conftop)) {
		// ̵кʶΥեꥹȤ֤
		make_dir($conftop, 0775);
		return $folder_list;
	}
	if (!is_dir($conftop)) {	//ǥ쥯ȥ꤫
		// ǥ쥯ȥǤʤжΥեꥹȤ֤
		return $folder_list;
	}
	// եѤΥǥ쥯ȥΥե򥵡
	if ($dh1 = @opendir($conftop)) {
		while (($name = readdir($dh1)) !== false) {
			// եǥ쥯ȥ꤫ʥǥ쥯ȥ̾̾Τˤʤ
			if ($name == "." || $name == "..") {
				continue;
			}
			// եǥ쥯ȥ꤫ե򸫤Ĥ
			$confdir = make_path($conftop, "", $name);
			if (!is_dir($confdir)) {
				// ǥ쥯ȥʳоݤǤϤʤ
				continue;
			}
			if ($dh2 = @opendir($confdir)) {
				while (($fname = readdir($dh2)) !== false) {
					// ĥҤ conf Υեõ
					$ext = substr($fname, strrpos($fname, '.') + 1);
					if ($ext == "conf") {
						// ե򸫤Ĥ
						$conf_file = make_path($confdir, "", $fname);

						// Ƥɤ߹
						$cf = read_conf_file($conf_file);

						$val["NAME"] = $name;
						$val["CONFIG_FILE"] = $cf["config"];
						$val["TOP_DIR"] = $cf["TOPDIR"];
						$folder_list[$idx] = $val;
						$idx++;
					}
				}
				closedir($dh2);
			}
		}
		closedir($dh1);
	}
	return $folder_list;
}

// Ԥ֤ե륳ԡ
function replace_line_file_copy($src_file, $dst_file, $pattern, $replace)
{
	if (! file_exists($src_file)) {
		echo "src file (" . $src_file . ") not exist\n";
		return FALSE;
	}
	// ե롦ץ
	if (!($ifp = fopen ($src_file, "r"))) {
		echo "src file ($src_file) can not open\n";
		return FALSE;
	}
	flock($ifp, 2);

	// ϥե롦ץ
	if (!($ofp = fopen ($dst_file, "w"))) {
		echo "dst file ($dst_file) can not open\n";
		return FALSE;
	}
	flock($ofp, 2);

	while (!feof ($ifp)) {
		//ɤ߹
		$buffer = fgets($ifp, 4096);
		$buffer = chop($buffer);

		$str = "";
		if (ereg($pattern, $buffer, $regs)) {
			//ѥ˥ޥåԤ֤
			$str = $replace;
		} else  {
			$str = $buffer;
		}
		fputs($ofp, "$str\n");
	}
	flock($ifp, 3);
	fclose($ifp);

	flock($ofp, 3);
	fclose($ofp);

	chmod($dst_file, 0664);

	return TRUE;
}

// ե̾ˤեꥹȤΥӴؿ
function sort_func_name($a, $b)
{
	return strcmp($a["name"], $b["name"]);
}

// ե̾ˤեꥹȤΥӴؿʵս
function sort_func_name_r($a, $b)
{
	$ret = strcmp($a["name"], $b["name"]);
	if ($ret > 0) {
		return -1;
	} elseif ($ret < 0) {
		return -1;
	}
	return 0;
}

// ȤˤեꥹȤΥӴؿ
function sort_func_comment($a, $b)
{
	return strcmp($a["comment"], $b["comment"]);
}

// ȤˤեꥹȤΥӴؿʵս
function sort_func_comment_r($a, $b)
{
	$ret = strcmp($a["comment"], $b["comment"]);
	if ($ret > 0) {
		return -1;
	} elseif ($ret < 0) {
		return -1;
	}
	return 0;
}

// եͭ̾ˤեꥹȤΥӴؿ
function sort_func_owner($a, $b)
{
	return strcmp($a["owner"], $b["owner"]);
}

// եͭ̾ˤեꥹȤΥӴؿʵս
function sort_func_owner_r($a, $b)
{
	$ret = strcmp($a["owner"], $b["owner"]);
	if ($ret > 0) {
		return -1;
	} elseif ($ret < 0) {
		return -1;
	}
	return 0;
}

// ե륵ˤեꥹȤΥӴؿ
function sort_func_size($a, $b)
{
	if ($a["size"] == $b["size"]) {
		return 0;
	}
	return ($a["size"] > $b["size"]) ? 1 : -1;
}

// ե륵ˤեꥹȤΥӴؿʵս
function sort_func_size_r($a, $b)
{
	if ($a["size"] > $b["size"]) {
		return -1;
	} elseif ($a["size"] < $b["size"]) {
		return 1;
	}
	return 0;
}

// ե빹ˤեꥹȤΥӴؿ
function sort_func_time($a, $b)
{
	$dt_a = $a["date"] . $a["time"];
	$dt_b = $b["date"] . $b["time"];

	return strcmp($dt_a, $dt_b);
}

// ե빹ˤեꥹȤΥӴؿʵս
function sort_func_time_r($a, $b)
{
	$dt_a = $a["date"] . $a["time"];
	$dt_b = $b["date"] . $b["time"];

	$ret = strcmp($dt_a, $dt_b);
	if ($ret > 0) {
		return -1;
	} elseif ($ret < 0) {
		return 1;
	}
	return 0;
}

// եꥹȤΥ
function sort_filelist(&$file_list, $sort_key, $rev_flg)
{
	switch($sort_key) {
	case "name":	//ե̾
		if ($rev_flg) {
			usort($file_list, "sort_func_name_r");
		} else {
			usort($file_list, "sort_func_name");
		}
		break;
	case "comment":	//
		if ($rev_flg) {
			usort($file_list, "sort_func_comment_r");
		} else {
			usort($file_list, "sort_func_comment");
		}
		break;
	case "owner":	//ͭ
		if ($rev_flg) {
			usort($file_list, "sort_func_owner_r");
		} else {
			usort($file_list, "sort_func_owner");
		}
		break;
	case "size":	//ե륵
		if ($rev_flg) {
			usort($file_list, "sort_func_size_r");
		} else {
			usort($file_list, "sort_func_size");
		}
		break;
	case "time":	//
		if ($rev_flg) {
			usort($file_list, "sort_func_time_r");
		} else {
			usort($file_list, "sort_func_time");
		}
		break;
	}
}

// եꥹȤɤ߹
function read_filelist($curdir, $listfname)
{
	$listfile = make_path($curdir, "", $listfname);
	$files = array();
	$idx = 0;

	// եꥹɤ߹
	if (file_exists($listfile) && ($fp = fopen($listfile, "r"))) {
		flock($fp, 2);

		while (!feof ($fp)) {
			//ɤ߹
			$buffer = fgets($fp, 4096);
			$buffer = chop($buffer);

			if (strlen($buffer) < 5) {	//ܤʤΤǣʸʲϼΤƤ
				continue;
			}
			if (substr($buffer, 0, 1) == "#") {	//ȹԤϥå
				continue;
			}
			//Ԥԣ¤ʬ
			$flds = split("\t", $buffer);

			//ĤΥեɤ뤳
			if ($flds[0] != "" && $flds[1] != "" && $flds[2] != "") {
				$fname = "";
				if ($flds[0] == ".") {
					$file_path = $curdir;
				} elseif ($flds[0] == "..") {
					$file_path = get_dirpath($curdir);
				} elseif (substr($flds[0], 0, 1) == ".") {
					continue;
				} else {
					$file_path = make_path($curdir, "", $flds[0]);
				}
				$fname = $flds[0];
				$fcomment = $flds[1];
				$fowner = $flds[2];
				$ftype = filetype($file_path);
				if (! isset($flds[3]) || $flds[3] == "") {
					$fdate = date("Y/m/d", filemtime($file_path));
					$ftime = date("H:i:s", filemtime($file_path));
				} else {
					$fdate =  $flds[3];
					if (isset($flds[4]) && $flds[4] != "") {
						$ftime = $flds[4];
					} else {
						$ftime = "";
					}
				}
				$fimg = get_file_image($curdir, $fname);

				//ե륵
				if (is_dir($file_path)) {
					//ǥ쥯ȥξ
					$fsize = "---";
					$fsize = get_dir_use_size($file_path);
				} else {
					$fsize = filesize($file_path);
				}
				if ($fname != "") {
					//ե˳Ǽ
					$files[$idx] = array(
						"name" => $fname,
						"comment" => $fcomment,
						"owner" => $fowner,
						"type" => $ftype,
						"size" => $fsize,
						"date" => $fdate,
						"time" => $ftime,
						"image" => $fimg
					);
					$idx++;
				}
			}
		}
	}
	return $files;
}

//ǥ쥯ȥΥե
function get_dirfiles($dir, $flist)
{
	$dir_files = array();
	$idx = 0;
	$update = FALSE;

	$dh = opendir($dir);
	while (($fname = readdir($dh)) !== false) {
		if (isset($flist) && count($flist) > 0) {
			$find = FALSE;
			foreach($flist as $finf) {
				if ($finf["name"] == $fname) {
					$dir_files[$idx] = $finf;
					$idx++;
					$find = TRUE;
					break;
				}
			}
			if ($find) {
				continue;
			}
		}
		if ($fname == ".") {
			$file_path = $dir;
			$fcomment = get_filename($dir);
		} elseif ($fname == "..") {
			$file_path = get_dirpath($dir);
			$fcomment = "̥ե";
		} elseif (substr($fname, 0, 1) == ".") {
			continue;
		} else {
			$file_path = make_path($dir, "", $fname);
			$fcomment = "";
		}
		$fdate =  date("Y/m/d", filemtime($file_path));
		$ftime =  date("H:i:s", filemtime($file_path));
		$ftype = filetype($file_path);
		$fimg = get_file_image($dir, $fname);

		//ե륵
		if (is_dir($file_path)) {
			//ǥ쥯ȥξ
			//$fsize = "---";
			$fsize = get_dir_use_size($file_path);
		} else {
			$fsize = filesize($file_path);
		}
		//ե˳Ǽ
		$dir_files[$idx] = array(
			"name" => $fname,
			"comment" => $fcomment,
			"owner" => "",
			"type" => $ftype,
			"size" => $fsize,
			"date" => $fdate,
			"time" => $ftime,
			"image" => $fimg
		);
		$update =TRUE;
		$idx++;
     }
     closedir($dh); 

	return array($dir_files, $update);
}

function write_file_list($listfile, $files)
{
	// եꥹȽ񤭹
	if (($fp = fopen ($listfile, "w"))) {
		flock($fp, 2);

		foreach ($files as $finf) {
			$str = $finf["name"];
			$str .= "\t" . $finf["comment"];
			$str .= "\t" . $finf["owner"];
			$str .= "\t" . $finf["date"];
			$str .= "\t" . $finf["time"];
			fputs($fp, "$str\n");
		}

		flock($fp, 3);
		fclose($fp);

		chmod($listfile, 0664);

		return TRUE;
	}
	return FALSE;
}

//եꥹμ¥ե
function count_files($files_info)
{
	$num = 0;

	foreach ($files_info as $finf) {
		if (strncmp($finf["name"], ".", 2) != 0 &&
						strncmp($finf["name"], "..", 2) != 0) {
			$num++;
		}
	}
	return $num;
}

function get_current_info($files_info)
{
	$fname = "";
	$comment = "";
	$owner = "";
	foreach ($files_info as $finf) {
		if (strncmp($finf["name"], ".", 2) == 0) {
			$fname = realpath($finf["name"]);
			$fname = get_filename($fname);
			$comment = $finf["comment"];
			$owner = $finf["owner"];
			break;
		}
	}
	return array($fname, $comment, $owner);
}

// ե
function make_dir($dirname, $mode = 0777)
{
	if (file_exists($dirname)) {
		return TRUE;
	}
	$dname = dirname($dirname);

	if (!file_exists($dname)) {
		if (!make_dir($dname, $mode)) {
			return FALSE;
		}
	}
	$sts = mkdir($dirname, $mode);
	if ($sts) {
		chmod($dirname, $mode);
	}
	return $sts;
}

// եȤΥե
function delete_dir($dirname)
{
	$dh = opendir($dirname);
	while (($fname = readdir($dh)) !== false) {
		if (strncmp($fname, ".", 2) != 0 && strncmp($fname, "..", 3) != 0) {
			$file_path = make_path($dirname, "", $fname);
			if (is_dir($file_path)) {
				$sts = delete_dir($file_path);
			} else {
				$sts = unlink($file_path);
			}
			if (! $sts) {
				break;
			}
		}
	}
	closedir($dh);
	if ($sts) {
		$sts = rmdir($dirname);
	}
	return $sts;
}

// եΥԡ
function copy_dir($dirname, $dstdir)
{
	$sts = TRUE;

	if (!is_dir($dirname)) {
		return FALSE;
	}
	if (!($dh = opendir($dirname))) {
		return FALSE;
	}
	if (!file_exists($dstdir)) {
		make_dir($dstdir, 0775);
	} else {
		if (!is_dir($dstdir)) {
			closedir($dh);
			return FALSE;
		}
	}
	while (($fname = readdir($dh)) !== false) {
		if (strncmp($fname, ".", 2) != 0 && strncmp($fname, "..", 3) != 0) {
			$src_path = make_path($dirname, "", $fname);
			$dst_path = make_path($dstdir, "", $fname);
			if (is_dir($src_path)) {
				$sts = copy_dir($src_path, $dst_path);
			} else {
				$sts = copy($src_path, $dst_path);
			}
			if (! $sts) {
				break;
			}
		}
	}
	closedir($dh);

	return $sts;
}

// Ѳǽ̤
function get_free_size($conf)
{
	// Ѳǽ
	$maxsize = $conf["MAX_TOTAL_SIZE"];

	// ǥ
	$disk_free_size = diskfreespace($conf["TOPDIR"]);
	if ($disk_free_size  < $maxsize) {
		$maxsize = $disk_free_size;
	}
	// ѥ
	$use_size = get_dir_use_size($conf["TOPDIR"]);

	// Ѳǽ
	$free_size = $maxsize - $use_size;

	return $free_size;
}

// ǥѾʸ
function get_disk_info_str($conf)
{
	// Ѳǽ
	$maxsize = $conf["MAX_TOTAL_SIZE"];

	// ǥ
	$disk_free_size = diskfreespace($conf["TOPDIR"]);
	if ($disk_free_size  < $maxsize) {
		$maxsize = $disk_free_size;
	}
	// ѥ
	$use_size = get_dir_use_size($conf["TOPDIR"]);

	// Ѳǽ
	$free_size = $maxsize - $use_size;

	$maxsize = get_filesize_str($maxsize);
	$use_size = get_filesize_str($use_size);
	$free_size = get_filesize_str($free_size);

	$str = "̡" . $use_size . "/" . $maxsize;
	$str .= "ʻѲǽ̡" . $free_size . "";

	return $str;
}


//ǥѾHTML
function get_disk_info_HTML($conf)
{
	$str = get_disk_info_str($conf);

	$html = "<TABLE width=95% border=0>";
	$html .= "<TR align=right><TD>" . $str . "</TD>";
	$html .= "<TD width=70 align=right>[<a href=\"manual/\">إ</a>]</TD>";
	$html .= "</TR>";
	$html .= "</TABLE>";

	return $html;
}

//ڡȥHTML
function get_page_title_HTML($conf)
{
	$ret_html = "";

	//ڡȥΥ᡼ޤʸɽ
	if ($conf["TITLEIMG"] != "") {
		$img = make_path($conf["IMGDIR"], "", $conf["TITLEIMG"]);
		$width = $conf["ptitleimg_w"];
		$height = $conf["ptitleimg_h"];
		$ret_html = "<IMG src=\"$img\" width=$width  height=$height>\n";
	} else {
		$ptitle = $conf["TITLESTR"];
		$ret_html = "<H2>$ptitle</H2>\n";
	}
	return $ret_html;
}

//ڡեåHTML
function get_page_footer_HTML($conf)
{
	$ret_html = "";

	$prog_name = get_program_name();
	$varsion = get_version_no();
	$copy_right = get_copyright_str();
	$homepage = get_homepage();

	$ret_html = <<<_END_OF__DATA__
	<br>
	<hr>
	<table width=95% align=center border=0>
	<tr>
		<td width=70></td>
		<td align=center>
			<a href="$homepage">
			$prog_name ver. $varsion
			</a>
		</td>
		<td width=70 align=right>[<a href="manual/index.html">إ</a>]</td>
	</tr>
<!-- -->
	<tr>
		<td width=70></td>
		<td align=center>$copy_right</td>
		<td width=70></td>
	</tr>
<!-- -->
	<table>
_END_OF__DATA__;

	return $ret_html;
}

// Σգң̤HTMLʸ
function get_return_refer_url_HTML($url, $str)
{
	$html = "<A HREF=\"" . $url . "\"><B>$str</B></A>";

	return $html;
}

//URLHTML
function make_return_url_HTML($returl, $title, $font_color)
{
	$ret_html = "";

	// գң̤Хɽ
	if (isset($returl) &&  $returl != "") {
		$rettitle = $returl;
		if (isset($title)) {
			$rettitle = $title;
		}
		$ret_html = "<A href=\"$returl\">";
		if (isset($font_color) && $font_color != "") {
			$ret_html .= "<FONT color=$font_color>";
		}
		$ret_html .= $rettitle;
		if (isset($font_color) && $font_color != "") {
			$ret_html .= "</FONT>";
		} 
		$ret_html .= "</A>\n";
	} else {
		$ret_html = "";
	}
	return $ret_html;
}

// 裱裲ؤΥ󥯤ɽHTML
function get_return_url_HTML($conf)
{
	$next_align = "left";
	$html = "<TABLE width=95% border=0><TBODY>\n";
	$html .= "<TR>";
	if (isset($conf["returl"]) && $conf["returl"] != "") {
		// գң̤к¦˥ɽ
		$html .= "<TD align=$next_align>" . make_return_url_HTML($conf["returl"],"", "") . "</TD>\n";
		$next_align = "center";
	}
	// գң̣к¦˥ɽ
	$html .= "<TD align=$next_align>" . make_return_url_HTML($conf["RETURL1"], $conf["returntitle1"], "") . "</TD>\n";
	// գң̣б¦˥ɽ
	$html .= "<TD align=right>" . make_return_url_HTML($conf["RETURL2"], $conf["returntitle2"], "#ff0000") . "</TD>\n";
	$html .= "</TR>\n";

	// ǥѾʸ
	//$html .= "<TR><TD align=right colspan=2>" . get_disk_info_str($conf) . "</TD></TR>\n";

	$html .= "</TBODY></TABLE>\n";

	return $html;
}

// եHTMLʸ
function get_return_files_HTML($conf)
{
	$s_name = files_session_name();
	$s_id = session_id();

	$filesurl = $conf["FILES_SCRIPT"];
	$filesurl .= "?dir=" . conv_url_code($conf["curdir"]);
	$filesurl .= "&url=" . conv_url_code($conf["cururl"]);
	$filesurl .= "&config=" . conv_url_code($conf["config"]);
	$filesurl .= "&" . $s_name . "=" . $s_id;

	$html = "<A HREF=\"" . $filesurl . "\"><B>ե</B></A>";

	return $html;
}

// ե˥쥯ȤHTMLʸ
function get_redirect_files_HTML($conf)
{
	$s_name = files_session_name();
	$s_id = session_id();

	$filesurl = $conf["FILES_SCRIPT"];
	$filesurl .= "?dir=" . conv_url_code($conf["curdir"]);
	$filesurl .= "&url=" . conv_url_code($conf["cururl"]);
	$filesurl .= "&config=" . conv_url_code($conf["config"]);
	$filesurl .= "&" . $s_name . "=" . $s_id;

	$html = <<<_END_OF__DATA__
<HTML>
<HEAD>
<meta http-equiv="Refresh" content="0; URL=$filesurl">
</HEAD>
<BODY>
</BODY>
</HTML>
_END_OF__DATA__;

	return $html;
}

// JavaScriptȤäƥե˥쥯ȤHTMLʸ
function get_redirect_files_JavaScriptHTML($conf)
{
	$title = $conf["HEADER_TITLE"];
	$script = $conf["FILES_SCRIPT"];
	$dir = $conf["curdir"];
	$url = $conf["cururl"];
	$config = $conf["config"];
	$returl = $conf["returl"];
	$s_name = files_session_name();
	$s_id = session_id();

	$html = <<<__END_OF_DATA__
<HTML>
<HEAD>
<META http-equiv=Content-Type content="text/html; CHARSET=euc-jp">
<TITLE>$title</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!--
function start() {
	document.form1.submit();
}
// -->
</SCRIPT>
</HEAD>
<BODY onLoad="start()">
<form name="form1" action="$script" method="post">
	<input type="hidden" name="dir" value="$dir">
	<input type="hidden" name="url" value="$url">
	<input type="hidden" name="config" value="$config">
	<input type="hidden" name="returl" value="$returl">
	<input type="hidden" name="$s_name" value="$s_id">
</form>
</BODY>
</HTML>
__END_OF_DATA__;

	return $html;
}

// JavaScriptȤäƻURL˥쥯ȤHTMLʸ
function get_redirect_url_JavaScriptHTML($url)
{
	$s_name = files_session_name();
	$s_id = session_id();

	if (strstr($url, "?")) {
		$url .= "&" . $s_name . "=" . $s_id;
	} else {
		$url .= "?" . $s_name . "=" . $s_id;
	}

	$html = <<<__END_OF_DATA__
<HTML>
<HEAD>
<META http-equiv=Content-Type content="text/html; CHARSET=euc-jp">
<TITLE>JUMP TO <?php echo $url ?></TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!--
function start() {
	location.href = "$url";
}
// -->
</SCRIPT>
</HEAD>
<BODY onLoad="start()">
</BODY>
</HTML>
__END_OF_DATA__;

	return $html;
}

// JavaScriptȤä˥塼˥쥯ȤHTMLʸ
function get_redirect_confmenu_JavaScriptHTML($conf)
{
	$title = $conf["HEADER_TITLE"];
	$script = $conf["CONFMENU_SCRIPT"];
	$config = $conf["config"];
	$returl = $conf["returl"];
	$s_name = files_session_name();
	$s_id = session_id();

	$html = <<<__END_OF_DATA__
<HTML>
<HEAD>
<META http-equiv=Content-Type content="text/html; CHARSET=euc-jp">
<TITLE>$title</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!--
function start() {
	document.form1.submit();
}
// -->
</SCRIPT>
</HEAD>
<BODY onLoad="start()">
<form name="form1" action="$script" method="post">
	<input type="hidden" name="config" value="$config">
	<input type="hidden" name="returl" value="$returl">
	<input type="hidden" name="$s_name" value="$s_id">
</form>
</BODY>
</HTML>
__END_OF_DATA__;

	return $html;
}

// ե˥쥯Ȥ
function redirect_to_files($conf)
{
	$s_name = files_session_name();
	$s_id = session_id();

	$filesurl = $conf["FILES_SCRIPT"];
	$filesurl .= "?dir=" . conv_url_code($conf["curdir"]);
	$filesurl .= "&url=" . conv_url_code($conf["cururl"]);
	$filesurl .= "&config=" . conv_url_code($conf["config"]);
	$filesurl .= "&" . $s_name . "=" . $s_id;

	$location_str = "Location: " . $filesurl;

	header($location_str);

	exit;
}

// JavaScriptȤäƥ̤˥쥯ȤHTMLʸ
function get_redirect_login_JavaScriptHTML($conf)
{
	$title = $conf["HEADER_TITLE"];
	$script = $conf["LOGIN_SCRIPT"];
	$config = $conf["config"];
	$returl = $conf["returl"];
	$s_name = files_session_name();
	$s_id = session_id();

	$html = <<<__END_OF_DATA__
<HTML>
<HEAD>
<META http-equiv=Content-Type content="text/html; CHARSET=euc-jp">
<TITLE>$title</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!--
function start() {
	document.form1.submit();
}
// -->
</SCRIPT>
</HEAD>
<BODY onLoad="start()">
<form name="form1" action="$script" method="post">
	<input type="hidden" name="config" value="$config">
	<input type="hidden" name="returl" value="$returl">
	<input type="hidden" name="$s_name" value="$s_id">
</form>
</BODY>
</HTML>
__END_OF_DATA__;

	return $html;
}

//BODYطʿطʥ᡼ʸ
function get_body_bg_str($conf)
{
	$bg_str = "";

	if ($conf["BG_COLOR"] != "") {
		$bg_str .= " bgColor=" . $conf["BG_COLOR"];
	}
	if ($conf["BG_IMAGE"] != "") {
		$bg_str .= " background=";
		if ($conf[IMGDIR] != "") {
			$bg_str .= $conf[IMGDIR] . "/";
		}
		$bg_str .= "$conf[BG_IMAGE]";
	}
	return $bg_str;
}

//ƤӽФURLΥå
function referer_url_check($conf, $referer_url, $block_flg, $default)
{
//	echo "HTTP_REFERER=" . $referer_url . "<br>\n";
//	echo "CALLER_URL=" . $conf["CALLER_URL"] . "<br>\n";
put_dbg_log($conf, "HTTP_REFERER=" . $referer_url . "<br>");
put_dbg_log($conf, "CALLER_URL=" . $conf["CALLER_URL"] . "<br>");

	if (isset($default)) {
		$acess_flg = $default;
	} else {
		$acess_flg = TRUE;
	}

	if ($conf["CALLER_URL"] != "") {
//		echo "CALLER_URL=" . $conf["CALLER_URL"] . "<br>\n";
		if (stristr($referer_url, $conf["SCRIPT_DIR_URL"])) {
			$acess_flg = TRUE;
		} else {
			if (!isset($referer_url) || $referer_url == "") {
				$acess_flg = FALSE;
			} else {
				$acess_flg = FALSE;
				$ref_url_list = split(",", $conf["CALLER_URL"]);
				foreach($ref_url_list as $ref_url) {
					if (stristr($referer_url, $ref_url)) {
						$acess_flg = TRUE;
						break;
					}
				}
			}
		}
	}
	if ($acess_flg == FALSE && $block_flg == TRUE) {
		$bgstr = get_body_bg_str($conf);
		echo "<HTML><HEAD>\n";
		echo "<META http-equiv=Content-Type content=\"text/html; CHARSET=euc-jp\">";
		echo "<TITLE>kitabora</TITLE></HEAD>";
		echo "<BODY " . $bgstr . ">";
		echo "<B>[" . $conf["title"] . "]<BR><BR>\n";
		echo "ǤޤǤ<BR>\n";
		echo "뤫ǧƤ<BR><BR></B>\n";
		echo "<A HREF=\"" . $referer_url . "\">" . $referer_url . "</A>\n";
		echo "</BODY></HTML>\n";
		exit;
	}
	return $acess_flg;
}

//󡦥å
function login_check($conf)
{
	//ѥɥեȥ󥹥ץȤåȤƤ뤫
	if (isset($conf["PASSWD_FILE"]) && $conf["PASSWD_FILE"] != "" &&
			isset($conf["LOGIN_SCRIPT"]) && $conf["LOGIN_SCRIPT"] != "") {
		//åѿå
		$login_user = get_session_value("LOGIN_USER");
		if (!(isset($login_user) && $login_user != "")) {
			//åѿåȤƤʤ
			return FALSE;
		}
	}
	return TRUE;
}

function put_info_log($conf, $msg)
{
	$remote_addr = $GLOBALS["REMOTE_ADDR"];

	$user = get_session_value("LOGIN_USER");

	openlog("files", LOG_PID | LOG_PERROR, LOG_LOCAL0);

    // Ͽ
    $access = date("Y/m/d H:i:s");
    syslog(LOG_INFO, "$access $remote_addr $user $msg");

	closelog();
}

function put_log($conf, $msg)
{
	if ($conf["OUTPUT_LOG"] != 1) {
		return TRUE;
	}
	$remote_addr = $GLOBALS["REMOTE_ADDR"];

	$user = get_session_value("LOGIN_USER");

	$access = date("Y/m/d H:i:s");
	$logmsg = "$access $remote_addr $user $msg\n";

	// ե񤭹ߥץ
	if (($fp = fopen ($conf["LOGFILE"], "a"))) {
		flock($fp, 2);

    		// Ͽ
		fputs($fp, $logmsg);

		flock($fp, 3);
		fclose($fp);

		return TRUE;
	}
	return FALSE;
}

function put_dbg_log($conf, $msg)
{
	if ($GLOBALS["DEBUG_LOG"]) {
		return put_log($conf, $msg);
	}
	return TRUE;
}

function get_upload_file_info()
{
	$upload_info = array();

	if (isset($UploadFile_name) && isset($UploadFile_type) &&
						isset($UploadFile_size) && isset($UploadFile)) {
		$upload_info['name'] = $UploadFile_name;
		$upload_info['type'] = $UploadFile_type;
		$upload_info['size'] = $UploadFile_size;
		$upload_info['tmp_name'] = $UploadFile;
	} elseif (isset($HTTP_POST_FILES) &&
						isset($HTTP_POST_FILES['UploadFile'])) {
		$upload_info["name"] = $HTTP_POST_FILES['UploadFile']['name'];
		$upload_info["type"] = $HTTP_POST_FILES['UploadFile']['type'];
		$upload_info["size"] = $HTTP_POST_FILES['UploadFile']['size'];
		$upload_info["tmp_name"] = $HTTP_POST_FILES['UploadFile']['tmp_name'];
	} elseif (isset($_FILES) && isset($_FILES['UploadFile'])) {
		$upload_info["name"] = $_FILES['UploadFile']['name'];
		$upload_info["type"] = $_FILES['UploadFile']['type'];
		$upload_info["size"] = $_FILES['UploadFile']['size'];
		$upload_info["tmp_name"] = $_FILES['UploadFile']['tmp_name'];
	}
	return $upload_info;
}

function files_session_name()
{
	return "FILES_SESSION";
}

function init_files($login_page)
{
	$http_referer = $GLOBALS["HTTP_REFERER"];
	$remote_user = $GLOBALS["REMOTE_USER"];

	$returl = get_post_get_val("returl");
	$config = get_post_get_val("config");
	$dir = get_post_get_val("dir");
	$url = get_post_get_val("url");

	$conffile = "./files.conf";
	if (isset($config) && $config != "") {
		$conffile = $config;
	}
	$topdir = getcwd();
	$topurl = ".";

	if (isset($remote_user)) {
		$user = $remote_user;
	}

	// եɤ߹
	$conf = read_conf_file($conffile);

	if (isset($returl) && $returl != "") {
		$conf["returl"] = $returl;
	}
	if (isset($conf["TOPDIR"])) {
		$topdir = $conf["TOPDIR"];
	}
	if (isset($conf["TOPURL"])) {
		$topurl = $conf["TOPURL"];
	}
	if (!isset($conf["CUTDIR"]) || $conf["CUTDIR"] == "") {
		$conf["CUTDIR"] = $conf["TOPDIR"] . "/" . ".cutdir";
	}
	if (!isset($conf["CUTURL"]) || $conf["CUTURL"] == "") {
		$conf["CUTURL"] = $conf["TOPURL"] . "/" . ".cutdir";
	}
	if ($mode == "") {
		$mode = "files";
	}

	//եѥ
	$topdir = realpath($topdir);

	$conf["config"] = $conffile;
	if (isset($dir)) {
		$conf["curdir"] = $dir;
	} else {
		$conf["curdir"] = "";
	}
	if (isset($url)) {
		$conf["cururl"] = $url;
	} else {
		$conf["cururl"] = "";
	}
	// ȥǥ쥯ȥ̾ե̾Ф
	$curdir = make_path($conf["TOPDIR"], $conf["curdir"], "");
	$cururl = make_path($conf["TOPURL"], $conf["cururl"], "");
	$conf["title"] = get_filename($curdir);
	$conf["uptime"] = date("Y/m/d H:i:s", filemtime($curdir));

	//ƤӽФURLΥå
	session_name(files_session_name());
	session_start();

	$conf_path = realpath($conf["config"]);
	$save_conf_path = get_session_value("CONFIG_FNAME");

	$allow_user ="";

	//åΩե뤬äƤʤå
	if ($save_conf_path != $conf_path) {
		set_session_value("ALLOW_USER", "");
		set_session_value("LOGIN_USER", "");
	} else {
		$allow_user = get_session_value("ALLOW_USER");
	}

	set_session_value("CONFIG_FNAME", $conf_path);
	$session = FALSE;
	if (isset($allow_user)) {
		if (strncmp("123", $allow_user, 3) == 0) {
			$session = TRUE;
		}
	}
	if (! $session) {
		//åѿåȤƤʤʥ̤
		$return_url = "";
		if ($returl != "") {
			$return_url = $returl;
		}
		if ($return_url != "") {
			set_session_value("RETURN_URL", $return_url);
		}
		if (!(isset($conf["CALLER_URL"]) && $conf["CALLER_URL"] != "" &&
				referer_url_check($conf, $http_referer, FALSE, TRUE))) {
			//̵˵ĤƤ륵ȤθƤӽФǤϤʤ
			if (!login_check($conf)) {
				//̤󤷤Ƥʤ
				if ($login_page != TRUE) {
					//ڡǤʤʤڡ˥
					echo get_redirect_login_JavaScriptHTML($conf);
					exit;
				}
				return $conf;
			}
		}
		set_session_value("ALLOW_USER", "123");
	}
	$conf["returl"] = get_session_value("RETURN_URL");

	return $conf;
}
?>
