<?php
/******************************************************************************
	Files(WEBե붦ͭPHPץ)
	Files(WEB file share PHP script)

	̥֥롼󡦥ե
	Common subroutine file

  	files_com.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2008 Technoworks Co., Ltd. All rights reserved.

	Update:

	Ver.2.3
		PHP4ǥݡȤƤʤؿ stripos() ѤƤΤǡ
		stristr() Ȥ褦ѹ
		Because function stripos() not supported with PHP4 had been used, 
		it changed to use stristr() instead. 

	Ver.2.1
		եɲ
		The configuration file arrangement setting is added.

	Ver.2.0
		ɽʸ locale.php 褦˽
		The display character string was acquired from locale.php. 

		ʸɤλ locale.php 褦˽
		The specification of the character-code was acquired from locale.php.

		ͭԤȥ롼פˤ륢浡ǽղ
		The access control function by the group is added with the owner. 

		HTMLʬˣХʸѤʤ褦˽
		֥饦ʸɼưȽ̤˱ƶʤ褦ˤ뤿
		To make it not misidentified by the character-code automatic operation 
		identification of a browser, it was corrected that Japanese was not 
		used for the HTML part. 

	Ver.1.4 ޤǤι
		2005/04/19	ꥹȤե˽Ф
					The icon list was given to an external file.

		2005/07/26	եνʣåѤΥեꥹȼؿɲ
					File list acquisition function addition for checking for
					duplication of file.

		2005/08/02	ԤΥǥեȥѥɲ
					The manager's default password setting is added. 

		2005/08/02	̤Υڡإåʬؿɲ
					A common page header partial function is added. 
******************************************************************************/

require('locale.php');

require('session.php');

function get_charset()
{
	global $dsp_charset;

	if (isset($dsp_charset) && $dsp_charset != "") {
		return $dsp_charset;
	} else {
		return "";
	}
}

function get_txt($key)
{
	global $txt;

	return $txt[$key];
}

function get_charset_line()
{
	$charset = get_charset();

	$html = "";
	if ($charset != "") {
		$html = "<META http-equiv=Content-Type content=\"text/html; CHARSET=" .
															$charset . "\">";
	}
	return $html;
}

function disp_message($conf, $msg)
{
	$bgstr = get_body_bg_str($conf);
	echo "<HTML><HEAD>\n";
	echo get_charset_line();
	echo "<TITLE>" . $conf["HEADER_TITLE"] . "</TITLE></HEAD>";
	echo "<BODY " . $bgstr . ">";
	echo $msg . "<BR>\n";
	echo "</BODY></HTML>\n";
}

/**
function replace_str($str, $search_str, $replace_str)
{
	$srch_str_len = strlen($search_str);
	$wk = "";
	while (($idx = stripos($str, $search_str)) != false) {
		$wk .= substr($str, 0, $idx);
		$wk .= $replace_str;
		$str = substr($str, $idx + $srch_str_len);
	}
	$wk .= $str;

	return $wk;
}
**/

function replace_str($str, $search_str, $replace_str)
{
	$wk = "";

	$srch_str_len = strlen($search_str);

	while (($ss = stristr($str, $search_str)) != false && isset($ss) && $ss != "") {
		$str_len = strlen($str);
		$ss_len =strlen($ss);
		$len = $str_len - $ss_len;
		if ($len > 0) {
			$wk .= substr($str, 0, $len);
		}
		$wk .= $replace_str;
		if ($ss_len > $srch_str_len) {
			$str = substr($ss, $srch_str_len);
		} else {
			$str = "";
			break;
		}
	}
	$str = $wk . $str;

	return $str;
}

function noblank_str($str)
{
	if (!(isset($str) && $str != "")) {
		$str = "&nbsp;";
	} else {
		$wk = $str;
		$str = replace_str($wk, "&lt;br&gt;", "<br>");
		$wk = $str;
		$str = replace_str($wk, "&lt;b&gt;", "<b>");
		$wk = $str;
		$str = replace_str($wk, "&lt;/b&gt;", "</b>");
	}
	return $str;
}

//ѥɤMD5ϥå岽뤫
//Is the password made MD5 hush?
function is_md5_use($conf)
{
	//ѥɤMD5ϥåѤ뤫
	//Is the MD5 hush used for the password?
	if (strcasecmp($conf["MD5_PASSWD_USE"], "NO") == 0) {
		return FALSE;
	} elseif (strcasecmp($conf["MD5_PASSWD_USE"], "NO_MAC") == 0) {
		$chk_val = get_env_val("HTTP_UA_OS");
		if (isset($chk_val) && $chk_val != "") {
			if (stristr($chk_val, "MacOS") != FALSE) {
				return TRUE;
			}
		} else {
			$chk_val = get_env_val("HTTP_USER_AGENT");
			if (stristr($chk_val, "Mac") != FALSE) {
				return FALSE;
			}
		}
	}
	return TRUE;
}

//å
//It locks. 
function lock_files($lockfname)
{
	if (($lock_fp = fopen($lockfname, "w"))) {
		flock($lock_fp, 2);
		return $lock_fp;
	}
	return 0;
}

//å
//The lock is released. 
function unlock_files($fp, $lockfname)
{
	flock($fp, 3);
	fclose($fp);
	unlink($lockfname);
}

//Υ̾¸ߥå
//Existence check of key name of array
function is_key_exist($keyname, $arry)
{
	foreach(array_keys($arry) as $key) {
		if ($key == $keyname) {
			return TRUE;
		}
	}
	return FALSE;
}

//ǥ쥯ȥΥե륵ιפ
//The total of the size of the file in the directory is obtained. 
function get_dir_use_size($top_dir)
{
	$dir_size = 0;

	if ($dir = @opendir($top_dir)) {
		while (($file = readdir($dir)) !== false) {
			if (strcmp($file, ".") != 0 && strcmp($file, "..") != 0) {
				$filepath = make_path($top_dir, "", $file);
				if (is_dir($filepath)) {
					$dir_size += get_dir_use_size($filepath);
				} else {
					$dir_size += filesize($filepath);
				}
			}
		}  
		closedir($dir);
	}
	return $dir_size;
}

//ե륵ɽѤʸ123MB123KBˤ
//The size of the file is obtained and the character string
// (..123MB.. 123KB etc.) for the display is obtained.
function get_filesize_str($filesize)
{
	$filesize_str = "";

	if ($filesize >= 1000000000) {
		$filesize_str = sprintf("%.1f", $filesize / 1000000000);
		//$filesize_str = make_comma_val($filesize_str);
		$filesize_str .= "GB";
	} elseif ($filesize >= 1000000) {
		$filesize_str = sprintf("%.1f", $filesize / 1000000);
		//$filesize_str = make_comma_val($filesize_str);
		$filesize_str .= "MB";
	} elseif ($filesize >= 1000) {
		$filesize_str = sprintf("%.1f", $filesize / 1000);
		//$filesize_str = make_comma_val($filesize_str);
		$filesize_str .= "KB";
	} else {
		$filesize_str = $filesize;
		//$filesize_str = make_comma_val($filesize_str);
		$filesize_str .= "Byte";
	}
	return $filesize_str;
}

//եΥ󥤥᡼̾
//The icon image name of the file is obtained. 
function get_file_image($dir, $fname)
{
	/* 󥤥᡼ΥꥹȤϳե */
	/* The list of the icon image is set with an external file. */
	include "icon_img.php";

	$path = make_path($dir, "", $fname);

	//󥤥᡼
	//The icon image is obtained.
	if ($fname == "..") {
		//̥ǥ쥯ȥξ
		//For a high-ranking directory
		$img = $ftype_img["updir"];
	} elseif ($fname == ".") {
		//ȥǥ쥯ȥξ
		//For the current directory
		$img = $ftype_img["dir"];
	} elseif (is_dir($path)) {
		//ǥ쥯ȥξ
		//For the directory
		$img = $ftype_img["dir"];
	} else {
		//ĥҤФ
		//The extension is taken out.
		$arr_ext = split("\.", $fname);
		if (count($arr_ext) > 0) {
			//ĥҤ
			//There is an extension.
			$ext = array_pop($arr_ext);
			$ext = strtolower($ext);
			if (is_key_exist($ext, $ftype_img)) {
				//̥᡼
				//When there is an image according to the type
				$img = $ftype_img[$ext];
			} else {
				//̥᡼ʤȤ
				//Unknown when there is no image according to type
				$img = $ftype_img["unknown"];
			}
		} else {
			//ĥҤʤξ
			//Unknown when there is no extension
			$img = $ftype_img["unknown"];
		}
	}
	return $img;
}

//ѥɡե̾
//The password file name is acquired.
function get_passwd_filename($conf)
{
	$pwdfile = "";

	if ($conf["PASSWD_FILE"] != "") {
		$pwdfile = $conf["PASSWD_FILE"];
	}
	return $pwdfile;
}

//롼סե̾
//The group file name is acquired.
function get_group_filename($conf)
{
	$groupfile = "";

	if ($conf["PASSWD_FILE"] != "") {
		if ($conf["GROUP_FILE"] != "") {
			$groupfile = $conf["GROUP_FILE"];
		} else {
			$dir = get_dirpath($conf["PASSWD_FILE"]);
			if ($dir != "") {
				$groupfile = make_path($dir, "", $conf["DEFAULT_GROUP_FILE"]);
			} else {
				$groupfile = $conf["DEFAULT_GROUP_FILE"];
			}
		}
	}
	return $groupfile;
}

//桼IDΥꥹȤ
//The list of user ID is acquired.
function get_user_list($conf)
{
	$user_list = array();

	$pwdfile = get_passwd_filename($conf);

	if ($pwdfile != "") {
		if(!file_exists($pwdfile)) {
			return $user_list;
		}
		if (!($fp = fopen ($pwdfile, "r"))) {
			return $user_list;
		}
		flock($fp, 2);

		$idx = 0;
		while (!feof($fp)) {
			//ɤ߹
			//One line reading
			$buffer = fgets($fp, 4096);
			$buffer = chop($buffer);
			if (strlen($buffer) < 2) {
				//ʸʲιԤϼΤƤ
				//The line of two characters or less is thrown away.
				continue;
			}
			if (substr($buffer, 0, 1) == "#") {
				//ȹԤϥå
				//The comment line is skipped.
				continue;
			}
			//Ԥԣ¤ʬ
			//The line is divided with TAB.
			$flds = split("\t", $buffer);

			if ($flds[0] != "") {
				$user_list[$idx] = $flds[0];
			}
			$idx++;
		}
		flock($fp, 3);
		fclose($fp);
	}
	return $user_list;
}

//롼פΥꥹȤ
//The list of the group is acquired.
function get_group_list($conf)
{
	$group_list = array();

	$groupfile = get_group_filename($conf);

	if ($groupfile != "") {
		if(!file_exists($groupfile)) {
			return $group_list;
		}
		if (!($fp = fopen ($groupfile, "r"))) {
			return $group_list;
		}
		flock($fp, 2);

		$idx = 0;
		while (!feof($fp)) {
			//ɤ߹
			//One line reading
			$buffer = fgets($fp, 4096);
			$buffer = chop($buffer);
			if (strlen($buffer) < 2) {
				//ʸʲιԤϼΤƤ
				//The line of two characters or less is thrown away.
				continue;
			}
			if (substr($buffer, 0, 1) == "#") {
				//ȹԤϥå
				//The comment line is skipped.
				continue;
			}
			//Ԥԣ¤ʬ
			//The line is divided with TAB.
			$flds = split("\t", $buffer);

			if ($flds[0] != "") {
				$group_list[$idx] = $flds[0];
				$idx++;
			}
		}
		flock($fp, 3);
		fclose($fp);
	}
	return $group_list;
}

//롼פ˽°桼ΥꥹȤ
//The list of the user who belongs to the group is acquired.
function get_group_users($conf, $group)
{
	$user_list = array();

	$groupfile = get_group_filename($conf);

	if ($groupfile != "") {
		if(!file_exists($groupfile)) {
			return $group_list;
		}
		if (!($fp = fopen ($groupfile, "r"))) {
			return $group_list;
		}
		flock($fp, 2);

		while (!feof($fp)) {
			//ɤ߹
			//One line reading
			$buffer = fgets($fp, 4096);
			$buffer = chop($buffer);

			if (strlen($buffer) < 2) {
				//ʸʲιԤϼΤƤ
				//The line of two characters or less is thrown away.
				continue;
			}
			if (substr($buffer, 0, 1) == "#") {
				//ȹԤϥå
				//The comment line is skipped.
				continue;
			}
			//Ԥԣ¤ʬ
			//The line is divided with TAB.
			$flds = split("\t", $buffer);

			if ($flds[0] == $group) {
				if (isset($flds[1]) && $flds[1] != "") {
					//ޤʬ
					//It divides by the comma.
					$user_list = split(",", $flds[1]);
				}
				break;
			}
		}
		flock($fp, 3);
		fclose($fp);
	}
	return $user_list;
}

//桼°륰롼פΥꥹȤ
//The list of the group to which the user belongs is acquired.
function get_user_groups($conf, $user)
{
	$group_list = array();

	$groupfile = get_group_filename($conf);

	if ($groupfile != "") {
		if(!file_exists($groupfile)) {
			return $group_list;
		}
		if (!($fp = fopen ($groupfile, "r"))) {
			return $group_list;
		}
		flock($fp, 2);

		$idx = 0;
		while (!feof($fp)) {
			//ɤ߹
			//One line reading
			$buffer = fgets($fp, 4096);
			$buffer = chop($buffer);
			if (strlen($buffer) < 3) {
				//ʸʲιԤϼΤƤ
				//The line of three characters or less is thrown away.
				continue;
			}
			if (substr($buffer, 0, 1) == "#") {
				//ȹԤϥå
				//The comment line is skipped.
				continue;
			}
			//Ԥԣ¤ʬ
			//The line is divided with TAB.
			$flds = split("\t", $buffer);

			//ĤΥեɤ뤳
			//There must be two fields.
			if ($flds[0] != "" && isset($flds[1]) && $flds[1] != "") {
				//ޤʬ
				//It divides by the comma.
				$user_list = split(",", $flds[1]);
				foreach($user_list as $user_id) {
					if ($user_id == $user) {
						$group_list[$idx] = $flds[0];
						$idx++;
						break;
			 		}
				}
			}
		}
		flock($fp, 3);
		fclose($fp);
	}
	return $group_list;
}

function get_permission($conf, $finf, $user, $group_list)
{
	$permit = array("r" => 0, "w" => 0, "x" => 0);
	$attr_str = array("r", "w", "x");

	if ($user == $conf["ADMIN_USERID"] || $finf["name"] == "") {
		$permit["r"] = 1;
		$permit["w"] = 1;
		$permit["x"] = 1;
		return $permit;
	}
	$attr = $conf["DEFAULT_ATTR"];
	if (isset($finf["attr"]) && $finf["attr"] != "") {
		$attr = $finf["attr"];
	}
	$mask = 0004;
	for ($i = 0; $i < 3; $i++) {
		if ($attr & $mask) {
			$permit[$attr_str[$i]] = 1;
		}
		$mask >>= 1;
	}
	if (!($permit["r"] && $permit["w"] && $permit["x"])) {
		if ($finf["user"] == $user) {
			$mask = 0400;
			for ($i = 0; $i < 3; $i++) {
				if ($attr & $mask) {
					$permit[$attr_str[$i]] = 1;
				}
				$mask >>= 1;
			}
		}
	}
	if (!($permit["r"] && $permit["w"] && $permit["x"])) {
		foreach($group_list as $group) {
			if ($finf["group"] == $group) {
				$mask = 0040;
				for ($i = 0; $i < 3; $i++) {
					if ($attr & $mask) {
						$permit[$attr_str[$i]] = 1;
					}
					$mask >>= 1;
				}
			}
		}
	}
	return $permit;
}

function get_file_permit($conf, $curdir, $fname, $user, $group_list)
{
	$permit = array();
	$flist = array();
	$flist = read_filelist($curdir, $conf["LISTFILE"]);
	foreach ($flist as $finf) {
		if ($finf["name"] == $fname) {
			return get_permission($conf, $finf, $user, $group_list);
		}
	}
	return $permit;
}

function is_file_writable($conf, $curdir, $fname, $user, $group_list)
{
	$permit = get_file_permit($conf, $finf, $user, $group_list);
	if ($permit["w"]) {
		return TRUE;
	}
	return FALSE;
}

function is_file_readable($conf, $curdir, $fname, $user, $group_list)
{
	$permit = get_file_permit($conf, $finf, $user, $group_list);
	if ($permit["r"]) {
		return TRUE;
	}
	return FALSE;
}

function is_file_executable($conf, $curdir, $fname, $user, $group_list)
{
	$permit = get_file_permit($conf, $finf, $user, $group_list);
	if ($permit["x"]) {
		return TRUE;
	}
	return FALSE;
}

//°ʸɽˤ
//The attribute is written in the character string.
function get_attr_str($attr)
{
	$attr_str = "";

	$attr_str .= ($attr & 00400) ? "r" : "-";
	$attr_str .= ($attr & 00200) ? "w" : "-";
	$attr_str .= ($attr & 00100) ? "x" : "-";
	$attr_str .= ($attr & 00040) ? "r" : "-";
	$attr_str .= ($attr & 00020) ? "w" : "-";
	$attr_str .= ($attr & 00010) ? "x" : "-";
	$attr_str .= ($attr & 00004) ? "r" : "-";
	$attr_str .= ($attr & 00002) ? "w" : "-";
	$attr_str .= ($attr & 00001) ? "x" : "-";

	return $attr_str;
}

//ʸɽ°ͤˤ
//The attribute of the character string mark is made a numerical value.
function get_attr_val($attr_str)
{
	$attr = 0;

	$attr |= (substr($attr_str, 0, 1) == "r" ? 0400 : 0000);
	$attr |= (substr($attr_str, 1, 1) == "w" ? 0200 : 0000);
	$attr |= (substr($attr_str, 2, 1) == "x" ? 0100 : 0000);
	$attr |= (substr($attr_str, 3, 1) == "r" ? 0040 : 0000);
	$attr |= (substr($attr_str, 4, 1) == "w" ? 0020 : 0000);
	$attr |= (substr($attr_str, 5, 1) == "x" ? 0010 : 0000);
	$attr |= (substr($attr_str, 6, 1) == "r" ? 0004 : 0000);
	$attr |= (substr($attr_str, 7, 1) == "w" ? 0002 : 0000);
	$attr |= (substr($attr_str, 8, 1) == "x" ? 0001 : 0000);

	return $attr;
}

// եꥹȡեɤ߹
//Folder list file reading
function read_folder_list($conf)
{
	$folder_list = array();
	$val = array();
	$idx = 0;

	$conftop = get_conf_top_dir($conf);

	// եѤΥǥ쥯ȥ꤬ߤ뤫
	//Does the directory for the configuration file break out?
	if (!file_exists($conftop)) {
		// ̵кʶΥեꥹȤ֤
		//It makes it in case of not being. 
		//(An empty folder list is returned. )
		make_dir($conftop, get_conf_dir_attr($conf));
		return $folder_list;
	}
	//ǥ쥯ȥ꤫
	//Is it a directory?
	if (!is_dir($conftop)) {
		// ǥ쥯ȥǤʤжΥեꥹȤ֤
		//If it is not a directory, an empty folder list is returned.
		return $folder_list;
	}
	// եѤΥǥ쥯ȥΥե򥵡
	//It searches for the file in the directory for the configuration file.
	if ($dh1 = @opendir($conftop)) {
		while (($name = readdir($dh1)) !== false) {
			// եǥ쥯ȥ꤫ʥǥ쥯ȥ̾̾Τˤʤ
			//Is it a folder setting directory?
			//(The directory name becomes a name. )
			if ($name == "." || $name == "..") {
				continue;
			}
			// եǥ쥯ȥ꤫ե򸫤Ĥ
			//The configuration file is found from the folder
			//setting directory.
			$confdir = make_path($conftop, "", $name);
			if (!is_dir($confdir)) {
				// ǥ쥯ȥʳоݤǤϤʤ
				//It is not an object excluding the directory.
				continue;
			}
			if ($dh2 = @opendir($confdir)) {
				while (($fname = readdir($dh2)) !== false) {
					// ĥҤ conf Υեõ
					//The extension looks for the file of conf.
					$ext = substr($fname, strrpos($fname, '.') + 1);
					if ($ext == "conf") {
						// ե򸫤Ĥ
						//The configuration file was found.
						$conf_file = make_path($confdir, "", $fname);

						// Ƥɤ߹
						//A set content is read.
						$cf = read_conf_file($conf_file);

						$val["NAME"] = $name;
						$val["CONFIG_FILE"] = $cf["config"];
						$val["TOP_DIR"] = $cf["TOPDIR"];
						$folder_list[$idx] = $val;
						$idx++;
					}
				}
				closedir($dh2);
			}
		}
		closedir($dh1);
	}
	return $folder_list;
}

// Ԥ֤ե륳ԡ
//Replacement file copy of specified line
function replace_line_file_copy($src_file, $dst_file, $pattern, $replace)
{
	if (! file_exists($src_file)) {
		echo "src file (" . $src_file . ") not exist\n";
		return FALSE;
	}
	// ե롦ץ
	//The file of the copy origin is opened.
	if (!($ifp = fopen ($src_file, "r"))) {
		echo "src file ($src_file) can not open\n";
		return FALSE;
	}
	flock($ifp, 2);

	// ϥե롦ץ
	//Output file and opening
	if (!($ofp = fopen ($dst_file, "w"))) {
		echo "dst file ($dst_file) can not open\n";
		return FALSE;
	}
	flock($ofp, 2);

	while (!feof ($ifp)) {
		//ɤ߹
		//One line reading
		$buffer = fgets($ifp, 4096);
		$buffer = chop($buffer);

		$str = "";
		if (ereg($pattern, $buffer, $regs)) {
			//ѥ˥ޥåԤ֤
			//The line that matches to the pattern is replaced.
			$str = $replace;
		} else  {
			$str = $buffer;
		}
		fputs($ofp, "$str\n");
	}
	flock($ifp, 3);
	fclose($ifp);

	flock($ofp, 3);
	fclose($ofp);

	$conf = get_config();

	chmod($dst_file, get_conf_file_attr($conf));

	return TRUE;
}

// ե̾ˤեꥹȤΥӴؿ
//Sorting comparison function of file list by file name
function sort_func_name($a, $b)
{
	return strcmp($a["name"], $b["name"]);
}

// ե̾ˤեꥹȤΥӴؿʵս
//Sorting comparison function of file list by file name(reverse order)
function sort_func_name_r($a, $b)
{
	$ret = strcmp($a["name"], $b["name"]);
	if ($ret > 0) {
		return -1;
	} elseif ($ret < 0) {
		return -1;
	}
	return 0;
}

// ȤˤեꥹȤΥӴؿ
//Sorting comparison function of file list by comment
function sort_func_comment($a, $b)
{
	return strcmp($a["comment"], $b["comment"]);
}

// ȤˤեꥹȤΥӴؿʵս
//Sorting comparison function of file list by comment(reverse order)
function sort_func_comment_r($a, $b)
{
	$ret = strcmp($a["comment"], $b["comment"]);
	if ($ret > 0) {
		return -1;
	} elseif ($ret < 0) {
		return -1;
	}
	return 0;
}

// եͭ̾ˤեꥹȤΥӴؿ
//Sorting comparison function of file list by file owner name
function sort_func_owner($a, $b)
{
	return strcmp($a["owner"], $b["owner"]);
}

// եͭ̾ˤեꥹȤΥӴؿʵս
//Sorting comparison function of file list by file owner name(reverse order)
function sort_func_owner_r($a, $b)
{
	$ret = strcmp($a["owner"], $b["owner"]);
	if ($ret > 0) {
		return -1;
	} elseif ($ret < 0) {
		return -1;
	}
	return 0;
}

// ե륵ˤեꥹȤΥӴؿ
//Sorting comparison function of file list by size of file
function sort_func_size($a, $b)
{
	if ($a["size"] == $b["size"]) {
		return 0;
	}
	return ($a["size"] > $b["size"]) ? 1 : -1;
}

// ե륵ˤեꥹȤΥӴؿʵս
//Sorting comparison function of file list by size of file(reverse order)
function sort_func_size_r($a, $b)
{
	if ($a["size"] > $b["size"]) {
		return -1;
	} elseif ($a["size"] < $b["size"]) {
		return 1;
	}
	return 0;
}

// ե빹ˤեꥹȤΥӴؿ
//Sorting comparison function of file list by file update time
function sort_func_time($a, $b)
{
	$dt_a = $a["date"] . $a["time"];
	$dt_b = $b["date"] . $b["time"];

	return strcmp($dt_a, $dt_b);
}

// ե빹ˤեꥹȤΥӴؿʵս
//Sorting comparison function of file list by file update time(reverse order)
function sort_func_time_r($a, $b)
{
	$dt_a = $a["date"] . $a["time"];
	$dt_b = $b["date"] . $b["time"];

	$ret = strcmp($dt_a, $dt_b);
	if ($ret > 0) {
		return -1;
	} elseif ($ret < 0) {
		return 1;
	}
	return 0;
}

// եꥹȤΥ
//Sorting of file list
function sort_filelist(&$file_list, $sort_key, $rev_flg)
{
	switch($sort_key) {
	case "name":
		//ե̾
		//File name
		if ($rev_flg) {
			usort($file_list, "sort_func_name_r");
		} else {
			usort($file_list, "sort_func_name");
		}
		break;
	case "comment":
		//
		//Comment
		if ($rev_flg) {
			usort($file_list, "sort_func_comment_r");
		} else {
			usort($file_list, "sort_func_comment");
		}
		break;
	case "owner":
		//ͭ
		//Owner
		if ($rev_flg) {
			usort($file_list, "sort_func_owner_r");
		} else {
			usort($file_list, "sort_func_owner");
		}
		break;
	case "size":
		//ե륵
		//File size
		if ($rev_flg) {
			usort($file_list, "sort_func_size_r");
		} else {
			usort($file_list, "sort_func_size");
		}
		break;
	case "time":
		//
		//Update date and time
		if ($rev_flg) {
			usort($file_list, "sort_func_time_r");
		} else {
			usort($file_list, "sort_func_time");
		}
		break;
	}
}

// եꥹȤɤ߹
//The file list is read.
function read_filelist($curdir, $listfname)
{
	$listfile = make_path($curdir, "", $listfname);
	$files = array();
	$idx = 0;
	$conf = get_config();

	// եꥹɤ߹
	//File list reading
	if (file_exists($listfile) && ($fp = fopen($listfile, "r"))) {
		flock($fp, 2);

		while (!feof ($fp)) {
			//ɤ߹
			//One line reading
			$buffer = fgets($fp, 4096);
			$buffer = chop($buffer);

			if (strlen($buffer) < 2) {
				//2ʸʲϼΤƤ
				//The line of two characters or less is thrown away.
				continue;
			}
			if (substr($buffer, 0, 1) == "#") {
				//ȹԤϥå
				//The comment line is skipped.
				continue;
			}
			//Ԥԣ¤ʬ
			//The line is divided with TAB. 
			$flds = split("\t", $buffer);

			//1ĤΥեɤ뤳
			//There must be one fields.
			if ($flds[0] != "") {
				$fname = "";
				if ($flds[0] == ".") {
					$file_path = $curdir;
				} elseif ($flds[0] == "..") {
					$file_path = get_dirpath($curdir);
				} elseif (substr($flds[0], 0, 1) == ".") {
					continue;
				} else {
					$file_path = make_path($curdir, "", $flds[0]);
				}
				$fname = $flds[0];
				if (isset($flds[1])) {
					$fcomment = $flds[1];
				} else {
					$fcomment = "";
				}
				if (isset($flds[2])) {
					$fowner = $flds[2];
				} else {
					$fowner = "";
				}
				if (! isset($flds[3]) || $flds[3] == "") {
					$fdate = date("Y/m/d", filemtime($file_path));
					$ftime = date("H:i:s", filemtime($file_path));
				} else {
					$fdate =  $flds[3];
					if (isset($flds[4]) && $flds[4] != "") {
						$ftime = $flds[4];
					} else {
						$ftime = "";
					}
				}
				$fuser = "";
				if (isset($flds[5]) && $flds[5] != "") {
					$fuser = $flds[5];
				}
				$fgroup = "";
				if (isset($flds[6]) && $flds[6] != "") {
					$fgroup = $flds[6];
				}
				$fattr = $conf["DEFAULT_ATTR"];
				if (isset($flds[7]) && $flds[7] != "") {
					$tmp_attr = intval($flds[7], 8);
					if ($tmp_attr != 0) {
						$fattr = $tmp_attr;
					}
				}
				$fimg = get_file_image($curdir, $fname);

				if (file_exists($file_path)) {
					//ե륵
					//Get the file size.
					if (is_dir($file_path)) {
						//ǥ쥯ȥξ
						//For the directory
						$fsize = get_dir_use_size($file_path);
					} else {
						$fsize = filesize($file_path);
					}
				} else {
					$fsize = 0;
				}
				if ($fname != "") {
					//ե˳Ǽ
					//The file information is stored in the array.
					$files[$idx] = array(
						"name" => $fname,
						"comment" => $fcomment,
						"owner" => $fowner,
						"size" => $fsize,
						"date" => $fdate,
						"time" => $ftime,
						"user" => $fuser,
						"group" => $fgroup,
						"attr" => $fattr,
						"image" => $fimg
					);
					$idx++;
				}
			}
		}
	}
	return $files;
}

//ǥ쥯ȥΥե
//The file list in the directory is obtained.
function get_dir_file_list($dir)
{
	$file_list = array();
	$idx = 0;

	$dh = opendir($dir);
	while (($fname = readdir($dh)) !== false) {
		$file_list[$idx] = $fname;
		$idx++;
     }
     closedir($dh); 

	return $file_list;
}

//ǥ쥯ȥΥե
//The file list in the directory is obtained.
function get_dirfiles($conf, $dir, $flist)
{
	$file_list = array();
	$dir_files = array();
	$idx = 0;
	$update = FALSE;

	$file_list = get_dir_file_list($dir);

	foreach($file_list as $fname) {
		if (isset($flist) && count($flist) > 0) {
			$find = FALSE;
			$find_inf = array();
			foreach($flist as $finf) {
				if ($finf["name"] == $fname) {
					//$dir_files[$idx] = $finf;
					$find_inf = $finf;
					$find = TRUE;
					break;
				}
			}
			if ($find) {
/***
				if ($fname != "." && $fname != ".." &&
										$fname != $conf["LISTFILE"]) {
					$file_path = make_path($dir, "", $fname);
					$fdate =  date("Y/m/d", filemtime ($file_path));
					$ftime =  date("H:i:s", filemtime ($file_path));
					if ($fdate != $find_inf["date"]) {
						$find_inf["date"] = $fdate;
						$update =TRUE;
					}
					if ($ftime != $find_inf["time"]) {
						$find_inf["time"] = $ftime;
						$update =TRUE;
					}
				}
***/
				$dir_files[$idx] = $find_inf;
				$idx++;
				continue;
			}
		}
		if ($fname == ".") {
			$file_path = $dir;
			$fcomment = get_filename($dir);
		} elseif ($fname == "..") {
			$file_path = get_dirpath($dir);
			$fcomment = get_txt("upper folder");
		} elseif (substr($fname, 0, 1) == ".") {
			continue;
		} else {
			$file_path = make_path($dir, "", $fname);
			$fcomment = "";
		}
		$fdate =  date("Y/m/d", filemtime($file_path));
		$ftime =  date("H:i:s", filemtime($file_path));
		$fimg = get_file_image($dir, $fname);

		//ե륵
		//The size of the file is obtained.
		if (is_dir($file_path)) {
			//ǥ쥯ȥξ
			//For the directory
			$fsize = get_dir_use_size($file_path);
		} else {
			$fsize = filesize($file_path);
		}
		//ե˳Ǽ
		//The file information is stored in the array.
		$dir_files[$idx] = array(
			"name" => $fname,
			"comment" => $fcomment,
			"owner" => "",
			"size" => $fsize,
			"date" => $fdate,
			"time" => $ftime,
			"user" => "",
			"group" => "",
			"attr" => $conf["DEFAULT_ATTR"],
			"image" => $fimg
		);
		$update =TRUE;
		$idx++;
     }

	return array($dir_files, $update);
}

function write_file_list($listfile, $files)
{
	$conf = get_config();

	// եꥹȽ񤭹
	//File list writing
	if (!($fp = fopen ($listfile, "w"))) {
		return FALSE;
	} else {
		flock($fp, 2);

		foreach ($files as $finf) {
			$attr = $finf["attr"];
			if ($attr == 0) {
				$attr = $conf["DEFAULT_ATTR"];
			}
			$attr_str = sprintf("%04o", $attr);
			$str = $finf["name"];
			$str .= "\t" . $finf["comment"];
			$str .= "\t" . $finf["owner"];
			$str .= "\t" . $finf["date"];
			$str .= "\t" . $finf["time"];
			$str .= "\t" . $finf["user"];
			$str .= "\t" . $finf["group"];
			$str .= "\t" . $attr_str;
			fputs($fp, "$str\n");
		}

		flock($fp, 3);
		fclose($fp);

		chmod($listfile, get_data_file_attr($conf));

		return TRUE;
	}
}

//եꥹμ¥ե
//The number of real files listing the file is obtained.
function count_files($files_info)
{
	$num = 0;

	foreach ($files_info as $finf) {
		if (strncmp($finf["name"], ".", 2) != 0 &&
						strncmp($finf["name"], "..", 2) != 0) {
			$num++;
		}
	}
	return $num;
}

function get_file_info($conf, $fname)
{
	$finf = array();

	$finf["name"] = "";
	$finf["comment"] = "";
	$finf["owner"] = "";
	$finf["date"] = "";
	$finf["time"] = "";
	$finf["user"] = "";
	$finf["group"] = "";
	$finf["attr"] = "";

	if ($conf["TOPDIR"] != $fname) {
		$curdir = get_dirpath($fname);
		$name = get_filename($fname);

		$list_files = read_filelist($curdir, $conf["LISTFILE"]);

		foreach ($list_files as $inf) {
			if ($inf["name"] == $name) {
				$finf = $inf;
				break;
			}
		}
	}
	return $finf;
}

function put_file_info($conf, $fname, $finf)
{
	if ($conf["TOPDIR"] != $fname) {
		$curdir = get_dirpath($fname);
		$name = get_filename($fname);

		$list_files = read_filelist($curdir, $conf["LISTFILE"]);

		$find = FALSE;
		for ($i = 0; $i < count($list_files); $i++) {
			$inf = $list_files[$i];
			if ($inf["name"] == $name) {
				$list_files[$i] = $finf;
				$find = TRUE;
				break;
			}
		}
		if (!$find) {
			$list_files[$i] = $finf;
		}
		$listfile = make_path($curdir, "", $conf["LISTFILE"]);
		write_file_list($listfile, $list_files);

	}
}

//եդ򹹿
//Update folder date and time.
function update_dir_time($conf, $dirpath, $date, $time)
{
	$sts = TRUE;

	//ƥǥ쥯ȥ
	//Get parent directory
	$parent_dir = get_dirpath($dirpath);

	$fdate = $date;
	$ftime = $time;
	if (! isset($date) || $date == "") {
		$fdate =  date("Y/m/d");
		$ftime =  date("H:i:s");
	} else {
		$fdate = $date;
		if (isset($time)) {
			$ftime = $time;
		} else {
			$ftime = "";
		}
	}
	//å
	//It locks.
	$lockfile = make_path($parent_dir, "", $conf["LOCKFILE"]);
	$lock_fp = lock_files($lockfile);
	if (! $lock_fp) {
		$msg .= get_txt("cannot lock") . "<br>\n";
		$sts = FALSE;
	} else {
		//եξɤ߹
		//Read folder info.
		$finf = get_file_info($conf, $dirpath);

		$finf["date"] = $fdate;
		$finf["time"] = $ftime;

		//դѹեξ񤭹
		//Write modified date and time info.
		put_file_info($conf, $dirpath, $finf);

		//å
		//The lock is released.
		unlock_files($lock_fp, $lockfile);
	}
	return $sts;
}

function get_current_info($files_info)
{
	$fname = "";
	$comment = "";
	$owner = "";
	foreach ($files_info as $finf) {
		if (strncmp($finf["name"], ".", 2) == 0) {
			$fname = realpath($finf["name"]);
			$fname = get_filename($fname);
			$comment = $finf["comment"];
			$owner = $finf["owner"];
			break;
		}
	}
	return array($fname, $comment, $owner);
}

function search_file_inf($file_list, $path)
{
	$finf = array();

	$finf["name"] = "";
	$finf["comment"] = "";
	$finf["owner"] = "";
	$finf["date"] = "";
	$finf["time"] = "";
	$finf["user"] = "";
	$finf["group"] = "";
	$finf["attr"] = "";

	$fname = get_filename($path);
	foreach($file_list as $inf) {
		if ($inf["name"] == $fname) {
			$finf = $inf;
			break;
		}
	}
	return $finf;
}

// ե
//The folder is made.
function make_dir($dirname, $mode = 0777)
{
	if (file_exists($dirname)) {
		return TRUE;
	}
	$dname = dirname($dirname);

	if (!file_exists($dname)) {
		if (!make_dir($dname, $mode)) {
			return FALSE;
		}
	}
	$sts = mkdir($dirname, $mode);
	if ($sts) {
		chmod($dirname, $mode);
	}
	return $sts;
}

// եȤΥե
//The folder and the file in that are deleted.
function delete_dir($dirname)
{
	$sts = TRUE;

	$dh = opendir($dirname);
	while (($fname = readdir($dh)) !== false) {
		if (strncmp($fname, ".", 2) != 0 && strncmp($fname, "..", 3) != 0) {
			$file_path = make_path($dirname, "", $fname);
			if (is_dir($file_path)) {
				$sts = delete_dir($file_path);
			} else {
				$sts = unlink($file_path);
			}
			if (! $sts) {
				break;
			}
		}
	}
	closedir($dh);
	if ($sts) {
		$sts = rmdir($dirname);
	}
	return $sts;
}

// եȤΥե
//The folder and the file in that are deleted.
function delete_dir_with_permit($conf, $dirname, $user, $group_list)
{
	$finf_list = read_filelist($dirname, $conf["LISTFILE"]);
	
	$dh = opendir($dirname);
	while (($fname = readdir($dh)) !== false) {
		if (strncmp($fname, ".", 2) != 0 && strncmp($fname, "..", 3) != 0) {
			$file_path = make_path($dirname, "", $fname);

			$finf = search_file_inf($finf_list, $file_path);

			$permit = get_permission($conf, $finf, $user, $group_list);
			if (!$permit["w"]) {
				return false;
			}
			if (is_dir($file_path)) {
				if (!$permit["r"] || !$permit["x"]) {
					return false;
				}
				$sts = delete_dir_with_permit($conf, $file_path,
												$user, $group_list);
			} else {
				$sts = unlink($file_path);
			}
			if (! $sts) {
				break;
			}
		}
	}
	closedir($dh);
	if ($sts) {
		$sts = rmdir($dirname);
	}
	return $sts;
}

// եȤΥեκ¤
//The deletion authority of the folder and the file in that is acquired.
function check_delete_permit($conf, $dirname, $user, $group_list)
{
	$sts = TRUE;

	$finf_list = read_filelist($dirname, $conf["LISTFILE"]);
	
	$dh = opendir($dirname);
	while (($fname = readdir($dh)) != false) {
		if (strncmp($fname, ".", 2) != 0 && strncmp($fname, "..", 3) != 0) {
			$file_path = make_path($dirname, "", $fname);

			$finf = search_file_inf($finf_list, $file_path);

			if ($finf["name"] != "") {
				$permit = get_permission($conf, $finf, $user, $group_list);
			} else {
				$permit["r"] = 1;
				$permit["w"] = 1;
				$permit["x"] = 1;
			}
			$sts = FALSE;
			if ($permit["w"]) {
				if (is_dir($file_path)) {
					if ($permit["r"] && $permit["x"]) {
						$sts = check_delete_permit($conf, $file_path,
														$user, $group_list);
					}
				} else {
					$sts = TRUE;
				}
			}
			if (! $sts) {
				break;
			}
		}
	}
	closedir($dh);

	return $sts;
}

// եȤΥեɤ߹߸¤
// The reading authority of the folder and the file in that is acquired.
function check_read_permit($conf, $dirname, $user, $group_list)
{
	$finf_list = read_filelist($dirname, $conf["LISTFILE"]);
	
	$dh = opendir($dirname);
	while (($fname = readdir($dh)) != false) {
		if (strncmp($fname, ".", 2) != 0 && strncmp($fname, "..", 3) != 0) {
			$file_path = make_path($dirname, "", $fname);

			$finf = search_file_inf($finf_list, $file_path);

			$permit = get_permission($conf, $finf, $user, $group_list);
			$sts = FALSE;
			if ($permit["r"]) {
				if (is_dir($file_path)) {
					if ($permit["r"] && $permit["x"]) {
						$sts = check_delete_permit($conf, $file_path,
														$user, $group_list);
					}
				} else {
					$sts = TRUE;
				}
			}
			if (! $sts) {
				break;
			}
		}
	}
	closedir($dh);

	return $sts;
}

// եΥԡ
//Copy of folder
function copy_dir($dirname, $dstdir, $attr)
{
	$sts = TRUE;
	$conf = get_config();

	if (!is_dir($dirname)) {
		return FALSE;
	}
	if (!($dh = opendir($dirname))) {
		return FALSE;
	}
	if (!file_exists($dstdir)) {
		make_dir($dstdir, $attr);
	} else {
		if (!is_dir($dstdir)) {
			closedir($dh);
			return FALSE;
		}
	}
	while (($fname = readdir($dh)) != false) {
		if (strncmp($fname, ".", 2) != 0 && strncmp($fname, "..", 3) != 0) {
			$src_path = make_path($dirname, "", $fname);
			$dst_path = make_path($dstdir, "", $fname);
			if (is_dir($src_path)) {
				$sts = copy_dir($src_path, $dst_path, $attr);
			} else {
				$sts = copy($src_path, $dst_path);
			}
			if (! $sts) {
				break;
			}
		}
	}
	closedir($dh);

	return $sts;
}

// եΥԡ
//Copy of folder
function copy_dir_with_permit($conf, $dirname, $dstdir, $user, $group_list)
{
	$sts = TRUE;

	$finf_list = read_filelist($dirname, $conf["LISTFILE"]);

	if (!is_dir($dirname)) {
		return FALSE;
	}
	if (!($dh = opendir($dirname))) {
		return FALSE;
	}
	if (!file_exists($dstdir)) {
		make_dir($dstdir, get_data_dir_attr($conf));
	} else {
		if (!is_dir($dstdir)) {
			closedir($dh);
			return FALSE;
		}
	}
	while (($fname = readdir($dh)) != false) {
		if (strncmp($fname, ".", 2) != 0 && strncmp($fname, "..", 3) != 0) {
			$src_path = make_path($dirname, "", $fname);
			$dst_path = make_path($dstdir, "", $fname);

			$finf = search_file_inf($finf_list, $src_path);

			$permit = get_permission($conf, $finf, $user, $group_list);
			if (!$permit["r"]) {
				return false;
			}
			if (is_dir($src_path)) {
				if (!$permit["r"] || !$permit["x"]) {
					return false;
				}
				$sts = copy_dir_with_permit($conf, $src_path, $dst_path,
													$user, $group_list);
			} else {
				$sts = copy($src_path, $dst_path);
			}
			if (! $sts) {
				break;
			}
		}
	}
	closedir($dh);

	return $sts;
}

// Ѳǽ̤
//The capacity that can be used is obtained.
function get_free_size($conf)
{
	// Ѳǽ
	//Size that can be maximum used
	$maxsize = $conf["MAX_TOTAL_SIZE"];

	// ǥ
	//Empty capacity of disk
	$disk_free_size = diskfreespace($conf["TOPDIR"]);
	if ($disk_free_size  < $maxsize) {
		$maxsize = $disk_free_size;
	}
	// ѥ
	//Use size
	$use_size = get_dir_use_size($conf["TOPDIR"]);

	// Ѳǽ
	//Size that can be used
	$free_size = $maxsize - $use_size;

	return $free_size;
}

// ǥѾʸ
//The disk usage condition character string is obtained.
function get_disk_info_str($conf)
{
	// Ѳǽ
	//Size that can be maximum used
	$maxsize = $conf["MAX_TOTAL_SIZE"];

	// ǥ
	//Empty capacity of disk
	$disk_free_size = diskfreespace($conf["TOPDIR"]);
	if ($disk_free_size  < $maxsize) {
		$maxsize = $disk_free_size;
	}
	// ѥ
	//Used size
	$use_size = get_dir_use_size($conf["TOPDIR"]);

	// Ѳǽ
	//Size that can be used
	$free_size = $maxsize - $use_size;

	$maxsize = get_filesize_str($maxsize);
	$use_size = get_filesize_str($use_size);
	$free_size = get_filesize_str($free_size);

	$str = get_txt("use size") . "&nbsp;:&nbsp;" . $use_size . "/" . $maxsize;
	$str .= "&nbsp;(" . get_txt("use capacity") . "&nbsp;:&nbsp;" . $free_size . ")";

	return $str;
}

//ǥѾHTML
//Disk usage condition HTML is acquired.
function get_header_info_HTML($conf, $user_id_flg, $disk_info_flg, $help_flg)
{
	$disk_info_str = get_disk_info_str($conf);

	$html = "<TABLE width=95% border=0>";
	$html .= "<TR>";

	if ($user_id_flg) {
		$html .= "<TD align=left>" . get_txt("user id") .
						"&nbsp;:&nbsp;" . get_login_user() . "</TD>";
		$html .= "<TD>&nbsp;</TD>";
	}
	if ($disk_info_flg) {
		$html .= "<TD align=right>" . $disk_info_str . "</TD>";
	} else {
		$html .= "<TD>&nbsp;</TD>";
	}
	if ($help_flg) {
		$html .= "<TD width=70 align=right>[<a href=\"manual/index.html\"" .
						" target=\"_blank\">" . get_txt("help") . "</a>]</TD>";
	} else {
		$html .= "<TD>&nbsp;</TD>";
	}
	$html .= "</TR>";
	$html .= "</TABLE>";

	return $html;
}

//ڡȥHTML
//Page title HTML is acquired.
function get_page_title_HTML($conf)
{
	$ret_html = "";

	//ڡȥΥ᡼ޤʸɽ
	//The image or the character string in page title is displayed.
	if ($conf["TITLEIMG"] != "") {
		$img = make_path($conf["IMGDIR"], "", $conf["TITLEIMG"]);
		$width = $conf["ptitleimg_w"];
		$height = $conf["ptitleimg_h"];
		$ret_html = "<IMG src=\"$img\" width=$width  height=$height>\n";
	} else {
		$ptitle = $conf["TITLESTR"];
		$ret_html = "<H2>$ptitle</H2>\n";
	}
	return $ret_html;
}

//ڡإåHTML
//Page header HTML is acquired.
function get_page_header_HTML($conf, $comment_key, $disk_info_flg, $help_flg)
{
	$ret_html = <<<_END_OF__DATA__
<CENTER>
<TABLE align=center border=0><TBODY>
	<TR>
		<TD>
			<CENTER>
_END_OF__DATA__;

	//ڡȥΥ᡼ޤʸ
	//Image or character string in page title
	$ret_html .= get_page_title_HTML($conf);

	$ret_html .= <<<_END_OF__DATA__
			</CENTER>
		</TD>
	</TR>
</TBODY></TABLE>
_END_OF__DATA__;

	//ȥ벼Υȹɽ
	//Comment line display under title
	if (isset($conf[$comment_key]) && $conf[$comment_key] != "") {
		$ret_html .= "<CENTER>" . $conf[$comment_key] . "</CENTER>";
	}
	//裱裲ؤΥ󥯤ɽHTML
	//Link HTML to return 1 and return 2 destination is generated.
	$ret_html .= get_return_url_HTML($conf);
	$ret_html .= get_header_info_HTML($conf, TRUE, $disk_info_flg, $help_flg);
	$ret_html .= <<<_END_OF__DATA__
</CENTER>
_END_OF__DATA__;

	return $ret_html;
}

//ڡեåHTML
//Page footer HTML is acquired.
function get_page_footer_HTML($conf)
{
	$ret_html = "";

	$prog_name = get_program_name();
	$varsion = get_version_no();
	$copy_right = get_copyright_str();
	$homepage = get_homepage();

	$ret_html = <<<_END_OF__DATA__
	<br>
	<hr>
	<table width=95% align=center border=0>
	<tr>
		<td width=70>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
		<td align=center>
			<a href="$homepage">
			$prog_name ver. $varsion
			</a>
		</td>
_END_OF__DATA__;

	$ret_html .= "<td width=70 align=right>[<a href=\"manual/index.html\"" . 
						" target=\"_blank\">" . get_txt("help") . "</a>]</td>";

	$ret_html .= <<<_END_OF__DATA__
	</tr>
<!-- -->
	<tr>
		<td width=70>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
		<td align=center>$copy_right</td>
		<td width=70>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
	</tr>
<!-- -->
	<table>
_END_OF__DATA__;

	return $ret_html;
}

// Σգң̤HTMLʸ
//HTML that returns to former URL is acquired.
function get_return_refer_url_HTML($url, $str)
{
	$html = "<A HREF=\"" . conv_url_code($url) . "\"><B>$str</B></A>";

	return $html;
}

//URLHTML
//HTML of URL at the return destination is acquired.
function make_return_url_HTML($returl, $title, $font_color)
{
	$ret_html = "";

	// գң̤Хɽ
	//It displays it the link if there is URL at the return destination.
	if (isset($returl) &&  $returl != "") {
		$rettitle = $returl;
		if (isset($title)) {
			$rettitle = $title;
		}
		$ret_html = "<A href=\"" . conv_url_code($returl) . "\">";
		if (isset($font_color) && $font_color != "") {
			$ret_html .= "<FONT color=$font_color>";
		}
		$ret_html .= $rettitle;
		if (isset($font_color) && $font_color != "") {
			$ret_html .= "</FONT>";
		} 
		$ret_html .= "</A>\n";
	} else {
		$ret_html = "&nbsp;&nbsp;";
	}
	return $ret_html;
}

// 裱裲ؤΥ󥯤ɽHTML
//Link HTML to return 1 and return 2 destination is generated.
function get_return_url_HTML($conf)
{
	$next_align = "left";
	$html = "<TABLE width=95% border=0><TBODY>\n";
	$html .= "<TR>";
	if (isset($conf["returl"]) && $conf["returl"] != "") {
		// գң̤к¦˥ɽ
		//It displays it left the link if there is URL at the
		//return destination.
		$html .= "<TD align=$next_align>" . make_return_url_HTML($conf["returl"], get_txt("back"), "") . "</TD>\n";
		$next_align = "center";
	}
	// գң̣к¦˥ɽ
	//It displays it left the link if there is URL1 at the return destination.
	$html .= "<TD align=$next_align>" . make_return_url_HTML($conf["RETURL1"], $conf["returntitle1"], "") . "</TD>\n";
	// գң̣б¦˥ɽ
	//It displays it left the link if there is URL2 at the return destination.
	$html .= "<TD align=right>" . make_return_url_HTML($conf["RETURL2"], $conf["returntitle2"], "#ff0000") . "</TD>\n";
	$html .= "</TR>\n";

	$html .= "</TBODY></TABLE>\n";

	return $html;
}

// եHTMLʸ\
//HTML that returns to the file list is acquired.
function get_return_files_HTML($conf)
{
	$s_name = files_session_name();
	$s_id = session_id();

	$filesurl = $conf["FILES_SCRIPT"];
	$filesurl .= "?dir=" . conv_url_code($conf["curdir"]);
	$filesurl .= "&config=" . conv_url_code($conf["config"]);
	$filesurl .= "&" . $s_name . "=" . $s_id;

	$html = "<A HREF=\"" . $filesurl . "\"><B>" . 
						get_txt("back to file list") . "</B></A>";

	return $html;
}

// ΥڡHTMLʸ\
//HTML that returns to the previous page is acquired.
function get_return_prev_page_HTML($conf, $prev_page, $title)
{
	$s_name = files_session_name();
	$s_id = session_id();
	if (!isset($title) || $title == "") {
		$title = get_txt("back to previous page");
	}
	$prevurl = $prev_page;
	$prevurl .= "?dir=" . conv_url_code($conf["curdir"]);
	$prevurl .= "&config=" . conv_url_code($conf["config"]);
	$prevurl .= "&" . $s_name . "=" . $s_id;

	$html = "<A HREF=\"" . $prevurl . "\"><B>" . $title . "</B></A>";

	return $html;
}

// JavaScriptȤäƥե˥쥯ȤHTMLʸ
//HTML redirected to the file list by using JavaScript is acquired.
function get_redirect_files_JavaScriptHTML($conf)
{
	$title = $conf["HEADER_TITLE"];
	$script = $conf["FILES_SCRIPT"];
	$dir = $conf["curdir"];
	$config = $conf["config"];
	$returl = $conf["returl"];
	$s_name = files_session_name();
	$s_id = session_id();

	$html = <<<__END_OF_DATA__
<HTML>
<HEAD>
__END_OF_DATA__;

	$html .= get_charset_line();

	$html .= <<<__END_OF_DATA__
<TITLE>$title</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!--
function start() {
	document.form1.submit();
}
// -->
</SCRIPT>
</HEAD>
<BODY onLoad="start()">
<form name="form1" action="$script" method="post">
	<input type="hidden" name="dir" value="$dir">
	<input type="hidden" name="config" value="$config">
	<input type="hidden" name="returl" value="$returl">
	<input type="hidden" name="$s_name" value="$s_id">
</form>
</BODY>
</HTML>
__END_OF_DATA__;

	return $html;
}

// JavaScriptȤäƻURL˥쥯ȤHTMLʸ
//HTML redirected to specification URL by using JavaScript is acquired.
function get_redirect_url_JavaScriptHTML($url)
{
	$s_name = files_session_name();
	$s_id = session_id();

	if (strstr($url, "?")) {
		$url .= "&" . $s_name . "=" . $s_id;
	} else {
		$url .= "?" . $s_name . "=" . $s_id;
	}

	$html = <<<__END_OF_DATA__
<HTML>
<HEAD>
__END_OF_DATA__;

	$html .= get_charset_line();

	$html .= <<<__END_OF_DATA__
<TITLE>	Jump To <?php echo $url; ?></TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!--
function start() {
	location.href = "$url";
}
// -->
</SCRIPT>
</HEAD>
<BODY onLoad="start()">
</BODY>
</HTML>
__END_OF_DATA__;

	return $html;
}

// JavaScriptȤä˥塼˥쥯ȤHTMLʸ
//HTML redirected to a set menu by using JavaScript is acquired.
function get_redirect_confmenu_JavaScriptHTML($conf)
{
	$title = $conf["HEADER_TITLE"];
	$script = $conf["CONFMENU_SCRIPT"];
	$config = $conf["config"];
	$returl = $conf["returl"];
	$s_name = files_session_name();
	$s_id = session_id();

	$html = <<<__END_OF_DATA__
<HTML>
<HEAD>
__END_OF_DATA__;

	$html .= get_charset_line();

	$html .= <<<__END_OF_DATA__
<TITLE>$title</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!--
function start() {
	document.form1.submit();
}
// -->
</SCRIPT>
</HEAD>
<BODY onLoad="start()">
<form name="form1" action="$script" method="post">
	<input type="hidden" name="config" value="$config">
	<input type="hidden" name="returl" value="$returl">
	<input type="hidden" name="$s_name" value="$s_id">
</form>
</BODY>
</HTML>
__END_OF_DATA__;

	return $html;
}

function get_upload_file_info()
{
	$upload_info = array();

	if (isset($UploadFile_name) &&
					isset($UploadFile_size) && isset($UploadFile)) {
		$upload_info['name'] = $UploadFile_name;
		$upload_info['size'] = $UploadFile_size;
		$upload_info['tmp_name'] = $UploadFile;
	} elseif (isset($HTTP_POST_FILES) &&
					isset($HTTP_POST_FILES['UploadFile'])) {
		$upload_info["name"] = $HTTP_POST_FILES['UploadFile']['name'];
		$upload_info["size"] = $HTTP_POST_FILES['UploadFile']['size'];
		$upload_info["tmp_name"] = $HTTP_POST_FILES['UploadFile']['tmp_name'];
	} elseif (isset($_FILES) && isset($_FILES['UploadFile'])) {
		$upload_info["name"] = $_FILES['UploadFile']['name'];
		$upload_info["size"] = $_FILES['UploadFile']['size'];
		$upload_info["tmp_name"] = $_FILES['UploadFile']['tmp_name'];
	}
	return $upload_info;
}

?>