<?php
/******************************************************************************
	Files(WEBե붦ͭPHPץ)
	Files(WEB file share PHP script)

	ե롿եΥåȡԡ
	Cut and copy processing of file or folder

  	cut.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2008 Technoworks Co., Ltd. All rights reserved.

	Update:

	Ver.2.3
		ϰϳΥǥåؤλȤԤʤ褦˽
		It was corrected that it did not refer to the index beyond the 
		limits of the array.

	Ver.2.1
		եɲ
		The configuration file arrangement setting is added.

	Ver.2.0
		ɽʸ locale.php 褦˽
		The display character string was acquired from locale.php. 

		ʸɤλ locale.php 褦˽
		The specification of the character-code was acquired from locale.php.

		ͭԤȥ롼פˤ륢浡ǽղ
		The access control function by the group is added with the owner. 

		HTMLʬˣХʸѤʤ褦˽
		֥饦ʸɼưȽ̤˱ƶʤ褦ˤ뤿
		To make it not misidentified by the character-code automatic operation 
		identification of a browser, it was corrected that Japanese was not 
		used for the HTML part. 

	Ver.1.4 ޤǤι
	Update history to Ver.1.4
		2005/08/02	̤Υڡإåʬؿɲ
					A common page header partial function is added. 
******************************************************************************/

require('files_com.php');

$conf = init_files(FALSE);

$mode = get_post_get_val("mode");
$fname = get_post_get_val("fname");
$comment = get_post_get_val("comment");
$owner = get_post_get_val("owner");
$date = get_post_get_val("date");
$time = get_post_get_val("time");
$user = get_post_get_val("user");
$group = get_post_get_val("group");
$attr = get_post_get_val("attr");

$scriptname = "cut.php";

$msg = "";
$sts = FALSE;

if ($mode != "copy") {
	$mode = "cut";
}

$login_user = get_login_user();
$login_user_groups = get_user_groups($conf, $login_user);

//ȥǥ쥯ȥΥѥ
//The path in the current directory is made.
$curdir = make_path($conf["TOPDIR"], $conf["curdir"], "");

//ȥǥ쥯ȥξ
//Information on the current directory is obtained.
$curdir_inf = get_file_info($conf, $curdir);

//ȥǥ쥯ȥΥѡߥå
//The permission of the current directory is obtained.
$curdir_permit = get_permission($conf, $curdir_inf,
								$login_user, $login_user_groups);

$path = make_path($curdir, "", $fname);
$folder_flg = is_dir($path);

//եξ
//Information on the targeted file is obtained.
$finf = get_file_info($conf, $path);

$permit = get_permission($conf, $finf,
							$login_user, $login_user_groups);

//ڼꡦԡ
//Cutout and copy processing
if ((!($curdir_permit["w"] && $permit["w"]) || ($folder_flg && !$permit["x"])) && $mode == "cut") {
	//񤭹߸̵
	//There is no writing right.
	$msg = get_txt("writing has not been permitted");
} else if ($fname != "") {
	$dstpath = make_path($conf["CUTDIR"], "", $fname);

	if ($folder_flg) {
		$type_str = get_txt("folder");
	} else {
		$type_str = get_txt("file");
	}
	$sts = TRUE;
	if (!file_exists($conf["CUTDIR"])) {
		$sts = make_dir($conf["CUTDIR"], get_data_dir_attr($conf));
		if (!sts) {
			$err_msg = get_txt("cannot make cut buffer folder");
			$msg .= $err_msg . "<br>\n";
			put_log($conf, $mode . " failure:" .
								$err_msg . ":" . $conf["CUTDIR"]);
		}
	}
	if ($sts) {
		$sts = FALSE;
		if (file_exists($dstpath)) {
			$err_msg = get_txt("the file name overlaps");
			$msg .= $err_msg . ":" . $type_str . "<br>\n";
			put_log($conf, $mode . " failure:" . $err_msg . ":" . $dstpath);
		} else {
			if ($mode != "copy") {
				if ($folder_flg &&
						!check_delete_permit($conf, $path, $login_user, $login_user_groups)) {
					$err_msg = get_txt("writing has not been permitted");
					$msg .= $err_msg . ":" . $type_str . "<br>\n";
					put_log($conf, $mode . " failure:" . $err_msg . ":" . $dstpath);
				} else {
					// ե̾ѹ
					//Change in file name
					$sts = rename($path, $dstpath);
					if (!$sts) {
						$msg .= $type_str . "(" . $fname . "):" .
										get_txt("cannot cut") . "<br>\n";
						put_log($conf, "Cut failure : " . $msg);
					} else {
						put_log($conf, "Cut File=" . $path .
										" User=" . $login_user);
					}
				}
			} else {
				if ($folder_flg &&
						!check_read_permit($conf, $path, $login_user, $login_user_groups)) {
						$err_msg = get_txt("reading has not been permitted");
						$msg .= $err_msg . ":" . $type_str . "<br>\n";
						put_log($conf, $mode . " failure:" . $err_msg . ":" . $dstpath);
				} else {
					if ($folder_flg) {
						$sts = copy_dir_with_permit($conf, $path, $dstpath,
											$login_user, $login_user_groups);
					} else {
						// եΥԡ
						//Copy of file
						$sts = copy($path, $dstpath);
					}
					if (!$sts) {
						$msg .= $type_str . "(" . $fname . "):" .
										get_txt("cannot copy") . "<br>\n";
						put_log($conf, "Copy failure : " . $msg);
					} else {
						put_log($conf, "Copy File=" . $path .
										" User=" . $login_user);
					}
				}
			}
		}
	}
	if ($sts) {
		if ($mode != "copy") {
			//ȥǥ쥯ȥå
			//The current directory is locked.
			$lockfile = make_path($curdir, "", $conf["LOCKFILE"]);
			$lock_fp = lock_files($lockfile);
			if (! $lock_fp) {
				//å
				//The lock is released.
				$msg .= get_txt("cannot lock current folder") . "<br>\n";
				$sts = FALSE;
				put_log($conf, "Cut failure : can not lock");
			} else {
				//ȥǥ쥯ȥΥեꥹȤ򹹿
				//The file list of the current directory is updated.

				// եꥹȤɤ߹
				//The file list is read.
				$listfile = make_path($curdir, "", $conf["LISTFILE"]);
				if (file_exists($listfile)) {
					$list_files = read_filelist($curdir, $conf["LISTFILE"]);
				}
				//ȥǥ쥯ȥΥե
				//The file list in the current directory is obtained.
				list($files, $update) = get_dirfiles($conf,
													$curdir, $list_files);

				// ȥǥ쥯ȥΥեꥹȽ񤭹
				//File list of current directory writing
				if (!write_file_list($listfile, $files)) {
					$msg .= get_txt("cannot write file list") . 
										":" . $listfile . "<br>\n";
					$sts = FALSE;
					put_log($conf, "Cut failure : " . $path .
											" : can not update file list");
				}
				//ȥǥ쥯ȥΥå
				//The lock of the current directory is released.
				unlock_files($lock_fp, $lockfile);

				if ($sts) {
					//եդ򹹿
					update_dir_time($conf, $curdir, "", "");
				}
			}
		}
		//åȥХåեå
		//The cutting buffer is locked.
		$cutlockfile = make_path($conf["CUTDIR"], "",$conf["LOCKFILE"]);
		$cutlock_fp = lock_files($cutlockfile);
		if (! $cutlock_fp) {
			$msg .= get_txt("cannot lock cut buffer") . "<br>\n";
			$sts = FALSE;
			put_log($conf, $mode . " failure : " . $path .
										" : can not lock cut buffer");
		} else {
			//åȥХåեΥեꥹȤ򹹿
			//The file list of the cutting buffer is updated.

			// åȥХåեΥեꥹȤɤ߹
			//The file list of the cutting buffer is read.
			$listfile = make_path($conf["CUTDIR"], "", $conf["LISTFILE"]);
			if (file_exists($listfile)) {
				$list_files = read_filelist($conf["CUTDIR"], $conf["LISTFILE"]);
			}
			//åȥХåեΥե
			//The file list in the cutting buffer is obtained.
			list($files, $update) = get_dirfiles($conf,
												$conf["CUTDIR"], $list_files);

			if (isset($login_user_groups) && isset($login_user_groups[0])) {
				$login_group = $login_user_groups[0];
			} else {
				$login_group = "";
			}

			for ($i = 0; $i < count($files); $i++) {
				$finf = $files[$i];
				if ($finf["name"] == $fname) {
					$finf["name"] = $fname;
					$finf["comment"] = $comment;
					$finf["owner"] = $owner;
					$finf["date"] = $date;
					$finf["time"] = $time;
					if ($mode != "cut") {
						$finf["user"] = $login_user;
						$finf["group"] = $login_group;
						$finf["attr"] = get_attr_val("rwxrwxrwx");
					} else {
						$finf["user"] = $user;
						$finf["group"] = $group;
						$finf["attr"] = $attr;
					}
					$files[$i] = $finf;
					break;
				}
			}
			// åȥХåեΥեꥹȽ񤭹
			//File list of cutting buffer writing
			if (!write_file_list($listfile, $files)) {
				$msg .= get_txt("cannot write cut buffer file list") .
										":" . $listfile . "<br>\n";
				$sts = FALSE;
				put_log($conf, $mode . " failure : " . $path .
									" : can not update file list");
			}
			//å
			//The lock is released.
			unlock_files($cutlock_fp, $cutlockfile);
			if ($sts) {
				put_log($conf, $mode . " success : " . $path);
			}
		}
	}
} else {
	$msg .= get_txt("file name is not specified") . "<br>\n";
	put_log($conf, $mode . " failure : no filename");
}

if ($sts) {
	//ե˥쥯Ȥ
	//It redirects it to the file list.
	echo get_redirect_files_JavaScriptHTML($conf);
	exit;
}

?>
<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>
<HR>
<?php
if (!$sts) {
	echo $msg;
	echo "<HR>";
	//եHTMLʸ
	//The HTML string to return to the file list is acquired.
	echo get_return_files_HTML($conf);
}
?>
<?php
//ڡեåʥץࡦСCopyrightɽ
//Page footer(program version and Copyright display)
echo get_page_footer_HTML($conf);
?>
</BODY>
</HTML>
