<?php
/******************************************************************************
	Files(WEBե붦ͭPHPץ)
	Files(WEB file share PHP script)

	ͭե
	Shared folder deletion processing

  	delconf.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2008 Technoworks Co., Ltd. All rights reserved.

	Update:

	Ver.2.1
		configեȤ̤Υǥ쥯ȥindex.php褦ˤ
		I made index.php in another directory with the config file

		եɲ
		The configuration file arrangement setting is added.

	Ver.2.0
		ɽʸ locale.php 褦˽
		The display character string was acquired from locale.php. 

		ʸɤλ locale.php 褦˽
		The specification of the character-code was acquired from locale.php.

		ͭԤȥ롼פˤ륢浡ǽղ
		The access control function by the group is added with the owner. 

		HTMLʬˣХʸѤʤ褦˽
		֥饦ʸɼưȽ̤˱ƶʤ褦ˤ뤿
		To make it not misidentified by the character-code automatic operation 
		identification of a browser, it was corrected that Japanese was not 
		used for the HTML part. 

	Ver.1.4 ޤǤι
	Update history to Ver.1.4
		2005/08/02	ڡإåʬ̲
					A common page header partial function is added. 
******************************************************************************/

require('files_com.php');

$conf = init_files(FALSE);

$scriptname = "delconf.php";

$s_name = files_session_name();
$s_id = session_id();

$submit = get_post_get_val("submit");
$mode = get_post_get_val("mode");
$return_url = get_post_get_val("return_url");
$returl = get_post_get_val("returl");
$config_name = get_post_get_val("config_name");
$topdir = get_post_get_val("topdir");

$config_dir = make_path(get_conf_top_dir($conf), "", $config_name);

$entry_page_url = get_entry_page_top_url($conf) . "/" . $config_name . "/";
$entry_page_dir = get_entry_page_top_dir($conf) . "/" . $config_name;

$conf["returl"] = $return_url . "?config=" . $conf["config"];
$conf["returl"] .= "&" . $s_name . "=" . $s_id;

?>

<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>

<?php
//ڡإåHTML
//Page header HTML is acquired.
echo get_page_header_HTML($conf, "", FALSE, $conf["SHOW_HELP_LINK"]);
?>

<CENTER>
<HR>

<?php

if ($mode != "send") {
	//ͭեեɽ
	//Shared folder deletion form display
	if (! isset($config_name)) {
		$config_name = "";
	}
?>

<form action="<?php echo $conf["DELCONF_SCRIPT"] ?>" method="post">
	<input type="hidden" name="mode" value="send">
	<input type="hidden" name="config" value="<?php echo $conf["config"] ?>">
	<input type="hidden" name="config_name" value="<?php echo $config_name; ?>">
	<input type="hidden" name="topdir" value="<?php echo $topdir; ?>">
	<input type="hidden" name="return_url" value="<?php echo $return_url ?>">
	<input type="hidden" name="<?php echo $s_name ?>" value="<?php echo $s_id ?>">
	<TABLE border=1><TBODY>
		<TR BGCOLOR="<?php echo $conf["LIST_TITLE_BG"] ?>">
			<TD colspan=2>
				<CENTER>
					<B><?php echo get_txt("delete shared folder"); ?></B>
				</CENTER>
			</TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("name"); ?></B></TD>
			<TD><?php echo $config_name; ?></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("connect url"); ?></B></TD>
			<TD><?php echo $entry_page_url; ?></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("top folder full path"); ?></B></TD>
			<TD><?php echo $topdir; ?></TD>
		</TR>
		<TR>
			<TD colspan=2>
				<CENTER>
				<input type="submit" name="submit"
									value="<?php echo get_txt("delete"); ?>">
				<input type="reset" value="<?php echo get_txt("reset"); ?>">
				</CENTER>
			</TD>
		</TR>
	</TBODY></TABLE>
</form>

<?php

} else {
	//ե
	//Folder deletion processing
	$msg = "";
	$sts = TRUE;
	$lock_fp = FALSE;

	if ($submit == "") {
		$sts = FALSE;
	} else {
		// Ƭǥ쥯ȥ̵ͭǧ
		//The presence of the first directory is confirmed.
		if ($topdir != "") {
			if (file_exists($topdir)) {
				$sts = delete_dir($topdir);
				if (!$sts) {
					put_log($conf, "Delete config failure " . $config_name .
											" can not delete data folder");
				}
			}
		}
		if ($sts) {
			// ǥ쥯ȥ̵ͭǧ
			//The presence of a config directory is confirmed.
			if ($config_dir == "" || !file_exists($config_dir)) {
				$msg .= get_txt("config folder is not specified") . "<br>\n";
				$sts = FALSE;
				put_log($conf, "Delete config failure " . $config_name .
														" no config dir");
			} else {
				$sts = delete_dir($config_dir);
				if (!$sts) {
					put_log($conf, "Delete config failure " . $config_name .
											" can not delete config folder");
				}
			}
			if ($sts) {
				put_log($conf, "Delete config " . $config_name . " success");
			}
		}
		if ($sts) {
			// ǥ쥯ȥ̵ͭǧ
			//The presence of a entry page directory is confirmed.
			if ($entry_page_dir == "" || !file_exists($entry_page_dir)) {
				$msg .= get_txt("entry page folder is not specified") . "<br>\n";
				$sts = FALSE;
				put_log($conf, "Delete entry page failure " . $entry_page_dir .
														" no entry page dir");
			} else {
				$sts = delete_dir($entry_page_dir);
				if (!$sts) {
					put_log($conf, "Delete config failure " . $entry_page_dir .
										" can not delete entry page folder");
				}
			}
			if ($sts) {
				put_log($conf, "Delete entry page " .
									$entry_page_dir . " success");
			}
		}
	}
	if ($sts) {
		//˥塼˥쥯Ȥ
		//It redirects it to a set menu.
		$url = $return_url . "?config=" . conv_url_code($conf["config"]);

		//ƤӽФ˥쥯Ȥ
		//It redirects it to the call origin.
		$url .= "&return_url=" . conv_url_code($conf["returl"]);

		echo get_redirect_url_JavaScriptHTML($url);
		exit;
	} else {
		echo $msg;
	}
}
?>

<HR>
<?php 

//裱裲ؤΥ󥯤ɽHTML
//Link HTML to return 1 and return 2 destination is generated.
echo get_return_url_HTML($conf);

//ڡեåʥץࡦСCopyrightɽ
//Page footer(program version and Copyright display)
echo get_page_footer_HTML($conf);

?>
</BODY>
</HTML>
