<?php
/******************************************************************************
	Files(WEBե붦ͭPHPץ)
	Files(WEB file share PHP script)

	ͭեΥե롿եΰ
	List screen of file/folder in common folder

  	files.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2008 Technoworks Co., Ltd. All rights reserved.

	Last Update: 2008/03/25

	Update history:

	Ver.2.4
		ɡեΥˡѹ
		The method of linking the download files was changed. 

		ܸ̾Υեɤݤˡ֥饦μθ
		ե̾Ѵ褦ˤ
		When the file of a Japanese name was downloaded, the file name was 
		converted in consideration of the kind of a browser.

		åȥХåեΥեؤΥ褬ְäƤΤǽ
		Because link ahead to the file of the cut buffer was wrong, I revised it

	Ver.2.1
		եɲ
		The configuration file arrangement setting is added.

	Ver.2.0
		ɽʸ locale.php 褦˽
		The display character string was acquired from locale.php. 

		ʸɤλ locale.php 褦˽
		The specification of the character-code was acquired from locale.php.

		ͭԤȥ롼פˤ륢浡ǽղ
		The access control function by the group is added with the owner. 

		HTMLʬˣХʸѤʤ褦˽
		֥饦ʸɼưȽ̤˱ƶʤ褦ˤ뤿
		To make it not misidentified by the character-code automatic operation 
		identification of a browser, it was corrected that Japanese was not 
		used for the HTML part. 

		ɤ˥եؤΥ󥯤ѤΤǤϤʤѤ
		ץȤѤ褦ѹ
		Not to use the link to the file for download but to use the script for 
		download, it changed.

	Ver.1.4 ޤǤι
	Update history to Ver.1.4
		2005/08/02	ڡإåʬ̲
					A common page header partial function is added. 

******************************************************************************/

require('files_com.php');

function make_download_link($conf, $dir, $fname, $img_src)
{
	$urlstr = "<FORM ACTION=\"download.php\" METHOD=\"POST\" style=\" margin: 0px; padding: 0px; \">\n";
	$urlstr .= "<input type=\"hidden\" name=\"config\" value=\"" .
											$conf["config"] . "\">\n";
	$urlstr .= "<input type=\"hidden\" name=\"dir\" value=\"" .
											$dir . "\">\n";
	$urlstr .= "<input type=\"hidden\" name=\"filename\" value=\"" . 
											$fname . "\">\n";
	if (isset($img_src) && $img_src != "") {
		$urlstr .= "<input type=\"image\" name=\"download\" src=\"" . $img_src . "\"";
		$urlstr .= " width=" . $conf["ICON_W"];
		$urlstr .= " height=" . $conf["ICON_H"];
		$urlstr .= " ALT=\"Download\">\n";
	} else {
		$urlstr .= "<input type=\"submit\" value=\"" . $fname . "\"";
		$urlstr .= " style=\"cursor: pointer; font-size: 100%; border-style: none; width: 100%; text-align: left; background-color: transparent; text-decoration: underline; color: blue; margin: 0px; padding: 0px; \">";
	}
	$urlstr .= "</FORM>";

	return $urlstr;
}

$conf = init_files(FALSE);
$mode = get_post_get_val("mode");
$fname = get_post_get_val("fname");
$sort_key = get_post_get_val("SORT_KEY");
$reverse_sort = get_post_get_val("REVERSE_SORT");
$returl = get_post_get_val("returl");
if ($conf["returl"] == "") {
	$conf["returl"] = $returl;
}

$s_name = files_session_name();
$s_id = session_id();

$login_user = get_login_user();
$login_user_groups = get_user_groups($conf, $login_user);

$scriptname = "files.php";
$scripturl = $scriptname;


$check_name = "";
$check_comment = "";
$check_owner = "";
$check_size = "";
$check_time = "";

if (isset($sort_key) && $sort_key != "") {
	switch ($sort_key) {
	case "name":
		$conf["SORT_KEY"] = "name";
		$check_name = "CHECKED";
		break;
	case "comment":
		$conf["SORT_KEY"] = "comment";
		$check_comment = "CHECKED";
		break;
	case "owner":
		$conf["SORT_KEY"] = "owner";
		$check_owner = "CHECKED";
		break;
	case "size":
		$conf["SORT_KEY"] = "size";
		$check_size = "CHECKED";
		break;
	case "time":
		$conf["SORT_KEY"] = "time";
		$check_time = "CHECKED";
		break;
	}
} else {
	$check_time = "CHECKED";
}

$check_descend = "";
$check_ascend = "";

if (isset($reverse_sort) && $reverse_sort != "") {
	if ($reverse_sort == "1") {
		$conf["REVERSE_SORT"] = 1;
		$check_descend = "CHECKED";
	} else {
		$conf["REVERSE_SORT"] = 0;
		$check_ascend = "CHECKED";
	}
} else {
	$check_descend = "CHECKED";
}

//ȥǥ쥯ȥΥѥ
//The path in the current directory is made.
$curdir = make_path($conf["TOPDIR"], $conf["curdir"], "");

?>
<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"]; ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>

<?php
//ȥǥ쥯ȥξ
//Information on the current directory is obtained.
$curdir_inf = get_file_info($conf, $curdir);

//ȥǥ쥯ȥΥѡߥå
//The permission of the current directory is obtained.
$curdir_permit = get_permission($conf, $curdir_inf,
								$login_user, $login_user_groups);
if ($curdir == $conf["TOPDIR"]) {
	$curdir_permit["r"] = 1;
	$curdir_permit["w"] = 1;
	$curdir_permit["x"] = 1;
}

//echo "dbg_msg=";
//echo $dbg_msg . "<br>\n";
?>

<?php
//ڡإåHTML
//Page header HTML is acquired.
echo get_page_header_HTML($conf, "TITLE_COMMENT_FILES",
								TRUE, $conf["SHOW_HELP_LINK"]);
?>

<CENTER>
<HR>
<?php

if (!file_exists($curdir)) {
	if (!make_dir($curdir, get_data_dir_attr($conf))) {
		echo "<B>[&nbsp;&nbsp;" . $conf["title"] . "&nbsp;&nbsp;]<BR><BR>\n";
		echo get_txt("cannot make folder") . "<BR>\n";
		echo get_txt("please confirm permission") . "<BR><BR>\n";
		$rerturnurl = $conf["FILES_SCRIPT"];
		$rerturnurl .= "?" . $s_name . "=" . $s_id;
		echo "<A HREF=\"" . $rerturnurl . "\"><B>" .
						get_txt("return to top") . "</B></A>";
		echo "</BODY></HTML>\n";
		exit;
	}
}

//å
//It locks.
$lockfile = make_path($curdir, "", $conf["LOCKFILE"]);
$lock_fp = lock_files($lockfile);
if (! $lock_fp) {
	echo "<B>[&nbsp;&nbsp;" . $conf["title"] . "&nbsp;&nbsp;]<BR><BR>\n";
	echo get_txt("could not access") . "<BR>\n";
	echo get_txt("please confirm permission") . "<BR><BR>\n";
	$rerturnurl = $conf["FILES_SCRIPT"];
	$rerturnurl .= "?" . $s_name . "=" . $s_id;
	echo "<A HREF=\"" . $rerturnurl . "\"><B>" .
					get_txt("return to top") . "</B></A>";
	echo "</BODY></HTML>\n";
	exit;
}
$cutfiles = array();
$files = array();

//åȥХåեΥå
//Check on cutting buffer
if (!file_exists($conf["CUTDIR"])) {
	if (!make_dir($conf["CUTDIR"], get_data_dir_attr($conf))) {
		echo "<B>[&nbsp;&nbsp;" . $conf["title"] . "&nbsp;&nbsp;]<BR><BR>\n";
		echo get_txt("cannot make cut buffer folder") . "<BR>\n";
		echo get_txt("please confirm permission") . "<BR><BR>\n";
		$rerturnurl = $conf["FILES_SCRIPT"];
		$rerturnurl .= "?" . $s_name . "=" . $s_id;
		echo "<A HREF=\"" . $rerturnurl . "\"><B>" .
						get_txt("return to top") . "</B></A>";
		echo "</BODY></HTML>\n";
		exit;
	}
}
$listfile = make_path($conf["CUTDIR"], "", $conf["LISTFILE"]);
$list_files = array();

// åȥХåեΥեꥹȤɤ߹
//The file list of the cutting buffer is read.
if (file_exists($listfile)) {
	$list_files = read_filelist($conf["CUTDIR"], $conf["LISTFILE"]);
}

//åȥХåեΥե
//The file list in the cutting buffer is obtained.
list($cutfiles, $update) = get_dirfiles($conf, $conf["CUTDIR"], $list_files);

sort_filelist($cutfiles, $conf["SORT_KEY"], $conf["REVERSE_SORT"]);

// ƤեꥹȽ񤭹
//It writes it in the file list if updated.
if ($update) {
	if (! write_file_list($listfile, $cutfiles)) {
		echo "list file ($listfile) write open error\n";
	}
}

// ȥǥ쥯ȥΥեꥹȤ
//The file list of the current directory is obtained.

// եꥹȵϿե̾
//File list record file name
$listfile = make_path($curdir, "", $conf["LISTFILE"]);
$list_files = array();

// եꥹȤɤ߹
//The file list is read.
if (file_exists($listfile)) {
	$conf["uptime"] = date("Y/m/d H:i:s", filemtime($listfile));
	$list_files = read_filelist($curdir, $conf["LISTFILE"]);
}

//ȥǥ쥯ȥΥե
//The file list in the current directory is obtained.
list($files, $update) = get_dirfiles($conf, $curdir, $list_files);

sort_filelist($files, $conf["SORT_KEY"], $conf["REVERSE_SORT"]);

list($curr_name, $curr_comment, $curr_owner) = get_current_info($files);

/***
if ($curr_comment != "") {
	$curr_name = get_filename($curdir);
	$conf["title"] = $curr_name . "&nbsp;&nbsp;:&nbsp;&nbsp;" . $curr_comment;
}
***/
if ($curdir == $conf["TOPDIR"]) {
	$date_time = split(" ", $conf["uptime"]);
	$curdir_inf["name"] = $conf["title"];
	$curdir_inf["comment"] = $conf["name"];
	$curdir_inf["owner"] = $curr_owner;
	$curdir_inf["date"] = $date_time[0];
	$curdir_inf["time"] = $date_time[1];
	$curdir_inf["user"] = "";
	$curdir_inf["group"] = "";
	$curdir_inf["attr"] = 0777;
}
/***/

// ƤեꥹȤ˽񤭹
//It writes it in the file list if updated.
if ($update) {
	$conf["uptime"] = date("Y/m/d H:i:s");

	if (! write_file_list($listfile, $files)) {
		echo "list file ($listfile) write open error\n";
	}
}
//å
//The lock is released.
unlock_files($lock_fp, $lockfile);

?>


<TABLE width=95% border=0><TBODY>
	<TR>
		<TD>
<?php

if ($curdir_permit["w"]) {
	$mkdirurl = $conf["MKDIR_SCRIPT"];
	$mkdirurl .= "?dir=" . conv_url_code($conf["curdir"]);
	$mkdirurl .= "&config=" . conv_url_code($conf["config"]);
	$mkdirurl .= "&" . $s_name . "=" . $s_id;

	echo "<A HREF=\"" . $mkdirurl . "\">";
}

echo "<B>" . get_txt("make folder") . "</B>";

if ($curdir_permit["w"]) {
	echo "</A>";
}
echo "&nbsp;&nbsp;&nbsp;&nbsp;";

if ($curdir_permit["w"]) {
	$uploadurl = $conf["UPLOAD_SCRIPT"];
	$uploadurl .= "?dir=" . conv_url_code($conf["curdir"]);
	$uploadurl .= "&config=" . conv_url_code($conf["config"]);
	$uploadurl .= "&mode=select";
	$uploadurl .= "&" . $s_name . "=" . $s_id;

	echo "<A HREF=\"" . $uploadurl . "\">";
}

echo "<B>" . get_txt("upload") . "</B>";
echo "&nbsp;(" . get_txt("file size limit") . "&nbsp;:&nbsp;";
echo get_filesize_str($conf["MAX_UPLOAD_SIZE"]) . ")";

if ($curdir_permit["w"]) {
	echo "</A>";
}
echo "\n";

?>
		</TD>
		<TD>
<?php
if (isset($conf["PASSWD_FILE"]) && $conf["PASSWD_FILE"] != "") {
	if (isset($login_user) && $login_user != "") {
		$pwdurl = $conf["PASSWD_SCRIPT"];
		$pwdurl .= "?config=" . conv_url_code($conf["config"]);
		$pwdurl .= "&dir=" . $conf["curdir"];
		$pwdurl .= "&return_url=" . $conf["FILES_SCRIPT"];
		$pwdurl .= "&" . $s_name . "=" . $s_id;
		echo "<A HREF=\"" . $pwdurl . "\"><B>" .
				get_txt("password setting") . "</B></A>&nbsp;&nbsp;";
	}
	if (isset($login_user) && $login_user != "" &&
							$login_user == $conf["ADMIN_USERID"]) {
		$grpurl = $conf["GROUP_SCRIPT"];
		$grpurl .= "?config=" . conv_url_code($conf["config"]);
		$grpurl .= "&dir=" . $conf["curdir"];
		$grpurl .= "&return_url=" . $conf["FILES_SCRIPT"];
		$grpurl .= "&" . $s_name . "=" . $s_id;
		echo "&nbsp;&nbsp<A HREF=\"" . $grpurl . "\"><B>" .
				get_txt("user and group setting") . "</B></A>&nbsp;&nbsp;";
	}
}
?>
		</TD>
	</TR>
</TBODY></TABLE>
<form action="<?php echo $scripturl; ?>" method="POST">
<input type="hidden" name="dir" value="<?php echo $conf["curdir"]; ?>">
<input type="hidden" name="config" value="<?php echo $conf["config"]; ?>">
<input type="hidden" name="<?php echo $s_name ?>" value="<?php echo $s_id ?>">
<TABLE width=95% border=1><TBODY>
	<TR>
		<TD><B><?php echo get_txt("display order"); ?>:</B></TD>
		<TD>
			<input type="radio" name="SORT_KEY" value="name"
										<?php echo $check_name ?>>
										<?php echo get_txt("filename"); ?>
			<input type="radio" name="SORT_KEY" value="comment"
										<?php echo $check_comment ?>>
										<?php echo get_txt("comment"); ?>
			<input type="radio" name="SORT_KEY" value="owner"
										<?php echo $check_owner ?>>
										<?php echo get_txt("create user"); ?>
			<input type="radio" name="SORT_KEY" value="size"
										<?php echo $check_size ?>>
										<?php echo get_txt("size"); ?>
			<input type="radio" name="SORT_KEY" value="time"
										<?php echo $check_time ?>>
										<?php echo get_txt("date"); ?>
		</TD>
		<TD>
			<input type="radio" name="REVERSE_SORT" value="0"
										<?php echo $check_ascend ?>>
										<?php echo get_txt("ascending"); ?>
			<input type="radio" name="REVERSE_SORT" value="1"
										<?php echo $check_descend ?>>
										<?php echo get_txt("descending"); ?>
		</TD>
		<TD>
			<input type="submit" name="submit" value="<?php echo get_txt("redisplay"); ?>">
		</TD>
	</TR>
</TBODY></TABLE>
</form>

<?php
if (count_files($cutfiles) > 0) {
?>
<TABLE width=95% border=1><TBODY>
	<TR BGCOLOR="<?php echo $conf["LIST_TITLE_BG2"] ?>">
	<TD COLSPAN=9><B><?php echo get_txt("cut buffer"); ?></B></TD>
	</TR>
	<TR BGCOLOR="<?php echo $conf["LIST_HEAD_BG2"] ?>">
		<TD width=<?php echo $conf["ICON_W"] ?> align=center>&nbsp;&nbsp;</TD>
		<TD  align=center><B><?php echo get_txt("filename"); ?><br>
							<?php echo get_txt("comment"); ?></B></TD>
		<TD width=<?php echo $conf["ICON_W"] ?> align=center>
					<B><?php echo get_txt("edit label"); ?></B></TD>
		<TD width=<?php echo $conf["ICON_W"] ?> align=center>
					<B><?php echo get_txt("delete label"); ?></B></TD>
		<TD width=<?php echo $conf["ICON_W"] ?> align=center>
					<B><?php echo get_txt("paste label"); ?></B></TD>
		<TD align=center><B><?php echo get_txt("size"); ?><br>
							<?php echo get_txt("attr"); ?></B></TD>
		<TD align=center><B><?php echo get_txt("date"); ?><br>
							<?php echo get_txt("time"); ?></B></TD>
		<TD align=center><B><?php echo get_txt("create user"); ?></B></TD>
		<TD align=center><B><?php echo get_txt("owner") ?><br>
							<?php echo get_txt("group"); ?></B></TD>
	</TR>

<?php

	foreach($cutfiles as $finf) {
		if ($finf["name"] == ".") {
			continue;
		}
		if ($finf["name"] == "..") {
			continue;
		}
		$file_path = make_path($conf["CUTDIR"], "", $finf["name"]);

		$img = make_path($conf["IMGDIR"], "", $finf["image"]);

		$dirflg = is_dir($file_path);

		//եФѡߥå
		//The permission to the file is obtained.
		$permit = get_permission($conf, $finf,
								$login_user, $login_user_groups);

		$link_ok = FALSE;
		if (($dirflg && $permit["r"] && $permit["x"]) ||
								(!$dirflg && $permit["r"])) {
			$link_ok = TRUE;
		}

		echo "<TR>\n";

		//ե륿פΥ᡼
		//Image icon of file type
		echo "<TD align=center>";
		if ($link_ok && !$dirflg) {
			$urlstr = make_download_link($conf, $conf["CUTDIR"], $finf["name"], $img);
		} else {
			$urlstr = "<IMG SRC=\"" . $img . "\" border=0";
			$urlstr .= " width=" . $conf["ICON_W"];
			$urlstr .= " height=" . $conf["ICON_H"];
			$urlstr .= ">";
		}
		echo $urlstr;
		echo "</TD>\n";

		//ե̾
		//File name
		echo "<TD>";
		if ($link_ok && !$dirflg) {
			$urlstr = make_download_link($conf, $conf["CUTDIR"], $finf["name"], "");
			echo $urlstr;
		} else {
			echo $finf["name"];
		}

		//
		//Comment
		echo noblank_str($finf["comment"]);

		echo "</TD>\n";

		//Խ
		//Edit
		$img = make_path($conf["IMGDIR"], "", $conf["EDIT_IMAGE"]);
		echo "<TD align=center>\n";
		if ($permit["w"]) {
			//񤭹߲Ĥʤ
			//If it is possible to write it
			echo "<FORM ACTION=\"" . $conf["EDIT_SCRIPT"] .
													"\" METHOD=\"POST\">\n";
			echo "<input type=\"hidden\" name=\"config\" value=\"" .
													$conf["config"] . "\">\n";
			echo "<input type=\"hidden\" name=\"dir\" value=\"" .
													$conf["curdir"] . "\">\n";
			echo "<input type=\"hidden\" name=\"CUTMODE\" value=\"1\">\n";
			echo "<input type=\"hidden\" name=\"fname\" value=\"" . 
													$finf["name"] . "\">\n";
			echo "<input type=\"hidden\" name=\"comment\" value=\"" . 
													$finf["comment"] . "\">\n";
			echo "<input type=\"hidden\" name=\"owner\" value=\"" . 
													$finf["owner"] . "\">\n";
			echo "<input type=\"hidden\" name=\"date\" value=\"" . 
													$finf["date"] . "\">\n";
			echo "<input type=\"hidden\" name=\"" . $s_name . "\"" .
												" value=\"" . $s_id . "\">\n";
			echo "<input type=\"hidden\" name=\"time\" value=\"" . 
													$finf["time"] . "\">\n";
			echo "<input type=\"hidden\" name=\"user\" value=\"" . 
													$finf["user"] . "\">\n";
			echo "<input type=\"hidden\" name=\"group\" value=\"" . 
													$finf["group"] . "\">\n";
			echo "<input type=\"hidden\" name=\"attr\" value=\"" . 
													$finf["attr"] . "\">\n";
			echo "<input type=\"image\" name=\"edit\" src=\"" . $img . "\"";
			echo " width=" . $conf["ICON_W"];
			echo " height=" . $conf["ICON_H"];
			echo " ALT=\"" . get_txt("edit") . "\">\n";
			echo "</FORM>\n";
		} else {
			echo "&nbsp;&nbsp;";
		}
		echo "</TD>\n";

		//
		//Delete
		$img = make_path($conf["IMGDIR"], "", $conf["DELETE_IMAGE"]);
		echo "<TD align=center>\n";
		if ($permit["w"]) {
			//񤭹߲Ĥʤ
			//If it is possible to write it
			echo "<FORM ACTION=\"" . $conf["DELETE_SCRIPT"] .
													"\" METHOD=\"POST\">\n";
			echo "<input type=\"hidden\" name=\"config\" value=\"" .
													$conf["config"] . "\">\n";
			echo "<input type=\"hidden\" name=\"dir\" value=\"" .
													$conf["curdir"] . "\">\n";
			echo "<input type=\"hidden\" name=\"CUTMODE\" value=\"1\">\n";
			echo "<input type=\"hidden\" name=\"fname\" value=\"" . 
													$finf["name"] . "\">\n";
			echo "<input type=\"hidden\" name=\"comment\" value=\"" . 
													$finf["comment"] . "\">\n";
			echo "<input type=\"hidden\" name=\"owner\" value=\"" . 
													$finf["owner"] . "\">\n";
			echo "<input type=\"hidden\" name=\"date\" value=\"" . 
													$finf["date"] . "\">\n";
			echo "<input type=\"hidden\" name=\"time\" value=\"" . 
													$finf["time"] . "\">\n";
			echo "<input type=\"hidden\" name=\"user\" value=\"" . 
													$finf["user"] . "\">\n";
			echo "<input type=\"hidden\" name=\"group\" value=\"" . 
													$finf["group"] . "\">\n";
			echo "<input type=\"hidden\" name=\"attr\" value=\"" . 
													$finf["attr"] . "\">\n";
			echo "<input type=\"hidden\" name=\"" . $s_name . "\"" .
												" value=\"" . $s_id . "\">\n";
			echo "<input type=\"image\" name=\"delete\" src=\"" . $img . "\"";
			echo " width=" . $conf["ICON_W"];
			echo " height=" . $conf["ICON_H"];
			echo " ALT=\"" . get_txt("delete") . "\">\n";
			echo "</FORM>\n";
		} else {
			echo "&nbsp;&nbsp;";
		}
		echo "</TD>\n";

		//Žդ
		//Paste
		$img = make_path($conf["IMGDIR"], "", $conf["PASTE_IMAGE"]);
		echo "<TD align=center>\n";
		if ($permit["w"] && $curdir_permit["w"]) {
			//ȥե񤭹߲Ĥʤ
			//If you can write a current folder
			echo "<FORM ACTION=\"" . $conf["PASTE_SCRIPT"] .
													"\" METHOD=\"POST\">\n";
			echo "<input type=\"hidden\" name=\"config\" value=\"" .
													$conf["config"] . "\">\n";
			echo "<input type=\"hidden\" name=\"dir\" value=\"" .
													$conf["curdir"] . "\">\n";
			echo "<input type=\"hidden\" name=\"fname\" value=\"" . 
													$finf["name"] . "\">\n";
			echo "<input type=\"hidden\" name=\"comment\" value=\"" . 
													$finf["comment"] . "\">\n";
			echo "<input type=\"hidden\" name=\"owner\" value=\"" . 
													$finf["owner"] . "\">\n";
			echo "<input type=\"hidden\" name=\"date\" value=\"" . 
													$finf["date"] . "\">\n";
			echo "<input type=\"hidden\" name=\"time\" value=\"" . 
													$finf["time"] . "\">\n";
			echo "<input type=\"hidden\" name=\"user\" value=\"" . 
													$finf["user"] . "\">\n";
			echo "<input type=\"hidden\" name=\"group\" value=\"" . 
													$finf["group"] . "\">\n";
			echo "<input type=\"hidden\" name=\"attr\" value=\"" . 
													$finf["attr"] . "\">\n";
			echo "<input type=\"hidden\" name=\"" . $s_name . "\"" .
												" value=\"" . $s_id . "\">\n";
			echo "<input type=\"image\" name=\"paste\" src=\"" . $img . "\"";
			echo " width=" . $conf["ICON_W"];
			echo " height=" . $conf["ICON_H"];
			echo " ALT=\"" . get_txt("paste") . "\">\n";
			echo "</FORM>\n";
		} else {
			echo "&nbsp;&nbsp;";
		}
		echo "</TD>\n";

		//ե륵ȥ
		//Size of file and permission
		echo "<TD align=right>" . get_filesize_str($finf["size"]) . "<br>" . 
									get_attr_str($finf["attr"]) . "</TD>\n";

		//եա
		//File creation date and time
		echo "<TD>" . $finf["date"] . "<BR>" . $finf["time"] . "</TD>\n";

		//եԡǤդν̾
		//Person who up-loaded file (Arbitrary signature)
		echo "<TD>" . noblank_str($finf["owner"]) . "</TD>\n";

		//եͭԡ롼
		//File owner: Group
		echo "<TD valign=top>" . noblank_str($finf["user"]) . "<br>" .
								noblank_str($finf["group"]) . "</TD>\n";

		echo "</TR>\n";
	}
	echo "</TBODY></TABLE>\n";
}

//ȥǥ쥯ȥλ̤
//The amount of use in the current directory is obtained.
$dirsize = get_dir_use_size($curdir);
$dirsize_str = get_filesize_str($dirsize);
?>
<P>
<TABLE width=95% border=1><TBODY>
	<TR valign=top BGCOLOR="<?php echo $conf["LIST_TITLE_BG"] ?>">
		<TD COLSPAN=6><B><?php echo noblank_str($curdir_inf["name"]) ?><br>
					<?php echo noblank_str($curdir_inf["comment"]) ?></B></TD>
		<TD align=right><?php echo $dirsize_str ?><br>
						<?php echo get_attr_str($curdir_inf["attr"]) ?></TD>
		<TD><?php echo $curdir_inf["date"] ?><br>
						<?php echo noblank_str($curdir_inf["time"]) ?></TD>
		<TD valign=center><?php echo noblank_str($curdir_inf["owner"]) ?></TD>
		<TD><?php echo noblank_str($curdir_inf["user"]) ?><br>
						<?php echo noblank_str($curdir_inf["group"]) ?></TD>
	</TR>
	<TR BGCOLOR="<?php echo $conf["LIST_HEAD_BG"] ?>">
		<TD width=<?php echo $conf["ICON_W"] ?> align=center>&nbsp;&nbsp;</TD>
		<TD align=center><B><?php echo get_txt("filename"); ?><br>
						<?php echo get_txt("comment"); ?></B></TD>
		<TD width=<?php echo $conf["ICON_W"] ?> align=center>
						<B><?php echo get_txt("edit label"); ?></B></TD>
		<TD width=<?php echo $conf["ICON_W"] ?> align=center>
						<B><?php echo get_txt("delete label"); ?></B></TD>
		<TD width=<?php echo $conf["ICON_W"] ?> align=center>
						<B><?php echo get_txt("copy label"); ?></B></TD>
		<TD width=<?php echo $conf["ICON_W"] ?> align=center>
						<B><?php echo get_txt("cut label"); ?></B></TD>
		<TD align=center><B><?php echo get_txt("size"); ?><br>
							<?php echo get_txt("attr"); ?></B></TD>
		<TD align=center><B><?php echo get_txt("date"); ?><br>
							<?php echo get_txt("time"); ?></B></TD>
		<TD align=center><B><?php echo get_txt("create user"); ?></B></TD>
		<TD align=center><B><?php echo get_txt("owner") ?><br>
							<?php echo get_txt("group"); ?></B></TD>
	</TR>

<?php
	if ($conf["TOPDIR"] != $curdir) {
		// ̥ǥ쥯ȥΥѥ
		//The path of a high-ranking directory is obtained.
		$updir = get_dirpath($conf["curdir"]);

		//եѥ
		//The full path is obtained.
		$upname = realpath($curdir . "/..");
		$upname = get_filename($upname);

		$urlstr = $scripturl;
		$urlstr .= "?dir=" . conv_url_code($updir);
		$urlstr .= "&config=" . conv_url_code($conf["config"]);
		$urlstr .= "&" . $s_name . "=" . $s_id;

		$img = make_path($conf["IMGDIR"], "", $conf["UP_IMAGE"]);

		echo "<TR>";

		//ե륿פΥ᡼
		//Image icon of file type
		echo "<TD align=center>\n";
		echo "<A HREF=\"" . $urlstr . "\">";
		echo "<IMG SRC=\"" . $img . "\"  border=0";
		echo " width=" . $conf["ICON_W"];
		echo " height=" . $conf["ICON_H"];
		echo " ALT=\"" . $conf["UP_TITLE"] . "\"></A>\n";
		echo "</TD>\n";

		//ե̾
		//File name
		echo "<TD>";
		echo "<A HREF=\"" . $urlstr . "\">" . $upname . "</A>";

		//
		//Comment
		echo "<BR>" . $conf["UP_TITLE"] . "</TD>\n";

		//Խ
		//Edit
		echo "<TD>&nbsp;&nbsp;</TD>\n";

		//
		//Delete
		echo "<TD>&nbsp;&nbsp;</TD>\n";

		//ʣ
		//Copy
		echo "<TD>&nbsp;&nbsp;</TD>\n";

		//ڼ
		//Cut
		echo "<TD>&nbsp;&nbsp;</TD>\n";

		//ե륵
		//Size of file and permission
		echo "<TD align=right>" . "---<br>---" . "</TD>\n";

		//եա
		//File creation date and time
		echo "<TD>" . "---<br>---" . "</TD>\n";

		//եԡǤդν̾
		//Person who up-loaded file (Arbitrary signature)
		echo "<TD>" . "---" . "</TD>\n";

		//եͭԡ롼
		//File owner: Group
		echo "<TD>" . "---<br>---" . "</TD>\n";

		echo "</TR>\n";
	}
	foreach($files as $finf) {
		if ($finf["name"] == ".") {
			continue;
		}
		if ($finf["name"] == "..") {
			continue;
		}
		$file_fullpath = make_path($curdir, "", $finf["name"]);
		$file_path = make_path($conf["curdir"], "", $finf["name"]);

		$img = make_path($conf["IMGDIR"], "", $finf["image"]);

		$dirflg = is_dir($file_fullpath);

		//եФѡߥå
		//The permission to the file is obtained.
		$permit = get_permission($conf, $finf,
								$login_user, $login_user_groups);
		$link_ok = FALSE;
		if (($dirflg && $permit["r"] && $permit["x"]) ||
									(!$dirflg && $permit["r"])) {
			$link_ok = TRUE;
		}

		if ($dirflg) {
			$urlstr = "<a href=\"" . $scripturl;
			$urlstr .= "?dir=" . conv_url_code($file_path);
			$urlstr .= "&config=" . conv_url_code($conf["config"]);
			$urlstr .= "&" . $s_name . "=" . $s_id;
			$urlstr .= "\">";
			$urlstr .= "<IMG SRC=\"" . $img . "\" border=0";
			$urlstr .= " width=" . $conf["ICON_W"];
			$urlstr .= " height=" . $conf["ICON_H"];
			$urlstr .= ">";
		} else {
			$urlstr = make_download_link($conf, $curdir, $finf["name"], $img);
		}

		echo "<TR>\n";

		//ե륿פΥ᡼
		//Image icon of file type
		echo "<TD align=center>";
		if ($link_ok) {
			echo $urlstr;
		} else {
			echo "<IMG SRC=\"" . $img . "\" border=0";
			echo " width=" . $conf["ICON_W"];
			echo " height=" . $conf["ICON_H"];
			echo ">";
		}
		echo "</TD>\n";

		//ե̾
		//File name
		echo "<TD>";
		if ($link_ok) {
			if ($dirflg) {
				$urlstr = "<a href=\"" . $scripturl;
				$urlstr .= "?dir=" . conv_url_code($file_path);
				$urlstr .= "&config=" . conv_url_code($conf["config"]);
				$urlstr .= "&" . $s_name . "=" . $s_id;
				$urlstr .= "\">" . $finf["name"] . "</a><BR>";
			} else {
				$urlstr = make_download_link($conf, $curdir, $finf["name"], "");
			}
		} else {
			$urlstr = $finf["name"] . "<BR>";
		}
		echo $urlstr;

		//
		//Comment
		echo noblank_str($finf["comment"]);

		echo "</TD>\n";

		//Խ
		//Edit
		$img = make_path($conf["IMGDIR"], "", $conf["EDIT_IMAGE"]);
		echo "<TD align=center>\n";
		if ($permit["w"]) {
			echo "<FORM ACTION=\"" . $conf["EDIT_SCRIPT"] .
													"\" METHOD=\"POST\">\n";
			echo "<input type=\"hidden\" name=\"config\" value=\"" .
													$conf["config"] . "\">\n";
			echo "<input type=\"hidden\" name=\"dir\" value=\"" .
													$conf["curdir"] . "\">\n";
			echo "<input type=\"hidden\" name=\"fname\" value=\"" . 
													$finf["name"] . "\">\n";
			echo "<input type=\"hidden\" name=\"comment\" value=\"" . 
													$finf["comment"] . "\">\n";
			echo "<input type=\"hidden\" name=\"owner\" value=\"" . 
													$finf["owner"] . "\">\n";
			echo "<input type=\"hidden\" name=\"date\" value=\"" . 
													$finf["date"] . "\">\n";
			echo "<input type=\"hidden\" name=\"time\" value=\"" . 
													$finf["time"] . "\">\n";
			echo "<input type=\"hidden\" name=\"user\" value=\"" . 
													$finf["user"] . "\">\n";
			echo "<input type=\"hidden\" name=\"group\" value=\"" . 
													$finf["group"] . "\">\n";
			echo "<input type=\"hidden\" name=\"attr\" value=\"" . 
													$finf["attr"] . "\">\n";
			echo "<input type=\"hidden\" name=\"" . $s_name . "\"" .
												" value=\"" . $s_id . "\">\n";
			echo "<input type=\"image\" name=\"edit\" src=\"" . $img . "\"";
			echo " width=" . $conf["ICON_W"];
			echo " height=" . $conf["ICON_H"];
			echo " ALT=\"" . get_txt("edit") . "\">\n";
			echo "</FORM>\n";
		} else {
			echo "&nbsp;&nbsp;";
		}
		echo "</TD>\n";

		//
		//Delete
		$img = make_path($conf["IMGDIR"], "", $conf["DELETE_IMAGE"]);
		echo "<TD align=center>\n";
		if ($permit["w"] && $curdir_permit["w"]) {
			echo "<FORM ACTION=\"" . $conf["DELETE_SCRIPT"] .
													"\" METHOD=\"POST\">\n";
			echo "<input type=\"hidden\" name=\"config\" value=\"" .
													$conf["config"] . "\">\n";
			echo "<input type=\"hidden\" name=\"dir\" value=\"" .
													$conf["curdir"] . "\">\n";
			echo "<input type=\"hidden\" name=\"fname\" value=\"" . 
													$finf["name"] . "\">\n";
			echo "<input type=\"hidden\" name=\"comment\" value=\"" . 
													$finf["comment"] . "\">\n";
			echo "<input type=\"hidden\" name=\"owner\" value=\"" . 
													$finf["owner"] . "\">\n";
			echo "<input type=\"hidden\" name=\"date\" value=\"" . 
													$finf["date"] . "\">\n";
			echo "<input type=\"hidden\" name=\"time\" value=\"" . 
													$finf["time"] . "\">\n";
			echo "<input type=\"hidden\" name=\"user\" value=\"" . 
													$finf["user"] . "\">\n";
			echo "<input type=\"hidden\" name=\"group\" value=\"" . 
													$finf["group"] . "\">\n";
			echo "<input type=\"hidden\" name=\"attr\" value=\"" . 
													$finf["attr"] . "\">\n";
			echo "<input type=\"hidden\" name=\"" . $s_name . "\"" .
												" value=\"" . $s_id . "\">\n";
			echo "<input type=\"image\" name=\"delete\" src=\"" . $img . "\"";
			echo " width=" . $conf["ICON_W"];
			echo " height=" . $conf["ICON_H"];
			echo " ALT=\"" . get_txt("delete") . "\">\n";
			echo "</FORM>\n";
		} else {
			echo "&nbsp;&nbsp;";
		}
		echo "</TD>\n";

		//ʣ
		//Copy
		$img = make_path($conf["IMGDIR"], "", $conf["COPY_IMAGE"]);
		echo "<TD align=center>\n";
		if ($permit["r"]) {
			echo "<FORM ACTION=\"" . $conf["CUT_SCRIPT"] .
													"\" METHOD=\"POST\">\n";
			echo "<input type=\"hidden\" name=\"config\" value=\"" .
													$conf["config"] . "\">\n";
			echo "<input type=\"hidden\" name=\"dir\" value=\"" .
													$conf["curdir"] . "\">\n";
			echo "<input type=\"hidden\" name=\"mode\" value=\"copy\">\n";
			echo "<input type=\"hidden\" name=\"fname\" value=\"" . 
													$finf["name"] . "\">\n";
			echo "<input type=\"hidden\" name=\"comment\" value=\"" . 
													$finf["comment"] . "\">\n";
			echo "<input type=\"hidden\" name=\"owner\" value=\"" . 
													$finf["owner"] . "\">\n";
			echo "<input type=\"hidden\" name=\"date\" value=\"" . 
													$finf["date"] . "\">\n";
			echo "<input type=\"hidden\" name=\"time\" value=\"" . 
													$finf["time"] . "\">\n";
			echo "<input type=\"hidden\" name=\"user\" value=\"" . 
													$finf["user"] . "\">\n";
			echo "<input type=\"hidden\" name=\"group\" value=\"" . 
													$finf["group"] . "\">\n";
			echo "<input type=\"hidden\" name=\"attr\" value=\"" . 
													$finf["attr"] . "\">\n";
			echo "<input type=\"hidden\" name=\"" . $s_name . "\"" .
												" value=\"" . $s_id . "\">\n";
			echo "<input type=\"image\" name=\"copy\" src=\"" . $img . "\"";
			echo " width=" . $conf["ICON_W"];
			echo " height=" . $conf["ICON_H"];
			echo " ALT=\"" . get_txt("copy") . "\">\n";
			echo "</FORM>\n";
		} else {
			echo "&nbsp;&nbsp;";
		}
		echo "</TD>\n";

		//ڼ
		//Cut
		$img = make_path($conf["IMGDIR"], "", $conf["CUT_IMAGE"]);
		echo "<TD align=center>\n";
		if ($permit["w"] && $curdir_permit["w"]) {
			echo "<FORM ACTION=\"" . $conf["CUT_SCRIPT"] .
													"\" METHOD=\"POST\">\n";
			echo "<input type=\"hidden\" name=\"config\" value=\"" .
													$conf["config"] . "\">\n";
			echo "<input type=\"hidden\" name=\"dir\" value=\"" .
													$conf["curdir"] . "\">\n";
			echo "<input type=\"hidden\" name=\"mode\" value=\"cut\">\n";
			echo "<input type=\"hidden\" name=\"fname\" value=\"" . 
													$finf["name"] . "\">\n";
			echo "<input type=\"hidden\" name=\"comment\" value=\"" . 
													$finf["comment"] . "\">\n";
			echo "<input type=\"hidden\" name=\"owner\" value=\"" . 
													$finf["owner"] . "\">\n";
			echo "<input type=\"hidden\" name=\"date\" value=\"" . 
													$finf["date"] . "\">\n";
			echo "<input type=\"hidden\" name=\"time\" value=\"" . 
													$finf["time"] . "\">\n";
			echo "<input type=\"hidden\" name=\"user\" value=\"" . 
													$finf["user"] . "\">\n";
			echo "<input type=\"hidden\" name=\"group\" value=\"" . 
													$finf["group"] . "\">\n";
			echo "<input type=\"hidden\" name=\"attr\" value=\"" . 
													$finf["attr"] . "\">\n";
			echo "<input type=\"hidden\" name=\"" . $s_name . "\"" .
												" value=\"" . $s_id . "\">\n";
			echo "<input type=\"image\" name=\"cut\" src=\"" . $img . "\"";
			echo " width=" . $conf["ICON_W"];
			echo " height=" . $conf["ICON_H"];
			echo " ALT=\"" . get_txt("cut") . "\">\n";
			echo "</FORM>\n";
		} else {
			echo "&nbsp;&nbsp;";
		}
		echo "</TD>\n";

		//ե륵
		//Size of file and permission
		echo "<TD align=right>" . get_filesize_str($finf["size"]) . "<br>" .
									get_attr_str($finf["attr"]) . "</TD>\n";

		//ե
		//File creation date and time
		echo "<TD>" . $finf["date"] . "<BR>" . $finf["time"] . "</TD>\n";

		//եԡǤդν̾
		//Person who up-loaded file (Arbitrary signature)
		echo "<TD>" . noblank_str($finf["owner"]) . "</TD>\n";

		//եͭԡ롼
		//File owner: Group
		echo "<TD valign=top>" . noblank_str($finf["user"]) . "<br>" .
								noblank_str($finf["group"]) . "</TD>\n";

		echo "</TR>\n";
	}
?>

</TBODY></TABLE>
</P>
<HR>
<?php
//裱裲ؤΥ󥯤ɽHTML
//Link HTML to return 1 and return 2 destination is generated.
echo get_return_url_HTML($conf);
?>
<br>
<?php

if ($conf["ENTRY_PAGE_DIR_URL"] != "") {
	$link_url = $conf["ENTRY_PAGE_DIR_URL"];
	$str = "<b>" . get_txt("link address to this page") . "&nbsp;:&nbsp;";
	$str .= get_return_refer_url_HTML($link_url . "/", $link_url . "/");
	echo $str;
}

//ڡեåʥץࡦСCopyrightɽ
//Page footer(program version and Copyright display)
echo get_page_footer_HTML($conf);

?>
</CENTER>
</BODY>
</HTML>
