<?php
/******************************************************************************
	Files(WEBファイル共有PHPスクリプト)
	Files(WEB file share PHP script)

	ファイル／フォルダのカット／コピー処理
	Cut and copy processing of file or folder

  	cut.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2014 GUSUKU All rights reserved.

	Update:

	Ver.2.6.2
		著作権者変更
		The copyright owner has been changed.

	Ver.2.3
		配列の範囲外のインデックスへの参照を行わないように修正した
		It was corrected that it did not refer to the index beyond the 
		limits of the array.

	Ver.2.1
		構成ファイル配置設定を追加
		The configuration file arrangement setting is added.

	Ver.2.0
		表示文字列を locale.php から取得するように修正
		The display character string was acquired from locale.php. 

		文字コードの指定も locale.php から取得するように修正
		The specification of the character-code was acquired from locale.php.

		所有者とグループによるアクセス権制御機能を付加
		The access control function by the group is added with the owner. 

		HTML部分に２バイト文字を使用しないように修正した、
		ブラウザの文字コード自動判別に影響しないようにするため
		To make it not misidentified by the character-code automatic operation 
		identification of a browser, it was corrected that Japanese was not 
		used for the HTML part. 

	Ver.1.4 までの更新履歴
	Update history to Ver.1.4
		2005/08/02	共通のページヘッダー部分関数を追加
					A common page header partial function is added. 
******************************************************************************/

require('files_com.php');

$conf = init_files(FALSE);

$mode = get_post_get_val("mode");
$fname = get_post_get_val("fname");
$comment = get_post_get_val("comment");
$owner = get_post_get_val("owner");
$date = get_post_get_val("date");
$time = get_post_get_val("time");
$user = get_post_get_val("user");
$group = get_post_get_val("group");
$attr = get_post_get_val("attr");

$scriptname = "cut.php";

$msg = "";
$sts = FALSE;

if ($mode != "copy") {
	$mode = "cut";
}

$login_user = get_login_user();
$login_user_groups = get_user_groups($conf, $login_user);

//カレントディレクトリのパスを得る
//The path in the current directory is made.
$curdir = make_path($conf["TOPDIR"], $conf["curdir"], "");

//cut buffer directory
$cutdir = make_path($conf["TOPDIR"], $conf["CUTDIR"], "");

//カレントディレクトリの情報を得る
//Information on the current directory is obtained.
$curdir_inf = get_file_info($conf, $curdir);

//カレントディレクトリのパーミッションを得る
//The permission of the current directory is obtained.
$curdir_permit = get_permission($conf, $curdir_inf,
								$login_user, $login_user_groups);

$path = make_path($curdir, "", $fname);
$folder_flg = is_dir($path);

//指定ファイルの情報を得る
//Information on the targeted file is obtained.
$finf = get_file_info($conf, $path);

$permit = get_permission($conf, $finf,
							$login_user, $login_user_groups);

//切取り・コピー処理
//Cutout and copy processing
if ((!($curdir_permit["w"] && $permit["w"]) || ($folder_flg && !$permit["x"])) && $mode == "cut") {
	//書き込み権が無い
	//There is no writing right.
	$msg = get_txt("writing has not been permitted");
} else if ($fname != "") {
	$dstpath = make_path($cutdir, "", $fname);

	if ($folder_flg) {
		$type_str = get_txt("folder");
	} else {
		$type_str = get_txt("file");
	}
	$sts = TRUE;
	if (!file_exists($cutdir)) {
		$sts = make_dir($cutdir, get_data_dir_attr($conf));
		if (!sts) {
			$err_msg = get_txt("cannot make cut buffer folder");
			$msg .= $err_msg . "<br>\n";
			put_log($conf, $mode . " failure:" .
								$err_msg . ":" . $cutdir);
		}
	}
	if ($sts) {
		$sts = FALSE;
		if (file_exists($dstpath)) {
			$err_msg = get_txt("the file name overlaps");
			$msg .= $err_msg . ":" . $type_str . "<br>\n";
			put_log($conf, $mode . " failure:" . $err_msg . ":" . $dstpath);
		} else {
			if ($mode != "copy") {
				if ($folder_flg &&
						!check_delete_permit($conf, $path, $login_user, $login_user_groups)) {
					$err_msg = get_txt("writing has not been permitted");
					$msg .= $err_msg . ":" . $type_str . "<br>\n";
					put_log($conf, $mode . " failure:" . $err_msg . ":" . $dstpath);
				} else {
					// ファイル名の変更
					//Change in file name
					$sts = rename($path, $dstpath);
					if (!$sts) {
						$msg .= $type_str . "(" . $fname . "):" .
										get_txt("cannot cut") . "<br>\n";
						put_log($conf, "Cut failure : " . $msg);
					} else {
						put_log($conf, "Cut File=" . $path .
										" User=" . $login_user);
					}
				}
			} else {
				if ($folder_flg &&
						!check_read_permit($conf, $path, $login_user, $login_user_groups)) {
						$err_msg = get_txt("reading has not been permitted");
						$msg .= $err_msg . ":" . $type_str . "<br>\n";
						put_log($conf, $mode . " failure:" . $err_msg . ":" . $dstpath);
				} else {
					if ($folder_flg) {
						$sts = copy_dir_with_permit($conf, $path, $dstpath,
											$login_user, $login_user_groups);
					} else {
						// ファイルのコピー
						//Copy of file
						$sts = copy($path, $dstpath);
					}
					if (!$sts) {
						$msg .= $type_str . "(" . $fname . "):" .
										get_txt("cannot copy") . "<br>\n";
						put_log($conf, "Copy failure : " . $msg);
					} else {
						put_log($conf, "Copy File=" . $path .
										" User=" . $login_user);
					}
				}
			}
		}
	}
	if ($sts) {
		if ($mode != "copy") {
			//カレントディレクトリをロックする
			//The current directory is locked.
			$lockfile = make_path($curdir, "", $conf["LOCKFILE"]);
			$lock_fp = lock_files($lockfile);
			if (! $lock_fp) {
				//ロックを解除する
				//The lock is released.
				$msg .= get_txt("cannot lock current folder") . "<br>\n";
				$sts = FALSE;
				put_log($conf, "Cut failure : can not lock");
			} else {
				//カレントディレクトリのファイルリストを更新する
				//The file list of the current directory is updated.

				// ファイルリストを読み込む
				//The file list is read.
				$listfile = make_path($curdir, "", $conf["LISTFILE"]);
				if (file_exists($listfile)) {
					$list_files = read_filelist($curdir, $conf["LISTFILE"]);
				}
				//カレントディレクトリ内のファイル一覧を得る
				//The file list in the current directory is obtained.
				list($files, $update) = get_dirfiles($conf,
													$curdir, $list_files);

				// カレントディレクトリのファイルリスト書き込み
				//File list of current directory writing
				if (!write_file_list($listfile, $files)) {
					$msg .= get_txt("cannot write file list") . 
										":" . $listfile . "<br>\n";
					$sts = FALSE;
					put_log($conf, "Cut failure : " . $path .
											" : can not update file list");
				}
				//カレントディレクトリのロックを解除する
				//The lock of the current directory is released.
				unlock_files($lock_fp, $lockfile);

				if ($sts) {
					//フォルダの日付を更新する
					update_dir_time($conf, $curdir, "", "");
				}
			}
		}
		//カットバッファをロックする
		//The cutting buffer is locked.
		$cutlockfile = make_path($cutdir, "",$conf["LOCKFILE"]);
		$cutlock_fp = lock_files($cutlockfile);
		if (! $cutlock_fp) {
			$msg .= get_txt("cannot lock cut buffer") . "<br>\n";
			$sts = FALSE;
			put_log($conf, $mode . " failure : " . $path .
										" : can not lock cut buffer");
		} else {
			//カットバッファのファイルリストを更新する
			//The file list of the cutting buffer is updated.

			// カットバッファのファイルリストを読み込む
			//The file list of the cutting buffer is read.
			$listfile = make_path($cutdir, "", $conf["LISTFILE"]);
			if (file_exists($listfile)) {
				$list_files = read_filelist($cutdir, $conf["LISTFILE"]);
			}
			//カットバッファ内のファイル一覧を得る
			//The file list in the cutting buffer is obtained.
			list($files, $update) = get_dirfiles($conf,
												$cutdir, $list_files);

			if (isset($login_user_groups) && isset($login_user_groups[0])) {
				$login_group = $login_user_groups[0];
			} else {
				$login_group = "";
			}

			for ($i = 0; $i < count($files); $i++) {
				$finf = $files[$i];
				if ($finf["name"] == $fname) {
					$finf["name"] = $fname;
					$finf["comment"] = $comment;
					$finf["owner"] = $owner;
					$finf["date"] = $date;
					$finf["time"] = $time;
					if ($mode != "cut") {
						$finf["user"] = $login_user;
						$finf["group"] = $login_group;
						$finf["attr"] = get_attr_val("rwxrwxrwx");
					} else {
						$finf["user"] = $user;
						$finf["group"] = $group;
						$finf["attr"] = $attr;
					}
					$files[$i] = $finf;
					break;
				}
			}
			// カットバッファのファイルリスト書き込み
			//File list of cutting buffer writing
			if (!write_file_list($listfile, $files)) {
				$msg .= get_txt("cannot write cut buffer file list") .
										":" . $listfile . "<br>\n";
				$sts = FALSE;
				put_log($conf, $mode . " failure : " . $path .
									" : can not update file list");
			}
			//ロックを解除する
			//The lock is released.
			unlock_files($cutlock_fp, $cutlockfile);
			if ($sts) {
				put_log($conf, $mode . " success : " . $path);
			}
		}
	}
} else {
	$msg .= get_txt("file name is not specified") . "<br>\n";
	put_log($conf, $mode . " failure : no filename");
}

if ($sts) {
	//ファイル一覧にリダイレクトする
	//It redirects it to the file list.
	echo get_redirect_files_JavaScriptHTML($conf);
	exit;
}

?>
<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>
<HR>
<?php
if (!$sts) {
	echo $msg;
	echo "<HR>";
	//ファイル一覧に戻るのHTML文字列を取得
	//The HTML string to return to the file list is acquired.
	echo get_return_files_HTML($conf);
}
?>
<?php
//ページフッター（プログラム・バージョンとCopyright表示）
//Page footer(program version and Copyright display)
echo get_page_footer_HTML($conf);
?>
</BODY>
</HTML>
