<?php
/******************************************************************************
	Files(WEBファイル共有PHPスクリプト)
	Files(WEB file share PHP script)

	ファイル／フォルダの名称・コメント・属性編集
	Name, comment, and attribute edit of file/folder

  	edit.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2014 GUSUKU All rights reserved.

	Update:

	Ver.2.6.2
		著作権者変更
		The copyright owner has been changed.

	Ver.2.3
		未定義の変数への参照をしないように修正した
		It was corrected that it did not refer to an undefined variable.

	Ver.2.1
		構成ファイル配置設定を追加
		The configuration file arrangement setting is added.

	Ver.2.0
		表示文字列を locale.php から取得するように修正
		The display character string was acquired from locale.php. 

		文字コードの指定も locale.php から取得するように修正
		The specification of the character-code was acquired from locale.php.

		所有者とグループによるアクセス権制御機能を付加
		The access control function by the group is added with the owner. 

		HTML部分に２バイト文字を使用しないように修正した、
		ブラウザの文字コード自動判別に影響しないようにするため
		To make it not misidentified by the character-code automatic operation 
		identification of a browser, it was corrected that Japanese was not 
		used for the HTML part. 

	Ver.1.4 までの更新履歴
	Update history to Ver.1.4
		2005/08/02	ページヘッダー部分を共通化
					A common page header partial function is added. 
******************************************************************************/

require('files_com.php');

$conf = init_files(FALSE);
$mode = get_post_get_val("mode");

$CUTMODE = get_post_get_val("CUTMODE");

$submit = get_post_get_val("submit");
$cancel = get_post_get_val("cancel");

$fname = get_post_get_val("fname");
$comment = get_post_get_val("comment");
$owner = get_post_get_val("owner");
$date = get_post_get_val("date");
$time = get_post_get_val("time");
$user = get_post_get_val("user");
$group = get_post_get_val("group");
$attr = get_post_get_val("attr");

$scriptname = "edit.php";

$s_name = files_session_name();
$s_id = session_id();

if ($CUTMODE == "1") {
	$curdir = make_path($conf["TOPDIR"], $conf["CUTDIR"], "");
} else {
	$curdir = make_path($conf["TOPDIR"], $conf["curdir"], "");
}

$type_str = get_txt("file");
$folder_flg = FALSE;
if ($fname != "") {
	$file_path = make_path($curdir, "", $fname);
	$folder_flg = is_dir($file_path);
	if ($folder_flg) {
		$type_str = get_txt("folder");
	}
}

//ログインユーザー
//Login user
$login_user = get_login_user();

//ログインユーザーの所属グループ
//Login user's belonging group
$login_user_groups = get_user_groups($conf, $login_user);

//カレントディレクトリのパスを得る
//The path in the current directory is made.
$curdir = make_path($conf["TOPDIR"], $conf["curdir"], "");

//カレントディレクトリの情報を得る
//Information on the current directory is obtained.
$curdir_inf = get_file_info($conf, $curdir);

//カレントディレクトリのパーミッションを得る
//The permission of the current directory is obtained.
$curdir_permit = get_permission($conf, $curdir_inf,
								$login_user, $login_user_groups);
if ($curdir == $conf["TOPDIR"]) {
	$curdir_permit["r"] = 1;
	$curdir_permit["w"] = 1;
	$curdir_permit["x"] = 1;
}

$fullpath = make_path($curdir, "", $fname);

//指定ファイルの情報を得る
//Information on the targeted file is obtained.
$finf = get_file_info($conf, $fullpath);

$permit = get_permission($conf, $finf,
							$login_user, $login_user_groups);

$mod_ok = FALSE;
$readonly = "readonly";
$form_action = "";
if ($curdir_permit["w"] && $permit["w"] ||
				$login_user == $finf["user"] ||
				$login_user == $conf["ADMIN_USERID"]) {
	$mod_ok = TRUE;
	$readonly = "";
	$form_action = "action=\"" . $conf["EDIT_SCRIPT"] ."\" method=\"post\"";
}

$mod_attr = FALSE;
$mod_attr_disable = "disabled";

if ((!$CUTMODE && $login_user == $finf["user"]) ||
					$login_user == $conf["ADMIN_USERID"]) {
	$mod_attr = TRUE;
	$mod_attr_disable = "";
}
$admin = FALSE;
$adm_readonly = "readonly";
if ($login_user == $conf["ADMIN_USERID"]) {
	$adm_readonly = "";
	$admin = TRUE;
}

//$dbg_msg = sprintf("curdir_permit=%d, %d, %d<br>\n",
//								$curdir_permit["r"],
//								$curdir_permit["w"],
//								$curdir_permit["x"]);
//$dbg_msg .= sprintf("permit=%d, %d, %d<br>\n",
//								$permit["r"],
//								$permit["w"],
//								$permit["x"]);
//$dbg_msg .= sprintf("mod_ok=%d, mod_attr=%d, admin=%d<br>\n",
//								$mod_ok, $mod_attr, $admin);

if ($mode != "update" && $mode != "attr") {
	//編集フォーム表示
	//Edit form display

	//ファイルのパーミッションを得る
	//The permission of the file is obtained.
	if (! isset($attr) || $attr == 0) {
		$attr = $finf["attr"];
	}
	if (! isset($attr) || $attr == 0) {
		$attr = $conf["DEFAULT_ATTR"];
	}
	$checked["ur"] = ($attr & 0400) ? "checked" : "";
	$checked["uw"] = ($attr & 0200) ? "checked" : "";
	$checked["ux"] = ($attr & 0100) ? "checked" : "";
	$checked["gr"] = ($attr & 0040) ? "checked" : "";
	$checked["gw"] = ($attr & 0020) ? "checked" : "";
	$checked["gx"] = ($attr & 0010) ? "checked" : "";
	$checked["or"] = ($attr & 0004) ? "checked" : "";
	$checked["ow"] = ($attr & 0002) ? "checked" : "";
	$checked["ox"] = ($attr & 0001) ? "checked" : "";

	$group_list = get_group_list($conf);
	$user_list = get_user_list($conf);
?>

<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>

<?php
	//debug echo
	//echo $dbg_msg;

	//ページヘッダーHTMLを取得
	//Page header HTML is acquired.
	echo get_page_header_HTML($conf, "TITLE_COMMENT_EDIT",
									TRUE, $conf["SHOW_HELP_LINK"]);
?>

<CENTER>
<HR>
<TABLE width=95% border=0>
	<TR>
		<TD>
			<?php
				//ファイル一覧に戻るのHTML文字列を取得
				//The HTML string to return to the file list is acquired.
				echo get_return_files_HTML($conf);
			?>
		</TD>
	</TR>
	<TR>
		<TD align=center>
			<!-- <P align=center> -->
				<B><?php echo $conf["title"] ?></B>&nbsp;&nbsp;
				(<?php echo get_txt("update datetime"); ?>&nbsp;:&nbsp;
				<?php echo $conf["uptime"] ?>)
			<!-- </P> -->
		</TD>
	</TR>
</TABLE>
<form <?php echo $form_action ?>>
	<input type="hidden" name="mode" value="update">
	<input type="hidden" name="config" value="<?php echo $conf["config"] ?>">
	<input type="hidden" name="dir" value="<?php echo $conf["curdir"] ?>">
	<input type="hidden" name="CUTMODE" value="<?php echo $CUTMODE ?>">
	<input type="hidden" name="fname" value="<?php echo $fname ?>">
	<input type="hidden" name="comment" value="<?php echo $comment ?>">
	<input type="hidden" name="owner" value="<?php echo $owner ?>">
	<input type="hidden" name="date" value="<?php echo $date ?>">
	<input type="hidden" name="time" value="<?php echo $time ?>">
	<input type="hidden" name="user" value="<?php echo $user ?>">
	<input type="hidden" name="group" value="<?php echo $group ?>">
	<input type="hidden" name="attr" value="<?php echo $attr ?>">
	<input type="hidden" name="<?php echo $s_name ?>" value="<?php echo $s_id ?>">
	<TABLE border=1>
		<TR BGCOLOR="<?php echo $conf["LIST_TITLE_BG"] ?>">
			<TD colspan=2 align=center>
				<B><?php echo $type_str . get_txt("edit"); ?></B>
			</TD>
		</TR>
		<TR>
			<TD><B><?php echo $type_str . get_txt("name"); ?>:</B></TD>
			<TD><input name="newfname" type="text" size=80 maxlength=128
				value="<?php echo $fname ?>" <?php echo $readonly ?>></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("comment"); ?>:</B></TD>
			<TD><input name="newcomment" type="text" size=80 maxlength=128
				value="<?php echo $comment ?>" <?php echo $readonly ?>></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("create user name"); ?>:</B></TD>
			<TD><input name="newowner" type="text" size=20 maxlength=30
				value="<?php echo $owner ?>" <?php echo $readonly ?>></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("owner name"); ?>:</B></TD>
			<TD>
				<select name="newuser" size=1 style="width:150">
<?php
	$selected = "";
	if ($user == "") {
		$selected = "selected";
	}
	echo "<option value=\"\" $selected $adm_readonly>\n";
	foreach($user_list as $user_id) {
		$selected = "";
		if ($user_id == $user) {
			$selected = "selected";
		}
		if ($user_id != "") {
 			echo "<option value=\"$user_id\" $selected $adm_readonly>
														$user_id\n";
 		}
	}
?>
				</select>
			</TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("belong group"); ?>:</B></TD>
			<TD>
				<select name="newgroup" size=1 style="width:150">
<?php	
	if ($finf["group"] == "") {
		$selected = "selected";
	}
	echo "<option value=\"\" $selected $adm_readonly>\n";
	foreach($group_list as $group_id) {
		$selected = "";
		if ($group_id == $finf["group"]) {
			$selected = "selected";
		}
		if ($group_id != "") {
 			echo "<option value=\"$group_id\" $selected $adm_readonly>
														$group_id\n";
 		}
	}
?>
				</select>
			</TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("create date"); ?>:</B></TD>
			<TD><input name="newdate" type="text" size=20 maxlength=15
				value="<?php echo $date ?>" <?php echo $readonly ?>></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("create time"); ?>:</B></TD>
			<TD><input name="newtime" type="text" size=20 maxlength=5
				value="<?php echo $time ?>" <?php echo $readonly ?>></TD>
		</TR>
<?php
	if ($mod_ok) {
?>
		<TR>
			<TD colspan=2>
				<CENTER>
				<input type="submit" name="submit"
									value="<?php echo get_txt("update"); ?>">
				<input type="reset" value="<?php echo get_txt("reset"); ?>">
				</CENTER>
			</TD>
		</TR>
<?php
	}
?>
	</TABLE>
</form>
<P>
<form <?php echo $form_action ?>>
	<input type="hidden" name="mode" value="attr">
	<input type="hidden" name="config" value="<?php echo $conf["config"] ?>">
	<input type="hidden" name="dir" value="<?php echo $conf["curdir"] ?>">
	<input type="hidden" name="CUTMODE" value="<?php echo $CUTMODE ?>">
	<input type="hidden" name="fname" value="<?php echo $fname ?>">
	<input type="hidden" name="comment" value="<?php echo $comment ?>">
	<input type="hidden" name="owner" value="<?php echo $owner ?>">
	<input type="hidden" name="date" value="<?php echo $date ?>">
	<input type="hidden" name="time" value="<?php echo $time ?>">
	<input type="hidden" name="user" value="<?php echo $user ?>">
	<input type="hidden" name="group" value="<?php echo $group ?>">
	<input type="hidden" name="attr" value="<?php echo $attr ?>">
	<input type="hidden" name="<?php echo $s_name ?>" value="<?php echo $s_id ?>">
	<TABLE border=1>
		<TR BGCOLOR="<?php echo $conf["LIST_TITLE_BG2"] ?>">
			<TD colspan=3>
				<CENTER><B><?php echo $type_str ?><?php echo get_txt("change attr"); ?></B></CENTER>
			</TD>
		</TR>
		<TR align="center" BGCOLOR="<?php echo $conf["LIST_HEAD_BG2"] ?>">
			<TD><B><?php echo get_txt("owner"); ?></B></TD>
			<TD><B><?php echo get_txt("group"); ?></B></TD>
			<TD><B><?php echo get_txt("other"); ?></B></TD>
		</TR>
		<TR>
			<TD>
				<input type="checkbox" name="user_r" value="1"
					<?php echo $checked["ur"] . " " . $mod_attr_disable; ?> >
										<?php echo get_txt("read"); ?>
				<input type="checkbox" name="user_w" value="1"
					<?php echo $checked["uw"] . " " . $mod_attr_disable; ?> >
										<?php echo get_txt("write"); ?>
				<input type="checkbox" name="user_x" value="1"
					<?php echo $checked["ux"] . " " . $mod_attr_disable; ?> >
										<?php echo get_txt("exec"); ?>
			</TD>
			<TD>
				<input type="checkbox" name="group_r" value="1"
					<?php echo $checked["gr"] . " " . $mod_attr_disable; ?> >
										<?php echo get_txt("read"); ?>
				<input type="checkbox" name="group_w" value="1"
					<?php echo $checked["gw"] . " " . $mod_attr_disable; ?> >
										<?php echo get_txt("write"); ?>
				<input type="checkbox" name="group_x" value="1"
					<?php echo $checked["gx"] . " " . $mod_attr_disable; ?> >
										<?php echo get_txt("exec"); ?>
			</TD>
			<TD>
				<input type="checkbox" name="other_r" value="1"
					<?php echo $checked["or"] . " " . $mod_attr_disable; ?> >
										<?php echo get_txt("read"); ?>
				<input type="checkbox" name="other_w" value="1"
					<?php echo $checked["ow"] . " " . $mod_attr_disable; ?> >
										<?php echo get_txt("write"); ?>
				<input type="checkbox" name="other_x" value="1"
					<?php echo $checked["ox"] . " " . $mod_attr_disable; ?> >
										<?php echo get_txt("exec"); ?>
			</TD>
		</TR>
<?php
	if ($mod_attr) {
?>
		<TR>
			<TD colspan=3>
				<CENTER>
				<input type="submit" name="submit"
									value="<?php echo get_txt("edit"); ?>">
				<input type="reset" value="<?php echo get_txt("reset"); ?>">
				</CENTER>
			</TD>
		</TR>
<?php
	}
?>
	</TABLE>
</form>
<p>
<HR>
<?php
	//戻り先１と戻り先２へのリンクを表示するHTMLを生成
	//Link HTML to return 1 and return 2 destination is generated.
	echo get_return_url_HTML($conf);
?>

<?php

} elseif ($mode == "update") {

	$newfname = get_post_get_val("newfname");
	$newcomment = get_post_get_val("newcomment");
	$newowner = get_post_get_val("newowner");
	$newdate = get_post_get_val("newdate");
	$newtime = get_post_get_val("newtime");
	$newuser = get_post_get_val("newuser");
	$newgroup = get_post_get_val("newgroup");

	//更新処理
	//Update processing
	$msg = "";
	$sts = TRUE;
	if ($submit != "" && ($fname != $newfname ||
							$comment != $newcomment ||
							$owner != $newowner ||
							$date != $newdate ||
							$time != $newtime ||
							$user != $newuser ||
							$group != $newgroup)) {
		$old_finf = array();
		$old_flg = FALSE;
		$listfile = make_path($curdir, "", $conf["LISTFILE"]);
		if (file_exists($listfile)) {
			$files = read_filelist($curdir, $conf["LISTFILE"]);
			foreach($files as $finf) {
				if ($finf["name"] == $fname) {
					$old_finf = $finf;
					$old_flg = TRUE;
					break;
				}
			}
		}
		if ((! $admin) && (($user != $newuser) || ($group != $newgroup))) {
			$msg = get_txt("writing has not been permitted");
			$sts = FALSE;
		} elseif (!$mod_ok) {
			$msg = get_txt("writing has not been permitted");
			$sts = FALSE;
		} else {
			if ($fname != $newfname) {
				// ファイル名の変更
				//Change in file name
				$oldfpath = make_path($curdir, "", $fname);
				$newfpath = make_path($curdir, "", $newfname);
				$sts = rename($oldfpath, $newfpath);
				if ($sts) {
					put_log($conf, "Rename OldName=" . $oldfpath .
											" NewName=" . $newfpath .
											" User=" . $login_user);
				}
			}
			if ($sts) {
				//ロックする
				//It locks.
				$lockfile = make_path($curdir, "", $conf["LOCKFILE"]);
				$lock_fp = lock_files($lockfile);
				if (! $lock_fp) {
					$msg .= get_txt("cannot lock") . "<br>\n";
					$sts = FALSE;
					put_log($conf, "Edit failure : can not lock");
				} else {
					// ファイルリスト記録ファイル名
					//File list record file name
					$listfile = make_path($curdir, "", $conf["LISTFILE"]);

					// ファイルリストを読み込む
					//The file list is read.
					if (file_exists($listfile)) {
						$list_files = read_filelist($curdir, $conf["LISTFILE"]);
					}

					//カレントディレクトリ内のファイル一覧を得る
					//The file list in the current directory is obtained.
					list($files, $update) = get_dirfiles($conf,
														$curdir, $list_files);

					if ($newdate == "") {
						$newdate = date("Y/m/d");
						$newtime = date("H:i:s");
					}
					if ($newuser == "" || $newgroup == "") {
						$attr = get_attr_val("rwxrwxrwx");
					}

					$found = FALSE;
					for ($i = 0; $i < count($files); $i++) {
						$finf = $files[$i];
						if ($finf["name"] == $fname ||
										$finf["name"] == $newfname) {
							$finf["name"] = $newfname;
							$finf["comment"] = $newcomment;
							$finf["owner"] = $newowner;
							$finf["date"] = $newdate;
							$finf["time"] = $newtime;
							$finf["user"] = $newuser;
							$finf["group"] = $newgroup;
							$finf["attr"] = $attr;
							$files[$i] = $finf;
							$found = TRUE;
							break;
						}
					}
					if (!$found && $old_flg) {
						$old_finf["name"] = $newfname;
						$old_finf["comment"] = $newcomment;
						$old_finf["owner"] = $newowner;
						$old_finf["date"] = $newdate;
						$old_finf["time"] = $newtime;
						$old_finf["user"] = $newuser;
						$old_finf["group"] = $newgroup;
						$old_finf["attr"] = $attr;
						$files[] = $old_finf;
					}

					// ファイルリスト書き込み
					//File list writing
					if (!write_file_list($listfile, $files)) {
						$msg .= get_txt("cannot write file list") .
											":" . $listfile . "<br>\n";
						$sts = FALSE;
						put_log($conf, "Edit failure : " . $fname .
										" : can not update file list");
					}
					//ロックを解除する
					//The lock is released.
					unlock_files($lock_fp, $lockfile);
					if ($sts) {
						put_log($conf, "Edit success : " . $fname);

						//フォルダの日付を更新する
						update_dir_time($conf, $curdir, "", "");
					}
				}
			} else {
				$msg .= get_txt("cannot rename file");
				put_log($conf, "Edit failure : can not rename " . $fname);
			}
		}
	}
} elseif ($mode == "attr") {

put_log($conf, "Updare attr\n");

	$user_r = get_post_get_val("user_r");
	$user_w = get_post_get_val("user_w");
	$user_x = get_post_get_val("user_x");
	$group_r = get_post_get_val("group_r");
	$group_w = get_post_get_val("group_w");
	$group_x = get_post_get_val("group_x");
	$other_r = get_post_get_val("other_r");
	$other_w = get_post_get_val("other_w");
	$other_x = get_post_get_val("other_x");


	//属性変更処理
	//Attribute change processing
	$msg = "";
	$sts = TRUE;

	$attr &= $conf["DEFAULT_ATTR"];		// may be 0777

	if ($user == "" || $group == "") {
		$newattr = get_attr_val("rwxrwxrwx");
	} else {
		$newattr = 00000;
		$newattr |= ($user_r ? 00400 : 00000);
		$newattr |= ($user_w ? 00200 : 00000);
		$newattr |= ($user_x ? 00100 : 00000);
		$newattr |= ($group_r ? 00040 : 00000);
		$newattr |= ($group_w ? 00020 : 00000);
		$newattr |= ($group_x ? 00010 : 00000);
		$newattr |= ($other_r ? 00004 : 00000);
		$newattr |= ($other_w ? 00002 : 00000);
		$newattr |= ($other_x ? 00001 : 00000);
	}
	put_log($conf, "Updare attr newattr=" . get_attr_str($newattr) . "\n");
	if (!$mod_attr) {
		$msg = get_txt("writing has not been permitted");
		$sts = FALSE;
	} if ($attr != $newattr && $submit != "") {
		//ロックする
		//It locks.
		$lockfile = make_path($curdir, "", $conf["LOCKFILE"]);
		$lock_fp = lock_files($lockfile);
		if (! $lock_fp) {
			$msg .= get_txt("cannot lock") . "<br>\n";
			$sts = FALSE;
			put_log($conf, "Edit failure : can not lock");
		} else {
			// ファイルリスト記録ファイル名
			//File list record file name
			$listfile = make_path($curdir, "", $conf["LISTFILE"]);

			// ファイルリストを読み込む
			//The file list is read.
			if (file_exists($listfile)) {
				$list_files = read_filelist($curdir, $conf["LISTFILE"]);
			}

			//カレントディレクトリ内のファイル一覧を得る
			//The file list in the current directory is obtained.
			list($files, $update) = get_dirfiles($conf,
												$curdir, $list_files);

			if (!isset($newdate) || $newdate == "") {
				$newdate = date("Y/m/d");
				$newtime = date("H:i:s");
			}
			$found = FALSE;
			for ($i = 0; $i < count($files); $i++) {
				$finf = $files[$i];
				if ($finf["name"] == $fname) {
					$finf["name"] = $fname;
					$finf["comment"] = $comment;
					$finf["owner"] = $owner;
					$finf["date"] = $date;
					$finf["time"] = $time;
					$finf["user"] = $user;
					$finf["group"] = $group;
					$finf["attr"] = $newattr;
					$files[$i] = $finf;
					$found = TRUE;
					break;
				}
			}
			if (!$found && $old_flg) {
				$old_finf["name"] = $fname;
				$old_finf["comment"] = $comment;
				$old_finf["owner"] = $owner;
				$old_finf["date"] = $date;
				$old_finf["time"] = $time;
				$old_finf["user"] = $user;
				$old_finf["group"] = $group;
				$old_finf["attr"] = $newattr;
				$files[] = $old_finf;
			}
			// ファイルリスト書き込み
			//File list writing
			if (!write_file_list($listfile, $files)) {
				$msg .= get_txt("cannot write file list") .
									":" . $listfile . "<br>\n";
				$sts = FALSE;
				put_log($conf, "Edit failure : " . $fname .
									" : can not update file list");
			}
			//ロックを解除する
			//The lock is released.
			unlock_files($lock_fp, $lockfile);
			if ($sts) {
				put_log($conf, "Edit success : " . $fname);

				//フォルダの日付を更新する
				update_dir_time($conf, $curdir, "", "");
			}
		}
		if (! $sts) {
			$msg .= $type_str . "(" . $fname . ")" .
								get_txt("cannot change attr");
			put_log($conf, "Edit permition failure : " . $file_path);
		} else {
			put_log($conf, "Edit permition success : " . $file_path);
		}
	}
}

if ($mode == "update" || $mode == "attr") {
	if ($sts) {
		//ファイル一覧にリダイレクトする
		//It redirects it to the file list.
		echo get_redirect_files_JavaScriptHTML($conf);
		exit;
	}
?>

<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>
<HR>

<?php
	//echo "mode=" . $mode . " : dbg_msg = ";
	//echo $dbg_msg;
	//echo "<br>\n";

	if (!$sts) {
		put_log($conf, $msg);
		echo $msg;
		echo "<HR>";
		//ファイル一覧に戻るのHTML文字列を取得
		//The HTML string to return to the file list is acquired.
		echo get_return_files_HTML($conf);
	}
}

//ページフッター（プログラム・バージョンとCopyright表示）
//Page footer(program version and Copyright display)
echo get_page_footer_HTML($conf)

?>
</BODY>
</HTML>

