<?php
/******************************************************************************
	Files(WEBファイル共有PHPスクリプト)
	Files(WEB file share PHP script)

	グループ設定処理
	Group setting processing

  	group.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2014 GUSUKU All rights reserved.

	Update:

	Ver.2.6.2
		著作権者変更
		The copyright owner has been changed.

	Ver.2.1
		構成ファイル配置設定を追加
		The configuration file arrangement setting is added.

	Ver.2.0
		新規作成
		New making

******************************************************************************/

require('files_com.php');

$conf = init_files(FALSE);
$mode = get_post_get_val("mode");

$scriptname = "group.php";

$s_name = files_session_name();
$s_id = session_id();

$login_user = get_login_user();

$form_action = "action=\"" . $conf["GROUP_SCRIPT"] ."\" method=\"post\"";

$return_url = get_post_get_val("return_url");
$conf["returl"] = $return_url . "?config=" . $conf["config"];
$conf["returl"] .= "&" . $s_name . "=" . $s_id;

$msg = "";

//グループ設定フォーム表示
//Group setting and form displays
if ($mode == "") {
	//グループ追加・削除後の戻り先（同じ画面）
	//At the return after it adds the group and it deletes it destination
	//(same screen)
	$grpurl = $scriptname;
	$grpurl .= "?config=" . conv_url_code($conf["config"]);
	$grpurl .= "&return_url=" . $conf["FILES_SCRIPT"];
	$grpurl .= "&" . $s_name . "=" . $s_id;

	//ユーザーリストを取得
	//The user list is acquired.
	$user_list = get_user_list($conf);

	//グループリストを取得
	//The group list is acquired.
	$group_list = get_group_list($conf);

	//ユーザー毎の所属グループを取得（カンマ区切り）
	//Each user's belonging group is acquired. (comma district switching off)
	$group_user_list = array();
	$idx = 0;
	foreach ($group_list as $group) {
		$users = get_group_users($conf, $group);
		$group_user_list[$idx] = join(",", $users);
		$idx++;
	}
?>

<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
<script type="text/javascript">
<!--

//Array of user name
user_list = new Array();

//Array of group name
group_list = new Array();

//The group belonging user's (comma district Kiaya Gerets) array
group_user_list = new Array();

//The group belonging user's array is obtained.
function GetGroupUserArray(group_idx)
{
	usr_lst = new Array();
	
	if (0 <= group_idx && group_idx < group_user_list.length) {
		group_user_str = group_user_list[group_idx];
		if (group_user_str != "") {
			usr_lst = group_user_str.split(",");
		}
	}
	return usr_lst;
}

//The list of the belonging group is reflected in the list of the form.
function UpdateGroupUserList(group_user_arr)
{
	//It empties it.
	len = document.group_user_form.group_user_list.length;
	for (i = 0; i < len; i++) {
		document.group_user_form.group_user_list.options[i] = null;
	}

	//The belonging group is set in the list.
	for (i = 0; i < group_user_arr.length; i++) {
		document.group_user_form.group_user_list.options[i] =
							new Option(group_user_arr[i], group_user_arr[i]);
	}
}

//The group was selected.
function OnSelectGroup()
{
	group_idx = document.group_form.group_list.selectedIndex;

	//The array of the belonging group is acquired.
	group_user_arr = GetGroupUserArray(group_idx);

	//The belonging group is reflected in the list of the form.
	UpdateGroupUserList(group_user_arr);
}

//The belonging user of the group is added.
function OnAddGroupUser()
{
	group_idx = document.group_form.group_list.selectedIndex;
	if (group_idx < 0 || group_list.length <= group_idx) {
		alert("OnAddGroupUser(): group is not selected");
		return false;
	}
	user_idx = document.user_form.user_list.selectedIndex;

	sel_user = document.user_form.user_list.options[user_idx].value
	if (sel_user == "") {
		alert("OnAddGroupUser(): user is not selected");
		return false;
	}

	//The belonging user's array is acquired.
	group_user_arr = GetGroupUserArray(group_idx);
	new_user_arr = new Array();

	found = false;
	for (i = 0; i < group_user_arr.length; i++) {
		user = group_user_arr[i];
		if (user == sel_user) {
			alert("OnAddGroupUser(): user already exists");
			return false;
		}
		new_user_arr.push(user);
	}
	new_user_arr.push(sel_user);

	if (new_user_arr.length > 0) {
		group_user_list[group_idx] = new_user_arr.join(",");
	} else {
		group_user_list[group_idx] = "";
	}

	//The belonging group is reflected in the list of the form.
	UpdateGroupUserList(new_user_arr);

	return true;
}

//The belonging user of the group is deleted.
function OnDelGroupUser()
{
	group_idx = document.group_form.group_list.selectedIndex;
	if (group_idx < 0 || group_list.length <= group_idx) {
		alert("OnDelGroupUser(): group is not selected");
		return false;
	}
	user_idx = document.group_user_form.group_user_list.selectedIndex;

	sel_user = document.group_user_form.group_user_list.options[user_idx].value

	//The belonging user's array is acquired.
	group_user_arr = GetGroupUserArray(group_idx);
	new_user_arr = new Array();

	for (i = 0; i < group_user_arr.length; i++) {
		user = group_user_arr[i];
		if (user != sel_user) {
			new_user_arr.push(user);
		}
	}
	if (new_user_arr.length > 0) {
		group_user_list[group_idx] = new_user_arr.join(",");
	} else {
		group_user_list[group_idx] = "";
	}
	//The belonging group is reflected in the list of the form.
	UpdateGroupUserList(new_user_arr);

	return true;
}

//The group is added.
function OnAddGroup()
{
	group = document.group_add_form.add_group.value;

	//It is checked whether the same name as the array of the group exists.
	for (i = 0; i < group_list.length; i++) {
		if (group_list[i] == group) {
			alert("OnAddGroup(): group already exists");
			return false;
		}
	}
	document.group_add_form.groupid.value = group;
	document.group_add_form.mode = "add_group";
	//document.group_add_form.submit();

	return true;
}

//The group is deleted.
function OnDelGroup()
{
	group_idx = document.group_form.group_list.selectedIndex;
	if (group_idx < 0 || group_list.length <= group_idx) {
		alert("OnDelGroup(): Illegal group");
		return;
	}
	group = document.group_form.group_list.options[group_idx].value;

	document.group_form.groupid.value = group;
	document.group_form.mode = "del_group";
	//document.group_form.submit();

	return true;
}

//The user is added.
function OnAddUser()
{
	user = document.user_add_form.add_user.value;

	//It is checked whether the same name as the user's array exists.
	for (i = 0; i < user_list.length; i++) {
		if (user_list[i] == user) {
			alert("OnAddUser(): user already exists");
			return false;
		}
	}
	document.user_add_form.userid.value = user;
	document.user_add_form.mode = "add_user";
	//document.user_add_form.submit();

	return true;
}

//The user is deleted.
function OnDelUser()
{
	user_idx = document.user_form.user_list.selectedIndex;
	if (user_idx < 0 || user_list.length <= user_idx) {
		alert("OnDelUser(): Illegal user");
		return;
	}
	user = document.user_form.user_list.options[user_idx].value;

	document.user_form.userid.value = user;
	document.user_form.mode = "del_user";
	//document.user_form.submit();

	return true;
}

function OnUpdate()
{
	group_idx = document.group_form.group_list.selectedIndex;
	if (group_idx < 0 || group_list.length <= group_idx) {
		alert("OnUpdate(): Illegal group");
		return false;
	}
	group = document.group_form.group_list.options[group_idx].value;

	len = document.group_user_form.group_user_list.length;
	new_group_user_list = new Array();
	for (i = 0; i < len; i++) {
		user = document.group_user_form.group_user_list.options[i].value;
		new_group_user_list.push(user);
	}
	if (new_group_user_list.length > 0) {
		group_user_list[group_idx] = new_group_user_list.join(",");
	} else {
		group_user_list[group_idx] = "";
	}
	document.group_user_form.groupid.value = group;
	document.group_user_form.group_user.value = group_user_list[group_idx];
	document.group_user_form.mode = "update";
	//document.group_user_form.submit();

	return true;
}

function OnLoad()
{

<?php
	//ユーザー名の配列を作成
	//The array of the user name is made.
	foreach($user_list as $user) {
		echo "\tuser_list.push(\"$user\");\n";
	}
	//グループ名の配列を作成
	//The array of the group name is made.
	foreach($group_list as $group) {
		echo "\tgroup_list.push(\"$group\");\n";
	}
	//ユーザー毎の所属グループ（カンマ区切文字列）の配列を作成
	//Each user's belonging group's (comma district Kiaya Gerets)
	//array is made.
	foreach($group_user_list as $grp_usr) {
		echo "\tgroup_user_list.push(\"$grp_usr\");\n";
	}
?>
	if (document.group_form.group_list.length > 0) {
		if (document.group_form.group_list.selectedIndex < 0) {
			document.group_form.group_list.selectedIndex = 0;
		}
	}
	group_user_arr = GetGroupUserArray(0);

	//The belonging group is reflected in the list of the form.
	UpdateGroupUserList(group_user_arr);
}
// -->
</script>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?> onload="OnLoad()">

<?php
/*****
	$users = get_group_users($conf, $group_list[0]);
	echo "group_user_list start<br>\n";
	$idx = 0;
	foreach ($users as $grp_usr) {
		echo "userlst=" . $grp_usr . "<br>\n";
	}
	echo "group_user_list end<br>\n";
****/
?>

<?php
	//ページヘッダーHTMLを取得
	//Page header HTML is acquired.
	echo get_page_header_HTML($conf, "", FALSE, $conf["SHOW_HELP_LINK"]);
?>

<CENTER>
<HR>
<TABLE width=95% border=0>
	<TR>
		<TD>
			<?php
				//ファイル一覧に戻るのHTML文字列を取得
				//The HTML string to return to the file list is acquired.
				echo get_return_files_HTML($conf);
			?>
		</TD>
	</TR>
	<TR>
		<TD align=center>
			<!-- <P align=center> -->
				<B><?php echo $conf["title"] ?></B>&nbsp;&nbsp;
				(<?php echo get_txt("update datetime"); ?>&nbsp;:&nbsp;
				<?php echo $conf["uptime"] ?>)
			<!-- </P> -->
		</TD>
	</TR>
</TABLE>
<TABLE border=1><TBODY>
	<TR BGCOLOR="<?php echo $conf["LIST_TITLE_BG"] ?>">
		<TD colspan=3>
			<CENTER>
				<B><?php echo get_txt("user and group setting"); ?></B>
			</CENTER>
		</TD>
	</TR>
	<TR>
		<TD valign="top">
			<table border=0>
			<tr>
				<td><B><?php echo get_txt("group") ?>&nbsp;:&nbsp;</B></td>
			</tr>
			<tr>
				<td>
					<form name="group_form" <?php echo $form_action ?>>
						<input type="hidden" name="mode" value="del_group">
						<input type="hidden" name="groupid" value="">
						<input type="hidden" name="config"
										value="<?php echo $conf["config"] ?>">
						<input type="hidden" name="return_url"
										value="<?php echo $return_url ?>">
						<input type="hidden" name="group_url"
										value="<?php echo $grpurl ?>">
						<input type="hidden" name="<?php echo $s_name ?>"
										value="<?php echo $s_id ?>">
						<table border=0 width=100%>
						<tr>
							<td align="left">

							<select name="group_list" size=5 style="width:150"
												onchange="OnSelectGroup()">
<?php
	foreach($group_list as $group) {
		if ($group != "") {
			echo "<option value=\"$group\">$group\n";
		}
	}
?>
							</select>

							</td>
							<td align="right" valign="bottom">
								<input type="submit" onclick="return OnDelGroup()"
									value="<?php echo get_txt("delete"); ?>">
							</td>
						</tr>
						</table>
					</form>
				</td>
			</tr>
			<tr>
				<td>
					<form name="group_add_form" <?php echo $form_action ?>>
						<input type="hidden" name="mode" value="add_group">
						<input type="hidden" name="groupid" value="">
						<input type="hidden" name="config"
										value="<?php echo $conf["config"] ?>">
						<input type="hidden" name="return_url"
										value="<?php echo $return_url ?>">
						<input type="hidden" name="group_url"
										value="<?php echo $grpurl ?>">
						<input type="hidden" name="<?php echo $s_name ?>"
										value="<?php echo $s_id ?>">
						<table border=0 width=100%>
						<tr>
							<td align="left">
								<input name="add_group" type="text" 
											value="" size=24 maxlength=32>
							</td>
							<td align="right">
								<input type="submit" onclick="return OnAddGroup()"
										value="<?php echo get_txt("add"); ?>">
							</td>
						</tr>
						</table>
					</form>
				</td>
			</tr>
			</table>
		</TD>
		<TD valign="top">
			<form name="group_user_form" <?php echo $form_action ?>>
				<input type="hidden" name="mode" value="update">
				<input type="hidden" name="groupid" value="">
				<input type="hidden" name="group_user" value="">
				<input type="hidden" name="config"
										value="<?php echo $conf["config"] ?>">
				<input type="hidden" name="return_url"
										value="<?php echo $return_url ?>">
				<input type="hidden" name="group_url"
										value="<?php echo $grpurl ?>">
				<input type="hidden" name="<?php echo $s_name ?>"
										value="<?php echo $s_id ?>">

				<table border=0>
				<tr>
					<td colspan=2>
						<B><?php echo get_txt("group user"); ?>&nbsp;:&nbsp;</B>
					</td>
				</tr>
				<tr>
					<td>
						<select name="group_user_list" size=5
													style="width:150">
						</select>
					</td>
					<td>
						<input type="button" onClick="OnAddGroupUser()"
										value="&lt;--">
						<br><br>
						<input type="button" onClick="OnDelGroupUser()"
									value="--&gt;">
					</td>
				</tr>
				<tr>
					<td colspan=2>
						&nbsp;
					</td>
				</tr>
				<tr>
					<td colspan=2>
						<CENTER>
						<input type="submit" onClick="return OnUpdate()"
									value="<?php echo get_txt("update") ?>">
<!--
						<input type="reset"
									value="<?php echo get_txt("reset") ?>">
-->
						</CENTER>
					</td>
				</tr>
				</table>
			</form>
		</TD>
		<TD valign="top">
			<table border=0>
			<tr>
				<td><B><?php echo get_txt("user id") ?>&nbsp;:&nbsp;</B>
			</tr>
			<tr>
				<td>
					<form name="user_form" <?php echo $form_action ?>>
						<input type="hidden" name="mode" value="del_user">
						<input type="hidden" name="userid" value="">
						<input type="hidden" name="config"
										value="<?php echo $conf["config"] ?>">
						<input type="hidden" name="return_url"
										value="<?php echo $return_url ?>">
						<input type="hidden" name="group_url"
										value="<?php echo $grpurl ?>">
						<input type="hidden" name="<?php echo $s_name ?>"
										value="<?php echo $s_id ?>">
						<table border=0 width=100%>
						<tr>
							<td align="left">
								<select name="user_list" size=5 style="width:150">
<?php
	foreach($user_list as $user_id) {
		if ($user_id != "") {
			echo "<option value=\"$user_id\">$user_id\n";
		}
	}
?>
								</select>
							</td>
							<td align="right" valign="bottom">
								<input type="submit" onclick="return OnDelUser()"
									value="<?php echo get_txt("delete"); ?>">
							</td>
						</tr>
						</table>
					</form>
				</td>
			</tr>
			<tr>
				<td>
					<form name="user_add_form" <?php echo $form_action ?>>
						<input type="hidden" name="mode" value="add_user">
						<input type="hidden" name="userid" value="">
						<input type="hidden" name="config"
										value="<?php echo $conf["config"] ?>">
						<input type="hidden" name="return_url"
										value="<?php echo $return_url ?>">
						<input type="hidden" name="group_url"
										value="<?php echo $grpurl ?>">
						<input type="hidden" name="<?php echo $s_name ?>"
										value="<?php echo $s_id ?>">
						<table border=0 width=100%>
						<tr>
							<td align="left">
								<input name="add_user" type="text" 
											value="" size=24 maxlength=32>
							</td>
							<td align="right">
								<input type="submit" onclick="return OnAddUser()"
										value="<?php echo get_txt("add"); ?>">
							</td>
						</tr>
						</table>
					</form>
				</td>
			</tr>
			</table>
		</TD>
	</TR>
</TBODY></TABLE>
<HR>

<?php
	//戻り先１と戻り先２へのリンクを表示するHTMLを生成
	//Link HTML to return 1 and return 2 destination is generated.
	echo get_return_url_HTML($conf);

	//ページフッター（プログラム・バージョンとCopyright表示）
	//Page footer(program version and Copyright display)
	echo get_page_footer_HTML($conf);
?>

</BODY>
</HTML>

<?php

} elseif ($mode == "update") {
	//ユーザーグループ設定
	//User groups setting
	$msg = "";
	$sts = TRUE;
	$fp = 0;

	$group_url = get_post_get_val("group_url");

	$groupid = get_post_get_val("groupid");
	$group_user = get_post_get_val("group_user");

	$group_file = get_group_filename($conf);

	$dbg_msg = "grouopid=" . $groupid . ": group_user=" . $group_user;

	if ($groupid == "") {
		//グループ未設定
		//Group unsetting
		$msg .= get_txt("group") . "&nbsp;" . get_txt("is not specified");
		put_log($conf, "Group change failure : no group id");
		$sts = FALSE;
	} elseif (isset($login_user) && $login_user != $conf["ADMIN_USERID"]) {
		//管理者でないログインユーザーがグループの設定を変更した場合
		//When the user who is not the manager changes the setting of the group
		$msg .= get_txt("cannot set group excluding the manager");
		put_log($conf, "Group change " . $userid . " failure : no admin user");
		$sts = FALSE;
	} elseif(! file_exists($group_file)) {
		$msg .= get_txt("no group file");
		put_log($conf, "Group change " . $userid . " failure : no group file");
		$sts = FALSE;
	} elseif (!($fp = fopen ($group_file, "r"))) {
		$msg .= get_txt("cannot open group file");
		put_log($conf, "Group change " . $userid .
									" failure : can not open group file");
		$sts = FALSE;
	} else {
		flock($fp, 2);

		$group_arr = array();

		$idx = 0;
		$found = FALSE;

		while (!feof($fp)) {
			//１行読み込み
			//One line reading
			$buffer = fgets($fp, 4096);
			$buffer = chop($buffer);

			if ($buffer == "") {
				//空行は捨てる
				//The null line is thrown away.
				continue;
			} elseif (strlen($buffer) < 3) {
				//３文字以下の行はそのまま出力
				//The line of three characters or less is output as it is.
				$group_arr[$idx] = $buffer;
				$idx++;
			} elseif (substr($buffer, 0, 1) == "#") {
				//コメント行はそのまま出力
				//The comment line is output as it is.
				$group_arr[$idx] = $buffer;
				$idx++;
			} else {
				//行をＴＡＢで分割
				//The line is divided with TAB.
				$flds = split("\t", $buffer);

				if ($flds[0] != "") {
					//目的のグループかチェックする
					//Whether it is a target group is checked.
					if ($flds[0] == $groupid) {
						$group_arr[$idx] = $flds[0] . "\t" . $group_user;
						$found = TRUE;
					} else {
						if ($flds[1] != "") {
							$group_arr[$idx] = $flds[0] . "\t" . $flds[1];
						} else {
							$group_arr[$idx] = $flds[0] . "\t";
						}
					}
				} else {
					$group_arr[$idx] = $buffer;
				}
				$idx++;
			}
		}
		if (! $found) {
			$group_arr[$idx] = $groupid . "\t" . $group_user;
		}
		flock($fp, 3);
		fclose($fp);

		if (!($fp = fopen ($group_file, "w"))) {
			$msg .= get_txt("cannot open group file");
			put_log($conf, "Group change " . $userid .
									" failure : can not open group file");
			$sts = FALSE;
		} else {
			flock($fp, 2);
			foreach($group_arr as $group_line) {
				fputs($fp, "$group_line\n");
			}

			flock($fp, 3);
			fclose($fp);
			chmod($group_file, get_pwd_file_attr($conf));

			$msg = get_txt("group") . "&nbsp;:&nbsp;";
			$msg .= $groupid . "&nbsp;:&nbsp;" . get_txt("group set complete");
			put_log($conf, "Group change success : " . $groupid);
		}
	}
} elseif ($mode == "add_group") {
	$msg = "";
	$sts = TRUE;
	$fp = 0;

	$group_url = get_post_get_val("group_url");

	$groupid = get_post_get_val("groupid");

	$group_file = get_group_filename($conf);

	$dbg_msg = ": groupid=" . $groupid;

	if ($groupid == "") {
		//グループ未設定
		//Group unsetting
		$msg .= get_txt("group") . "&nbsp;" . get_txt("is not specified");
		put_log($conf, "Group add failure : no group id");
		$sts = FALSE;
	} elseif (!isset($login_user) || $login_user != $conf["ADMIN_USERID"]) {
		//管理者でないログインユーザーがグループの設定を変更した場合
		//When the user who is not the manager changes the setting of the group
		$msg .= get_txt("cannot set group excluding the manager");
		put_log($conf, "Group add " . $groupid . " failure : no admin user");
		$sts = FALSE;
	} else {
		$group_arr = array();

		if (file_exists($group_file)) {
			if (!($fp = fopen ($group_file, "r"))) {
				//グループファイルがオープンできない
				//The group file cannot be opened.
				$msg .= get_txt("cannot open group file");
				put_log($conf, "Group add " . $groupid .
									" failure : can not open group file");
				$sts = FALSE;
			} else {
				flock($fp, 2);

				$idx = 0;
				$found = FALSE;

				while (!feof($fp)) {
					//１行読み込み
					//One line reading
					$buffer = fgets($fp, 4096);
					$buffer = chop($buffer);

					if ($buffer == "") {
						//空行は捨てる
						//The null line is thrown away.
						continue;
					} elseif (strlen($buffer) < 2) {
						//２文字以下の行はそのまま出力
						//The line of two characters or less is
						//output as it is.
						$group_arr[$idx] = $buffer;
						$idx++;
					} elseif (substr($buffer, 0, 1) == "#") {
						//コメント行はそのまま出力
						//The comment line is output as it is.
						$group_arr[$idx] = $buffer;
						$idx++;
					} else {
						//行をＴＡＢで分割
						//The line is divided with TAB.
						$flds = split("\t", $buffer);

						if ($flds[0] != "") {
							if ($flds[0] == $groupid) {
								$found = TRUE;
							}
							if (isset($flds[1]) && $flds[1] != "") {
								$group_arr[$idx] = $flds[0] . "\t" . $flds[1];
							} else {
								$group_arr[$idx] = $flds[0] . "\t";
							}
						} else {
							$group_arr[$idx] = $buffer;
						}
						$idx++;
					}
				}
				if (! $found) {
					$group_arr[$idx] = $groupid . "\t";
				}
				flock($fp, 3);
				fclose($fp);
			}
		} else {
			$group_arr[0] = $groupid . "\t";
		}
		if ($sts) {
			//書き込みオープンする
			//It writes and it opens.
			if (!($fp = fopen ($group_file, "w"))) {
				$msg .= get_txt("cannot open group file") .
								"group_file=" . $group_file;
				put_log($conf, "Group add " . $groupid .
									" failure : can not open group file");
				$sts = FALSE;
			} else {
				flock($fp, 2);

				foreach($group_arr as $group_line) {
					fputs($fp, "$group_line\n");
				}

				flock($fp, 3);
				fclose($fp);
				chmod($group_file, get_pwd_file_attr($conf));

				$msg = get_txt("group") . "&nbsp;:&nbsp;";
				$msg .= $groupid . "&nbsp;:&nbsp;" .
										get_txt("group set complete");
				put_log($conf, "Group add success : " . $groupid);
			}
		}
	}
} elseif ($mode == "del_group") {
	$msg = "";
	$sts = TRUE;
	$fp = 0;

	$group_url = get_post_get_val("group_url");

	$groupid = get_post_get_val("groupid");

	$group_file = get_group_filename($conf);

	$dbg_msg = "grouopid=" . $groupid;

	if ($groupid == "") {
		//グループ未設定
		//Group unsetting
		$msg .= get_txt("group") . "&nbsp;" . get_txt("is not specified");
		put_log($conf, "Group change failure : no group id");
		$sts = FALSE;
	} elseif (!isset($login_user) || $login_user != $conf["ADMIN_USERID"]) {
		//管理者でないログインユーザーがグループの設定を変更した場合
		//When the user who is not the manager changes the setting of the group
		$msg .= get_txt("cannot set group excluding the manager");
		put_log($conf, "Group change " . $groupid .
									" failure : no admin user");
		$sts = FALSE;
	} elseif(! file_exists($group_file)) {
		$msg .= get_txt("no group file");
		put_log($conf, "Group delete " . $groupid .
									" failure : no group file");
		$sts = FALSE;
	} elseif (!($fp = fopen ($group_file, "r"))) {
		//グループファイルがオープンできない
		//The group file cannot be opened.
		$msg .= get_txt("cannot open group file");
		put_log($conf, "Group change " . $groupid .
							" failure : can not open group file");
		$sts = FALSE;
	} else {
		flock($fp, 2);

		$group_arr = array();

		$idx = 0;
		while (!feof($fp)) {
			//１行読み込み
			//One line reading
			$buffer = fgets($fp, 4096);
			$buffer = chop($buffer);

			if ($buffer == "") {
				//空行は捨てる
				//The null line is thrown away.
				continue;
			} elseif (strlen($buffer) < 3) {
				//３文字以下の行はそのまま出力
				//The line of three characters or less is output as it is.
				$group_arr[$idx] = $buffer;
				$idx++;
			} elseif (substr($buffer, 0, 1) == "#") {
				//コメント行はそのまま出力
				//The comment line is output as it is.
				$group_arr[$idx] = $buffer;
				$idx++;
			} else {
				//行をＴＡＢで分割
				//The line is divided with TAB.
				$flds = split("\t", $buffer);

				if ($flds[0] != "") {
					if ($flds[0] != $groupid) {
						if (isset($flds[1]) && $flds[1] != "") {
							$group_arr[$idx] = $flds[0] . "\t" . $flds[1];
						} else {
							$group_arr[$idx] = $flds[0] . "\t";
						}
					}
				} else {
					$group_arr[$idx] = $buffer;
				}
				$idx++;
			}
		}
		flock($fp, 3);
		fclose($fp);

		//書き込みオープンする
		//It writes and it opens.
		if (!($fp = fopen ($group_file, "w"))) {
			$msg .= get_txt("cannot open group file") .
							"group_file=" . $group_file;
			put_log($conf, "Group delete " . $groupid .
								" failure : can not open group file");
			$sts = FALSE;
		} else {
			flock($fp, 2);

			foreach($group_arr as $group_line) {
				fputs($fp, "$group_line\n");
			}

			flock($fp, 3);
			fclose($fp);
			chmod($group_file, get_pwd_file_attr($conf));

			$msg = get_txt("group") . "&nbsp;:&nbsp;";
			$msg .= $groupid . "&nbsp;:&nbsp;" .
									get_txt("group set complete");
			put_log($conf, "Group change success : " . $groupid);
		}
	}
} elseif ($mode == "add_user") {
	$msg = "";
	$sts = TRUE;
	$fp = 0;

	$group_url = get_post_get_val("group_url");

	$userid = get_post_get_val("userid");

	$passwd_file = get_passwd_filename($conf);

	$dbg_msg = ": userid=" . $userid;

	if ($userid == "") {
		//ユーザー未設定
		//User unsetting
		$msg .= get_txt("user id") . "&nbsp;" . get_txt("is not specified");
		put_log($conf, "User add failure : no user id");
		$sts = FALSE;
	} elseif (!isset($login_user) || $login_user != $conf["ADMIN_USERID"]) {
		//管理者でないログインユーザーがユーザーの設定を変更した場合
		//When the user who is not the manager changes the setting of the user
		$msg .= get_txt("cannot set user excluding the manager");
		put_log($conf, "User change " . $userid . " failure : no admin user");
		$sts = FALSE;
	} else {
		$user_arr = array();

		if (file_exists($passwd_file)) {
			if (!($fp = fopen ($passwd_file, "r"))) {
				//パスワードファイルがオープンできない
				//The password file cannot be opened.
				$msg .= get_txt("cannot open password file");
				put_log($conf, "User add " . $userid .
									" failure : can not open group file");
				$sts = FALSE;
			} else {
				flock($fp, 2);

				$idx = 0;
				$found = FALSE;

				while (!feof($fp)) {
					//１行読み込み
					//One line reading
					$buffer = fgets($fp, 4096);
					$buffer = chop($buffer);

					if ($buffer == "") {
						//空行は捨てる
						//The null line is thrown away.
						continue;
					} elseif (strlen($buffer) < 2) {
						//２文字以下の行はそのまま出力する
						//The line of two characters or less is
						//output as it is.
						$user_arr[$idx] = $buffer;
						$idx++;
					} elseif (substr($buffer, 0, 1) == "#") {
						//コメント行はそのまま出力する
						//The comment line is output as it is.
						$user_arr[$idx] = $buffer;
						$idx++;
					} else {
						//行をＴＡＢで分割
						//The line is divided with TAB.
						$flds = split("\t", $buffer);

						if ($flds[0] != "") {
							if ($flds[0] == $userid) {
								$found = TRUE;
							}
							if ($flds[1] != "") {
								$user_arr[$idx] = $flds[0] . "\t" . $flds[1];
							} else {
								$user_arr[$idx] = $flds[0] . "\t";
							}
						} else {
							$user_arr[$idx] = $buffer;
						}
						$idx++;
					}
				}
				if (! $found) {
					$user_arr[$idx] = $userid . "\t";
				}
				flock($fp, 3);
				fclose($fp);
			}
		} else {
			$user_arr[0] = $userid . "\t";
		}
		if ($sts) {
			//書き込みオープンする
			//It writes and it opens.
			if (!($fp = fopen ($passwd_file, "w"))) {
				$msg .= get_txt("cannot open password file") .
								"password_file=" . $passwd_file;
				put_log($conf, "User add " . $userid .
									" failure : can not open password file");
				$sts = FALSE;
			} else {
				flock($fp, 2);

				foreach($user_arr as $user_line) {
					fputs($fp, "$user_line\n");
				}

				flock($fp, 3);
				fclose($fp);
				chmod($passwd_file, get_pwd_file_attr($conf));

				$msg = get_txt("user id") . "&nbsp;:&nbsp;";
				$msg .= $userid . "&nbsp;:&nbsp;" .
										get_txt("user add complete");
				put_log($conf, "User add success : " . $userid);
			}
		}
	}
} elseif ($mode == "del_user") {
	$msg = "";
	$sts = TRUE;
	$fp = 0;

	$group_url = get_post_get_val("group_url");

	$userid = get_post_get_val("userid");

	$passwd_file = get_passwd_filename($conf);
	$group_file = get_group_filename($conf);

	$dbg_msg = "userid=" . $userid;

	if ($userid == "") {
		//ユーザー未設定
		//User unsetting
		$msg .= get_txt("user id") . "&nbsp;" . get_txt("is not specified");
		put_log($conf, "User change failure : no user id");
		$sts = FALSE;
	} elseif (!isset($login_user) || $login_user != $conf["ADMIN_USERID"]) {
		//管理者でないログインユーザーがユーザーの設定を変更した場合
		//When the user who is not the manager changes the setting of the user
		$msg .= get_txt("cannot set user excluding the manager");
		put_log($conf, "User change " . $userid . " failure : no admin user");
		$sts = FALSE;
	} elseif(! file_exists($passwd_file)) {
		$msg .= get_txt("no password file");
		put_log($conf, "User delete " . $userid .
									" failure : no password file");
		$sts = FALSE;
	} elseif (!($fp = fopen ($passwd_file, "r"))) {
		//パスワードファイルがオープンできない
		//The password file cannot be opened.
		$msg .= get_txt("cannot open password file");
		put_log($conf, "User change " . $userid .
							" failure : can not open password file");
		$sts = FALSE;
	} else {
		flock($fp, 2);

		$user_arr = array();

		$idx = 0;
		while (!feof($fp)) {
			//１行読み込み
			//One line reading
			$buffer = fgets($fp, 4096);
			$buffer = chop($buffer);

			if ($buffer == "") {
				//空行は捨てる
				//The null line is thrown away.
				continue;
			} elseif (strlen($buffer) < 3) {
				//３文字以下の行はそのまま出力する
				//The line of three characters or less is
				//output as it is.
				$user_arr[$idx] = $buffer;
				$idx++;
			} elseif (substr($buffer, 0, 1) == "#") {
				//コメント行はそのまま出力する
				//The comment line is output as it is.
				$user_arr[$idx] = $buffer;
				$idx++;
			} else {
				//行をＴＡＢで分割
				//The line is divided with TAB.
				$flds = split("\t", $buffer);

				if ($flds[0] != "") {
					//ユーザーIDが同じでない場合だけ出力する
					//Only when user ID is not the same, it outputs it.
					if ($flds[0] != $userid) {
						if ($flds[1] != "") {
							$user_arr[$idx] = $flds[0] . "\t" . $flds[1];
						} else {
							$user_arr[$idx] = $flds[0] . "\t";
						}
					}
				} else {
					$user_arr[$idx] = $buffer;
				}
				$idx++;
			}
		}
		flock($fp, 3);
		fclose($fp);

		//書き込みオープンする
		//It writes and it opens.
		if (!($fp = fopen ($passwd_file, "w"))) {
			$msg .= get_txt("cannot open password file") .
							"password_file=" . $passwd_file;
			put_log($conf, "User delete " . $userid .
								" failure : can not open password file");
			$sts = FALSE;
		} else {
			flock($fp, 2);

			foreach($user_arr as $user_line) {
				fputs($fp, "$user_line\n");
			}

			flock($fp, 3);
			fclose($fp);
			chmod($group_file, get_pwd_file_attr($conf));

			if(file_exists($group_file)) {
				if (($fp = fopen ($group_file, "r"))) {
					flock($fp, 2);

					$group_arr = array();

					$idx = 0;
					while (!feof($fp)) {
						//１行読み込み
						//One line reading
						$buffer = fgets($fp, 4096);
						$buffer = chop($buffer);

						if ($buffer == "") {
							//空行は捨てる
							//The null line is thrown away.
							continue;
						} elseif (strlen($buffer) < 3) {
							//３文字以下の行はそのまま出力
							//The line of three characters or less is
							//output as it is.
							$group_arr[$idx] = $buffer;
							$idx++;
						} elseif (substr($buffer, 0, 1) == "#") {
							//コメント行はそのまま出力
							//The comment line is output as it is.
							$group_arr[$idx] = $buffer;
							$idx++;
						} else {
							//行をＴＡＢで分割
							//The line is divided with TAB.
							$flds = split("\t", $buffer);

							if ($flds[0] != "" && isset($flds[1]) &&
														$flds[1] != "") {
								//所属ユーザーリストをカンマで分割
								//The belonging user list is divided by
								//the comma.
								$users = split(",", $flds[1]);
								$found = FALSE;
								$user_idx = 0;
								$user_arr = array();
								foreach ($users as $list_user_id) {
									if ($list_user_id != $userid) {
										$user_arr[$user_idx] = $list_user_id;
										$user_idx++;
									} else {
										$found = TRUE;
									}
								}
								if ($found) {
									$group_arr[$idx] = $flds[0] . "\t" .
													join(",", $user_arr);
								} else {
									$group_arr[$idx] = $flds[0] .
													"\t" . $flds[1];
								}
							} else {
								if ($flds[0] != "") {
									$group_arr[$idx] = $flds[0] . "\t";
								} else {
									$group_arr[$idx] = $buffer;
								}
							}
							$idx++;
						}
					}
					flock($fp, 3);
					fclose($fp);

					//書き込みオープンする
					//It writes and it opens.
					if (!($fp = fopen ($group_file, "w"))) {
						$msg .= get_txt("cannot open group file") .
										"group_file=" . $group_file;
						put_log($conf, "User delete " . $userid .
										" failure : can not open group file");
						$sts = FALSE;
					} else {
						flock($fp, 2);

						foreach($group_arr as $group_line) {
							fputs($fp, "$group_line\n");
						}

						flock($fp, 3);
						fclose($fp);
						chmod($group_file, get_pwd_file_attr($conf));

						$msg = get_txt("user id") . "&nbsp;:&nbsp;";
						$msg .= $userid . "&nbsp;:&nbsp;" .
												get_txt("group set complete");
						put_log($conf, "Group file change success:" . $userid);
					}
				}
			}
			$msg = get_txt("user id") . "&nbsp;:&nbsp;";
			$msg .= $userid . "&nbsp;:&nbsp;" .
									get_txt("user del complete");
			put_log($conf, "User delete success : " . $userid);
		}
	}
}

//$sts = FALSE;
if ($mode != "") {
	if ($sts) {
		// ユーザーとグループ設定画面にリダイレクトする
		//It is redirected to the group setting screen as the user.
		echo get_redirect_url_JavaScriptHTML($group_url);
		exit;
	}
?>
<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>
<HR>

<?php
	if (!$sts) {
		echo "groupurl=" . $group_url . "<br>\n";
		echo $msg;
		echo "<HR>";
		//ファイル一覧に戻るのHTML文字列を取得
		//The HTML string to return to the file list is acquired.
		echo get_return_files_HTML($conf);
		echo "<p>";
		echo get_return_refer_url_HTML($group_url, get_txt("back"));
		echo "<p>";
	}

	//ページフッター（プログラム・バージョンとCopyright表示）
	//Page footer(program version and Copyright display)
	echo get_page_footer_HTML($conf);
?>

</BODY>
</HTML>
<?php
}
?>
