<?php
/******************************************************************************
	Files(WEBファイル共有PHPスクリプト)
	Files(WEB file share PHP script)

	共有フォルダ内のフォルダ作成
	Folder making in common folder

  	mkdir.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2014 GUSUKU All rights reserved.

	Update:

	Ver.2.6.2
		著作権者変更
		The copyright owner has been changed.

	Ver.2.3
		配列の範囲外のインデックスへの参照を行わないように修正した
		It was corrected that it did not refer to the index beyond the 
		limits of the array.

	Ver.2.1
		構成ファイル配置設定を追加
		The configuration file arrangement setting is added.

	Ver.2.0
		表示文字列を locale.php から取得するように修正
		The display character string was acquired from locale.php. 

		文字コードの指定も locale.php から取得するように修正
		The specification of the character-code was acquired from locale.php.

		所有者とグループによるアクセス権制御機能を付加
		The access control function by the group is added with the owner. 

		HTML部分に２バイト文字を使用しないように修正した、
		ブラウザの文字コード自動判別に影響しないようにするため
		To make it not misidentified by the character-code automatic operation 
		identification of a browser, it was corrected that Japanese was not 
		used for the HTML part. 

	Ver.1.4 までの更新履歴
	Update history to Ver.1.4
		2005/08/02	ページヘッダー部分を共通化
					A common page header partial function is added. 
******************************************************************************/

require('files_com.php');

$conf = init_files(FALSE);

$submit = get_post_get_val("submit");
$cancel = get_post_get_val("cancel");
$mode = get_post_get_val("mode");
$dirname = get_post_get_val("dirname");
$comment = get_post_get_val("comment");
$owner = get_post_get_val("owner");
$date = get_post_get_val("date");
$time = get_post_get_val("time");

$login_user = get_login_user();
$login_user_groups = get_user_groups($conf, $login_user);

//カレントディレクトリのパスを得る
//The path in the current directory is made.
$curdir = make_path($conf["TOPDIR"], $conf["curdir"], "");

//カレントディレクトリの情報を得る
//Information on the current directory is obtained.
$curdir_inf = get_file_info($conf, $curdir);

//カレントディレクトリのパーミッションを得る
//The permission of the current directory is obtained.
$curdir_permit = get_permission($conf, $curdir_inf,
								$login_user, $login_user_groups);
if ($curdir == $conf["TOPDIR"]) {
	$curdir_permit["r"] = 1;
	$curdir_permit["w"] = 1;
	$curdir_permit["x"] = 1;
}

$scriptname = "mkdir.php";

$s_name = files_session_name();
$s_id = session_id();

if ($mode != "send") {

	//作成フォルダ指定フォーム表示
	//Making folder specification and form displays
	$date = date("Y/m/d");
	$time = date("H:i:s");

?>

<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>

<?php
	//echo $dmg_msg;
	//$login_user_group_arr = join(",", $login_user_groups);
	//echo sprintf("login_user=%s : login_user_group=%s<br>\n",
	//							$login_user, $login_user_group_arr);
?>

<?php
	//ページヘッダーHTMLを取得
	//Page header HTML is acquired.
	echo get_page_header_HTML($conf, "TITLE_COMMENT_MKDIR",
									TRUE, $conf["SHOW_HELP_LINK"]);
?>

<CENTER>
<HR>
<TABLE width=95% border=0>
	<TR>
		<TD>
			<?php
				//ファイル一覧に戻るのHTML文字列を取得
				//The HTML string to return to the file list is acquired.
				echo get_return_files_HTML($conf);
			?>
		</TD>
	</TR>
	<TR>
		<TD>
			<P align=center><B><?php echo $conf["title"] ?></B>&nbsp;&nbsp;
				(<?php echo get_txt("update datetime"); ?>&nbsp;:&nbsp;
				<?php echo $conf["uptime"] ?>)
			</P>
		</TD>
	</TR>
</TABLE>
<?php
	if ($curdir_permit["w"]) {
?>
<form action="<?php echo $conf["MKDIR_SCRIPT"] ?>" method="post">
	<input type="hidden" name="mode" value="send">
	<input type="hidden" name="dir" value="<?php echo $conf["curdir"] ?>">
	<input type="hidden" name="config" value="<?php echo $conf["config"] ?>">
	<input type="hidden" name="<?php echo $s_name ?>" value="<?php echo $s_id ?>">
	<TABLE border=1><TBODY>
		<TR BGCOLOR="<?php echo $conf["LIST_TITLE_BG"] ?>">
			<TD colspan=2>
				<CENTER>
					<B><?php echo get_txt("make new folder"); ?></B>
				</CENTER>
			</TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("folder name"); ?>:</B></TD>
			<TD><input name="dirname" type="text" size=80 maxlength=128></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("comment"); ?>:</B></TD>
			<TD><input name="comment" type="text" size=80 maxlength=128></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("create user"); ?>:</B></TD>
			<TD><input name="owner" type="text" size=20 maxlength=80></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("create date"); ?>:</B></TD>
			<TD><input name="date" type="text" size=20
					maxlength=15 value="<?php echo $date ?>"></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("create time"); ?>:</B></TD>
			<TD><input name="time" type="text" size=20
					maxlength=5 value="<?php echo $time ?>"></TD>
		</TR>
		<TR>
			<TD colspan=2>
				<CENTER>
				<input type="submit" name="submit" value="<?php echo get_txt("create"); ?>">
				<input type="reset" value="<?php echo get_txt("reset"); ?>">
				<input type="submit" name="cancel" value="<?php echo get_txt("cancel"); ?>">
				</CENTER>
			</TD>
		</TR>
	</TBODY></TABLE>
</form>
<?php
	} else {	//if ($curdir_permit["w"])
		echo "<b>";
		echo get_txt("writing has not been permitted");
		echo "</b>";
	}
?>
<HR>
<?php
	//戻り先１と戻り先２へのリンクを表示するHTMLを生成
	//Link HTML to return 1 and return 2 destination is generated.
	echo get_return_url_HTML($conf);

	//ページフッター（プログラム・バージョンとCopyright表示）
	//Page footer(program version and Copyright display)
	echo get_page_footer_HTML($conf);
?>
</BODY>
</HTML>

<?php

} else {
	// send 時の処理
	//Processing at send

	//フォルダ作成処理
	//Folder making processing
	$msg = "";
	$sts = FALSE;

	if (! $curdir_permit["w"]) {
		$msg = get_txt("writing has not been permitted");
	} else if ($submit == "") {
		$sts = TRUE;
	} elseif ($dirname != "") {
		//ロックする
		//It locks.
		$lockfile = make_path($curdir, "", $conf["LOCKFILE"]);
		$lock_fp = lock_files($lockfile);
		if (! $lock_fp) {
			$msg .= get_txt("cannot lock") . "<br>\n";
			put_log($conf, "make dir failure : cannot lock");
		} else {
			// ファイルリスト記録ファイル名
			//File list record file name
			$listfile = make_path($curdir, "", $conf["LISTFILE"]);

			// ファイルリストを読み込む
			//The file list is read.
			if (file_exists($listfile)) {
				$list_files = read_filelist($curdir, $conf["LISTFILE"]);
			}
			//ディレクトリ作成
			//Directory making
			$make_dir_path = make_path($curdir, "", $dirname);
			$sts = make_dir($make_dir_path, get_data_dir_attr($conf));

			if ($sts) {
				if (isset($login_user_groups) && isset($login_user_groups[0])) {
					$login_group = $login_user_groups[0];
				} else {
					$login_group = "";
				}
				$fimg = get_file_image($curdir, $dirname);
				if (!isset($date) || $date == "") {
					$fdate =  date("Y/m/d");
					$ftime =  date("H:i:s");
				} else {
					$fdate = $date;
					$ftime = $time;
				}
				$fsize = sprintf("%u", filesize($make_dir_path));

				$list_files[] = array(
					"name" => $dirname,
					"comment" => $comment,
					"owner" => $owner,
					"size" => $fsize,
					"date" => $fdate,
					"time" => $ftime,
					"user" => $login_user,
					"group" => $login_group,
					"attr" => $conf["DEFAULT_ATTR"],
					"image" => $fimg
				);

				//カレントディレクトリ内のファイル一覧を得る
				//The file list in the current directory is obtained.
				list($files, $update) = get_dirfiles($conf,
													$curdir, $list_files);

				// ファイルリスト書き込み
				//File list writing
				if (!write_file_list($listfile, $files)) {
					$msg .= get_txt("cannot write file list") .
									"&nbsp;:&nbsp;" . $listfile . "<br>\n";
					$sts = FALSE;
					put_log($conf, "make dir failure : " . $make_dir_path .
									 " : can not update file list");
				} else {
					// 作成したフォルダ内のリストにフォルダ情報を書き込む
					//Folder information is written in the list in the 
					//made folder.
					$listfile = make_path($make_dir_path, "", $conf["LISTFILE"]);

					// ファイルリスト書き込み
					//File list writing
					if (($fp = fopen ($listfile, "w"))) {
						flock($fp, 2);

						$str = ".";
						$str .= "\t" . $comment;
						$str .= "\t" . $owner;
						$str .= "\t" . $fdate;
						$str .= "\t" . $ftime;
						$str .= "\t" . $login_user;
						$str .= "\t" . $login_group;
						$str .= "\t" . $conf["DEFAULT_ATTR"];
						fputs($fp, "$str\n");

						flock($fp, 3);
						fclose($fp);
						chmod($listfile, get_data_file_attr($conf));
					} else {
						$msg .= get_txt("cannot write file list") .
										"&nbsp;:&nbsp;" . $listfile . "<br>\n";
						$sts = FALSE;
						put_log($conf, "make dir failure : " . $make_dir_path .
											 " : can not update file list");
					}
				}
				if ($sts) {
					put_log($conf, "make dir success : " . $make_dir_path);

					//フォルダの日付を更新する
					update_dir_time($conf, $curdir, "", "");
				}
			} else {
				$msg .= get_txt("cannot make folder");
				put_log($conf, "make dir failure : " . $make_dir_path);
			}
			//ロックを解除する
			//The lock is released.
			unlock_files($lock_fp, $lockfile);
		}
	} else {
		put_log($conf, "make dir failure : no folder name");
		$msg .= get_txt("folder name is not specified");
	}
	if ($sts) {
		//ファイル一覧にリダイレクトする
		//It redirects it to the file list.
		echo get_redirect_files_JavaScriptHTML($conf);
		exit;
	}
?>

<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>
<HR>

<?php
	if (!$sts) {
		echo $msg;
		echo "<HR>";
		//ファイル一覧に戻るのHTML文字列を取得
		//The HTML string to return to the file list is acquired.
		echo get_return_files_HTML($conf);
	}

	//ページフッター（プログラム・バージョンとCopyright表示）
	//Page footer(program version and Copyright display)
	echo get_page_footer_HTML($conf);
?>

</BODY>
</HTML>

<?php
}
?>
