<?php
/******************************************************************************
	Files(WEBファイル共有PHPスクリプト)
	Files(WEB file share PHP script)

	ファイル／フォルダのペースト処理
	Paste processing of file/folder

  	paste.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2014 GUSUKU All rights reserved.

	Update:

	Ver.2.6.2
		著作権者変更
		The copyright owner has been changed.

	Ver.2.1
		構成ファイル配置設定を追加
		The configuration file arrangement setting is added.

	Ver.2.0
		表示文字列を locale.php から取得するように修正
		The display character string was acquired from locale.php. 

		文字コードの指定も locale.php から取得するように修正
		The specification of the character-code was acquired from locale.php.

		所有者とグループによるアクセス権制御機能を付加
		The access control function by the group is added with the owner. 

		HTML部分に２バイト文字を使用しないように修正した、
		ブラウザの文字コード自動判別に影響しないようにするため
		To make it not misidentified by the character-code automatic operation 
		identification of a browser, it was corrected that Japanese was not 
		used for the HTML part. 

	Ver.1.4 までの更新履歴
	Update history to Ver.1.4
		2005/08/02	ページヘッダー部分を共通化
					A common page header partial function is added. 
******************************************************************************/

require('files_com.php');

$conf = init_files(FALSE);

$fname = get_post_get_val("fname");
$comment = get_post_get_val("comment");
$owner = get_post_get_val("owner");
$date = get_post_get_val("date");
$time = get_post_get_val("time");
$fuser = get_post_get_val("user");
$fgroup = get_post_get_val("group");
$fattr = get_post_get_val("attr");

$scriptname = "paste.php";

$msg = "";
$sts = FALSE;

//貼付け処理
//Paste processing
if ($fname != "") {

	//ログインユーザー
	//Login user
	$login_user = get_login_user();

	//ログインユーザーの所属グループ
	//Login user's belonging group
	$login_user_groups = get_user_groups($conf, $login_user);

	//カレントディレクトリのパスを取得する
	//Passing the current directory is acquired.
	$curdir = make_path($conf["TOPDIR"], $conf["curdir"], "");

	// cut buffer directory
	$cutdir = make_path($conf["TOPDIR"], $conf["CUTDIR"], "");

	$path = make_path($cutdir, "", $fname);
	$dstpath = make_path($curdir, "", $fname);

	//カレントディレクトリの情報を得る
	//Information on the current directory is obtained.
	$curdir_inf = get_file_info($conf, $curdir);

	//カレントディレクトリのパーミッションを得る
	//The permission of the current directory is obtained.
	$curdir_permit = get_permission($conf, $curdir_inf,
									$login_user, $login_user_groups);

	$folder_flg = is_dir($path);
	if ($folder_flg) {
		$type_str = get_txt("folder");
	} else {
		$type_str = get_txt("file");
	}

	$sts = FALSE;
	if (!$curdir_permit["w"]) {
		$msg .= get_txt("writing has not been permitted");
		put_log($conf, "Paste failure : " . get_txt("writing has not been permitted"));
	} elseif (file_exists($dstpath)) {
		$msg .= get_txt("destination name overlaps") .
							"&nbsp(" . $type_str . ")<br>\n";
		put_log($conf, "Paste failure : filename already exist : " . $dstpath);
	} else {
		// ファイル名の変更
		//Change in file name
		$sts = rename($path, $dstpath);
		if (!$sts) {
			$msg .= get_txt("cannot paste") .
								"&nbsp(" . $type_str . ")<br>\n";
			put_log($conf, "Paste failure : " . $msg);
		} else {
			put_log($conf, "Paste File=" . $dstpath . " User=" . $login_user);
		}
	}
	if ($sts) {
		//カレントディレクトリをロックする
		//The current directory is locked.
		$lockfile = make_path($curdir, "", $conf["LOCKFILE"]);
		$lock_fp = lock_files($lockfile);
		if (! $lock_fp) {
			$msg .= get_txt("cannot lock current folder") . "<br>\n";
			$sts = FALSE;
			put_log($conf, "Paste failure : can not lock folder : " . $curdir);
		} else {
			//カットバッファをロックする
			//The cutting buffer is locked.
			$cutlockfile = make_path($cutdir, "", $conf["LOCKFILE"]);
			$cutlock_fp = lock_files($cutlockfile);
			if (! $cutlock_fp) {
				//ロックを解除する
				//The lock is released.
				unlock_files($lock_fp, $lockfile);
				echo get_txt("cannot lock cut buffer") . "<br>\n";
				$sts = FALSE;
				put_log($conf, "Paste failure : can not lock cut buffer");
			}
		}
		if ($sts) {
			//カレントディレクトリのファイルリストを更新する
			//The file list of the current directory is updated.

			// ファイルリストを読み込む
			//The file list is read.
			$listfile = make_path($curdir, "", $conf["LISTFILE"]);
			if (file_exists($listfile)) {
				$list_files = read_filelist($curdir, $conf["LISTFILE"]);
			}
			//カレントディレクトリ内のファイル一覧を得る
			//The file list in the current directory is obtained.
			list($files, $update) = get_dirfiles($conf, $curdir, $list_files);

			for ($i = 0; $i < count($files); $i++) {
				$finf = $files[$i];
				if ($finf["name"] == $fname) {
					$finf["name"] = $fname;
					$finf["comment"] = $comment;
					$finf["owner"] = $owner;
					$finf["date"] = $date;
					$finf["time"] = $time;
					$finf["user"] = $fuser;
					$finf["group"] = $fgroup;
					$finf["attr"] = $fattr;
					$files[$i] = $finf;
					break;
				}
			}
			put_log($conf, "Paste success : " . $dstpath);

			// カレントディレクトリのファイルリスト書き込み
			//File list of current directory writing
			if (!write_file_list($listfile, $files)) {
				$msg .= get_txt("cannot write file list") . 
								"&nbsp;(" . $listfile . ")<br>\n";
			}
			//カレントディレクトリのロックを解除する
			//The lock of the current directory is released.
			unlock_files($lock_fp, $lockfile);

			//カットバッファのファイルリストを更新する
			//The file list of the cutting buffer is updated.

			// カットバッファのファイルリストを読み込む
			//The file list of the cutting buffer is read.
			$listfile = make_path($cutdir, "", $conf["LISTFILE"]);
			if (file_exists($listfile)) {
				$list_files = read_filelist($cutdir, $conf["LISTFILE"]);
			}
			//カットバッファ内のファイル一覧を得る
			//The file list in the cutting buffer is obtained.
			list($files, $update) = get_dirfiles($conf,
											$cutdir, $list_files);

			// カットバッファのファイルリスト書き込み
			//File list of cutting buffer writing
			if (!write_file_list($listfile, $files)) {
				$msg .= get_txt("cannot write cut buffer file list") .
								"&nbsp;(" . $listfile . ")<br>\n";
			}
			//カットバッファのロックを解除する
			//The lock of the cutting buffer is released.
			unlock_files($cutlock_fp, $cutlockfile);

			//フォルダの日付を更新する
			update_dir_time($conf, $curdir, "", "");
		}
	}
} else {
	$msg .= get_txt("file name is not specified") . "<br>\n";
	put_log($conf, "Paste failure : no file name");
}

if ($sts) {
	//ファイル一覧にリダイレクトする
	//It redirects it to the file list.
	echo get_redirect_files_JavaScriptHTML($conf);
	exit;
}

?>

<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>
<HR>
<?php
if (!$sts) {
	echo $msg;
	echo "<HR>";
	//ファイル一覧に戻るのHTML文字列を取得
	//The HTML string to return to the file list is acquired.
	echo get_return_files_HTML($conf);
}

//ページフッター（プログラム・バージョンとCopyright表示）
//Page footer(program version and Copyright display)
echo get_page_footer_HTML($conf);

?>

</BODY>
</HTML>
