<?php
/******************************************************************************
	Files(WEBファイル共有PHPスクリプト)
	Files(WEB file share PHP script)

	使用言語設定処理
	Configuration language setting

  	setlang.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2014 GUSUKU All rights reserved.

	Update:

	Ver.2.6.2
		著作権者変更
		The copyright owner has been changed.

	Ver.2.6
		ファイルを削除する前に存在チェックをするように修正した。
		（ログに警告が出力されないようにするため）
		I revised it there was it before deleting a file, and to check it. 
		（So that warning is not output by log）

		変数の間違いを修正(new_conf -> conf)
		I revised the mistake of the variable(new_conf -> conf)

	Ver.2.5
		新規作成
		New making

******************************************************************************/

require('files_com.php');

$conf = init_files(FALSE);

$scriptname = "setlang.php";

//language file name
$lang_file = "locale.php";

//Configuration file name
$config_file = "files.conf";

//manual directory name
$manual_dir = "manual";

$submit = get_post_get_val("submit");
$mode = get_post_get_val("mode");
$return_url = get_post_get_val("return_url");
$lang = get_post_get_val("lang");

$s_name = files_session_name();
$s_id = session_id();

$topdir = ".";

$conftop = get_conf_top_dir($conf);

$langdir=make_path($topdir, "locale", "");

$conf["returl"] = $return_url . "?config=" . $conf["config"];
$conf["returl"] .= "&" . $s_name . "=" . $s_id;

?>

<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>

<?php

//ページヘッダーHTMLを取得
//Page header HTML is acquired.
echo get_page_header_HTML($conf, "", FALSE, $conf["SHOW_HELP_LINK"]);
?>

<CENTER>
<HR>

<?php

if ($mode != "send") {

	$langlist = array();
	$langnum = 0;

	// Get language directory name from locale directory
	$filelist = get_dir_file_list($langdir);

	foreach($filelist as $fname) {
		if ($fname != "." && $fname != "..") {
			$path = make_path($langdir, $fname, "");
			if (is_dir($path)) {
				//Language directory
				$langlist[$langnum] = $fname;
				$langnum++;
			}
		}
	}
?>

<form action="<?php echo $scriptname; ?>" method="post">
	<input type="hidden" name="mode" value="send">
	<input type="hidden" name="config" value="<?php echo $conf["config"] ?>">
	<input type="hidden" name="return_url" value="<?php echo $return_url ?>">
	<input type="hidden" name="<?php echo $s_name ?>"
								value="<?php echo $s_id ?>">
	<TABLE border=0>
		<TR BGCOLOR="<?php echo $conf["LIST_TITLE_BG"] ?>">
			<TD>
				<CENTER><B>Select Language</B></CENTER>
			</TD>
		</TR>
		<TR>
			<TD align="center">
				<div>
				<select name="lang" size=10>
<?php
	foreach($langlist as $lang) {
		echo "<option value=\"" . $lang . "\">&nbsp;&nbsp;" . $lang . "&nbsp;&nbsp;\n";
	}
?>
				</select>
				</div>
			</TD>
		</TR>
		<TR>
			<TD>
				<CENTER>
				<input type="submit" name="submit" value="Submit">
				<input type="reset" value="Reset">
				</CENTER>
			</TD>
		</TR>
	</TABLE>
</form>

<?php

} else {
	//copy language file processing
	$msg = "";
	$sts = TRUE;
	$lock_fp = FALSE;

	if ($submit == "") {
		$sts = FALSE;
	} else {
		$lang_dir_path = make_path($langdir, $lang, "");

		// copy manual directory
		$src =  make_path($lang_dir_path, $manual_dir, "");
		$dst =  make_path($topdir, $manual_dir, "");

		$mode = get_data_dir_attr($conf);
		$stat = stat($src);
		if ($stat) {
			$mode = $stat['mode'];
		}

		$old_man_dir = "";
		if (file_exists($dst)) {
			$old_man_dir = $dst . ".old";
			delete_dir($old_man_dir);
			$sts = rename($dst, $old_man_dir);
			if (!$sts) {
				delete_dir($old_man_dir);
				$old_man_dir = "";

				$sts = delete_dir($dst);
			}
		}
		if ($sts) {
			$sts = copy_dir($src, $dst, $mode);
		} else {
			$msg .= "Cannot copy manual dir" . "<br>\n";
			put_log($conf, "Copy manual dir " . $src . " to " . $dst . " failure");
		}

		// copy language file
		$src =  make_path($lang_dir_path, "", $lang_file);
		$dst =  make_path($topdir, "", $lang_file);

		$mode = get_data_file_attr($conf);
		$stat = stat($src);
		if ($stat) {
			$mode = $stat['mode'];
		}

		$old_lang_file = "";
		if ($sts && file_exists($dst)) {
			$old_lang_file = $dst . ".old";
			if (file_exists($old_lang_file)) {
				unlink($old_lang_file);
			}
			$sts = rename($dst, $old_lang_file);
			if (!$sts) {
				if (file_exists($old_lang_file)) {
					unlink($old_lang_file);
				}
				$old_lang_file = "";

				$sts = unlink($dst);
			}
		}
		if ($sts) {
			$sts = copy($src, $dst);
			chmod($dst, $mode);
		} else {
			$msg .= "Cannot copy language file" . "<br>\n";
			put_log($conf, "Copy language file " . $src . " to " . $dst . " failure");
		}

		// copy configuration file
		$src =  make_path($lang_dir_path, "", $config_file);
		$dst =  make_path($conftop, "", $config_file);

		$mode = get_data_file_attr($conf);
		$stat = stat($src);
		if ($stat) {
			$mode = $stat['mode'];
		}

		$old_config_file = "";
		if ($sts && file_exists($dst)) {
			$old_config_file = $dst . ".old";
			if (file_exists($old_config_file)) {
				unlink($old_config_file);
			}
			$sts = rename($dst, $old_config_file);
			if (!$sts) {
				if (file_exists($old_config_file)) {
					unlink($old_config_file);
				}
				$old_config_file = "";

				$sts = unlink($dst);
			}
		}
		if ($sts) {
			$sts = copy($src, $dst);
			chmod($dst, $mode);
		} else {
			$msg .= "Cannot copy configuration file" . "<br>\n";
			put_log($conf, "Copy configuration file " . $src . " to " . $dst . " failure");
		}

		if ($sts) {
			//呼び出し元にリダイレクトする
			//It redirects it to the call origin.
			$url = $return_url . "?config=" . conv_url_code($conf["config"]);
			$url .= "&returl=" . $conf["returl"];

			echo get_redirect_url_JavaScriptHTML($url);
			exit;
		}
	}
	if (! $sts) {
		echo $msg;
	}
}
?>

<HR>
<?php

//戻り先１と戻り先２へのリンクを表示するHTMLを生成
//Link HTML to return 1 and return 2 destination is generated.
echo get_return_url_HTML($conf);

//ページフッター（プログラム・バージョンとCopyright表示）
//Page footer(program version and Copyright display)
echo get_page_footer_HTML($conf);

?>

</CENTER>
</BODY>
</HTML>
