<?php
/******************************************************************************
	Files(WEBファイル共有PHPスクリプト)
	Files(WEB file share PHP script)

	共有フォルダ削除処理
	Shared folder deletion processing

  	delconf.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2025 GUSUKU All rights reserved.

	Update:

	Ver.2.7.0
		PHP8 に対応した
		PHP8 support

	Ver.2.6.2
		著作権者変更
		The copyright owner has been changed.

		メッセージ用の文字列リソースが無かったので追加した。
		Add a string resource that was missing for the message

	Ver.2.1
		configファイルとは別のディレクトリにindex.phpを作成するようにした
		I made index.php in another directory with the config file

		構成ファイル配置設定を追加
		The configuration file arrangement setting is added.

	Ver.2.0
		表示文字列を locale.php から取得するように修正
		The display character string was acquired from locale.php. 

		文字コードの指定も locale.php から取得するように修正
		The specification of the character-code was acquired from locale.php.

		所有者とグループによるアクセス権制御機能を付加
		The access control function by the group is added with the owner. 

		HTML部分に２バイト文字を使用しないように修正した、
		ブラウザの文字コード自動判別に影響しないようにするため
		To make it not misidentified by the character-code automatic operation 
		identification of a browser, it was corrected that Japanese was not 
		used for the HTML part. 

	Ver.1.4 までの更新履歴
	Update history to Ver.1.4
		2005/08/02	ページヘッダー部分を共通化
					A common page header partial function is added. 
******************************************************************************/

require('files_com.php');

$conf = init_files(FALSE);

$scriptname = "delconf.php";

$s_name = files_session_name();
$s_id = session_id();

$submit = get_post_get_val("submit");
$mode = get_post_get_val("mode");
$return_url = get_post_get_val("return_url");
$returl = get_post_get_val("returl");
$config_name = get_post_get_val("config_name");
$topdir = get_post_get_val("topdir");
$config_only = get_post_get_val("config_only");

$config_dir = make_path(get_conf_top_dir($conf), "", $config_name);

$entry_page_url = get_entry_page_top_url($conf) . "/" . $config_name . "/";
$entry_page_dir = get_entry_page_top_dir($conf) . "/" . $config_name;

$conf["returl"] = $return_url . "?config=" . $conf["config"];
$conf["returl"] .= "&" . $s_name . "=" . $s_id;

?>

<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>

<?php
//ページヘッダーHTMLを取得
//Page header HTML is acquired.
echo get_page_header_HTML($conf, "", FALSE, $conf["SHOW_HELP_LINK"]);
?>

<CENTER>
<HR>

<?php

if ($mode != "send") {
	//共有フォルダ削除フォーム表示
	//Shared folder deletion form display
	if (! isset($config_name)) {
		$config_name = "";
	}
?>

<form action="<?php echo $conf["DELCONF_SCRIPT"] ?>" method="post">
	<input type="hidden" name="mode" value="send">
	<input type="hidden" name="config" value="<?php echo $conf["config"] ?>">
	<input type="hidden" name="config_name" value="<?php echo $config_name; ?>">
	<input type="hidden" name="topdir" value="<?php echo $topdir; ?>">
	<input type="hidden" name="return_url" value="<?php echo $return_url ?>">
	<input type="hidden" name="<?php echo $s_name ?>" value="<?php echo $s_id ?>">
	<TABLE border=1><TBODY>
		<TR BGCOLOR="<?php echo $conf["LIST_TITLE_BG"] ?>">
			<TD colspan=2>
				<CENTER>
					<B><?php echo get_txt("delete shared folder"); ?></B>
				</CENTER>
			</TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("name"); ?></B></TD>
			<TD><?php echo $config_name; ?></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("connect url"); ?></B></TD>
			<TD><?php echo $entry_page_url; ?></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("top folder full path"); ?></B></TD>
			<TD><?php echo $topdir; ?></TD>
		</TR>
		<TR>
			<TD colspan=2>
				<input type="checkbox" name="config_only" value="1">
				<B><?php echo get_txt("delete config only"); ?></B>
			</TD>
		</TR>
		<TR>
			<TD colspan=2>
				<CENTER>
				<input type="submit" name="submit"
									value="<?php echo get_txt("delete"); ?>">
				<input type="reset" value="<?php echo get_txt("reset"); ?>">
				</CENTER>
			</TD>
		</TR>
	</TBODY></TABLE>
</form>

<?php

} else {
	//フォルダ削除処理
	//Folder deletion processing
	$msg = "";
	$sts = TRUE;
	$lock_fp = FALSE;

	if ($submit == "") {
		$sts = FALSE;
	} else {
		if ($config_only == "") {
			echo "config_only is empty<br>\n";
			// 先頭ディレクトリの有無を確認
			//The presence of the first directory is confirmed.
			if ($topdir != "") {
				if (file_exists($topdir)) {
					$sts = delete_dir($topdir);
					if (!$sts) {
						put_log($conf, "Delete config failure " . $config_name .
												" can not delete data folder");
					}
				}
			}
		} else {
			echo "config_only is not empty<br>\n";
		}
		if ($sts) {
			// 設定ディレクトリの有無を確認
			//The presence of a config directory is confirmed.
			if ($config_dir == "" || !file_exists($config_dir)) {
				$msg .= get_txt("config folder is not specified") . "<br>\n";
				$sts = FALSE;
				put_log($conf, "Delete config failure " . $config_name .
														" no config dir");
			} else {
				$sts = delete_dir($config_dir);
				if (!$sts) {
					put_log($conf, "Delete config failure " . $config_name .
											" can not delete config folder");
				}
			}
			if ($sts) {
				put_log($conf, "Delete config " . $config_name . " success");
			}
		}
		if ($sts) {
			// 設定ディレクトリの有無を確認
			//The presence of a entry page directory is confirmed.
			if ($entry_page_dir == "" || !file_exists($entry_page_dir)) {
				$msg .= get_txt("can not find folder for entry page") . "<br>\n";
				$sts = FALSE;
				put_log($conf, "Delete entry page failure " . $entry_page_dir .
														" no entry page dir");
			} else {
				$sts = delete_dir($entry_page_dir);
				if (!$sts) {
					put_log($conf, "Delete config failure " . $entry_page_dir .
										" can not delete entry page folder");
				}
			}
			if ($sts) {
				put_log($conf, "Delete entry page " .
									$entry_page_dir . " success");
			}
		}
	}
	if ($sts) {
		//設定メニューにリダイレクトする
		//It redirects it to a set menu.
		$url = $return_url . "?config=" . conv_url_code($conf["config"]);

		//呼び出し元にリダイレクトする
		//It redirects it to the call origin.
		$url .= "&return_url=" . conv_url_code($conf["returl"]);

		echo get_redirect_url_JavaScriptHTML($url);
		exit;
	} else {
		echo $msg;
	}
}
?>

<HR>
<?php 

//戻り先１と戻り先２へのリンクを表示するHTMLを生成
//Link HTML to return 1 and return 2 destination is generated.
echo get_return_url_HTML($conf);

//ページフッター（プログラム・バージョンとCopyright表示）
//Page footer(program version and Copyright display)
echo get_page_footer_HTML($conf);

?>
</BODY>
</HTML>
