<?php
/******************************************************************************
	Files(WEBファイル共有PHPスクリプト)
	Files(WEB file share PHP script)

	ファイル／フォルダの削除処理
	Deletion processing of file/folder

	delete.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2025 GUSUKU All rights reserved.

	Update:

	Ver.2.7.0
		PHP8 に対応した
		PHP8 support

	Ver.2.6.2
		著作権者変更
		The copyright owner has been changed.

	Ver.2.1
		構成ファイル配置設定を追加
		The configuration file arrangement setting is added.

	Ver.2,0	
		表示文字列を locale.php から取得するように修正
		The display character string was acquired from locale.php. 

		文字コードの指定も locale.php から取得するように修正
		The specification of the character-code was acquired from locale.php.

		所有者とグループによるアクセス権制御機能を付加
		The access control function by the group is added with the owner. 

		HTML部分に２バイト文字を使用しないように修正した、
		ブラウザの文字コード自動判別に影響しないようにするため
		To make it not misidentified by the character-code automatic operation 
		identification of a browser, it was corrected that Japanese was not 
		used for the HTML part. 

	Ver.1.4 までの更新履歴
	Update history to Ver.1.4
		2005/08/02	ページヘッダー部分を共通化
					A common page header partial function is added. 
******************************************************************************/

require('files_com.php');

$conf = init_files(FALSE);

$mode = get_post_get_val("mode");

$CUTMODE = get_post_get_val("CUTMODE");

$submit = get_post_get_val("submit");
$cancel = get_post_get_val("cancel");

$fname = get_post_get_val("fname");
$comment = get_post_get_val("comment");
$owner = get_post_get_val("owner");
$date = get_post_get_val("date");
$time = get_post_get_val("time");
$user = get_post_get_val("user");
$group = get_post_get_val("group");
$attr = get_post_get_val("attr");

$scriptname = "delete.php";

$s_name = files_session_name();
$s_id = session_id();

//ログインユーザー
//Login user
$login_user = get_login_user();

//ログインユーザーの所属グループ
//Login user's belonging group
$login_user_groups = get_user_groups($conf, $login_user);

//カレントディレクトリのパスを得る
//The path in the current directory is made.
$curdir = make_path($conf["TOPDIR"], $conf["curdir"], "");

$cutdir = make_path($conf["TOPDIR"], $conf["CUTDIR"], "");

if ($CUTMODE == "1") {
	$curdir = $cutdir;
}

$type_str = get_txt("file");
$folder_flg = FALSE;
if ($fname != "") {
	$file_path = make_path($curdir, "", $fname);
	$folder_flg = is_dir($file_path);
	if ($folder_flg) {
		$type_str = get_txt("folder");
	}
}

//カレントディレクトリの情報を得る
//Information on the current directory is obtained.
$curdir_inf = get_file_info($conf, $curdir);

//カレントディレクトリのパーミッションを得る
//The permission of the current directory is obtained.
$curdir_permit = get_permission($conf, $curdir_inf,
								$login_user, $login_user_groups);

$path = make_path($curdir, "", $fname);

//指定ファイルの情報を得る
//Information on the targeted file is obtained.
$finf = get_file_info($conf, $path);

$permit = get_permission($conf, $finf,
							$login_user, $login_user_groups);

if ($mode != "send") {
	//削除確認フォーム表示
	//Deletion confirmation form display

?>

<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>

<?php
	//ページヘッダーHTMLを取得
	//Page header HTML is acquired.
	echo get_page_header_HTML($conf, "TITLE_COMMENT_DELETE",
									TRUE, $conf["SHOW_HELP_LINK"]);
?>

<CENTER>
<HR>
<TABLE width=95% border=0><TBODY>
	<TR>
		<TD>
			<?php
				//一覧に戻るのHTML文字列を取得
				//The HTML string to return to the file list is acquired.
				echo get_return_files_HTML($conf); 
			?>
		</TD>
	</TR>
	<TR>
		<TD>
			<P align=center><B><?php echo $conf["title"]; ?></B>&nbsp;&nbsp;
				(<?php echo get_txt("update datetime") . " : " . $conf["uptime"]; ?>)
			</P>
		</TD>
	</TR>
</TBODY></TABLE>
<?php
	if ((($curdir_permit["w"] && $permit["w"]) &&
					!($folder_flg && !$permit["x"])) || $CUTMODE) {
?>
<form action="<?php echo $conf["DELETE_SCRIPT"] ?>" method="post">
	<input type="hidden" name="mode" value="send">
	<input type="hidden" name="config" value="<?php echo $conf["config"] ?>">
	<input type="hidden" name="dir" value="<?php echo $conf["curdir"] ?>">
	<input type="hidden" name="CUTMODE" value="<?php echo $CUTMODE ?>">
	<input type="hidden" name="fname" value="<?php echo $fname ?>">
	<input type="hidden" name="comment" value="<?php echo $comment ?>">
	<input type="hidden" name="owner" value="<?php echo $owner ?>">
	<input type="hidden" name="date" value="<?php echo $date ?>">
	<input type="hidden" name="time" value="<?php echo $time ?>">
	<input type="hidden" name="user" value="<?php echo $user ?>">
	<input type="hidden" name="group" value="<?php echo $group ?>">
	<input type="hidden" name="attr" value="<?php echo $attr ?>">
	<input type="hidden" name="<?php echo $s_name ?>" value="<?php echo $s_id ?>">
	<TABLE border=1><TBODY>
		<TR BGCOLOR="<?php echo $conf["LIST_TITLE_BG"] ?>">
			<TD colspan=2>
				<CENTER>
					<B><?php echo $type_str . ":" . get_txt("is delete ok"); ?></B>
				</CENTER>
			</TD>
		</TR>
		<TR>
			<TD><B><?php echo $type_str . get_txt("name"); ?>:</B></TD>
			<TD><?php echo $fname ?></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("comment"); ?>:</B></TD>
			<TD><?php echo noblank_str($comment) ?></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("create user name"); ?>:</B></TD>
			<TD><?php echo noblank_str($owner) ?></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("create date"); ?>:</B></TD>
			<TD><?php echo $date ?></TD>
		</TR>
		<TR>
			<TD><B><?php echo get_txt("create time"); ?>:</B></TD>
			<TD><?php echo $time ?></TD>
		</TR>
		<TR>
			<TD colspan=2>
				<CENTER>
				<input type="submit" value="<?php echo get_txt("delete"); ?>">
				</CENTER>
			</TD>
		</TR>
	</TBODY></TABLE>
</form>
<?php
	} else {	//($curdir_permit["w"] && $permit["w"])
		echo "<b>";
		echo get_txt("writing has not been permitted");
		echo "</b>";
	}
?>
<HR>
<?php
	//戻り先１と戻り先２へのリンクを表示するHTMLを生成
	//Link HTML to return 1 and return 2 destination is generated.
	echo get_return_url_HTML($conf);
?>

<?php

} else {
	//削除処理
	//Deletion processing

	// とりあえずエラーのメッセージを用意する
	//The message of the error is prepared for the time being.
	$msg = "";
	$sts = FALSE;

	if ((($curdir_permit["w"] != 1) || ($permit["w"] != 1) ||
					($folder_flg && $permit["x"] != 1)) && !$CUTMODE) {
		//echo "writing has not been permitted\n";
		$msg = get_txt("writing has not been permitted");
	} elseif ($fname != "") {
		$path = make_path($curdir, "", $fname);
		if ($folder_flg) {
			$res = check_delete_permit($conf, $path, $login_user, $login_user_groups);
			if (!$CUTMODE && ! $res) {
				$msg = get_txt("writing has not been permitted");
			} else {
				if ($CUTMODE) {
					$sts = delete_dir($path);
				} else {
					$sts = delete_dir_with_permit($conf, $path,
								$login_user, $login_user_groups);
				}
				if (!$sts) {
					$msg = "delete_dir_with_permit():" .
								get_txt("cannot delete") . "<br>\n";
				} else {
					put_log($conf, "Delete Folder=" . $path .
											" User=" . $login_user);
				}
			}
		} else {
			$sts = unlink($path);
			if ($sts) {
				put_log($conf, "Delete File=" . $path .
										" User=" . $login_user);
			}
		}
		if ($sts) {
			//ロックする
			//It locks.
			$lockfile = make_path($curdir, "", $conf["LOCKFILE"]);
			$lock_fp = lock_files($lockfile);
			if (! $lock_fp) {
				$msg .= get_txt("annot lock") . "<br>\n";
				$sts = FALSE;
				put_log($conf, "Delete failure : can not lock");
			} else {
				// ファイルリスト記録ファイル名
				//File list record file name
				$listfile = make_path($curdir, "", $conf["LISTFILE"]);

				// ファイルリストを読み込む
				//The file list is read.
				if (file_exists($listfile)) {
					$list_files = read_filelist($curdir, $conf["LISTFILE"]);
				}

				//カレントディレクトリ内のファイル一覧を得る
				//The file list in the current directory is obtained.
				list($files, $update) = get_dirfiles($conf,
													$curdir, $list_files);

				// ファイルリスト書き込み
				//File list writing
				if (!write_file_list($listfile, $files)) {
					$msg .= get_txt("cannot write file list") .
											":" . $listfile . "<br>\n";
					$sts = FALSE;
					put_log($conf, "Delete failure : " . $path .
											" : can not update file list");
				}
				//ロックを解除する
				//The lock is released.
				unlock_files($lock_fp, $lockfile);

				if ($sts) {
					put_log($conf, "Delete success : " . $path);

					//フォルダの日付を更新する
					update_dir_time($conf, $curdir, "", "");
				}
			}
		} else {
			$msg .= $type_str . "(" . $fname . "):" .
								get_txt("cannot delete") . "<br>\n";
			put_log($conf, "Delete failure : can not delete " . $path);
		}
	} else {
		put_log($conf, "Delete failure : no file name");
		$msg .= get_txt("file name is not specified") . "<br>\n";
	}

	if ($sts) {
		//ファイル一覧にリダイレクトする
		//It redirects it to the file list.
		echo get_redirect_files_JavaScriptHTML($conf);
		exit;
	}
?>

<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"] ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>
<HR>

<?php
	if (!$sts) {
		echo $msg;
		echo "<HR>";
		//ファイル一覧に戻るのHTML文字列を取得
		//The HTML string to return to the file list is acquired.
		echo get_return_files_HTML($conf);
	}
}
?>
<?php
//ページフッター（プログラム・バージョンとCopyright表示）
//Page footer(program version and Copyright display)
echo get_page_footer_HTML($conf);
?>

</BODY>
</HTML>

