<?php
/******************************************************************************
	Files(WEBファイル共有PHPスクリプト)
	Files(WEB file share PHP script)

	共有フォルダ内のファイル／フォルダの一覧画面
	List screen of file/folder in common folder

  	files.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2025 GUSUKU All rights reserved.

	Update history:

	Ver.2.7.0
		PHP8 に対応した
		PHP8 support

		split() 関数が廃止されるので代わりに explode() を使うようにした
		The split() function is discontinued, so explode() is used instead

	Ver.2.6.2
		著作権者変更
		The copyright owner has been changed.

	Ver.2.5
		ファイルのダウンロード方法にダウンロードスクリプトの使用以外に
		ファイルへの直接リンクを使えるようにした
		I was able to use the direct link to the file besides the use of the 
		download script in the download method of the file.

	Ver.2.4
		ダウンロード・ファイルのリンク方法を変更した。
		The method of linking the download files was changed. 

		日本語名のファイルをダウンロードする際に、ブラウザの種類を考慮して
		ファイル名を変換するようにした。
		When the file of a Japanese name was downloaded, the file name was 
		converted in consideration of the kind of a browser.

		カットバッファのファイルへのリンク先が間違っていたので修正した
		Because link ahead to the file of the cut buffer was wrong, I revised it

	Ver.2.1
		構成ファイル配置設定を追加
		The configuration file arrangement setting is added.

	Ver.2.0
		表示文字列を locale.php から取得するように修正
		The display character string was acquired from locale.php. 

		文字コードの指定も locale.php から取得するように修正
		The specification of the character-code was acquired from locale.php.

		所有者とグループによるアクセス権制御機能を付加
		The access control function by the group is added with the owner. 

		HTML部分に２バイト文字を使用しないように修正した、
		ブラウザの文字コード自動判別に影響しないようにするため
		To make it not misidentified by the character-code automatic operation 
		identification of a browser, it was corrected that Japanese was not 
		used for the HTML part. 

		ダウンロードにファイルへのリンクを使用するのではなく、ダウンロード用の
		スクリプトを使用するように変更した。
		Not to use the link to the file for download but to use the script for 
		download, it changed.

	Ver.1.4 までの更新履歴
	Update history to Ver.1.4
		2005/08/02	ページヘッダー部分を共通化
					A common page header partial function is added. 

******************************************************************************/

require('files_com.php');

function make_download_link($conf, $dir, $fname, $img_src)
{
	$urlstr = "<FORM ACTION=\"download.php\" METHOD=\"POST\" style=\" margin: 0px; padding: 0px; \">\n";
	$urlstr .= "<input type=\"hidden\" name=\"config\" value=\"" .
											$conf["config"] . "\">\n";
	$urlstr .= "<input type=\"hidden\" name=\"dir\" value=\"" .
											$dir . "\">\n";
	$urlstr .= "<input type=\"hidden\" name=\"filename\" value=\"" . 
											$fname . "\">\n";
	if (isset($img_src) && $img_src != "") {
		$urlstr .= "<input type=\"image\" name=\"download\" src=\"" . $img_src . "\"";
		$urlstr .= " width=" . $conf["ICON_W"];
		$urlstr .= " height=" . $conf["ICON_H"];
		$urlstr .= " ALT=\"Download\">\n";
	} else {
		$urlstr .= "<input type=\"submit\" value=\"" . $fname . "\"";
		$urlstr .= " style=\"cursor: pointer; font-size: 100%; border-style: none; width: 100%; text-align: left; background-color: transparent; text-decoration: underline; color: blue; margin: 0px; padding: 0px; \">";
	}
	$urlstr .= "</FORM>";

	return $urlstr;
}

function make_direct_file_link($conf, $dir, $fname, $img_src)
{
	$file_fullurl = make_path($conf["TOPURL"], $dir, $fname);

	$file_urlstr = conv_url_code($file_fullurl);

	$urlstr = "<a href=\"" . $file_urlstr . "\">";

	if (isset($img_src) && $img_src != "") {
		$urlstr .= "<img src=\"" . $img_src . "\" border=0";
		$urlstr .= " width=" . $conf["ICON_W"];
		$urlstr .= " height=" . $conf["ICON_H"];
		$urlstr .= ">";
	} else {
		$urlstr .= $fname;
	}
	$urlstr .= "</a>\n";

	return $urlstr;
}

$conf = init_files(FALSE);
$mode = get_post_get_val("mode");
$fname = get_post_get_val("fname");
$sort_key = get_post_get_val("SORT_KEY");
$reverse_sort = get_post_get_val("REVERSE_SORT");
$returl = get_post_get_val("returl");
if ($conf["returl"] == "") {
	$conf["returl"] = $returl;
}

$s_name = files_session_name();
$s_id = session_id();

$login_user = get_login_user();
$login_user_groups = get_user_groups($conf, $login_user);

$scriptname = "files.php";
$scripturl = $scriptname;


$check_name = "";
$check_comment = "";
$check_owner = "";
$check_size = "";
$check_time = "";

if (isset($sort_key) && $sort_key != "") {
	switch ($sort_key) {
	case "name":
		$conf["SORT_KEY"] = "name";
		$check_name = "CHECKED";
		break;
	case "comment":
		$conf["SORT_KEY"] = "comment";
		$check_comment = "CHECKED";
		break;
	case "owner":
		$conf["SORT_KEY"] = "owner";
		$check_owner = "CHECKED";
		break;
	case "size":
		$conf["SORT_KEY"] = "size";
		$check_size = "CHECKED";
		break;
	case "time":
		$conf["SORT_KEY"] = "time";
		$check_time = "CHECKED";
		break;
	}
} else {
	$check_time = "CHECKED";
}

$check_descend = "";
$check_ascend = "";

if (isset($reverse_sort) && $reverse_sort != "") {
	if ($reverse_sort == "1") {
		$conf["REVERSE_SORT"] = 1;
		$check_descend = "CHECKED";
	} else {
		$conf["REVERSE_SORT"] = 0;
		$check_ascend = "CHECKED";
	}
} else {
	$check_descend = "CHECKED";
}

//カレントディレクトリのパスを得る
//The path in the current directory is made.
$curdir = make_path($conf["TOPDIR"], $conf["curdir"], "");

//カットバッファのパスを得る
$cutdir = make_path($conf["TOPDIR"], $conf["CUTDIR"], "");

?>
<HTML>
<HEAD>
<?php echo get_charset_line(); ?>
<TITLE><?php echo $conf["HEADER_TITLE"]; ?></TITLE>
</HEAD>
<BODY <?php echo get_body_bg_str($conf); ?>>

<?php

//カレントディレクトリの情報を得る
//Information on the current directory is obtained.
$curdir_inf = get_file_info($conf, $curdir);

//カレントディレクトリのパーミッションを得る
//The permission of the current directory is obtained.
$curdir_permit = get_permission($conf, $curdir_inf,
								$login_user, $login_user_groups);
if ($curdir == $conf["TOPDIR"]) {
	$curdir_permit["r"] = 1;
	$curdir_permit["w"] = 1;
	$curdir_permit["x"] = 1;
}

//echo "dbg_msg=";
//echo $dbg_msg . "<br>\n";
?>

<?php
//ページヘッダーHTMLを取得
//Page header HTML is acquired.
echo get_page_header_HTML($conf, "TITLE_COMMENT_FILES",
								TRUE, $conf["SHOW_HELP_LINK"]);
?>

<CENTER>
<HR>
<?php

if (!file_exists($curdir)) {
	if (!make_dir($curdir, get_data_dir_attr($conf))) {
		echo "<B>[&nbsp;&nbsp;" . $conf["title"] . "&nbsp;&nbsp;]<BR><BR>\n";
		echo get_txt("cannot make folder") . "<BR>\n";
		echo get_txt("please confirm permission") . "<BR><BR>\n";
		$rerturnurl = $conf["FILES_SCRIPT"];
		$rerturnurl .= "?" . $s_name . "=" . $s_id;
		echo "<A HREF=\"" . $rerturnurl . "\"><B>" .
						get_txt("return to top") . "</B></A>";
		echo "</BODY></HTML>\n";
		exit;
	}
}

//ロックする
//It locks.
$lockfile = make_path($curdir, "", $conf["LOCKFILE"]);
$lock_fp = lock_files($lockfile);
if (! $lock_fp) {
	echo "<B>[&nbsp;&nbsp;" . $conf["title"] . "&nbsp;&nbsp;]<BR><BR>\n";
	echo get_txt("could not access") . "<BR>\n";
	echo get_txt("please confirm permission") . "<BR><BR>\n";
	$rerturnurl = $conf["FILES_SCRIPT"];
	$rerturnurl .= "?" . $s_name . "=" . $s_id;
	echo "<A HREF=\"" . $rerturnurl . "\"><B>" .
					get_txt("return to top") . "</B></A>";
	echo "</BODY></HTML>\n";
	exit;
}
$cutfiles = array();
$files = array();

//カットバッファのチェック
//Check on cutting buffer
if (!file_exists($cutdir)) {
	if (!make_dir($cutdir, get_data_dir_attr($conf))) {
		echo "<B>[&nbsp;&nbsp;" . $conf["title"] . "&nbsp;&nbsp;]<BR><BR>\n";
		echo get_txt("cannot make cut buffer folder") . "<BR>\n";
		echo get_txt("please confirm permission") . "<BR><BR>\n";
		$rerturnurl = $conf["FILES_SCRIPT"];
		$rerturnurl .= "?" . $s_name . "=" . $s_id;
		echo "<A HREF=\"" . $rerturnurl . "\"><B>" .
						get_txt("return to top") . "</B></A>";
		echo "</BODY></HTML>\n";
		exit;
	}
}
$listfile = make_path($cutdir, "", $conf["LISTFILE"]);
$list_files = array();

// カットバッファのファイルリストを読み込む
//The file list of the cutting buffer is read.
if (file_exists($listfile)) {
	$list_files = read_filelist($cutdir, $conf["LISTFILE"]);
}

//カットバッファ内のファイル一覧を得る
//The file list in the cutting buffer is obtained.
list($cutfiles, $update) = get_dirfiles($conf, $cutdir, $list_files);

sort_filelist($cutfiles, $conf["SORT_KEY"], $conf["REVERSE_SORT"]);

// 更新されていたらファイルリスト書き込み
//It writes it in the file list if updated.
if ($update) {
	if (! write_file_list($listfile, $cutfiles)) {
		echo "list file ($listfile) write open error\n";
	}
}

// カレントディレクトリのファイルリストを得る
//The file list of the current directory is obtained.

// ファイルリスト記録ファイル名
//File list record file name
$listfile = make_path($curdir, "", $conf["LISTFILE"]);
$list_files = array();

// ファイルリストを読み込む
//The file list is read.
if (file_exists($listfile)) {
	$conf["uptime"] = date("Y/m/d H:i:s", filemtime($listfile));
	$list_files = read_filelist($curdir, $conf["LISTFILE"]);
}

//カレントディレクトリ内のファイル一覧を得る
//The file list in the current directory is obtained.
list($files, $update) = get_dirfiles($conf, $curdir, $list_files);

sort_filelist($files, $conf["SORT_KEY"], $conf["REVERSE_SORT"]);

list($curr_name, $curr_comment, $curr_owner) = get_current_info($files);

/***
if ($curr_comment != "") {
	$curr_name = get_filename($curdir);
	$conf["title"] = $curr_name . "&nbsp;&nbsp;:&nbsp;&nbsp;" . $curr_comment;
}
***/
if ($curdir == $conf["TOPDIR"]) {
	$date_time = explode(" ", $conf["uptime"]);
	$curdir_inf["name"] = $conf["title"];
	$curdir_inf["comment"] = $conf["name"];
	$curdir_inf["owner"] = $curr_owner;
	$curdir_inf["date"] = $date_time[0];
	$curdir_inf["time"] = $date_time[1];
	$curdir_inf["user"] = "";
	$curdir_inf["group"] = "";
	$curdir_inf["attr"] = 0777;
}
/***/

// 更新されていたらファイルリストに書き込み
//It writes it in the file list if updated.
if ($update) {
	$conf["uptime"] = date("Y/m/d H:i:s");

	if (! write_file_list($listfile, $files)) {
		echo "list file ($listfile) write open error\n";
	}
}
//ロックを解除する
//The lock is released.
unlock_files($lock_fp, $lockfile);

?>

<TABLE width=95% border=0><TBODY>
	<TR>
		<TD>
<?php

if ($curdir_permit["w"]) {
	$mkdirurl = $conf["MKDIR_SCRIPT"];
	$mkdirurl .= "?dir=" . conv_url_code($conf["curdir"]);
	$mkdirurl .= "&config=" . conv_url_code($conf["config"]);
	$mkdirurl .= "&" . $s_name . "=" . $s_id;

	echo "<A HREF=\"" . $mkdirurl . "\">";
}

echo "<B>" . get_txt("make folder") . "</B>";

if ($curdir_permit["w"]) {
	echo "</A>";
}
echo "&nbsp;&nbsp;&nbsp;&nbsp;";

if ($curdir_permit["w"]) {
	$uploadurl = $conf["UPLOAD_SCRIPT"];
	$uploadurl .= "?dir=" . conv_url_code($conf["curdir"]);
	$uploadurl .= "&config=" . conv_url_code($conf["config"]);
	$uploadurl .= "&mode=select";
	$uploadurl .= "&" . $s_name . "=" . $s_id;

	echo "<A HREF=\"" . $uploadurl . "\">";
}

echo "<B>" . get_txt("upload") . "</B>";
echo "&nbsp;(" . get_txt("file size limit") . "&nbsp;:&nbsp;";
echo get_filesize_str($conf["MAX_UPLOAD_SIZE"]) . ")";

if ($curdir_permit["w"]) {
	echo "</A>";
}
echo "\n";

?>
		</TD>
		<TD>
<?php
if (isset($conf["PASSWD_FILE"]) && $conf["PASSWD_FILE"] != "") {
	if (isset($login_user) && $login_user != "") {
		$pwdurl = $conf["PASSWD_SCRIPT"];
		$pwdurl .= "?config=" . conv_url_code($conf["config"]);
		$pwdurl .= "&dir=" . $conf["curdir"];
		$pwdurl .= "&return_url=" . $conf["FILES_SCRIPT"];
		$pwdurl .= "&" . $s_name . "=" . $s_id;
		echo "<A HREF=\"" . $pwdurl . "\"><B>" .
				get_txt("password setting") . "</B></A>&nbsp;&nbsp;";
	}
	if (isset($login_user) && $login_user != "" &&
							$login_user == $conf["ADMIN_USERID"]) {
		$grpurl = $conf["GROUP_SCRIPT"];
		$grpurl .= "?config=" . conv_url_code($conf["config"]);
		$grpurl .= "&dir=" . $conf["curdir"];
		$grpurl .= "&return_url=" . $conf["FILES_SCRIPT"];
		$grpurl .= "&" . $s_name . "=" . $s_id;
		echo "&nbsp;&nbsp<A HREF=\"" . $grpurl . "\"><B>" .
				get_txt("user and group setting") . "</B></A>&nbsp;&nbsp;";
	}
}
?>
		</TD>
	</TR>
</TBODY></TABLE>
<form action="<?php echo $scripturl; ?>" method="POST">
<input type="hidden" name="dir" value="<?php echo $conf["curdir"]; ?>">
<input type="hidden" name="config" value="<?php echo $conf["config"]; ?>">
<input type="hidden" name="<?php echo $s_name ?>" value="<?php echo $s_id ?>">
<TABLE width=95% border=1><TBODY>
	<TR>
		<TD><B><?php echo get_txt("display order"); ?>:</B></TD>
		<TD>
			<input type="radio" name="SORT_KEY" value="name"
										<?php echo $check_name ?>>
										<?php echo get_txt("filename"); ?>
			<input type="radio" name="SORT_KEY" value="comment"
										<?php echo $check_comment ?>>
										<?php echo get_txt("comment"); ?>
			<input type="radio" name="SORT_KEY" value="owner"
										<?php echo $check_owner ?>>
										<?php echo get_txt("create user"); ?>
			<input type="radio" name="SORT_KEY" value="size"
										<?php echo $check_size ?>>
										<?php echo get_txt("size"); ?>
			<input type="radio" name="SORT_KEY" value="time"
										<?php echo $check_time ?>>
										<?php echo get_txt("date"); ?>
		</TD>
		<TD>
			<input type="radio" name="REVERSE_SORT" value="0"
										<?php echo $check_ascend ?>>
										<?php echo get_txt("ascending"); ?>
			<input type="radio" name="REVERSE_SORT" value="1"
										<?php echo $check_descend ?>>
										<?php echo get_txt("descending"); ?>
		</TD>
		<TD>
			<input type="submit" name="submit" value="<?php echo get_txt("redisplay"); ?>">
		</TD>
	</TR>
</TBODY></TABLE>
</form>

<?php
if (count_files($cutfiles) > 0) {
?>
<TABLE width=95% border=1><TBODY>
	<TR BGCOLOR="<?php echo $conf["LIST_TITLE_BG2"] ?>">
	<TD COLSPAN=9><B><?php echo get_txt("cut buffer"); ?></B></TD>
	</TR>
	<TR BGCOLOR="<?php echo $conf["LIST_HEAD_BG2"] ?>">
		<TD width=<?php echo $conf["ICON_W"] ?> align=center>&nbsp;&nbsp;</TD>
		<TD  align=center><B><?php echo get_txt("filename"); ?><br>
							<?php echo get_txt("comment"); ?></B></TD>
		<TD width=<?php echo $conf["ICON_W"] ?> align=center>
					<B><?php echo get_txt("edit label"); ?></B></TD>
		<TD width=<?php echo $conf["ICON_W"] ?> align=center>
					<B><?php echo get_txt("delete label"); ?></B></TD>
		<TD width=<?php echo $conf["ICON_W"] ?> align=center>
					<B><?php echo get_txt("paste label"); ?></B></TD>
		<TD align=center><B><?php echo get_txt("size"); ?><br>
							<?php echo get_txt("attr"); ?></B></TD>
		<TD align=center><B><?php echo get_txt("date"); ?><br>
							<?php echo get_txt("time"); ?></B></TD>
		<TD align=center><B><?php echo get_txt("create user"); ?></B></TD>
		<TD align=center><B><?php echo get_txt("owner") ?><br>
							<?php echo get_txt("group"); ?></B></TD>
	</TR>

<?php

	foreach($cutfiles as $finf) {
		if ($finf["name"] == ".") {
			continue;
		}
		if ($finf["name"] == "..") {
			continue;
		}
		$file_path = make_path($cutdir, "", $finf["name"]);

		$img = make_path($conf["IMGDIR"], "", $finf["image"]);

		$dirflg = is_dir($file_path);

		//ファイルに対するパーミッションを得る
		//The permission to the file is obtained.
		$permit = get_permission($conf, $finf,
								$login_user, $login_user_groups);

		$link_ok = FALSE;
		if (($dirflg && $permit["r"] && $permit["x"]) ||
								(!$dirflg && $permit["r"])) {
			$link_ok = TRUE;
		}

		echo "<TR>\n";

		//ファイルタイプのイメージアイコン
		//Image icon of file type
		echo "<TD align=center>";
		if ($link_ok && !$dirflg) {
			if (isset($conf["TOPURL"]) && $conf["TOPURL"] != "") {
				$urlstr = make_direct_file_link($conf, $conf["CUTDIR"], $finf["name"], $img_src);
			} else {
				$urlstr = make_download_link($conf, $conf["CUTDIR"], $finf["name"], $img);
			}
		} else {
			$urlstr = "<IMG SRC=\"" . $img . "\" border=0";
			$urlstr .= " width=" . $conf["ICON_W"];
			$urlstr .= " height=" . $conf["ICON_H"];
			$urlstr .= ">";
		}
		echo $urlstr;
		echo "</TD>\n";

		//ファイル名
		//File name
		echo "<TD>";
		if ($link_ok && !$dirflg) {
			if (isset($conf["TOPURL"]) && $conf["TOPURL"] != "") {
				$urlstr = make_direct_file_link($conf, $conf["CUTDIR"], $finf["name"], "");
				$urlstr .= "<br>";
			} else {
				$urlstr = make_download_link($conf, $conf["CUTDIR"], $finf["name"], "");
			}
			echo $urlstr;
		} else {
			echo $finf["name"] . "<br>";
		}

		//コメント
		//Comment
		echo noblank_str($finf["comment"]);

		echo "</TD>\n";

		//編集
		//Edit
		$img = make_path($conf["IMGDIR"], "", $conf["EDIT_IMAGE"]);
		echo "<TD align=center>\n";
		if ($permit["w"]) {
			//書き込み可なら
			//If it is possible to write it
			echo "<FORM ACTION=\"" . $conf["EDIT_SCRIPT"] .
													"\" METHOD=\"POST\">\n";
			echo "<input type=\"hidden\" name=\"config\" value=\"" .
													$conf["config"] . "\">\n";
			echo "<input type=\"hidden\" name=\"dir\" value=\"" .
													$conf["curdir"] . "\">\n";
			echo "<input type=\"hidden\" name=\"CUTMODE\" value=\"1\">\n";
			echo "<input type=\"hidden\" name=\"fname\" value=\"" . 
													$finf["name"] . "\">\n";
			echo "<input type=\"hidden\" name=\"comment\" value=\"" . 
													$finf["comment"] . "\">\n";
			echo "<input type=\"hidden\" name=\"owner\" value=\"" . 
													$finf["owner"] . "\">\n";
			echo "<input type=\"hidden\" name=\"date\" value=\"" . 
													$finf["date"] . "\">\n";
			echo "<input type=\"hidden\" name=\"" . $s_name . "\"" .
												" value=\"" . $s_id . "\">\n";
			echo "<input type=\"hidden\" name=\"time\" value=\"" . 
													$finf["time"] . "\">\n";
			echo "<input type=\"hidden\" name=\"user\" value=\"" . 
													$finf["user"] . "\">\n";
			echo "<input type=\"hidden\" name=\"group\" value=\"" . 
													$finf["group"] . "\">\n";
			echo "<input type=\"hidden\" name=\"attr\" value=\"" . 
													$finf["attr"] . "\">\n";
			echo "<input type=\"image\" name=\"edit\" src=\"" . $img . "\"";
			echo " width=" . $conf["ICON_W"];
			echo " height=" . $conf["ICON_H"];
			echo " ALT=\"" . get_txt("edit") . "\">\n";
			echo "</FORM>\n";
		} else {
			echo "&nbsp;&nbsp;";
		}
		echo "</TD>\n";

		//削除
		//Delete
		$img = make_path($conf["IMGDIR"], "", $conf["DELETE_IMAGE"]);
		echo "<TD align=center>\n";
		if ($permit["w"]) {
			//書き込み可なら
			//If it is possible to write it
			echo "<FORM ACTION=\"" . $conf["DELETE_SCRIPT"] .
													"\" METHOD=\"POST\">\n";
			echo "<input type=\"hidden\" name=\"config\" value=\"" .
													$conf["config"] . "\">\n";
			echo "<input type=\"hidden\" name=\"dir\" value=\"" .
													$conf["curdir"] . "\">\n";
			echo "<input type=\"hidden\" name=\"CUTMODE\" value=\"1\">\n";
			echo "<input type=\"hidden\" name=\"fname\" value=\"" . 
													$finf["name"] . "\">\n";
			echo "<input type=\"hidden\" name=\"comment\" value=\"" . 
													$finf["comment"] . "\">\n";
			echo "<input type=\"hidden\" name=\"owner\" value=\"" . 
													$finf["owner"] . "\">\n";
			echo "<input type=\"hidden\" name=\"date\" value=\"" . 
													$finf["date"] . "\">\n";
			echo "<input type=\"hidden\" name=\"time\" value=\"" . 
													$finf["time"] . "\">\n";
			echo "<input type=\"hidden\" name=\"user\" value=\"" . 
													$finf["user"] . "\">\n";
			echo "<input type=\"hidden\" name=\"group\" value=\"" . 
													$finf["group"] . "\">\n";
			echo "<input type=\"hidden\" name=\"attr\" value=\"" . 
													$finf["attr"] . "\">\n";
			echo "<input type=\"hidden\" name=\"" . $s_name . "\"" .
												" value=\"" . $s_id . "\">\n";
			echo "<input type=\"image\" name=\"delete\" src=\"" . $img . "\"";
			echo " width=" . $conf["ICON_W"];
			echo " height=" . $conf["ICON_H"];
			echo " ALT=\"" . get_txt("delete") . "\">\n";
			echo "</FORM>\n";
		} else {
			echo "&nbsp;&nbsp;";
		}
		echo "</TD>\n";

		//貼り付け
		//Paste
		$img = make_path($conf["IMGDIR"], "", $conf["PASTE_IMAGE"]);
		echo "<TD align=center>\n";
		if ($permit["w"] && $curdir_permit["w"]) {
			//カレントフォルダが書き込み可なら
			//If you can write a current folder
			echo "<FORM ACTION=\"" . $conf["PASTE_SCRIPT"] .
													"\" METHOD=\"POST\">\n";
			echo "<input type=\"hidden\" name=\"config\" value=\"" .
													$conf["config"] . "\">\n";
			echo "<input type=\"hidden\" name=\"dir\" value=\"" .
													$conf["curdir"] . "\">\n";
			echo "<input type=\"hidden\" name=\"fname\" value=\"" . 
													$finf["name"] . "\">\n";
			echo "<input type=\"hidden\" name=\"comment\" value=\"" . 
													$finf["comment"] . "\">\n";
			echo "<input type=\"hidden\" name=\"owner\" value=\"" . 
													$finf["owner"] . "\">\n";
			echo "<input type=\"hidden\" name=\"date\" value=\"" . 
													$finf["date"] . "\">\n";
			echo "<input type=\"hidden\" name=\"time\" value=\"" . 
													$finf["time"] . "\">\n";
			echo "<input type=\"hidden\" name=\"user\" value=\"" . 
													$finf["user"] . "\">\n";
			echo "<input type=\"hidden\" name=\"group\" value=\"" . 
													$finf["group"] . "\">\n";
			echo "<input type=\"hidden\" name=\"attr\" value=\"" . 
													$finf["attr"] . "\">\n";
			echo "<input type=\"hidden\" name=\"" . $s_name . "\"" .
												" value=\"" . $s_id . "\">\n";
			echo "<input type=\"image\" name=\"paste\" src=\"" . $img . "\"";
			echo " width=" . $conf["ICON_W"];
			echo " height=" . $conf["ICON_H"];
			echo " ALT=\"" . get_txt("paste") . "\">\n";
			echo "</FORM>\n";
		} else {
			echo "&nbsp;&nbsp;";
		}
		echo "</TD>\n";

		//ファイルサイズとアクセス権
		//Size of file and permission
		echo "<TD align=right>" . get_filesize_str($finf["size"]) . "<br>" . 
									get_attr_str($finf["attr"]) . "</TD>\n";

		//ファイル作成日付・時刻
		//File creation date and time
		echo "<TD>" . $finf["date"] . "<BR>" . $finf["time"] . "</TD>\n";

		//ファイル作成者（任意の署名）
		//Person who up-loaded file (Arbitrary signature)
		echo "<TD>" . noblank_str($finf["owner"]) . "</TD>\n";

		//ファイル所有者：グループ
		//File owner: Group
		echo "<TD valign=top>" . noblank_str($finf["user"]) . "<br>" .
								noblank_str($finf["group"]) . "</TD>\n";

		echo "</TR>\n";
	}
	echo "</TBODY></TABLE>\n";
}

//カレントディレクトリの使用量を得る
//The amount of use in the current directory is obtained.
$dirsize = get_dir_use_size($curdir);
$dirsize_str = get_filesize_str($dirsize);

?>
<P>


<TABLE width=95% border=1><TBODY>
	<TR valign=top BGCOLOR="<?php echo $conf["LIST_TITLE_BG"] ?>">
		<TD COLSPAN=6><B><?php echo noblank_str($curdir_inf["name"]) ?><br>
					<?php echo noblank_str($curdir_inf["comment"]) ?></B></TD>
		<TD align=right><?php echo $dirsize_str ?><br>
						<?php echo get_attr_str($curdir_inf["attr"]) ?></TD>
		<TD><?php echo $curdir_inf["date"] ?><br>
						<?php echo noblank_str($curdir_inf["time"]) ?></TD>
		<TD valign=center><?php echo noblank_str($curdir_inf["owner"]) ?></TD>
		<TD><?php echo noblank_str($curdir_inf["user"]) ?><br>
						<?php echo noblank_str($curdir_inf["group"]) ?></TD>
	</TR>
	<TR BGCOLOR="<?php echo $conf["LIST_HEAD_BG"] ?>">
		<TD width=<?php echo $conf["ICON_W"] ?> align=center>&nbsp;&nbsp;</TD>
		<TD align=center><B><?php echo get_txt("filename"); ?><br>
						<?php echo get_txt("comment"); ?></B></TD>
		<TD width=<?php echo $conf["ICON_W"] ?> align=center>
						<B><?php echo get_txt("edit label"); ?></B></TD>
		<TD width=<?php echo $conf["ICON_W"] ?> align=center>
						<B><?php echo get_txt("delete label"); ?></B></TD>
		<TD width=<?php echo $conf["ICON_W"] ?> align=center>
						<B><?php echo get_txt("copy label"); ?></B></TD>
		<TD width=<?php echo $conf["ICON_W"] ?> align=center>
						<B><?php echo get_txt("cut label"); ?></B></TD>
		<TD align=center><B><?php echo get_txt("size"); ?><br>
							<?php echo get_txt("attr"); ?></B></TD>
		<TD align=center><B><?php echo get_txt("date"); ?><br>
							<?php echo get_txt("time"); ?></B></TD>
		<TD align=center><B><?php echo get_txt("create user"); ?></B></TD>
		<TD align=center><B><?php echo get_txt("owner") ?><br>
							<?php echo get_txt("group"); ?></B></TD>
	</TR>

<?php
	if ($conf["TOPDIR"] != $curdir) {
		// 上位ディレクトリのパスを得る
		//The path of a high-ranking directory is obtained.
		$updir = get_dirpath($conf["curdir"]);

		//フルパスを得る
		//The full path is obtained.
		$upname = realpath($curdir . "/..");
		$upname = get_filename($upname);

		$urlstr = $scripturl;
		$urlstr .= "?dir=" . conv_url_code($updir);
		$urlstr .= "&config=" . conv_url_code($conf["config"]);
		$urlstr .= "&" . $s_name . "=" . $s_id;

		$img = make_path($conf["IMGDIR"], "", $conf["UP_IMAGE"]);

		echo "<TR>";

		//ファイルタイプのイメージアイコン
		//Image icon of file type
		echo "<TD align=center>\n";
		echo "<A HREF=\"" . $urlstr . "\">";
		echo "<IMG SRC=\"" . $img . "\"  border=0";
		echo " width=" . $conf["ICON_W"];
		echo " height=" . $conf["ICON_H"];
		echo " ALT=\"" . $conf["UP_TITLE"] . "\"></A>\n";
		echo "</TD>\n";

		//ファイル名
		//File name
		echo "<TD>";
		echo "<A HREF=\"" . $urlstr . "\">" . $upname . "</A>";

		//コメント
		//Comment
		echo "<BR>" . $conf["UP_TITLE"] . "</TD>\n";

		//編集
		//Edit
		echo "<TD>&nbsp;&nbsp;</TD>\n";

		//削除
		//Delete
		echo "<TD>&nbsp;&nbsp;</TD>\n";

		//複写
		//Copy
		echo "<TD>&nbsp;&nbsp;</TD>\n";

		//切取り
		//Cut
		echo "<TD>&nbsp;&nbsp;</TD>\n";

		//ファイルサイズ・アクセス権
		//Size of file and permission
		echo "<TD align=right>" . "---<br>---" . "</TD>\n";

		//ファイル作成日付・時刻
		//File creation date and time
		echo "<TD>" . "---<br>---" . "</TD>\n";

		//ファイル作成者（任意の署名）
		//Person who up-loaded file (Arbitrary signature)
		echo "<TD>" . "---" . "</TD>\n";

		//ファイル所有者：グループ
		//File owner: Group
		echo "<TD>" . "---<br>---" . "</TD>\n";

		echo "</TR>\n";
	}
	foreach($files as $finf) {
		if ($finf["name"] == ".") {
			continue;
		}
		if ($finf["name"] == "..") {
			continue;
		}
		$file_fullpath = make_path($curdir, "", $finf["name"]);
		$file_path = make_path($conf["curdir"], "", $finf["name"]);

		$img = make_path($conf["IMGDIR"], "", $finf["image"]);

		$dirflg = is_dir($file_fullpath);

		//ファイルに対するパーミッションを得る
		//The permission to the file is obtained.
		$permit = get_permission($conf, $finf,
								$login_user, $login_user_groups);
		$link_ok = FALSE;
		if (($dirflg && $permit["r"] && $permit["x"]) ||
									(!$dirflg && $permit["r"])) {
			$link_ok = TRUE;
		}

		if ($dirflg) {
			$urlstr = "<a href=\"" . $scripturl;
			$urlstr .= "?dir=" . conv_url_code($file_path);
			$urlstr .= "&config=" . conv_url_code($conf["config"]);
			$urlstr .= "&" . $s_name . "=" . $s_id;
			$urlstr .= "\">";
			$urlstr .= "<IMG SRC=\"" . $img . "\" border=0";
			$urlstr .= " width=" . $conf["ICON_W"];
			$urlstr .= " height=" . $conf["ICON_H"];
			$urlstr .= ">";
		} else {
			if (isset($conf["TOPURL"]) && $conf["TOPURL"] != "") {
				$urlstr = make_direct_file_link($conf, $conf["curdir"], $finf["name"], $img);
			} else {
				$urlstr = make_download_link($conf, $conf["curdir"], $finf["name"], $img);
			}
		}

		echo "<TR>\n";

		//ファイルタイプのイメージアイコン
		//Image icon of file type
		echo "<TD align=center>";
		if ($link_ok) {
			echo $urlstr;
		} else {
			echo "<IMG SRC=\"" . $img . "\" border=0";
			echo " width=" . $conf["ICON_W"];
			echo " height=" . $conf["ICON_H"];
			echo ">";
		}
		echo "</TD>\n";

		//ファイル名
		//File name
		echo "<TD>";
		if ($link_ok) {
			if ($dirflg) {
				$urlstr = "<a href=\"" . $scripturl;
				$urlstr .= "?dir=" . conv_url_code($file_path);
				$urlstr .= "&config=" . conv_url_code($conf["config"]);
				$urlstr .= "&" . $s_name . "=" . $s_id;
				$urlstr .= "\">" . $finf["name"] . "</a><BR>";
			} else {
				if (isset($conf["TOPURL"]) && $conf["TOPURL"] != "") {
					$urlstr = make_direct_file_link($conf, $conf["curdir"], $finf["name"], "");
					$urlstr .= "<br>";
				} else {
					$urlstr = make_download_link($conf, $conf["curdir"], $finf["name"], "");
				}
			}
		} else {
			$urlstr = $finf["name"] . "<BR>";
		}
		echo $urlstr;

		//コメント
		//Comment
		echo noblank_str($finf["comment"]);

		echo "</TD>\n";

		//編集
		//Edit
		$img = make_path($conf["IMGDIR"], "", $conf["EDIT_IMAGE"]);
		echo "<TD align=center>\n";
		if ($permit["w"]) {
			echo "<FORM ACTION=\"" . $conf["EDIT_SCRIPT"] .
													"\" METHOD=\"POST\">\n";
			echo "<input type=\"hidden\" name=\"config\" value=\"" .
													$conf["config"] . "\">\n";
			echo "<input type=\"hidden\" name=\"dir\" value=\"" .
													$conf["curdir"] . "\">\n";
			echo "<input type=\"hidden\" name=\"fname\" value=\"" . 
													$finf["name"] . "\">\n";
			echo "<input type=\"hidden\" name=\"comment\" value=\"" . 
													$finf["comment"] . "\">\n";
			echo "<input type=\"hidden\" name=\"owner\" value=\"" . 
													$finf["owner"] . "\">\n";
			echo "<input type=\"hidden\" name=\"date\" value=\"" . 
													$finf["date"] . "\">\n";
			echo "<input type=\"hidden\" name=\"time\" value=\"" . 
													$finf["time"] . "\">\n";
			echo "<input type=\"hidden\" name=\"user\" value=\"" . 
													$finf["user"] . "\">\n";
			echo "<input type=\"hidden\" name=\"group\" value=\"" . 
													$finf["group"] . "\">\n";
			echo "<input type=\"hidden\" name=\"attr\" value=\"" . 
													$finf["attr"] . "\">\n";
			echo "<input type=\"hidden\" name=\"" . $s_name . "\"" .
												" value=\"" . $s_id . "\">\n";
			echo "<input type=\"image\" name=\"edit\" src=\"" . $img . "\"";
			echo " width=" . $conf["ICON_W"];
			echo " height=" . $conf["ICON_H"];
			echo " ALT=\"" . get_txt("edit") . "\">\n";
			echo "</FORM>\n";
		} else {
			echo "&nbsp;&nbsp;";
		}
		echo "</TD>\n";

		//削除
		//Delete
		$img = make_path($conf["IMGDIR"], "", $conf["DELETE_IMAGE"]);
		echo "<TD align=center>\n";
		if ($permit["w"] && $curdir_permit["w"]) {
			echo "<FORM ACTION=\"" . $conf["DELETE_SCRIPT"] .
													"\" METHOD=\"POST\">\n";
			echo "<input type=\"hidden\" name=\"config\" value=\"" .
													$conf["config"] . "\">\n";
			echo "<input type=\"hidden\" name=\"dir\" value=\"" .
													$conf["curdir"] . "\">\n";
			echo "<input type=\"hidden\" name=\"fname\" value=\"" . 
													$finf["name"] . "\">\n";
			echo "<input type=\"hidden\" name=\"comment\" value=\"" . 
													$finf["comment"] . "\">\n";
			echo "<input type=\"hidden\" name=\"owner\" value=\"" . 
													$finf["owner"] . "\">\n";
			echo "<input type=\"hidden\" name=\"date\" value=\"" . 
													$finf["date"] . "\">\n";
			echo "<input type=\"hidden\" name=\"time\" value=\"" . 
													$finf["time"] . "\">\n";
			echo "<input type=\"hidden\" name=\"user\" value=\"" . 
													$finf["user"] . "\">\n";
			echo "<input type=\"hidden\" name=\"group\" value=\"" . 
													$finf["group"] . "\">\n";
			echo "<input type=\"hidden\" name=\"attr\" value=\"" . 
													$finf["attr"] . "\">\n";
			echo "<input type=\"hidden\" name=\"" . $s_name . "\"" .
												" value=\"" . $s_id . "\">\n";
			echo "<input type=\"image\" name=\"delete\" src=\"" . $img . "\"";
			echo " width=" . $conf["ICON_W"];
			echo " height=" . $conf["ICON_H"];
			echo " ALT=\"" . get_txt("delete") . "\">\n";
			echo "</FORM>\n";
		} else {
			echo "&nbsp;&nbsp;";
		}
		echo "</TD>\n";

		//複写
		//Copy
		$img = make_path($conf["IMGDIR"], "", $conf["COPY_IMAGE"]);
		echo "<TD align=center>\n";
		if ($permit["r"]) {
			echo "<FORM ACTION=\"" . $conf["CUT_SCRIPT"] .
													"\" METHOD=\"POST\">\n";
			echo "<input type=\"hidden\" name=\"config\" value=\"" .
													$conf["config"] . "\">\n";
			echo "<input type=\"hidden\" name=\"dir\" value=\"" .
													$conf["curdir"] . "\">\n";
			echo "<input type=\"hidden\" name=\"mode\" value=\"copy\">\n";
			echo "<input type=\"hidden\" name=\"fname\" value=\"" . 
													$finf["name"] . "\">\n";
			echo "<input type=\"hidden\" name=\"comment\" value=\"" . 
													$finf["comment"] . "\">\n";
			echo "<input type=\"hidden\" name=\"owner\" value=\"" . 
													$finf["owner"] . "\">\n";
			echo "<input type=\"hidden\" name=\"date\" value=\"" . 
													$finf["date"] . "\">\n";
			echo "<input type=\"hidden\" name=\"time\" value=\"" . 
													$finf["time"] . "\">\n";
			echo "<input type=\"hidden\" name=\"user\" value=\"" . 
													$finf["user"] . "\">\n";
			echo "<input type=\"hidden\" name=\"group\" value=\"" . 
													$finf["group"] . "\">\n";
			echo "<input type=\"hidden\" name=\"attr\" value=\"" . 
													$finf["attr"] . "\">\n";
			echo "<input type=\"hidden\" name=\"" . $s_name . "\"" .
												" value=\"" . $s_id . "\">\n";
			echo "<input type=\"image\" name=\"copy\" src=\"" . $img . "\"";
			echo " width=" . $conf["ICON_W"];
			echo " height=" . $conf["ICON_H"];
			echo " ALT=\"" . get_txt("copy") . "\">\n";
			echo "</FORM>\n";
		} else {
			echo "&nbsp;&nbsp;";
		}
		echo "</TD>\n";

		//切取り
		//Cut
		$img = make_path($conf["IMGDIR"], "", $conf["CUT_IMAGE"]);
		echo "<TD align=center>\n";
		if ($permit["w"] && $curdir_permit["w"]) {
			echo "<FORM ACTION=\"" . $conf["CUT_SCRIPT"] .
													"\" METHOD=\"POST\">\n";
			echo "<input type=\"hidden\" name=\"config\" value=\"" .
													$conf["config"] . "\">\n";
			echo "<input type=\"hidden\" name=\"dir\" value=\"" .
													$conf["curdir"] . "\">\n";
			echo "<input type=\"hidden\" name=\"mode\" value=\"cut\">\n";
			echo "<input type=\"hidden\" name=\"fname\" value=\"" . 
													$finf["name"] . "\">\n";
			echo "<input type=\"hidden\" name=\"comment\" value=\"" . 
													$finf["comment"] . "\">\n";
			echo "<input type=\"hidden\" name=\"owner\" value=\"" . 
													$finf["owner"] . "\">\n";
			echo "<input type=\"hidden\" name=\"date\" value=\"" . 
													$finf["date"] . "\">\n";
			echo "<input type=\"hidden\" name=\"time\" value=\"" . 
													$finf["time"] . "\">\n";
			echo "<input type=\"hidden\" name=\"user\" value=\"" . 
													$finf["user"] . "\">\n";
			echo "<input type=\"hidden\" name=\"group\" value=\"" . 
													$finf["group"] . "\">\n";
			echo "<input type=\"hidden\" name=\"attr\" value=\"" . 
													$finf["attr"] . "\">\n";
			echo "<input type=\"hidden\" name=\"" . $s_name . "\"" .
												" value=\"" . $s_id . "\">\n";
			echo "<input type=\"image\" name=\"cut\" src=\"" . $img . "\"";
			echo " width=" . $conf["ICON_W"];
			echo " height=" . $conf["ICON_H"];
			echo " ALT=\"" . get_txt("cut") . "\">\n";
			echo "</FORM>\n";
		} else {
			echo "&nbsp;&nbsp;";
		}
		echo "</TD>\n";

		//ファイルサイズ・アクセス権
		//Size of file and permission
		echo "<TD align=right>" . get_filesize_str($finf["size"]) . "<br>" .
									get_attr_str($finf["attr"]) . "</TD>\n";

		//ファイル作成日付
		//File creation date and time
		echo "<TD>" . $finf["date"] . "<BR>" . $finf["time"] . "</TD>\n";

		//ファイル作成者（任意の署名）
		//Person who up-loaded file (Arbitrary signature)
		echo "<TD>" . noblank_str($finf["owner"]) . "</TD>\n";

		//ファイル所有者：グループ
		//File owner: Group
		echo "<TD valign=top>" . noblank_str($finf["user"]) . "<br>" .
								noblank_str($finf["group"]) . "</TD>\n";

		echo "</TR>\n";
	}
?>

</TBODY></TABLE>
</P>
<HR>
<?php
//戻り先１と戻り先２へのリンクを表示するHTMLを生成
//Link HTML to return 1 and return 2 destination is generated.
echo get_return_url_HTML($conf);
?>
<br>
<?php

if ($conf["ENTRY_PAGE_DIR_URL"] != "") {
	$link_url = $conf["ENTRY_PAGE_DIR_URL"];
	$str = "<b>" . get_txt("link address to this page") . "&nbsp;:&nbsp;";
	$str .= get_return_refer_url_HTML($link_url . "/", $link_url . "/");
	echo $str;
}

//ページフッター（プログラム・バージョンとCopyright表示）
//Page footer(program version and Copyright display)
echo get_page_footer_HTML($conf);

?>
</CENTER>
</BODY>
</HTML>
