<?php
/******************************************************************************
	Files(WEBファイル共有PHPスクリプト)
	Files(WEB file share PHP script)

	セッション用の関数
	Functions for session.

  	session.php

	Written by:	Takashi Miyagi

	Copyright (c) 2004-2025 GUSUKU All rights reserved.

	Update history:

	Ver.2.7.0
		PHP8 に対応した
		PHP8 support

		split() 関数が廃止されるので代わりに explode() を使うようにした
		The split() function is discontinued, so explode() is used instead

		ereg() 関数が非推奨となったので代わりに preg_match() を使うようにした
		The ereg() function is deprecated, so preg_match() is used instead

		get_magic_quotes_gpc() 関数が廃止されたので使わない様にした
		The get_magic_quotes_gpc() function has been discontinued, so it is no longer used

	Ver.2.6.2
		著作権者変更
		The copyright owner has been changed.

		メッセージ用の文字列リソースが無かったので追加した。
		Add a string resource that was missing for the message

		共有フォルダから戻った後に、共有フォルダの設定ファイルを参照しない
		ように修正した。
		After returning from a shared folder, the modified configuration file
		is not specified as a shared folder.

	Ver.2.6.1
		Internet Explorerで、アプリケーションでファイルを開かずに、保存ダイア
		ログが出るようにした。
		In Internet Explorer, without opening the file in the application, 
		so you get a save dialog.

	Ver.2.6
		設定ファイル名が渡されていないとき、セッション変数から取得するようにした
		When a config file name was not handed, I acquired it from a session 
		variable.

	Ver.2.5
		HTMLの前に、HTTPヘッダで使用する文字セットを指定するようにした。
		The character set used by HTTP header was specified in front of HTML.

		一部の関数を files_com.php から移動した。
		A part of function was moved from files_com.php.

	Ver.2.4
		ダウンロード・ファイルのリンク方法を変更した。
		The method of linking the download files was changed. 

		日本語名のファイルをダウンロードする際に、ブラウザの種類を考慮して
		ファイル名を変換するようにした。
		When the file of a Japanese name was downloaded, the file name was 
		converted in consideration of the kind of a browser.

		カットバッファのファイルへのリンク先が間違っていたので修正した
		Because link ahead to the file of the cut buffer was wrong, I revised it

	Ver.2.3
		PHP 4.3.3 以前のバージョンで、session_start() でエラーになる場合が
		あったので、session_start() の前に ini_set()を実行するように修正した
		It was corrected that ini_set() was executed in the session_start() 
		front because it had become an error by session_start() in the version 
		before PHP 4.3.3 occasionally. 

	Ver.2.2
		Ver.2.1 でリリースしたスクリプトの中の、文字コードが UTF-8 のファイルに
		BOMが混入してるものがあったので、差し替えた。
		The character-code in the script released with Ver.2.1 replaced it 
		because there was something that 'BOM' mixes with the file of UTF-8.

	Ver.2.1
		CONFIG_TOP_URL を廃止
		 abolish CONFIG_TOP_URL.

		index.php を config ファイルとは別の場所に作成するようにした
		I made index.php with the config file in another place.

		管理メニューに構成ファイル配置設定を追加した
		The configuration file arrangement setting was added to the management
		menu. 

	Ver.2.0
		files_com.php から分離
		It is divided by files_com.php.

******************************************************************************/

//error_reporting(E_ERROR);

require('locale.php');

$FILES_PROGRAM_NAME = "Files";

$FILES_VERSION_NO = "2.7.0";
//$FILES_VERSION_NO = "X.X";

$FILES_COPYRIGHT_STR =  "Copyright (c) 2004-2025" .
			" GUSUKU" .
			" All right reserved";

$MY_HOME_PAGE_URL = "http://www.gusuku.org/";

//$DEBUG_LOG = TRUE;
$DEBUG_LOG = FALSE;

$GLB_CONFIG = array();

function get_charset()
{
	global $dsp_charset;

	if (isset($dsp_charset) && $dsp_charset != "") {
		return $dsp_charset;
	} else {
		return "";
	}
}

function get_txt($key)
{
	global $txt;

	return $txt[$key];
}

function get_charset_line()
{
	$charset = get_charset();

	$html = "";
	if ($charset != "") {
		$html = "<meta http-equiv=\"Content-type\" content=\"text/html; charset=" .
															$charset . "\">\n";
	}
	return $html;
}

function files_session_name()
{
	return "FILES_SESSION";
}

function get_version_no()
{
	return $GLOBALS["FILES_VERSION_NO"];
}

function get_copyright_str()
{
	return $GLOBALS["FILES_COPYRIGHT_STR"];
}

function get_program_name()
{
	return $GLOBALS["FILES_PROGRAM_NAME"];
}

function get_homepage()
{
	return $GLOBALS["MY_HOME_PAGE_URL"];
}

function get_config()
{
	return $GLOBALS["GLB_CONFIG"];
}

function set_config($conf)
{
	$GLOBALS["GLB_CONFIG"] = $conf;
}

function get_env_val($val_name)
{
	$val = "";

	if (isset($$val_name)) {
		$val = $$val_name;
	} else {
		if (isset($_ENV) && isset($_ENV[$val_name])) {
			$val = $_POST[$val_name];
		} elseif (isset($HTTP_ENV_VARS) && isset($HTTP_ENV_VARS[$val_name])) {
			$val = $HTTP_ENV_VARS[$val_name];
		} elseif (isset($GLOBALS) && isset($GLOBALS[$val_name])) {
			$val = $GLOBALS[$val_name];
		} elseif (isset($_SERVER) && isset($_SERVER[$val_name])) {
			$val = $_SERVER[$val_name];
		}
	}
// php8で廃止されたので使用しないようにした
// It was discontinued in php8, so I stopped using it.
//	if (get_magic_quotes_gpc()) {
//		$val = stripslashes($val);
//	}
	return $val;
}

function get_post_get_val($val_name)
{
	$val = "";

	if (isset($$val_name)) {
		$val = $$val_name;
	} else {
		if (isset($_POST) && isset($_POST[$val_name])) {
			$val = $_POST[$val_name];
		} elseif (isset($_GET) && isset($_GET[$val_name])) {
			$val = $_GET[$val_name];
		} elseif (isset($HTTP_POST_VARS) && isset($HTTP_POST_VARS[$val_name])) {
			$val = $HTTP_POST_VARS[$val_name];
		} elseif (isset($HTTP_GET_VARS) && isset($HTTP_GET_VARS[$val_name])) {
			$val = $HTTP_GET_VARS[$val_name];
		} elseif (isset($GLOBALS) && isset($GLOBALS[$val_name])) {
			$val = $GLOBALS[$val_name];
		}
	}
// php8で廃止されたので使用しないようにした
// It was discontinued in php8, so I stopped using it.
//	if (get_magic_quotes_gpc()) {
//		$val = stripslashes($val);
//	}
	$val = htmlspecialchars($val, ENT_QUOTES);

	return $val;
}

function get_session_value($val_name)
{
	if (isset($_SESSION) && isset($_SESSION[$val_name])) {
		return $_SESSION[$val_name];
	}
	if (isset($HTTP_SESSION_VARS) && isset($HTTP_SESSION_VARS[$val_name])) {
		return $HTTP_SESSION_VARS[$val_name];
	}
	return "";
}

function set_session_value($val_name, $value)
{
	if (isset($_SESSION)) {
		$_SESSION[$val_name] = $value;
	} elseif ($HTTP_SESSION_VARS) {
		$HTTP_SESSION_VARS[$val_name] = $value;
	}
}

// ファイルURLに日本語が入っている場合は文字コードの文字列に変換
//It converts it into the character string of the character-code when
//there is Japanese in file URL. 
function conv_url_code($srcurl)
{
	$ret_url = "";

/*****
	//マルチバイト文字列関数（mbstring）が使える場合
	//When you can use multi byte character string function (mbstring)
	$len = mb_strlen($srcurl);
	for ($i = 0; $i < $len; $i++) {
		$char = mb_substr($srcurl, $i, 1);
		if (mb_detect_encoding($char) == "ASCII") {
			$ret_url .= $char;
		} else {
			$ret_url .= urlencode($char);
		}
	}
*****/

	$len = strlen($srcurl);
	$i = 0;
	while ($i < $len) {
		$char = substr($srcurl, $i++, 1);
		if (ord($char) <= 0x7f) {
			$ret_url .= $char;
		} else {
			if ($i < $len) {
				$char .= substr($srcurl, $i++, 1);
			}
			$ret_url .= urlencode($char);
		}
	}
/****/
	return $ret_url;
}

//パス中のファイル名部分のみを取り出す
//Only the file name part under passing is taken out. 
function get_filename($dir)
{
	$flds = explode("/", $dir);
	$filename = array_pop($flds);

	return $filename;
}

//ファイル名のベース名のみを取り出す
//Only the base name is taken out of the file name.
function get_basename($path)
{
	$filename = get_filename($path);
	$flds = explode(".", $filename);
	if (isset($flds[0]) && $flds[0] != "") {
		$basename = array_shift($flds);
	} else {
		$basename = $filename;
	}
	return $basename;
}

//パス中のディレクトリパス部分のみを取り出す
//Only the directory path part under passing is taken out. 
//（パスがディレクトリ名の場合は上位ディレクトリのパスを返す）
//(When passing is a directory name, passing a high-ranking directory is returned. )
function get_dirpath($dir)
{
	$flds = explode("/", $dir);
	if (count($flds) > 0) {
		$tmp = array_pop($flds);
		$num = count($flds);
		if ($num > 1) {
			$updir = join("/", $flds);
		} elseif ($num > 0) {
			$updir = $flds[0];
		} else {
			$updir = "";
		}
	} else {
		$updir = "";
	}
	return $updir;
}

//フルパスを組み立てる
//The full path is assembled.
function make_path($basedir, $dir, $fname)
{
	$path = $basedir;

	if ($dir != "") {
		if ($path != "") {
			$path .= "/";
		}
		$path .= $dir;
	}
	if ($fname != "") {
		if ($path != "") {
			$path .= "/";
		}
		$path .= $fname;
	}

	return $path;
}

//カンマ区切り文字のカンマを取り除く
//The comma of the comma delimiter is removed. 
function conv_comma_val($comma_val)
{
	$valstr = "";

	$vals = explode(",", $comma_val);

	foreach($vals as $val) {
		$valstr .= $val;
	}
	return $valstr;
}

//数値を3桁づつのカンマ区切りにする
//The numerical value is made the comma district switching off of the treble.
function make_comma_val($val)
{
	$tmpstr = "";
	$valstr = "";

	$len = strlen($val);
	for ($i = 0, $p = $len - 1; $i < $len; $i++, $p--) {
		if ($i > 0 && $i % 3 == 0) {
			$tmpstr .= ",";
		}
		$tmpstr .= substr($val, $p, 1);
	}
	$len = strlen($tmpstr);
	for ($i = 0, $p = $len - 1; $i < $len; $i++, $p--) {
		$valstr .= substr($tmpstr, $p, 1);
	}
	return $valstr;
}

//設定ファイル読み込み
//Configuration file reading
function read_conf_file($conffile)
{
	//設定ファイルで設定できる項目
	//Item that can be set by configuration file
	$topdir = getcwd();
	$conf = array(
		"CONFIG_DIR" => 0,
		"CONFIG_TOP_DIR" => "./config",
		"ENTRY_PAGE_DIR_URL" => "",
		"ENTRY_PAGE_TOP_DIR" => "./config",
		"ENTRY_PAGE_TOP_URL" => "./config",
		"SCRIPT_DIR_URL" => "",
		"LISTFILE" => ".files.lst",
		"LOCKFILE" => ".lock_files.lock",
		"LOGFILE" => "./files.log",
		"OUTPUT_LOG" => 0,
		"PASSWD_FILE" => "",
		"GROUP_FILE" => "",
		"DEFAULT_GROUP_FILE" => "group",
		"IMGDIR" => "./images",
		"TOPDIR" => ".",
		"TOPURL" => "",
		"CUTDIR" => "",
		"HEADER_TITLE" => "Files",
		"TITLEIMG" => "",
		"ptitleimg_w" => "200",
		"ptitleimg_h" => "35",
		"TITLESTR" => "Files",
		"TITLE_COMMENT_LOGIN" => "",
		"TITLE_COMMENT_FILES" => "",
		"TITLE_COMMENT_EDIT" => "",
		"TITLE_COMMENT_DELETE" => "",
		"TITLE_COMMENT_MKDIR" => "",
		"TITLE_COMMENT_UPLOAD" => "",
		"LOGIN_TITLE" => "",
		"RETURL1" => "",
		"returntitle1" => "",
		"RETURL2" => "",
		"returntitle2" => "",
		"FILES_SCRIPT" => "files.php",
		"EDIT_SCRIPT" => "edit.php",
		"DELETE_SCRIPT" => "delete.php",
		"COPY_SCRIPT" => "cut.php",
		"CUT_SCRIPT" => "cut.php",
		"PASTE_SCRIPT" => "paste.php",
		"MKDIR_SCRIPT" => "mkdir.php",
		"UPLOAD_SCRIPT" => "upload.php",
		"ATTR_SCRIPT" => "attr.php",
		"LOGIN_SCRIPT" => "login.php",
		"PASSWD_SCRIPT" => "passwd.php",
		"GROUP_SCRIPT" => "group.php",
		"CONFMENU_SCRIPT" => "confmenu.php",
		"NEWCONF_SCRIPT" => "newconf.php",
		"DELCONF_SCRIPT" => "delconf.php",
		"MODCONF_SCRIPT" => "modconf.php",
		"DIRLIST_SCRIPT" => "dirlist.php",
		"UPLOAD_CGI" => "upload.php",
		"DIR_IMAGE" => "folder.png",
		"UP_IMAGE" => "up.png",
		"UP_TITLE" => "to upper folder",
		"EDIT_IMAGE" => "edit.png",
		"DELETE_IMAGE" => "delete.png",
		"COPY_IMAGE" => "copy.png",
		"CUT_IMAGE" => "cut.png",
		"PASTE_IMAGE" => "paste.png",
		"BG_IMAGE" => "",
		"BG_COLOR" => "",
		"ICONSIZE" => "24",
		"ICON_W" => "20",
		"ICON_H" => "24",
		"CALLER_URL" => "",
		"MAX_UPLOAD_SIZE" => 10000000,
		"MAX_TOTAL_SIZE" => 500000000,
		"SORT_KEY" => "time",
		"REVERSE_SORT" => 1,
		"LIST_TITLE_BG" => "#cfccf0",
		"LIST_HEAD_BG" => "#a00ca4",
		"LIST_TITLE_BG2" => "#f0cccf",
		"LIST_HEAD_BG2" => "#a00ca4",
		"ADMIN_USERID" => "",
		"ADMIN_DEFAULT_PASSWD" => "",
		"MD5_PASSWD_USE" => "",
		"DEFAULT_ATTR" => 0777,
		"PERMIT_ALL" => "NO",
		"CONF_DIR_ATTR" => 0775,
		"CONF_FILE_ATTR" => 0664,
		"DATA_DIR_ATTR" => 0775,
		"DATA_FILE_ATTR" => 0664,
		"PWD_FILE_ATTR" => 0660,
		"SHOW_HELP_LINK" => 1,
		"curdir" => "",
		"returl" => "",
		"title" => "",
		"config" => "./files.conf"
	);

	$conf["config"] = $conffile;

	// 設定ファイル名から設定名を取り出す
	//A set name is taken out of the configuration file name.
	$conf["name"] = get_basename($conffile);

	if (! file_exists($conffile)) {
		echo "config file ($conffile) not exist\n";
		exit;
	}
	if (!($fp = fopen ($conffile, "r"))) {
		echo "config file ($conffile) ca not open\n";
		exit;
	}
	flock($fp, 2);

	while (!feof ($fp)) {
		//１行読み込み
		//One line reading
		$buffer = fgets($fp, 4096);
		$buffer = chop($buffer);

		if (strlen($buffer) < 3) {
			//最低２項目なので３文字以下の行は捨てる
			//Because they are two items or more, the line of
			//three characters or less is thrown away. 
			continue;
		}
		if (substr($buffer, 0, 1) == "#") {
			//コメント行はスキップ
			//The comment line is skipped.
			continue;
		}
		//行をＴＡＢで分割
		//The line is divided with TAB.
		$flds = explode("\t", $buffer);

		//フィールドがあること
		//There must be a field.
		if (isset($flds[0]) && $flds[0] != "" && isset($flds[1])) {
			switch ($flds[0]) {
			case "CONFIG_DIR":
				//設定用ディレクトリか
				//Is it a directory for the setting?
				$conf["CONFIG_DIR"] = $flds[1];
				break;
			case "CONFIG_TOP_DIR":
				//設定ファイルディレクトリの基点
				//Base point of configuration file directory
				$conf["CONFIG_TOP_DIR"] = $flds[1];
				break;
			case "ENTRY_PAGE_TOP_DIR":
				//エントリー・ページ格納ディレクトリ
				//Entry page files storage directory
				$conf["ENTRY_PAGE_TOP_DIR"] = $flds[1];
				break;
			case "ENTRY_PAGE_TOP_URL":
				//エントリー・ページ格納ディレクトリのURL
				//URL of entry page files storage directory
				$conf["ENTRY_PAGE_TOP_URL"] = $flds[1];
				break;
			case "LISTFILE":
				//リストファイル名
				//List file name
				$conf["LISTFILE"] = $flds[1];
				break;
			case "LOCKFILE":
				//ロックファイル名
				//Lock file name
				$conf["LOCKFILE"] = $flds[1];
				break;
			case "LOGFILE":
				//ログファイル名
				//Log file name
				$conf["LOGFILE"] = $flds[1];
				break;
			case "OUTPUT_LOG":
				//アクセスログを出力するか
				//Is the access log output?
				$conf["OUTPUT_LOG"] = $flds[1];
				break;
			case "PASSWD_FILE":
				//パスワードファイル
				//Password file
				$conf["PASSWD_FILE"] = $flds[1];
				break;
			case "GROUP_FILE":
				//グループファイル
				//Group file
				$conf["GROUP_FILE"] = $flds[1];
				break;
			case "DEFAULT_GROUP_FILE":
				$conf["DEFAULT_GROUP_FILE"] = $flds[1];
				break;
			case "IMGDIR":
				//イメージディレクトリ情報
				//Image directory information
				$conf["IMGDIR"] = $flds[1];
				break;
			case "CUTDIR":
				//カットバッファのディレクトリ情報
				//Directory information on cutting buffer
				$conf["CUTDIR"] = $flds[1];
				break;
			case "TOPDIR":
				//ＴＯＰディレクトリ情報
				//TOP directory information
				$conf["TOPDIR"] = $flds[1];
				if (isset($flds[2]) && $flds[2] != "") {
					$conf["toptitle"] = $flds[2];
				} else {
					$conf["toptitle"] = "";
				}
				break;
			case "TOPURL":
				//ＴＯＰディレクトリのURL
				//TOP directory URL
				$conf["TOPURL"] = $flds[1];
				break;
			case "HEADER_TITLE":
				//ヘッダのタイトル
				//Title of header
				$conf["HEADER_TITLE"] = $flds[1];
				break;
			case "TITLEIMG":
				//タイトルイメージ情報
				//Title image information
				$conf["TITLEIMG"] = $flds[1];
				if (isset($flds[2]) && $flds[2] != "") {
					$conf["ptitleimg_w"] = $flds[2];
				}
				if (isset($flds[3]) && $flds[3] != "") {
					$conf["ptitleimg_h"] = $flds[3];
				}
				break;
			case "TITLESTR":
				//タイトル文字列情報
				//Title character string information
				$conf["TITLESTR"] = $flds[1];
				break;
			case "TITLE_COMMENT_LOGIN":
				//ログイン画面のコメント行
				//Comment line of login screen
				$conf["TITLE_COMMENT_LOGIN"] = $flds[1];
				break;
			case "TITLE_COMMENT_FILES":
				//ファイル一覧画面のコメント行
				//Comment line of file list screen
				$conf["TITLE_COMMENT_FILES"] = $flds[1];
				break;
			case "TITLE_COMMENT_EDIT":
				//編集画面のコメント行
				//Comment line of edit display
				$conf["TITLE_COMMENT_EDIT"] = $flds[1];
				break;
			case "TITLE_COMMENT_DELETE":
				//削除画面のコメント行
				//Comment line of deletion screen
				$conf["TITLE_COMMENT_DELETE"] = $flds[1];
				break;
			case "TITLE_COMMENT_MKDIR":
				//フォルダ作成画面のコメント行
				//Comment line of folder making screen
				$conf["TITLE_COMMENT_MKDIR"] = $flds[1];
				break;
			case "TITLE_COMMENT_UPLOAD":
				//アップロード画面のコメント行
				//Comment line of up-loading screen
				$conf["TITLE_COMMENT_UPLOAD"] = $flds[1];
				break;
			case "LOGIN_TITLE":
				//ログイン・タイトル
				//Login title
				$conf["LOGIN_TITLE"] = $flds[1];
				break;
			case "RETURL1":
				//戻り先URL情報１
				//URL information 1 at return destination
				$conf["RETURL1"] = $flds[1];
				if (isset($flds[2]) && $flds[2] != "") {
					$conf["returntitle1"] = $flds[2];
				} else {
					$conf["returntitle1"] = $flds[1];
				}
				break;
			case "RETURL2":
				//戻り先URL情報２
				//URL information 2 at return destination
				$conf["RETURL2"] = $flds[1];
				if (isset($flds[2]) && $flds[2] != "") {
					$conf["returntitle2"] = $flds[2];
				} else {
					$conf["returntitle2"] = $flds[1];
				}
				break;
			case "FILES_SCRIPT":
				//ファイル一覧スクリプト
				//File list script
				$conf["FILES_SCRIPT"] = $flds[1];
				break;
			case "EDIT_SCRIPT":
				//編集スクリプト
				//Edit script
				$conf["EDIT_SCRIPT"] = $flds[1];
				break;
			case "DELETE_SCRIPT":
				//削除スクリプト
				//Deletion script
				$conf["DELETE_SCRIPT"] = $flds[1];
				break;
			case "COPY_SCRIPT":
				//複写スクリプト
				//Copy script
				$conf["COPY_SCRIPT"] = $flds[1];
				break;
			case "CUT_SCRIPT":
				//切取りスクリプト
				//Cutout script
				$conf["CUT_SCRIPT"] = $flds[1];
				break;
			case "PASTE_SCRIPT":
				//貼付けスクリプト
				//Paste script
				$conf["PASTE_SCRIPT"] = $flds[1];
				break;
			case "MKDIR_SCRIPT":
				//フォルダ作成スクリプト
				//Folder making script
				$conf["MKDIR_SCRIPT"] = $flds[1];
				break;
			case "UPLOAD_SCRIPT":
				//ファイルアップロードスクリプト
				//File up-loading script
				$conf["UPLOAD_SCRIPT"] = $flds[1];
				break;
			case "ATTR_SCRIPT":
				//ファイル属性変更スクリプト
				//File attribute change script
				$conf["ATTR_SCRIPT"] = $flds[1];
				break;
			case "LOGIN_SCRIPT":
				//ログインスクリプト
				//Login script
				$conf["LOGIN_SCRIPT"] = $flds[1];
				break;
			case "PASSWD_SCRIPT":
				//パスワード設定スクリプト
				//Password setting script
				$conf["PASSWD_SCRIPT"] = $flds[1];
				break;
			case "GROUP_SCRIPT":	//グループ設定スクリプト
				//グループ設定スクリプト
				//Group setting script
				$conf["GROUP_SCRIPT"] = $flds[1];
				break;
			case "CONFMENU_SCRIPT":
				//設定メニュースクリプト
				//Set menu script
				$conf["CONFMENU_SCRIPT"] = $flds[1];
				break;
			case "NEWCONF_SCRIPT":
				//共有フォルダ作成スクリプト
				//Common folder making script
				$conf["NEWCONF_SCRIPT"] = $flds[1];
				break;
			case "DELCONF_SCRIPT":
				//共有フォルダ削除スクリプト
				//Common folder deletion script
				$conf["DELCONF_SCRIPT"] = $flds[1];
				break;
			case "MODCONF_SCRIPT":
				//共有フォルダ設定更新スクリプト
				//Common folder setting update script
				$conf["MODCONF_SCRIPT"] = $flds[1];
				break;
			case "DIRLIST_SCRIPT":
				//共有フォルダ一覧スクリプト
				//Shared folder list script
				$conf["DIRLIST_SCRIPT"] = $flds[1];
				break;
			case "UPLOAD_CGI":
				//ファイルアップロードCGI
				//File up-loading CGI
				$conf["UPLOAD_CGI"] = $flds[1];
				break;
			case "DIR_IMAGE":
				//フォルダイメージ
				//Folder image
				$conf["DIR_IMAGE"] = $flds[1];
				break;
			case "UP_IMAGE":
				//上位フォルダイメージ
				//Upper folder image
				$conf["UP_IMAGE"] = $flds[1];
				break;
			case "UP_TITLE":
				//上位フォルダへのタイトル文字
				//Title character to upper folder
				$conf["UP_TITLE"] = $flds[1];
				break;
			case "EDIT_IMAGE":
				//コメント編集イメージ
				//Comment edit image
				$conf["EDIT_IMAGE"] = $flds[1];
				break;
			case "DELETE_IMAGE":
				//ファイル削除イメージ
				//File deletion image
				$conf["DELETE_IMAGE"] = $flds[1];
				break;
			case "COPY_IMAGE":
				//ファイル複写イメージ
				//File copy image
				$conf["COPY_IMAGE"] = $flds[1];
				break;
			case "CUT_IMAGE":
				//ファイル切取りイメージ
				//File cutout image
				$conf["CUT_IMAGE"] = $flds[1];
				break;
			case "PASTE_IMAGE":
				//ファイル貼付けイメージ
				//File paste image
				$conf["PASTE_IMAGE"] = $flds[1];
				break;
			case "BG_IMAGE":
				//背景イメージ
				//Background image
				$conf["BG_IMAGE"] = $flds[1];
				break;
			case "BG_COLOR":
				//背景色
				//Background color
				$conf["BG_COLOR"] = $flds[1];
				break;
			case "ICONSIZE":
				//アイコンサイズ
				//Size of icon
				$conf["ICONSIZE"] = $flds[1];
				break;
			case "ICON_W":
				//アイコン幅
				//Width of icon
				$conf["ICON_W"] = $flds[1];
				break;
			case "ICON_H":
				//アイコン高さ
				//Height of icon
				$conf["ICON_H"] = $flds[1];
				break;
			case "CALLER_URL":
				//呼び出し元ＵＲＬ
				//Call former URL
				$conf["CALLER_URL"] = $flds[1];
				break;
			case "MAX_UPLOAD_SIZE":
				//アップロードファイルのMAXサイズ
				//MAX size of up-loading file
				if ($flds[1] != "") {
					$conf["MAX_UPLOAD_SIZE"] = conv_comma_val($flds[1]);
				}
				break;
			case "MAX_TOTAL_SIZE":
				//使用容量のMAXサイズ
				//MAX size of use capacity
				if ($flds[1] != "") {
					$conf["MAX_TOTAL_SIZE"] = conv_comma_val($flds[1]);
				}
				break;
			case "SORT_KEY":
				//デフォルトのソートキー
				//Sorting key to default
				$conf["SORT_KEY"] = $flds[1];
				break;
			case "REVERSE_SORT":
				//ソート順
				//The order of sorting
				$conf["REVERSE_SORT"] = $flds[1];
				break;
			case "LIST_TITLE_BG":
				//表のタイトル部の背景色
				//Background color of title part of table
				$conf["LIST_TITLE_BG"] = $flds[1];
				break;
			case "LIST_HEAD_BG":
				//表のヘッダ部の背景色
				//Background color of header in table
				$conf["LIST_HEAD_BG"] = $flds[1];
				break;
			case "LIST_TITLE_BG2":
				//表のタイトル部の背景色２
				//Background color 2 of title part of table
				$conf["LIST_TITLE_BG2"] = $flds[1];
				break;
			case "LIST_HEAD_BG2":
				//表のヘッダ部の背景色２
				//Background color 2 of header in table
				$conf["LIST_HEAD_BG2"] = $flds[1];
				break;
			case "ADMIN_USERID":
				//管理者ID
				//Manager ID
				$conf["ADMIN_USERID"] = $flds[1];
				break;
			case "ADMIN_DEFAULT_PASSWD":
				//管理者のデフォルトパスワード
				//Manager's default password
				$conf["ADMIN_DEFAULT_PASSWD"] = $flds[1];
				break;
			case "MD5_PASSWD_USE":
				//パスワードにMD5ハッシュを使用するか
				//Is the MD5 hush used for the password?
				$conf["MD5_PASSWD_USE"] = $flds[1];
				break;
			case "DEFAULT_ATTR":
				$conf["DEFAULT_ATTR"] = $flds[1];
				break;
			case "PERMIT_ALL":
				$conf["PERMIT_ALL"] = $flds[1];
				break;
			case "CONF_DIR_ATTR":
				$conf["CONF_DIR_ATTR"] = intval($flds[1], 8);
				break;
			case "CONF_FILE_ATTR":
				$conf["CONF_FILE_ATTR"] = intval($flds[1], 8);
				break;
			case "DATA_DIR_ATTR":
				$conf["DATA_DIR_ATTR"] = intval($flds[1], 8);
				break;
			case "DATA_FILE_ATTR":
				$conf["DATA_FILE_ATTR"] = intval($flds[1], 8);
				break;
			case "PWD_FILE_ATTR":
				$conf["PWD_FILE_ATTR"] = intval($flds[1], 8);
				break;
			case "SHOW_HELP_LINK":
				$conf["SHOW_HELP_LINK"] = $flds[1];
				break;
			}
		}
	}
	flock($fp, 3);
	fclose($fp);

	$conf["SCRIPT_DIR_URL"] = dirname($_SERVER['SCRIPT_NAME']);

	//エントリー・ページのあるディレクトリのURL
	//URL of directory with entry page file
	if ($conf["name"] == "files") {
		$curr_url = (empty($_SERVER['HTTPS']) ? 'http://' : 'https://') . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
		$curr_url_arr = explode("?", $curr_url);
		$curr_url = $curr_url_arr[0];
		$curr_url_arr = explode("/", $curr_url);
		$cnt = count($curr_url_arr);
		
		$curr_url = "";
		for ($i = 0; $i < $cnt - 1; $i++) {
			if ($curr_url != "") {
				$curr_url = $curr_url . "/";
			}
			$curr_url = $curr_url . $curr_url_arr[$i];
		}
		$conf["ENTRY_PAGE_DIR_URL"] = $curr_url;
	} else {
		$conf["ENTRY_PAGE_DIR_URL"] = get_entry_page_top_url($conf) . 
											"/" . $conf["name"];
	}
	//if ($conf["CUTDIR"] == "" && $conf["TOPDIR"] != "") {
	//	$conf["CUTDIR"] = $conf["TOPDIR"] . "/.cutbuf";
	//}
	if ($conf["CUTDIR"] == "") {
		$conf["CUTDIR"] = ".cutbuf";
	}

	return $conf;
}

// 設定ファイル書き込み
//Configuration file writing
function write_conf_file($conf, $new_conf, $new_conffile)
{
	if (! file_exists($conf["config"])) {
		echo "config file (" . $conf["config"] . ") not exist\n";
		return FALSE;
	}
	$in_fname = realpath($conf["config"]);
	$new_conf_dir = get_dirpath($new_conffile);
	$new_conf_dir = realpath($new_conf_dir);
	$new_conf_fname = get_filename($new_conffile);
	$out_fname = make_path($new_conf_dir, "", $new_conf_fname);

	$keys = array_keys($new_conf);

	$write_flags = array();

	foreach($keys as $key) {
		$write_flags[$key] = 1;
	}

	$tmp_fname = "";
	if (strcasecmp($in_fname, $out_fname) == 0) {
		$tmp_fname = $in_fname . ".tmp";
		if (! rename($in_fname, $tmp_fname)) {
			return FALSE;
		}
		$in_fname = $tmp_fname;
	}
	// 基本設定ファイル・オープン
	//Basic configuration file and opening
	if (!($ifp = fopen ($in_fname, "r"))) {
		echo "config file (" . $conf["config"] , ") can not open\n";
		return FALSE;
	}
	flock($ifp, 2);

	// 設定ファイル・オープン
	//Configuration file and opening
	if (!($ofp = fopen ($out_fname, "w"))) {
		echo "new config file (" . $out_fname . ") can not open\n";
		return FALSE;
	}
	flock($ofp, 2);

	while (!feof ($ifp)) {
		//１行読み込み
		//One line reading
		$buffer = fgets($ifp, 4096);
		$buffer = chop($buffer);
		$str = "";
		if (substr($buffer, 0, 1) == "#") {
			//コメント行はそのまま出力
			//The comment line is output as it is.
			$str = $buffer;
		} else if (strlen($buffer) < 3) {
			//最低２項目なので３文字以下の行はそのまま出力
			//Because they are two items or more, the line of three characters
			//or less is output as it is.
			$str = $buffer;
		} else {
			//行をＴＡＢで分割
			//The line is divided with TAB.
			$flds = explode("\t", $buffer);

			//フィールドが無い行はそのまま出力
			//The line without the field is output as it is.
			if ($flds[0] == "") {
				$str = $buffer;
			} else {
				switch ($flds[0]) {
				case "CONFIG_DIR":
					$str = $flds[0] . "\t" . $new_conf["CONFIG_DIR"];
					$write_flags[$flds[0]] = 0;
					break;
				case "CONFIG_TOP_DIR":
					//設定ファイルディレクトリの基点
					//Base point of configuration file directory
					$str = $flds[0] . "\t" . $new_conf["CONFIG_TOP_DIR"];
					$write_flags[$flds[0]] = 0;
					break;
				case "ENTRY_PAGE_TOP_DIR":
					//エントリー・ページ格納ディレクトリ
					//Entry page files storage directory
					$str = $flds[0] . "\t" . $new_conf["ENTRY_PAGE_TOP_DIR"];
					$write_flags[$flds[0]] = 0;
					break;
				case "ENTRY_PAGE_TOP_URL":
					//エントリー・ページ格納ディレクトリのURL
					//URL of entry page files storage directory
					$str = $flds[0] . "\t" . $new_conf["ENTRY_PAGE_TOP_URL"];
					$write_flags[$flds[0]] = 0;
					break;
				case "LISTFILE":
					//リストファイル名
					//List file name
					$str = $flds[0] . "\t" . $new_conf["LISTFILE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "LOCKFILE":
					//ロックファイル名
					//Lock file name
					$str = $flds[0] . "\t" . $new_conf["LOCKFILE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "LOGFILE":
					//ログファイル名
					//Log file name
					$str = $flds[0] . "\t" . $new_conf["LOGFILE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "OUTPUT_LOG":
					//アクセスログを出力するか
					//Is the access log output?
					$str = $flds[0] . "\t" . $new_conf["OUTPUT_LOG"];
					$write_flags[$flds[0]] = 0;
					break;
				case "PASSWD_FILE":
					//パスワードファイル
					//Password file
					$str = $flds[0] . "\t" . $new_conf["PASSWD_FILE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "GROUP_FILE":
					//Group file
					$str = $flds[0] . "\t" . $new_conf["GROUP_FILE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "DEFAULT_GROUP_FILE":
					$str = $flds[0] . "\t" . $new_conf["DEFAULT_GROUP_FILE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "IMGDIR":
					//イメージディレクトリ
					//Image directory
					$str = $flds[0] . "\t" . $new_conf["IMGDIR"];
					$write_flags[$flds[0]] = 0;
					break;
				case "CUTDIR":
					//カットバッファのディレクトリ
					//Directory of cutting buffer
					$str = $flds[0] . "\t" . $new_conf["CUTDIR"];
					$write_flags[$flds[0]] = 0;
					break;
				case "TOPDIR":
					//ＴＯＰディレクトリ
					//TOP directory
					$str = $flds[0] . "\t" . $new_conf["TOPDIR"];
					$str .= "\t" . $new_conf["toptitle"];
					$write_flags[$flds[0]] = 0;
					break;
				case "TOPURL":
					//ＴＯＰディレクトリのURL
					//TOP directory URL
					$str = $flds[0] . "\t" . $new_conf["TOPURL"];
					$write_flags[$flds[0]] = 0;
					break;
				case "HEADER_TITLE":
					//ヘッダのタイトル
					//Title of header
					$str = $flds[0] . "\t" . $new_conf["HEADER_TITLE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "TITLEIMG":
					//タイトルイメージ
					//Title image
					$str = $flds[0] . "\t" . $new_conf["TITLEIMG"];
					$str .= "\t" . $new_conf["ptitleimg_w"];
					$str .= "\t" . $new_conf["ptitleimg_h"];
					$write_flags[$flds[0]] = 0;
					break;
				case "TITLESTR":
					//タイトル文字列
					//Title string
					$str = $flds[0] . "\t" . $new_conf["TITLESTR"];
					$write_flags[$flds[0]] = 0;
					break;
				case "TITLE_COMMENT_LOGIN":
					//ログイン画面のコメント行
					//Comment line of login screen
					$str = $flds[0] . "\t" . $new_conf["TITLE_COMMENT_LOGIN"];
					$write_flags[$flds[0]] = 0;
					break;
				case "TITLE_COMMENT_FILES":
					//ファイル一覧画面のコメント行
					//Comment line of file list screen
					$str = $flds[0] . "\t" . $new_conf["TITLE_COMMENT_FILES"];
					$write_flags[$flds[0]] = 0;
					break;
				case "TITLE_COMMENT_EDIT":
					//編集画面のコメント行
					//Comment line of edit display
					$str = $flds[0] . "\t" . $new_conf["TITLE_COMMENT_EDIT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "TITLE_COMMENT_DELETE":
					//削除画面のコメント行
					//Comment line of deletion screen
					$str = $flds[0] . "\t" . $new_conf["TITLE_COMMENT_DELETE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "TITLE_COMMENT_MKDIR":
					//フォルダ作成画面のコメント行
					//Comment line of folder making screen
					$str = $flds[0] . "\t" . $new_conf["TITLE_COMMENT_MKDIR"];
					$write_flags[$flds[0]] = 0;
					break;
				case "TITLE_COMMENT_UPLOAD":
					//アップロード画面のコメント行
					//Comment line of up-loading screen
					$str = $flds[0] . "\t" . $new_conf["TITLE_COMMENT_UPLOAD"];
					$write_flags[$flds[0]] = 0;
					break;
				case "LOGIN_TITLE":
					//ログイン・タイトル
					//Login title
					$str = $flds[0] . "\t" . $new_conf["LOGIN_TITLE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "RETURL1":
					//戻り先URL１
					//URL at return-1 destination
					$str = $flds[0] . "\t" . $new_conf["RETURL1"];
					$str .= "\t" . $new_conf["returntitle1"];
					$write_flags[$flds[0]] = 0;
					break;
				case "RETURL2":
					//戻り先URL情報２
					//URL at return-2 destination
					$str = $flds[0] . "\t" . $new_conf["RETURL2"];
					$str .= "\t" . $new_conf["returntitle2"];
					$write_flags[$flds[0]] = 0;
					break;
				case "FILES_SCRIPT":
					//ファイル一覧スクリプト
					//File list script
					$str = $flds[0] . "\t" . $new_conf["FILES_SCRIPT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "EDIT_SCRIPT":
					//編集スクリプト
					//Edit script
					$str = $flds[0] . "\t" . $new_conf["EDIT_SCRIPT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "DELETE_SCRIPT":
					//削除スクリプト
					//Delete script
					$str = $flds[0] . "\t" . $new_conf["DELETE_SCRIPT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "COPY_SCRIPT":
					//複写スクリプト
					//Copy script
					$str = $flds[0] . "\t" . $new_conf["COPY_SCRIPT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "CUT_SCRIPT":
					//切取りスクリプト
					//Cut script
					$str = $flds[0] . "\t" . $new_conf["CUT_SCRIPT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "PASTE_SCRIPT":
					//貼付けスクリプト
					//Paste script
					$str = $flds[0] . "\t" . $new_conf["PASTE_SCRIPT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "MKDIR_SCRIPT":
					//フォルダ作成スクリプト
					//Folder making script
					$str = $flds[0] . "\t" . $new_conf["MKDIR_SCRIPT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "UPLOAD_SCRIPT":
					//ファイルアップロードスクリプト
					//File up-loading script
					$str = $flds[0] . "\t" . $new_conf["UPLOAD_SCRIPT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "ATTR_SCRIPT":
					//ファイル属性変更スクリプト
					//File attribute change script
					$str = $flds[0] . "\t" . $new_conf["ATTR_SCRIPT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "LOGIN_SCRIPT":
					//ログインスクリプト
					//Login script
					$str = $flds[0] . "\t" . $new_conf["LOGIN_SCRIPT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "PASSWD_SCRIPT":
					//パスワード設定スクリプト
					//Password setting script
					$str = $flds[0] . "\t" . $new_conf["PASSWD_SCRIPT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "GROUP_SCRIPT":
					//グループ設定スクリプト
					//Group setting script
					$str = $flds[0] . "\t" . $new_conf["GROUP_SCRIPT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "CONFMENU_SCRIPT":
					//設定メニュースクリプト
					//Set menu script
					$str = $flds[0] . "\t" . $new_conf["CONFMENU_SCRIPT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "NEWCONF_SCRIPT":
					//共有フォルダ作成スクリプト
					//Shared folder making script
					$str = $flds[0] . "\t" . $new_conf["NEWCONF_SCRIPT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "DELCONF_SCRIPT":
					//共有フォルダ削除スクリプト
					//Shared folder deletion script
					$str = $flds[0] . "\t" . $new_conf["DELCONF_SCRIPT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "MODCONF_SCRIPT":
					//共有フォルダ設定更新スクリプト
					//Shared folder setting update script
					$str = $flds[0] . "\t" . $new_conf["MODCONF_SCRIPT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "DIRLIST_SCRIPT":
					//共有フォルダ一覧スクリプト
					//Shared folder list script
					$str = $flds[0] . "\t" . $new_conf["DIRLIST_SCRIPT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "UPLOAD_CGI":
					//ファイルアップロードCGI
					//File up-loading CGI
					$str = $flds[0] . "\t" . $new_conf["UPLOAD_CGI"];
					$write_flags[$flds[0]] = 0;
					break;
				case "DIR_IMAGE":
					//フォルダイメージ
					//Folder image
					$str = $flds[0] . "\t" . $new_conf["DIR_IMAGE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "UP_IMAGE":
					//上位フォルダイメージ
					//Upper folder image
					$str = $flds[0] . "\t" . $new_conf["UP_IMAGE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "UP_TITLE":
					//上位フォルダへのタイトル文字
					//Title character to upper folder
					$str = $flds[0] . "\t" . $new_conf["UP_TITLE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "EDIT_IMAGE":
					//編集イメージ
					//Edit image
					$str = $flds[0] . "\t" . $new_conf["EDIT_IMAGE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "DELETE_IMAGE":
					//ファイル削除イメージ
					//File deletion image
					$str = $flds[0] . "\t" . $new_conf["DELETE_IMAGE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "COPY_IMAGE":
					//ファイル複写イメージ
					//File copy image
					$str = $flds[0] . "\t" . $new_conf["COPY_IMAGE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "CUT_IMAGE":
					//ファイル切取りイメージ
					//File cutout image
					$str = $flds[0] . "\t" . $new_conf["CUT_IMAGE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "PASTE_IMAGE":
					//ファイル貼付けイメージ
					//File paste image
					$str = $flds[0] . "\t" . $new_conf["PASTE_IMAGE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "BG_IMAGE":
					//背景イメージ
					//Background image
					$str = $flds[0] . "\t" . $new_conf["BG_IMAGE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "BG_COLOR":
					//背景色
					//Background color
					$str = $flds[0] . "\t" . $new_conf["BG_COLOR"];
					$write_flags[$flds[0]] = 0;
					break;
				case "ICONSIZE":
					//アイコンサイズ
					//Size of icon
					$str = $flds[0] . "\t" . $new_conf["ICONSIZE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "ICON_W":
					//アイコンサイズ幅
					//Width of size of icon
					$str = $flds[0] . "\t" . $new_conf["ICON_W"];
					$write_flags[$flds[0]] = 0;
					break;
				case "ICON_H":
					//アイコンサイズ高さ
					//Height of size of icon
					$str = $flds[0] . "\t" . $new_conf["ICON_H"];
					$write_flags[$flds[0]] = 0;
					break;
				case "CALLER_URL":
					//呼び出し元ＵＲＬ
					//Call former URL
					$str = $flds[0] . "\t" . $new_conf["CALLER_URL"];
					$write_flags[$flds[0]] = 0;
					break;
				case "MAX_UPLOAD_SIZE":
					//アップロードファイルのMAXサイズ
					//MAX size of up-loading file
					$str = $flds[0] . "\t" . $new_conf["MAX_UPLOAD_SIZE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "MAX_TOTAL_SIZE":
					//使用容量のMAXサイズ
					//MAX size of use capacity
					$str = $flds[0] . "\t" . $new_conf["MAX_TOTAL_SIZE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "SORT_KEY":
					//デフォルトのソートキー
					//Sorting key to default
					$str = $flds[0] . "\t" . $new_conf["SORT_KEY"];
					$write_flags[$flds[0]] = 0;
					break;
				case "REVERSE_SORT":
					//ソート順
					//The order of sorting
					$str = $flds[0] . "\t" . $new_conf["REVERSE_SORT"];
					$write_flags[$flds[0]] = 0;
					break;
				case "LIST_TITLE_BG":
					//表のタイトル部の背景色
					//Background color of title part of table
					$str = $flds[0] . "\t" . $new_conf["LIST_TITLE_BG"];
					$write_flags[$flds[0]] = 0;
					break;
				case "LIST_HEAD_BG":
					//表のヘッダ部の背景色
					//Background color of header in table
					$str = $flds[0] . "\t" . $new_conf["LIST_HEAD_BG"];
					$write_flags[$flds[0]] = 0;
					break;
				case "LIST_TITLE_BG2":
					//表のタイトル部の背景色２
					//Background color 2 of title part of table
					$str = $flds[0] . "\t" . $new_conf["LIST_TITLE_BG2"];
					$write_flags[$flds[0]] = 0;
					break;
				case "LIST_HEAD_BG2":
					//表のヘッダ部の背景色２
					//Background color 2 of header in table
					$str = $flds[0] . "\t" . $new_conf["LIST_HEAD_BG2"];
					$write_flags[$flds[0]] = 0;
					break;
				case "ADMIN_USERID":
					//管理者ID
					//Manager ID
					$str = $flds[0] . "\t" . $new_conf["ADMIN_USERID"];
					$write_flags[$flds[0]] = 0;
					break;
				case "ADMIN_DEFAULT_PASSWD":
					//管理者のデフォルトパスワード
					//Manager's default password
					$str = $flds[0] . "\t" . $new_conf["ADMIN_DEFAULT_PASSWD"];
					$write_flags[$flds[0]] = 0;
					break;
				case "MD5_PASSWD_USE":
					//パスワードにMD5ハッシュを使用するか
					//Is the MD5 hush used for the password?
					$str = $flds[0] . "\t" . $new_conf["MD5_PASSWD_USE"];
					$write_flags[$flds[0]] = 0;
					break;
				case "DEFAULT_ATTR":
					//デフォルトのパーミッション
					//Permission of default
					$str = $flds[0] . "\t" .
								sprintf("%04o", $new_conf["DEFAULT_ATTR"]);
					$write_flags[$flds[0]] = 0;
					break;
				case "PERMIT_ALL":
					$str = $flds[0] . "\t" . $new_conf["PERMIT_ALL"];
					$write_flags[$flds[0]] = 0;
					break;
				case "CONF_DIR_ATTR":
					$str = $flds[0] . "\t" .
								sprintf("%04o", $new_conf["CONF_DIR_ATTR"]);
					$write_flags[$flds[0]] = 0;
					break;
				case "CONF_FILE_ATTR":
					$str = $flds[0] . "\t" .
								sprintf("%04o", $new_conf["CONF_FILE_ATTR"]);
					$write_flags[$flds[0]] = 0;
					break;
				case "DATA_DIR_ATTR":
					$str = $flds[0] . "\t" .
								sprintf("%04o", $new_conf["DATA_DIR_ATTR"]);
					$write_flags[$flds[0]] = 0;
					break;
				case "DATA_FILE_ATTR":
					$str = $flds[0] . "\t" .
								sprintf("%04o", $new_conf["DATA_FILE_ATTR"]);
					$write_flags[$flds[0]] = 0;
					break;
				case "PWD_FILE_ATTR":
					$str = $flds[0] . "\t" .
								sprintf("%04o", $new_conf["PWD_FILE_ATTR"]);
					$write_flags[$flds[0]] = 0;
					break;
				case "SHOW_HELP_LINK":
					$str = $flds[0] . "\t" . $new_conf["SHOW_HELP_LINK"];
					$write_flags[$flds[0]] = 0;
					break;
				case "toptitle":
				case "ptitleimg_h":
				case "ptitleimg_w":
				case "returntitle1":
				case "returntitle2":
				case "curdir":
				case "returl":
				case "title":
				case "config":
					$write_flags[$flds[0]] = 0;
					break;
				default:
					$str = $buffer;
					break;
				}
			}
		}
		fputs($ofp, "$str\n");
	}
	write_new_keys($conf, $new_conf, $ofp, $write_flags);

	flock($ifp, 3);
	fclose($ifp);

	flock($ofp, 3);
	fclose($ofp);

	chmod($out_fname, get_conf_file_attr($conf));

	if ($tmp_fname != "") {
		unlink($tmp_fname);
	}

	return TRUE;
}

function write_new_keys($conf, $new_conf, $ofp, $write_flags)
{
	$keys = array_keys($write_flags);

	foreach($keys as $key) {
		$str = "";
		if ($write_flags[$key] == 1) {
			switch ($key) {
			case "ENTRY_PAGE_DIR_URL":
			case "SCRIPT_DIR_URL":
			case "DEFAULT_GROUP_FILE":
			case "ptitleimg_w":
			case "ptitleimg_h":
			case "returntitle1":
			case "returntitle2":
			case "ATTR_SCRIPT":
			case "GROUP_SCRIPT":
			case "TOPDIR":
			case "TITLEIMG":
			case "RETURL1":
			case "RETURL2":
			case "DEFAULT_ATTR":
			case "CONF_DIR_ATTR":
			case "CONF_FILE_ATTR":
			case "DATA_DIR_ATTR":
			case "DATA_FILE_ATTR":
			case "PWD_FILE_ATTR":
			case "config":
			case "name":
				break;
			default:
				if (isset($new_conf[$key]) && $new_conf[$key] != "") {
					$str = $key . "\t" . $new_conf[$key];
				} else {
					$str = "";
				}
				break;
			}
			if ($str != "") {
				fputs($ofp, "$str\n");
			}
		}
	}
}

//エントリー・ページ格納ディレクトリ取得
//Getting entry page files storage directory
function get_entry_page_top_dir($conf)
{
	$entry_page_top_dir = $conf["ENTRY_PAGE_TOP_DIR"];
	return $entry_page_top_dir;
}

//エントリー・ページ格納ディレクトリのURL取得
//Getting URL of entry page files storage directory
function get_entry_page_top_url($conf)
{
	//echo "<br>ENTRY_PAGE_TOP_URL=" . $conf["ENTRY_PAGE_TOP_URL"] . "<br>\n";
	$entry_page_top_url = $conf["ENTRY_PAGE_TOP_URL"];
	return $entry_page_top_url;
}

// 共有フォルダ設定の格納用ディレクトリ取得
//Directory acquisition for storage of shared folder setting
function get_conf_top_dir($conf)
{
	$conftop = $conf["CONFIG_TOP_DIR"];
	return $conftop;
}

//設定用のフォルダのパーミッションを得る
function get_conf_dir_attr($conf)
{
	if (strcasecmp($conf["PERMIT_ALL"], "YES") == 0) {
		return 0777;
	}
	return $conf["CONF_DIR_ATTR"];
}

//設定用のファイルのパーミッションを得る
function get_conf_file_attr($conf)
{
	if (strcasecmp($conf["PERMIT_ALL"], "YES") == 0) {
		return 0777;
	}
	return $conf["CONF_FILE_ATTR"];
}

//データ用フォルダのパーミッションを得る
function get_data_dir_attr($conf)
{
	if (strcasecmp($conf["PERMIT_ALL"], "YES") == 0) {
		return 0777;
	}
	return $conf["DATA_DIR_ATTR"];
}

//データファイルのパーミッションを得る
function get_data_file_attr($conf)
{
	if (strcasecmp($conf["PERMIT_ALL"], "YES") == 0) {
		return 0666;
	}
	return $conf["DATA_FILE_ATTR"];
}

//パスワードファイルのパーミッションを得る
function get_pwd_file_attr($conf)
{
	if (strcasecmp($conf["PERMIT_ALL"], "YES") == 0) {
		return 0666;
	}
	return $conf["PWD_FILE_ATTR"];
}

//BODYの背景色／背景イメージの設定文字列取得
//Acquisition of set string of background color/background image of BODY
function get_body_bg_str($conf)
{
	$bg_str = "";

	if ($conf["BG_COLOR"] != "") {
		$bg_str .= " bgColor=" . $conf["BG_COLOR"];
	}
	if ($conf["BG_IMAGE"] != "") {
		$bg_str .= " background=";
		if ($conf["IMGDIR"] != "") {
			$bg_str .= $conf["IMGDIR"] . "/";
		}
		$bg_str .= $conf["BG_IMAGE"];
	}
	return $bg_str;
}

//呼び出し元URLのチェック
//Call former URL check
function referer_url_check($conf, $referer_url, $block_flg, $default)
{
	if (isset($default)) {
		$acess_flg = $default;
	} else {
		$acess_flg = TRUE;
	}

	if ($conf["CALLER_URL"] != "") {
		if (stristr($referer_url, $conf["SCRIPT_DIR_URL"])) {
			$acess_flg = TRUE;
		} else {
			if (!isset($referer_url) || $referer_url == "") {
				$acess_flg = FALSE;
			} else {
				$acess_flg = FALSE;
				$ref_url_list = explode(",", $conf["CALLER_URL"]);
				foreach($ref_url_list as $ref_url) {
					if (stristr($referer_url, $ref_url)) {
						$acess_flg = TRUE;
						break;
					}
				}
			}
		}
	}
	if ($acess_flg == FALSE && $block_flg == TRUE) {
		$bgstr = get_body_bg_str($conf);
		echo "<HTML><HEAD>\n";
		echo "<TITLE>" . $conf["title"] . "</TITLE></HEAD>";
		echo "<BODY " . $bgstr . ">";
		echo "<B>[&nbsp;&nbsp;" . $conf["title"] . "&nbsp;&nbsp;]<BR><BR>\n";
		echo "could not access" . "<BR>\n";
		echo "please confirm permission" . "<BR><BR></B>\n";
		echo "<A HREF=\"" . $referer_url . "\">" . $referer_url . "</A>\n";
		echo "</BODY></HTML>\n";
		exit;
	}
	return $acess_flg;
}

function get_login_user()
{
	return get_session_value("LOGIN_USER");
}

//ログイン・チェック
//Login check
function login_check($conf)
{
	//パスワードファイルとログインスクリプトがセットされているか
	//Are the password file and the login script set?
	if (isset($conf["PASSWD_FILE"]) && $conf["PASSWD_FILE"] != "" &&
			isset($conf["LOGIN_SCRIPT"]) && $conf["LOGIN_SCRIPT"] != "") {
		//セッション変数をチェック
		//The session variable is checked.
		$login_user = get_login_user();
		if (!(isset($login_user) && $login_user != "")) {
			//セッション変数がセットされていない
			//The session variable is not set.
			return FALSE;
		}
	}
	return TRUE;
}

// JavaScriptを使ってログイン画面にリダイレクトするHTML文字列を取得
//HTML redirected to the login screen by using JavaScript is acquired.
function get_redirect_login_JavaScriptHTML($conf)
{
	$title = $conf["HEADER_TITLE"];
	$script = $conf["LOGIN_SCRIPT"];
	$config = $conf["config"];
	$returl = $conf["returl"];
	$s_name = files_session_name();
	$s_id = session_id();

	$html = <<<__END_OF_DATA__
<HTML>
<HEAD>
<TITLE>$title</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!--
function start() {
	document.form1.submit();
}
// -->
</SCRIPT>
</HEAD>
<BODY onLoad="start()">
<form name="form1" action="$script" method="post">
	<input type="hidden" name="config" value="$config">
	<input type="hidden" name="returl" value="$returl">
	<input type="hidden" name="$s_name" value="$s_id">
</form>
</BODY>
</HTML>
__END_OF_DATA__;

	return $html;
}

function put_log($conf, $msg)
{
	if ($conf["OUTPUT_LOG"] != 1) {
		return TRUE;
	}
	$remote_addr = get_env_val("REMOTE_ADDR");

	$user = get_login_user();

	$access = date("Y/m/d H:i:s");
	$logmsg = "$access $remote_addr $user $msg\n";

	// ログファイル書き込みオープン
	//Log file writing opening
	if (($fp = fopen ($conf["LOGFILE"], "a"))) {
		flock($fp, 2);

   		// ログを記録する
		//The log is recorded.
		fputs($fp, $logmsg);

		flock($fp, 3);
		fclose($fp);

		return TRUE;
	}
	return FALSE;
}

function put_dbg_log($conf, $msg)
{
	if ($GLOBALS["DEBUG_LOG"]) {
		return put_log($conf, $msg);
	}
	return TRUE;
}

function put_info_log($conf, $msg)
{
	$remote_addr = get_env_val("REMOTE_ADDR");

	$user = get_login_user();

	openlog("files", LOG_PID | LOG_PERROR, LOG_LOCAL0);

    // ログを記録する
	//The log is recorded.
    $access = date("Y/m/d H:i:s");
    syslog(LOG_INFO, "$access $remote_addr $user $msg");

	closelog();
}

function get_user_agent_type()
{
	$user_agent = get_env_val("HTTP_USER_AGENT");

	$browser_type = "ANY";

	if (isset($user_agent) && $user_agent != "") {
		if (stristr($user_agent, "MSIE")) {
			$browser_type = "MSIE";
		} elseif (stristr($user_agent, "Firefox")) {
			$browser_type = "FIREFOX";
		} elseif (stristr($user_agent, "Opera")) {
			$browser_type = "OPERA";
		} elseif (stristr($user_agent, "Safari")) {
			$browser_type = "SAFARI";
		}
	}
	return $browser_type;
}

function init_files($login_page)
{
	if (version_compare(phpversion(), "4.4.0") < 0) {
		ini_set("session.save_handler", "files");
	}
	session_name(files_session_name());
	session_start();

	$http_referer = get_env_val("HTTP_REFERER");
	$remote_user = get_env_val("REMOTE_USER");

	$returl = get_post_get_val("returl");
	$config = get_post_get_val("config");
	$dir = get_post_get_val("dir");

	$save_conf_path = get_session_value("CONFIG_FNAME");
	if (isset($save_conf_path) && $save_conf_path != "") {
		$conffile = $save_conf_path;
	} else {
		$conffile = "./config/files.conf";
	}
	if (isset($config) && $config != "") {
		$conffile = $config;
	}
	$topdir = getcwd();

	if (isset($remote_user)) {
		$user = $remote_user;
	}

	// 設定ファイル読み込み
	//Configuration file reading
	$conf = read_conf_file($conffile);

	if (isset($config) && $config != "") {
		$conf["config"] = get_filename($config);
	}
	if (isset($returl) && $returl != "") {
		$conf["returl"] = $returl;
	}
	if (isset($conf["TOPDIR"])) {
		$topdir = $conf["TOPDIR"];
	}
	if (!isset($conf["CUTDIR"]) || $conf["CUTDIR"] == "") {
		$conf["CUTDIR"] = ".cutdir";
	}

	//フルパスを得る
	//The full path is obtained.
	$topdir = realpath($topdir);

	$conf["config"] = $conffile;
	if (isset($dir)) {
		$conf["curdir"] = $dir;
	} else {
		$conf["curdir"] = "";
	}
	$curdir = realpath($conf["curdir"]);

	// カレントディレクトリ名からファイル名を取り出す
	//The file name is taken out of the current directory name.
	$curdir = make_path($conf["TOPDIR"], $conf["curdir"], "");

	$conf["title"] = get_filename($curdir);
	$conf["uptime"] = date("Y/m/d H:i:s", filemtime($curdir));

	$conf_path = realpath($conf["config"]);

	$allow_user ="";

	//セッション確立時と設定ファイルが違っていないかチェック
	//It checks whether neither the session establishment nor the 
	//configuration file are different.
	if ($save_conf_path != $conf_path) {
		$change_config = get_session_value("CHANGE_CONFIG_FILE");
		if (isset($change_config) &&
					strcmp("TRUE", $change_config) == 0) {
			$allow_user = get_session_value("ALLOW_USER");
		} else {
			set_session_value("ALLOW_USER", "");
			set_session_value("LOGIN_USER", "");
		}
	} else {
		$allow_user = get_session_value("ALLOW_USER");
	}

	set_session_value("CONFIG_FNAME", $conf_path);
	$session = FALSE;
	if (isset($allow_user)) {
		if (strncmp("123", $allow_user, 3) == 0) {
			$session = TRUE;
		}
	}
	if (! $session) {
		//セッション変数がセットされていない（ログインが未だ）
		//The session variable is not set. (Not logged it in yet. )
		$return_url = "";
		if ($returl != "") {
			$return_url = $returl;
		}
		//if ($return_url != "") {
			set_session_value("RETURN_URL", $return_url);
		//}

		//呼び出し元URLのチェック
		//Call former URL check
		if (!(isset($conf["CALLER_URL"]) && $conf["CALLER_URL"] != "" &&
				referer_url_check($conf, $http_referer, FALSE, TRUE))) {
			//無条件に許可されているサイトからの呼び出しではない
			//It is not a call from the site that has been 
			//unconditionally permitted.
			if (!login_check($conf)) {
				//未だログインしていない
				//It has not logged it in yet.
				if ($login_page != TRUE) {
					//ログインページでないならログインページにジャンプ
					//It jumps to the login page if it is not a login page.
					echo get_redirect_login_JavaScriptHTML($conf);
					exit;
				}
				//グローバル変数にセットする
				set_config($conf);

				return $conf;
			}
		}
		set_session_value("ALLOW_USER", "123");
	}

	$conf["returl"] = get_session_value("RETURN_URL");

	//グローバル変数にセットする
	set_config($conf);

	//HTMLの前にヘッダとして文字コードを出力する
	$charset = get_charset();
	header("Content-Type: text/html;charset=$charset");

	return $conf;
}
?>
