﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace FontEdit
{
	public partial class FormFontInfo : Form
	{
		public FontInfo m_FontInf;
		public int m_nWidth;
		public int m_nHeight;
		public int m_nLineBytes;
		public int m_nXoffset;
		public int m_nYoffset;

		public FormFontInfo()
		{
			InitializeComponent();

			m_FontInf.sFoundry = "Misc";
			m_FontInf.sFamily = "Fixed";
			m_FontInf.sWeight = "Medium";
			m_FontInf.sSlant = "R";
			m_FontInf.sSetwidth = "Normal";
			m_FontInf.sSpacing = "M";
			m_FontInf.sCharset = "ISO8859";
			m_nWidth = 24;
			m_nHeight = 24;
			m_nLineBytes = 3;
			m_nXoffset = 0;
			m_nYoffset = 0;
		}

		private void FormFontInfo_Load(object sender, EventArgs e)
		{
			textBoxFoundry.Text = m_FontInf.sFoundry;
			textBoxFamily.Text = m_FontInf.sFamily;
			textBoxWeight.Text = m_FontInf.sWeight;
			textBoxSlant.Text = m_FontInf.sSlant;
			textBoxSetwidth.Text = m_FontInf.sSetwidth;
			textBoxSpacing.Text = m_FontInf.sSpacing;
			textBoxCharset.Text = m_FontInf.sCharset;

			textBoxWidth.Text = m_nWidth.ToString();
			textBoxHeight.Text = m_nHeight.ToString();
			textBoxLineBytes.Text = m_nLineBytes.ToString();
			textBoxXoff.Text = m_nXoffset.ToString();
			textBoxYoff.Text = m_nYoffset.ToString();
		}

		private void btn_OK_Click(object sender, EventArgs e)
		{
			int width;
			int height;
			int lineBytes;
			int bytes;
			int xoff, yoff;

			width = int.Parse(textBoxWidth.Text);
			height = int.Parse(textBoxHeight.Text);
			lineBytes = int.Parse(textBoxLineBytes.Text);
			xoff = int.Parse(textBoxXoff.Text);
			yoff = int.Parse(textBoxYoff.Text);

			bytes = width / 8;
			if (width % 8 > 0)
			{
				bytes++;
			}
			if (width <= 0 || height <= 0 || bytes > lineBytes)
			{
				Console.Beep(1000, 500);
				textBoxWidth.Text = m_nWidth.ToString();
				textBoxHeight.Text = m_nHeight.ToString();
				textBoxLineBytes.Text = m_nLineBytes.ToString();
				return;
			}
			if (xoff < 0 || width <= xoff)
			{
				textBoxXoff.Text = m_nXoffset.ToString();
				return;
			}
			if (yoff < 0 || height <= yoff)
			{
				textBoxYoff.Text = m_nYoffset.ToString();
				return;
			}
			m_nWidth = width;
			m_nHeight = height;
			m_nLineBytes = lineBytes;
			m_nXoffset = int.Parse(textBoxXoff.Text);
			m_nYoffset = int.Parse(textBoxYoff.Text);

			m_FontInf.sFoundry = textBoxFoundry.Text;
			m_FontInf.sFamily = textBoxFamily.Text;
			m_FontInf.sWeight = textBoxWeight.Text;
			m_FontInf.sSlant = textBoxSlant.Text;
			m_FontInf.sSetwidth = textBoxSetwidth.Text;
			m_FontInf.sSpacing = textBoxSpacing.Text;
			m_FontInf.sCharset = textBoxCharset.Text;

			this.DialogResult = DialogResult.OK;
			Close();
		}

		private void btn_Cancel_Click(object sender, EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			Close();
		}
	}
}
