﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace FontEdit
{
	public partial class FormRange : Form
	{
		public string m_sMsg;
		public int m_nStartIdx;
		public int m_nEndIdx;

		public FormRange()
		{
			InitializeComponent();

			m_sMsg = "Prease Input Range.";
			m_nStartIdx = 0;
			m_nEndIdx = 0;
		}

		private void FormRange_Load(object sender, EventArgs e)
		{
			labelMessage.Text = m_sMsg;
			textBoxStartIdx.Text = m_nStartIdx.ToString();
			textBoxEndIdx.Text = m_nEndIdx.ToString();
		}

		private void btnOK_Click(object sender, EventArgs e)
		{
			int start = int.Parse(textBoxStartIdx.Text);
			int end = int.Parse(textBoxEndIdx.Text);
			if (start < 0)
			{
				textBoxStartIdx.Text = m_nStartIdx.ToString();
				return;
			}
			if (end < 0)
			{
				textBoxEndIdx.Text = m_nEndIdx.ToString();
				return;
			}
			if (start > end)
			{
				m_nStartIdx = end;
				m_nEndIdx = start;
			}
			else
			{
				m_nStartIdx = start;
				m_nEndIdx = end;
			}
			this.DialogResult = DialogResult.OK;
			Close();
		}

		private void btnCancel_Click(object sender, EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			Close();
		}
	}
}
