﻿using System;
using System.IO;
using System.Text;
using System.Runtime.InteropServices;

class CIniFile
{
	[DllImport("KERNEL32.DLL")]
	public static extern int GetPrivateProfileString(string lpSection, string lpKey,
													string lpDefault, StringBuilder lpResult,
													int nSize, string lpFileName);

	[DllImport("KERNEL32.DLL")]
	public static extern int GetPrivateProfileInt(string lpSection, string lpKey,
													int nDefault, string lpFileName);

	[DllImport("KERNEL32.DLL")]
	public static extern int WritePrivateProfileString(string lpSection, string lpKey,
													string lpString, string lpFileName);

	string	m_strIniFile;

	public CIniFile(string fileName) {
		m_strIniFile = fileName;
	}

	public string	GetStrValue(string section, string key, string dflt_str) {
		StringBuilder sb = new StringBuilder(512);

		GetPrivateProfileString(section, key, dflt_str, sb, sb.Capacity, m_strIniFile);

		return sb.ToString();
	}

	public int	GetIntValue(string section, string key, int dflt_val) {
		int	val;

		val = GetPrivateProfileInt(section, key, dflt_val, m_strIniFile);

		return val;
	}

	public void	SetStrValue(string section, string key, string val) {
		WritePrivateProfileString(section, key, val, m_strIniFile);
	}

	public void	SetIntValue(string section, string key, int val) {
		WritePrivateProfileString(section, key, val.ToString(), m_strIniFile);
	}

}
