////////////////////////////////////////////////////////////////////////
// PictSvr.cpp
////////////////////////////////////////////////////////////////////////

#include	<windows.h>
#include	<windowsx.h>
#include	<scrnsave.h>
#include	<time.h>
#include	<atlimage.h>
#include	<commctrl.h>
#include	<shlobj.h>
#include	"resource.h"

#define			TIMER_ID			(32767)
#define			BLEND_TIMER_ID		(32766)
#define			MAX_PICTURE_FILES	(256)		//ő摜t@C
#define			MAX_MONITOR_NUM		(256)		//őʐ

#define			INI_SECTION_NAME	"Setting"
#define			IMAGE_FILE_FILTER	"All Image File(*.jpg;*.jpeg;*.bmp;*.gif;*.png;*.tif;*.tiff)\0*.jpg;*.jpeg;*.bmp;*.gif;*.png;*.tif;*.tiff\0JPEG(*.jpg;*.jpeg)\0*.jpg;*.jpeg\0BITMAP(*.bmp)\0*.bmp\0GIF(*.gif)\0*.gif\0PNG(*.png)\0*.png\0TIFF(*.tif;*.tiff)\0*.tif;*.tiff\0All files(*.*)\0*.*\0\0"

//ݒ荀
static UINT		nInterval = 10;					//\XVԊuibj
static UINT		nBlendInterval = 100;			//uh̕`XVԊui~bj
static char		szCnfPictureFiles[MAX_PICTURE_FILES][MAX_PATH];	//摜t@C̔z
static char		szPictureFiles[MAX_PICTURE_FILES][MAX_PATH];	//摜t@C̔z
static char		szEditFile[MAX_PATH];			//ҏWt@C
static int		nFilterIdx = 1;					//摜t@CĨftHg̃tB^CfbNX
static char		szDefaultDir[MAX_PATH];			//摜t@CĨftHgfBNg
static int		nOrgSizeRatio = 1;				//̏cێ
static int		nSeparateMonitor = 1;			//ʖɉ摜\		
static int		nSamePicture = 0;				//Sʂɓ摜\
static int		nFontSize = 48;					//摜ꍇ̎\̕TCY
static COLORREF	TextColor = RGB(255, 255, 255);	//\̕F
static BOOL		bAlphaBlend = TRUE;				//tF[h\L^
static BOOL		bSlidePicture = TRUE;			//摜ŕ\
static BOOL		bSearchDir = FALSE;				//wfBNg̉摜t@C\

//̑
static int		nConfPictureFileNum = 0;		//摜t@C̐
static int		nPictureFileNum = 0;			//摜t@C̐
static UINT		nTimerID = 0;					//ݒ肳ꂽ^C}ID
static UINT		nBlendTimerID = 0;				//ݒ肳ꂽ^C}ID
static BOOL		bIntervalChangeFlag = FALSE;	//XVԊu̕ύXtO
static RECT		MonitorRect[MAX_MONITOR_NUM];	//j^`̈
static SIZE		MaxMonitorSize;					//ő僂j^TCY
static int		nPictureIdx[MAX_MONITOR_NUM];	//j^̉摜CfbNX
static int		MonitorNum = 0;					//j^
static int		BlendPercent = 0;				//tF[h\pAt@uh̃p[Ze[W
static int		BlendPitch = 2;					//tF[h\̃p[Ze[Wsb`

static HDC		hMemDC = NULL;
static HBITMAP	hMemBmp = NULL;
static HBITMAP	hOldMemBmp = NULL;

int GetModuleName(char *name, int max_len)
{
	char	module_fname[MAX_PATH];

	GetModuleFileName(hMainInstance, module_fname, sizeof(module_fname) - 1);
	
	_splitpath_s(module_fname, NULL, 0, NULL, 0, name, max_len, NULL, 0);

	return strlen(name);
}

int GetModuleDir(char *dir, int max_len)
{
	char	module_fname[MAX_PATH];
	char	full_path[MAX_PATH];
	char	*pFile;

	GetModuleFileName(hMainInstance, module_fname, sizeof(module_fname) - 1);
	GetFullPathName(module_fname, sizeof(full_path), full_path, &pFile);
	if (pFile) {
		*pFile = NULL;
	}
	strncpy_s(dir, max_len - 1, full_path, max_len - 1);
	dir[max_len - 1] = NULL;

	return strlen(dir);
}

void	GetIniFileName(char *ini_filename, int max_len)
{
	char	module_dir[MAX_PATH];
	char	module_name[MAXFILELEN];

	GetModuleDir(module_dir, sizeof(module_dir));
	GetModuleName(module_name, sizeof(module_name));

	sprintf_s(ini_filename, max_len, "%s%s.ini", module_dir, module_name);
}

//ݒt@Cǂݍ
void	LoadConfig()
{
	char	key[32];
	char	buf[MAX_PATH];
	char	szIniFile[MAX_PATH];
	int		i;

	GetIniFileName(szIniFile, sizeof(szIniFile));

	//\̃tHgTCY
	sprintf_s(buf, sizeof(buf), "%d", nFontSize);
	GetPrivateProfileString(INI_SECTION_NAME, "FONTSIZE", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val > 0) {
			nFontSize = val; 
		}
	}

	//摜̍XVԊuibŎwj
	sprintf_s(buf, sizeof(buf), "%d", nInterval);
	GetPrivateProfileString(INI_SECTION_NAME, "INTERVAL", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val > 0) {
			nInterval = val; 
		}
	}

	//̏cێ邩
	sprintf_s(buf, sizeof(buf), "%d", nOrgSizeRatio);
	GetPrivateProfileString(INI_SECTION_NAME, "ORG_SIZE_RETIO", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val <= 0) {
			nOrgSizeRatio = 0;
		} else {
			nOrgSizeRatio = 1;
		}
	}

	//tF[h\̗L^
	sprintf_s(buf, sizeof(buf), "%d", (bAlphaBlend ? 1 : 0));
	GetPrivateProfileString(INI_SECTION_NAME, "FADE_IN", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val <= 0) {
			bAlphaBlend = FALSE;
		} else {
			bAlphaBlend = TRUE;
		}
	}

	//ʖɉ摜\
	sprintf_s(buf, sizeof(buf), "%d", nSeparateMonitor);
	GetPrivateProfileString(INI_SECTION_NAME, "SEPARATE_MONITOR", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val <= 0) {
			nSeparateMonitor = 0;
		} else {
			nSeparateMonitor = 1;
		}
	}

	//Sʂɓ摜\
	sprintf_s(buf, sizeof(buf), "%d", nSamePicture);
	GetPrivateProfileString(INI_SECTION_NAME, "DISP_SAME_PICTURE", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val <= 0) {
			nSamePicture = 0;
		} else {
			nSamePicture = 1;
		}
	}

	//摜ŕ\
	sprintf_s(buf, sizeof(buf), "%d", (bSlidePicture ? 1 : 0));
	GetPrivateProfileString(INI_SECTION_NAME, "SLIDE_PICTURE", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val <= 0) {
			bSlidePicture = FALSE;
		} else {
			bSlidePicture = TRUE;
		}
	}

	//t@CI_CAÕftHgfBNg
	GetPrivateProfileString(INI_SECTION_NAME, "DEFAULT_DIR", "", buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		strncpy_s(szDefaultDir, sizeof(szDefaultDir), buf, sizeof(szDefaultDir) - 1);
		szDefaultDir[sizeof(szDefaultDir) - 1] = '\0';
	}

	//t@CI_CAÕftHg̃tB^̃CfbNX
	sprintf_s(buf, sizeof(buf), "%d", nFilterIdx);
	GetPrivateProfileString(INI_SECTION_NAME, "FILE_FILTER_INDEX", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val > 0) {
			nFilterIdx = val;
		}
	}

	//INIt@Cݒ肳ꂽt@C擾
	nConfPictureFileNum = 0;
	for (i = 0; i < MAX_PICTURE_FILES; i++) {
		sprintf_s(key, sizeof(key), "PICTURE_FILE_%03d", i + 1);

		buf[0] = '\0';
		GetPrivateProfileString(INI_SECTION_NAME, key, "", buf, sizeof(buf), szIniFile);
		if (!buf[0]) {
			break;
		}
		//e[uɒǉ
		strncpy_s(&szCnfPictureFiles[nConfPictureFileNum][0], MAX_PATH, buf, MAX_PATH - 1);
		nConfPictureFileNum++;
	}
}

//ݒt@Cۑ
void	SaveConfig()
{
	int		i;
	char	key[32];
	char	buf[256];
	char	szIniFile[MAX_PATH];
	char	*bufp;

	GetIniFileName(szIniFile, sizeof(szIniFile));

	//\̃tHgTCY
	sprintf_s(buf, sizeof(buf), "%d", nFontSize);
	WritePrivateProfileString(INI_SECTION_NAME, "FONTSIZE", buf, szIniFile);

	//摜̍XVԊuibŎwj
	sprintf_s(buf, sizeof(buf), "%d", nInterval);
	WritePrivateProfileString(INI_SECTION_NAME, "INTERVAL", buf, szIniFile);

	//̏cێ邩
	sprintf_s(buf, sizeof(buf), "%d", nOrgSizeRatio);
	WritePrivateProfileString(INI_SECTION_NAME, "ORG_SIZE_RETIO", buf, szIniFile);

	//tF[h\̗L^
	sprintf_s(buf, sizeof(buf), "%d", (bAlphaBlend ? 1 : 0));
	WritePrivateProfileString(INI_SECTION_NAME, "FADE_IN", buf, szIniFile);

	//ʖɉ摜\
	sprintf_s(buf, sizeof(buf), "%d", nSeparateMonitor);
	WritePrivateProfileString(INI_SECTION_NAME, "SEPARATE_MONITOR", buf, szIniFile);

	//Sʂɓ摜\
	sprintf_s(buf, sizeof(buf), "%d", nSamePicture);
	WritePrivateProfileString(INI_SECTION_NAME, "DISP_SAME_PICTURE", buf, szIniFile);

	//摜ŕ\
	sprintf_s(buf, sizeof(buf), "%d", (bSlidePicture ? 1 : 0));
	WritePrivateProfileString(INI_SECTION_NAME, "SLIDE_PICTURE", buf, szIniFile);

	//t@CI_CAÕftHgfBNg
	WritePrivateProfileString(INI_SECTION_NAME, "DEFAULT_DIR", szDefaultDir, szIniFile);

	//t@CI_CAÕftHg̃tB^̃CfbNX
	sprintf_s(buf, sizeof(buf), "%d", nFilterIdx);
	WritePrivateProfileString(INI_SECTION_NAME, "FILE_FILTER_INDEX", buf, szIniFile);

	//INIt@Cɐݒ肳ꂽt@Cۑ
	for (i = 0; i < MAX_PICTURE_FILES; i++) {
		sprintf_s(key, sizeof(key), "PICTURE_FILE_%03d", i + 1);
		if (i < nConfPictureFileNum) {
			bufp = szCnfPictureFiles[i];
		} else {
			bufp = NULL;
		}
		WritePrivateProfileString(INI_SECTION_NAME, key, bufp, szIniFile);
	}
}

BOOL AddPictureFile(int idx,  LPCTSTR lpFileName)
{
	CImage	Image;

	//C[Wt@CƂă[hł邩`FbN
	if (Image.Load(lpFileName) == 0) {
		Image.Destroy();

		strncpy_s(&szPictureFiles[idx][0], MAX_PATH - 1, lpFileName, MAX_PATH - 1);
		szPictureFiles[idx][MAX_PATH - 1] = '\0';

		return TRUE;
	}
	return FALSE;
}

//tH_摜t@C̃Xgǉ
int	AddPictureFileFromDir(int idx, LPCTSTR lpFolder, LPCTSTR lpPattern)
{
	int				count;
	char			buf[MAX_PATH];
	HANDLE			hFind;
	WIN32_FIND_DATA FindFileData;

	if (!lpFolder || !(*lpFolder)) {
		return 0;
	}

	if (lpPattern && *lpPattern) {
		sprintf_s(buf, sizeof(buf), "%s\\%s", lpFolder, lpPattern);
	} else {
		sprintf_s(buf, sizeof(buf), "%s\\%s", lpFolder, "*.*");
	}
	count = 0;

	hFind = FindFirstFile(buf, &FindFileData);
	if (hFind != INVALID_HANDLE_VALUE) {
		char	fname[MAX_PATH];
		CImage	Image;

		do {
			if (strncmp(FindFileData.cFileName, ".", 2) != 0 &&
						strncmp(FindFileData.cFileName, "..", 3) != 0) {
				//tpXgݗĂ
				sprintf_s(fname, sizeof(fname), "%s\\%s", lpFolder, FindFileData.cFileName);

				//fBNgł͂Ȃ
				if ((GetFileAttributes(fname) & FILE_ATTRIBUTE_DIRECTORY)) {
					int	num = AddPictureFileFromDir(idx, fname, lpPattern);
					count += num;
					idx += num;
					if (idx >= MAX_PICTURE_FILES) {
						break;
					}
				} else {
					//C[Wt@CƂă[hł邩`FbNđ}
					if (AddPictureFile(idx, fname)) {
						count++;
						idx++;
						if (idx >= MAX_PICTURE_FILES) {
							break;
						}
					}
				}
			}
		} while (FindNextFile(hFind, &FindFileData));

		FindClose(hFind);
	}
	return count;
}

//C[WXg̃`FbN
int	SetImageFileList()
{
	if (nConfPictureFileNum <= 0) {
		return 0;
	}
	int		i;
	int		count;
	char	*fname;
	char	*pat;
	DWORD	dwAttr;
	int		idx = 0;

	for (i = 0; i < nConfPictureFileNum; i++) {
		pat = NULL;
		fname =  szCnfPictureFiles[i];
		dwAttr = GetFileAttributes(fname);

		if (dwAttr == (DWORD)-1) {
			char buf[MAX_PATH];
			if (GetFullPathName(fname, sizeof(buf), buf, &pat) > 0) {
				if (pat) {
					if (strchr(pat, '*') || strchr(pat, '?')) {
						if (*(pat - 1) == '\\') {
							*(pat - 1) = '\0';
						}
						strncpy_s(fname, sizeof(fname), buf, sizeof(fname) - 1);
					}
				}
			}
		}
		if (GetFileAttributes(fname) & FILE_ATTRIBUTE_DIRECTORY) { //fBNg̏ꍇ
			//tH_摜t@C̃Xgǉ
			count = AddPictureFileFromDir(idx, fname, pat);
			if (count > 0) {
				idx+= count;
			}
		} else {
			if (AddPictureFile(idx, fname)) {
				idx++;
			}
		}
	}
	nPictureFileNum = idx;

	return nPictureFileNum;
}

//EnumDisplayMonitors̃R[obN
BOOL CALLBACK MonitorEnumProc(HMONITOR hMonitor, HDC hdcMonitor,
										LPRECT lprcMonitor, LPARAM dwData)
{
	int	max_num = sizeof(MonitorRect) / sizeof(MonitorRect[0]);

	if (MonitorNum < max_num) {
		int	w, h;
		MonitorRect[MonitorNum] = *lprcMonitor;

		w = MonitorRect[MonitorNum].right - MonitorRect[MonitorNum].left;
		h = MonitorRect[MonitorNum].bottom - MonitorRect[MonitorNum].top;
		if (w > MaxMonitorSize.cx) {
			MaxMonitorSize.cx = w;
		}
		if (h > MaxMonitorSize.cy) {
			MaxMonitorSize.cy = h;
		}
		MonitorNum++;
		return TRUE;
	}
	return FALSE;
}

void	GetMonitorRect(HWND hWnd)
{
	MonitorNum = 0;
	MaxMonitorSize.cx = 0;
	MaxMonitorSize.cy = 0;

	if (!EnumDisplayMonitors (NULL, NULL, MonitorEnumProc, NULL)) {
		GetClientRect(hWnd, &MonitorRect[0]);
		MaxMonitorSize.cx = MonitorRect[0].right - MonitorRect[0].left; 
		MaxMonitorSize.cy = MonitorRect[0].bottom - MonitorRect[0].top; 
		MonitorNum = 1;
	}
}

BOOL	DrawPicture(HDC hDC, LPRECT lpRect, int PictIdx)
{
	BOOL	bDrawFlag = FALSE;	//`ς݃tO
	char	buf[256];

	int		nWidth = lpRect->right - lpRect->left;
	int		nHeight = lpRect->bottom - lpRect->top;

	//摜t@Cݒ肳Ă邩
	if (nPictureFileNum > 0) {
		CImage	Image;

		//C[Wt@C[hărbg}bv쐬
		if (Image.Load(szPictureFiles[PictIdx]) == 0) {
			//ǂݍ񂾃rbg}bṽTCY擾
			int src_w = Image.GetWidth();
			int src_h = Image.GetHeight();
			int dst_w = nWidth;
			int dst_h = nHeight;
			int x = lpRect->left;
			int	y = lpRect->top;
			int	frm_w = 0;
			int frm_h = 0;

			//cێ邩
			if (nOrgSizeRatio) {
				//c̃TCYvZ
				double x1 = (double)dst_w / (double)src_w;
				double x2 = (double)dst_h / (double)src_h;
				if (x1 < x2) {
					dst_w = (int)(src_w * x1);
					dst_h = (int)(src_h * x1);
				} else {
					dst_w = (int)(src_w * x2);
					dst_h = (int)(src_h * x2);
				}
				//\ʒuvZ
				if (dst_w < nWidth) {
					frm_w = (nWidth - dst_w) / 2;
					x = lpRect->left + frm_w;
				}
				if (dst_h < nHeight) {
					frm_h = (nHeight - dst_h) / 2;
					y = lpRect->top + frm_h;
				}
			}
			if (x > lpRect->left || y > lpRect->top) {
				if (hMemDC) {
					//]ꍇ͍œhԂ
					HBRUSH hOldBrush = (HBRUSH)SelectObject(hMemDC, GetStockObject(BLACK_BRUSH));
					Rectangle(hMemDC, 0, 0, MaxMonitorSize.cx, MaxMonitorSize.cy);

					//hԂɃC[W`
					StretchBlt(hMemDC, frm_w, frm_h, dst_w, dst_h, Image.GetDC(), 0, 0, src_w, src_h, SRCCOPY);

					//GetDCŎ擾foCX ReLXg
					Image.ReleaseDC(); 
					SelectObject(hMemDC, hOldBrush);
				} else {
					if (!bAlphaBlend || BlendPercent == 0) {
						HBRUSH hOldBrush = (HBRUSH)SelectObject(hDC, GetStockObject(BLACK_BRUSH));
						if (frm_w > 0) {
							Rectangle(hDC, lpRect->left, lpRect->top, x, lpRect->bottom);
							Rectangle(hDC, lpRect->right - frm_w, lpRect->top, lpRect->right, lpRect->bottom);
						}
						if (frm_h > 0) {
							Rectangle(hDC, lpRect->left, lpRect->top, lpRect->right, y);
							Rectangle(hDC, lpRect->left, lpRect->bottom - frm_h, lpRect->right, lpRect->bottom);
						}
						SelectObject(hDC, hOldBrush);
					}
				}
			} else {
				if (hMemDC) {
					StretchBlt(hMemDC, 0, 0, dst_w, dst_h, Image.GetDC(), 0, 0, src_w, src_h, SRCCOPY);
					//GetDCŎ擾foCX ReLXg
					Image.ReleaseDC(); 
				}
			}
			//ʂɃRs[
			if (bAlphaBlend && BlendPercent < 100) {
				BLENDFUNCTION blendFunc;

				blendFunc.BlendOp = AC_SRC_OVER;
				blendFunc.BlendFlags = 0;
				//blendFunc.AlphaFormat = AC_SRC_ALPHA;
				blendFunc.AlphaFormat = 0;
				blendFunc.SourceConstantAlpha = (BlendPercent * 255 / 100);

				if (hMemDC) {
					AlphaBlend(hDC, lpRect->left, lpRect->top, nWidth, nHeight,
									hMemDC, 0, 0, nWidth, nHeight, blendFunc);
				} else {
					AlphaBlend(hDC, x, y, dst_w, dst_h,
								Image.GetDC(), 0, 0, src_w, src_h, blendFunc);
					//GetDCŎ擾foCX ReLXg
					Image.ReleaseDC(); 
				}
#if	0
				sprintf_s(buf, sizeof(buf), "BlendPercent=%3d, SourceConstantAlpha=%3d", BlendPercent, blendFunc.SourceConstantAlpha);
				TextOut(hDC, 0, 0, buf, strlen(buf));
#endif
			} else {
				if (hMemDC) {
					StretchBlt(hDC, lpRect->left, lpRect->top, nWidth, nHeight, hMemDC, 0, 0, nWidth, nHeight, SRCCOPY);
				} else {
					StretchBlt(hDC, x, y, dst_w, dst_h, Image.GetDC(), 0, 0, src_w, src_h, SRCCOPY);
					//GetDCŎ擾foCX ReLXg
					Image.ReleaseDC(); 
				}
			}
			//rbg}bvj
			Image.Destroy();

			bDrawFlag = TRUE;
		}
	}
	//`悳Ȃꍇ͎\
	if (!bDrawFlag) {
		SIZE		sz;
		HFONT		hFont, hOldFont = NULL;
		time_t		t;
		struct tm	st;

		hFont = CreateFont(nFontSize, nFontSize / 2, 0, 0,
								FW_BOLD, FALSE, FALSE, FALSE, DEFAULT_CHARSET,
								OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
								DEFAULT_PITCH | FF_DONTCARE, NULL);

		if (hFont) {
			hOldFont = (HFONT)SelectObject(hDC, hFont);
		}

		//œhԂ
		HBRUSH hOldBrush = (HBRUSH)SelectObject(hDC, GetStockObject(BLACK_BRUSH));

		Rectangle(hDC, 0, 0, nWidth, nHeight);

		time(&t);

		localtime_s(&st, &t);
		sprintf_s(buf, sizeof(buf), "%04d/%02d/%02d %02d:%02d:%02d",
					st.tm_year + 1900, st.tm_mon + 1, st.tm_mday,
					st.tm_hour, st.tm_min, st.tm_sec);

		GetTextExtentPoint32(hDC, buf, strlen(buf), &sz);

		int			OldBkMode = SetBkMode(hDC, TRANSPARENT);;
		COLORREF	OldTextColor = SetTextColor(hDC, TextColor);

		TextOut(hDC, (nWidth / 2) - (sz.cx / 2), (nHeight / 2) - (sz.cy / 2), buf, strlen(buf));

		SetTextColor(hDC, OldTextColor);
		SetBkMode(hDC, OldBkMode);

		if (hOldFont) {
			SelectObject(hDC, hOldFont);
		}
		if (hFont) {
			DeleteObject(hFont);
		}
		SelectObject(hDC, hOldBrush);
	}
	return bDrawFlag;
}

//ʂ̕`
void	Draw(HWND hWnd)
{
	HDC	hDC;

	//XN[̃foCXReLXg𓾂
	hDC = GetDC(hWnd);
	if (hDC) {
		SetStretchBltMode(hDC, COLORONCOLOR);

		if (!hMemDC) {
			hMemDC = CreateCompatibleDC(hDC);
			if (hMemDC) {
				hMemBmp = CreateCompatibleBitmap(hDC, MaxMonitorSize.cx, MaxMonitorSize.cy);
				if (!hMemBmp) {
					DeleteDC(hMemDC);
					hMemDC = NULL;
				} else {
					hOldMemBmp = (HBITMAP)SelectObject(hMemDC, hMemBmp);
					SetStretchBltMode(hMemDC, COLORONCOLOR);
				}
			}
		}
		if (nSeparateMonitor) {	//ʖɉ摜\
			int	i;

			GetMonitorRect(hWnd);

			for (i = 0; i < MonitorNum; i++) {
				if (nSamePicture) {
					DrawPicture(hDC, &MonitorRect[i], nPictureIdx[0]);
				} else {
					if (DrawPicture(hDC, &MonitorRect[i], nPictureIdx[i])) {
						//ʖɈقȂ摜\ꍇ
						if (!bAlphaBlend || BlendPercent >= 100) {
							if (bSlidePicture) {
								nPictureIdx[i]++;
							} else {
								nPictureIdx[i] += MonitorNum;
							}
							if (nPictureIdx[i] >= nPictureFileNum) {
								nPictureIdx[i] %= nPictureFileNum;
							}
						}
					}
				}
			}
			if (nSamePicture) {
				//Sʂœ摜\ꍇ
				if (!bAlphaBlend || BlendPercent >= 100) {
					nPictureIdx[0]++;
					if (nPictureIdx[0] >= nPictureFileNum) {
						nPictureIdx[0] = 0;
					}
				}
			}
		} else {
			RECT	rect;

			//ʃTCY擾
			GetClientRect(hWnd, &rect);

			if (DrawPicture(hDC, &rect, nPictureIdx[0])) {
				if (!bAlphaBlend || BlendPercent >= 100) {
					nPictureIdx[0]++;
					if (nPictureIdx[0] >= nPictureFileNum) {
						nPictureIdx[0] = 0;
					}
				}
			}
		}
		ReleaseDC(hWnd, hDC);
	}
}

//摜t@CXgɃZbg
BOOL SetFileToList(HWND hListWnd, int idx, LPCTSTR lpFileName, BOOL bReplace)
{
	CImage	Image;

	//C[Wt@CƂă[hł邩`FbN
	if (Image.Load(lpFileName) == 0) {
		Image.Destroy();

		if (idx < 0) {
			bReplace = FALSE;

			idx = ListBox_GetCount(hListWnd);
			if (idx >= MAX_PICTURE_FILES) {
				return FALSE;
			}
		} else {
			if (bReplace) {
				ListBox_DeleteString(hListWnd, idx);
			}
		}
		//[hł摜t@CXgɑ}
		ListBox_InsertString(hListWnd, idx, lpFileName);

		return TRUE;
	}
	return FALSE;
}

//摜tH_XgɃZbg
BOOL SetDirToList(HWND hListWnd, int idx, LPCTSTR lpFolder, LPCTSTR lpPattern, BOOL bReplace)
{
	if (!lpFolder || !(*lpFolder)) {
		return FALSE;
	}
	if (idx < 0) {
		bReplace = FALSE;

		//}ʒu̎w肪Ȃꍇ̓Jg̑Iʒuɑ}
		idx = ListBox_GetCount(hListWnd);
		if (idx >= MAX_PICTURE_FILES) {
			return FALSE;
		}
	} else {
		if (bReplace) {
			ListBox_DeleteString(hListWnd, idx);
		}
	}
	char	buf[MAX_PATH];
	if (lpPattern && *lpPattern) {
		sprintf_s(buf, sizeof(buf), "%s\\%s", lpFolder, lpPattern);
	} else {
		sprintf_s(buf, sizeof(buf), "%s", lpFolder);
	}
	//[hł摜t@CXgɑ}
	ListBox_InsertString(hListWnd, idx, buf);

	return TRUE;
}

//摜t@C̓tH_XgɃZbg
void	SetItemToList(HWND hListWnd, int idx, LPCTSTR pszFname, BOOL bReplace)
{
	char	fname[MAX_PATH];
	char	*pat;

	strncpy_s(fname, sizeof(fname), pszFname, sizeof(fname));

	pat = NULL;
	if (GetFileAttributes(fname) == (DWORD)-1) {
		char buf[MAX_PATH];
		if (GetFullPathName(fname, sizeof(buf), buf, &pat) > 0) {
			if (pat) {
				if (strchr(pat, '*') || strchr(pat, '?')) {
					if (*(pat - 1) == '\\') {
						*(pat - 1) = '\0';
					}
					strncpy_s(fname, sizeof(fname), buf, sizeof(fname) - 1);
				}
			}
		}
	}
	if (GetFileAttributes(fname) & FILE_ATTRIBUTE_DIRECTORY) { //fBNg̏ꍇ
		//摜t@C̃tH_XgɃZbg
		SetDirToList(hListWnd, idx, fname, pat, bReplace);
	} else {
		//C[Wt@CƂă[hł邩`FbNđ}
		SetFileToList(hListWnd, idx, fname, bReplace);
	}
}

int	CALLBACK BrowseCallbackProc(HWND hWnd, UINT nMsg, LPARAM lParam, LPARAM lpData)
{
    if (nMsg == BFFM_INITIALIZED) {
        SendMessage(hWnd, BFFM_SETSELECTION, (WPARAM)TRUE, lpData);
    }
    return 0;
}

//XN[Z[o[EbZ[W
LRESULT WINAPI ScreenSaverProc(HWND hWnd, UINT nMsg, WPARAM wParam, LPARAM lParam)
{
	switch (nMsg) {
	case WM_CREATE:
		{
			int	i, idx;

			hMemDC = NULL;
			hMemBmp = NULL;
			hOldMemBmp = NULL;

			//ݒt@Cǂݍ
			LoadConfig();

			SetImageFileList();

			if ((nInterval * 1000 / 2) < (100 / BlendPitch) * nBlendInterval) {
				BlendPitch = 100 / ((nInterval * 1000 / 2) / nBlendInterval);
			}
			GetMonitorRect(hWnd);

			for (i = 0, idx = 0; i < MonitorNum; i++) {
				nPictureIdx[i] = idx++;
				if (idx >= nPictureFileNum) {
					idx = 0;
				}
			}
			//̕`s
			if (bAlphaBlend) {
				BlendPercent = 0;
				nBlendTimerID = SetTimer(hWnd, BLEND_TIMER_ID, nBlendInterval, NULL);
			}
			InvalidateRect(hWnd, NULL, FALSE);

			//摜XV^C}N
			bIntervalChangeFlag = FALSE;
			nTimerID = SetTimer(hWnd, TIMER_ID, nInterval * 1000, NULL);
		}
		break;
	case WM_TIMER:
		if ((UINT)wParam == nBlendTimerID) {
			BlendPercent += BlendPitch;
			if (BlendPercent >= 100) {
				KillTimer(hWnd, nBlendTimerID);
				nBlendTimerID = 0;
			}
			InvalidateRect(hWnd, NULL, FALSE);
		} else {
			//`XVs
			if (bAlphaBlend) {
				BlendPercent = 0;
				nBlendTimerID = SetTimer(hWnd, BLEND_TIMER_ID, nBlendInterval, NULL);
			}
			InvalidateRect(hWnd, NULL, FALSE);

			//`XVԊuύXĂ^C}ZbgȂ
			if (bIntervalChangeFlag) {
				if (nTimerID) {
					KillTimer(hWnd, nTimerID);
				}
				nTimerID = SetTimer(hWnd, TIMER_ID, nInterval * 1000, NULL);
				bIntervalChangeFlag = FALSE;
			}
		}
		return 0;
	case WM_PAINT:
		//`XVs
		Draw(hWnd);
		break;
	case WM_DESTROY:
		//^C}~
		if (nTimerID) {
			KillTimer(hWnd, nTimerID);
		}
		if (hMemDC) {
			if (hMemBmp) {
				if (hOldMemBmp) {
					SelectObject(hMemDC, hOldMemBmp);
					hOldMemBmp = NULL;
				}
			}
			DeleteDC(hMemDC);
			hMemDC = NULL;

			if (hMemBmp) {
				DeleteObject(hMemBmp);
				hMemBmp = NULL;
			}
		}
		//ݒt@Cۑ
		SaveConfig();

		PostQuitMessage(0);

		return 0;
	default:
		break;
	}
	return DefScreenSaverProc(hWnd, nMsg, wParam, lParam);
}

//ҏW_CAO
INT_PTR CALLBACK EditDialogProc(HWND hwndDlg,
							UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	UINT	uiCmd;
	HWND	hParentWnd = GetParent(hwndDlg);

	switch (uMsg) {
	case WM_INITDIALOG:
		//lGfBbgRg[ɃZbg
		SetDlgItemText(hwndDlg, IDC_EDIT_PICTURE_FILE, szEditFile);
		break;
	case WM_COMMAND:
		uiCmd = (UINT)LOWORD(wParam);
		switch (uiCmd) {
		case IDOK:
			GetDlgItemText(hwndDlg, IDC_EDIT_PICTURE_FILE, szEditFile, sizeof(szEditFile));
			if (!szEditFile[0]) {
				return 0;
			}
			EndDialog(hwndDlg, IDOK);
			break;
		case IDCANCEL:
			EndDialog(hwndDlg, IDCANCEL);
			break;
		case IDC_BUTTON_UPDATE:
			GetDlgItemText(hwndDlg, IDC_EDIT_PICTURE_FILE, szEditFile, sizeof(szEditFile));
			if (!szEditFile[0]) {
				return 0;
			}
			EndDialog(hwndDlg, IDC_BUTTON_UPDATE);
			break;
		case IDC_BTN_PICTURE_FILE_REF:
			{
				char			buf[256];
				char			fname[MAX_PATH];
				char			strTitle[256];
				OPENFILENAME	ofn;

				buf[0] = '\0';
				fname[0] = '\0';

				LoadString((HINSTANCE)GetModuleHandle(NULL), IDS_STR_SELECT_IMAGE_FILE, strTitle, sizeof(strTitle)-1);

				memset(&ofn, 0, sizeof(OPENFILENAME));

				ofn.lStructSize = sizeof(OPENFILENAME);
				ofn.hwndOwner = hwndDlg;
				ofn.lpstrFilter = IMAGE_FILE_FILTER;
				ofn.nFilterIndex = nFilterIdx;
				ofn.lpstrInitialDir = szDefaultDir;
				ofn.lpstrFile = fname;
				ofn.lpstrFileTitle = buf;
				ofn.nMaxFile = MAX_PATH;
				ofn.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
				ofn.lpstrDefExt = "bmp";
				ofn.lpstrTitle = strTitle;

				if (GetOpenFileName(&ofn)) {
					CImage Image;

					TCHAR	dir[MAX_PATH];
					TCHAR	*pf;

					nFilterIdx = ofn.nFilterIndex;

					if (GetFullPathName(fname, sizeof(dir) / sizeof(TCHAR), dir, &pf) > 0) {
						if (pf) {
							*pf = NULL;
						}
						strncpy_s(szDefaultDir, sizeof(szDefaultDir), dir, sizeof(szDefaultDir) - 1);
					}

					//C[Wt@CƂă[hł邩`FbN
					if (Image.Load(fname) == 0) {
						Image.Destroy();

						//GfBbgRg[ɃZbg
						SetDlgItemText(hwndDlg, IDC_EDIT_PICTURE_FILE, fname);
					}
				}
			}
			break;
		case IDC_BTN_DIR_SEL:
			{
				BROWSEINFO		inf;
				ITEMIDLIST		*pItmList = NULL;
				char			szFolder[MAX_PATH];
				char			strTitle[256];

				LoadString((HINSTANCE)GetModuleHandle(NULL), IDS_STR_SELECT_IMAGE_FOLDER, strTitle, sizeof(strTitle)-1);

				inf.hwndOwner      = hwndDlg;
				inf.pidlRoot       = NULL;
				inf.pszDisplayName = szFolder;
				inf.lpszTitle      = strTitle;
				inf.ulFlags        = BIF_RETURNONLYFSDIRS;
				inf.lpfn		   = BrowseCallbackProc;
				inf.lParam         = (LPARAM)szDefaultDir;
				inf.iImage         = 0;

				//tH_I_CAO
				pItmList = SHBrowseForFolder(&inf);
				if (pItmList) {
					//tH_擾
					if (SHGetPathFromIDList(pItmList, szFolder)) {
						//ITEMIDLIST̉
						CoTaskMemFree(pItmList);

						//GfBbgRg[ɃZbg
						SetDlgItemText(hwndDlg, IDC_EDIT_PICTURE_FILE, szFolder);

						//ftHgfBNgɃZbg
						strncpy_s(szDefaultDir, sizeof(szDefaultDir), szFolder, sizeof(szDefaultDir) - 1);
						szDefaultDir[sizeof(szDefaultDir) - 1] = '\0';
					}
				}
			}
			break;
		}
	}
	return 0;
}

//ݒ_CAO
BOOL	WINAPI ScreenSaverConfigureDialog(HWND hDlg, UINT nMsg, WPARAM wParam, LPARAM lParam)
{
	UINT	uiCmd; 

	switch (nMsg) {
	case WM_INITDIALOG:
		{
			HWND	hWnd;
			int		i;

			//ݒt@Cǂݍ
			LoadConfig();

			//XVԊu\
			SetDlgItemInt(hDlg, IDC_EDIT_INTERVAL, (UINT)nInterval, FALSE);

			//XVԊũXsRg[͈̔͂ݒ
			hWnd = GetDlgItem(hDlg, IDC_SPIN_INTERVAL);
			lParam = (LPARAM)MAKELONG(3600, 1);
			SendMessage(hWnd, UDM_SETRANGE, (WPARAM)0, lParam);

			//c̔䗦ێ邩
			hWnd = GetDlgItem(hDlg, IDC_CHECK_ORG_RATIO);
			Button_SetCheck(hWnd, nOrgSizeRatio);

			//tF[h\̗L^
			hWnd = GetDlgItem(hDlg, IDC_CHECK_ALPHA_BLEND);
			Button_SetCheck(hWnd, bAlphaBlend);

			//ʂƂɉ摜\
			hWnd = GetDlgItem(hDlg, IDC_CHECK_SEPARATE_MONITOR);
			Button_SetCheck(hWnd, nSeparateMonitor);

			//摜\
			hWnd = GetDlgItem(hDlg, IDC_CHECK_SAME_PICTURE);
			Button_SetCheck(hWnd, nSamePicture);

			//摜ŕ\
			hWnd = GetDlgItem(hDlg, IDC_CHECK_SLIDE);
			Button_SetCheck(hWnd, bSlidePicture);

			//Xgɉ摜t@CZbg
			hWnd = GetDlgItem(hDlg, IDC_LIST_PICTURE_FILE);
			for (i = 0; i < nConfPictureFileNum; i++) {
				//SendMessage(hWnd, LB_INSERTSTRING, (WPARAM)i, (LPARAM)szCnfPictureFiles[i]);
				ListBox_InsertString(hWnd, i, szCnfPictureFiles[i]);
			}
		}
		break;
	case WM_COMMAND:
		uiCmd = (UINT)LOWORD(wParam);
		switch (uiCmd) {
		case IDOK:
			{
				UINT	uiVal;
				BOOL	bStatus;
				HWND	hWnd;
				int		i, count;

				//XVԊuZbg
				uiVal = GetDlgItemInt(hDlg, IDC_EDIT_INTERVAL, &bStatus, FALSE);
				if (!bStatus || (uiVal <= 0 || 3600 < uiVal)) {
					SetDlgItemInt(hDlg, IDC_EDIT_INTERVAL, (UINT)nInterval, FALSE);
					return TRUE;
				}
				if (nInterval != uiVal) {
					nInterval = uiVal;
					bIntervalChangeFlag = TRUE;
				}
				if ((nInterval * 1000) < (100 / BlendPitch) * nBlendInterval) {
					BlendPitch = (nInterval * 1000) / nBlendInterval;
				}

				//c̔䗦ێ邩
				hWnd = GetDlgItem(hDlg, IDC_CHECK_ORG_RATIO);
				nOrgSizeRatio = Button_GetCheck(hWnd);

				//tF[h\̗L^
				hWnd = GetDlgItem(hDlg, IDC_CHECK_ALPHA_BLEND);
				bAlphaBlend = (Button_GetCheck(hWnd) == 1 ? TRUE : FALSE);

				//ʂƂɉ摜\
				hWnd = GetDlgItem(hDlg, IDC_CHECK_SEPARATE_MONITOR);
				nSeparateMonitor = Button_GetCheck(hWnd);

				//摜\
				hWnd = GetDlgItem(hDlg, IDC_CHECK_SAME_PICTURE);
				nSamePicture = Button_GetCheck(hWnd);

				//摜ŕ\
				hWnd = GetDlgItem(hDlg, IDC_CHECK_SLIDE);
				bSlidePicture = (Button_GetCheck(hWnd) == 1 ? TRUE : FALSE);

				//Xg摜t@C擾
				hWnd = GetDlgItem(hDlg, IDC_LIST_PICTURE_FILE);
				count = ListBox_GetCount(hWnd);

				memset(szCnfPictureFiles, 0, sizeof(szCnfPictureFiles));
				nConfPictureFileNum = 0;

				for (i = 0; i < count; i++) {
					//t@C擾
					ListBox_GetText(hWnd, i, szCnfPictureFiles[i]);
					nConfPictureFileNum++;
				}
				//ݒt@Cۑ
				SaveConfig();

				EndDialog(hDlg, IDOK);
			}
			break;
		case IDCANCEL:
			EndDialog(hDlg, IDCANCEL);
			break;
		case IDC_BTN_ADD_FILE:
			{
				char			buf[256];
				char			fname[MAX_PATH * 256];
				char			strTitle[256];
				OPENFILENAME	ofn;

				buf[0] = '\0';
				fname[0] = '\0';

				LoadString((HINSTANCE)GetModuleHandle(NULL), IDS_STR_SELECT_IMAGE_FILE, strTitle, sizeof(strTitle)-1);

				memset(&ofn, 0, sizeof(OPENFILENAME));

				ofn.lStructSize = sizeof(OPENFILENAME);
				ofn.hwndOwner = hDlg;
				ofn.lpstrFilter = IMAGE_FILE_FILTER;
				ofn.nFilterIndex = nFilterIdx;
				ofn.lpstrInitialDir = szDefaultDir;
				ofn.lpstrFile = fname;
				ofn.lpstrFileTitle = buf;
				ofn.nMaxFile = MAX_PATH;
				ofn.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_EXPLORER | OFN_ALLOWMULTISELECT;
				ofn.lpstrDefExt = "bmp";
				ofn.lpstrTitle = strTitle;

				if (GetOpenFileName(&ofn)) {
					CImage	Image;
					TCHAR	dir[MAX_PATH];
					TCHAR	path[MAX_PATH];
					TCHAR	*pf;
					HWND	hWnd;
					int		idx, count;

					hWnd = GetDlgItem(hDlg, IDC_LIST_PICTURE_FILE);

					count = ListBox_GetCount(hWnd);

					if (count >= MAX_PICTURE_FILES) {
						return TRUE;
					}
					idx = (int)ListBox_GetCurSel(hWnd);
					if (idx < 0) {
						idx = count;
					}
					nFilterIdx = ofn.nFilterIndex;

					if ((pf = strchr(fname, '\0')) || (pf = strchr(fname, ' '))) {
						TCHAR	*pFname;
						TCHAR	sepa = *pf;

						*pf = '\0';
						if (GetFileAttributes(fname) & FILE_ATTRIBUTE_DIRECTORY) { //fBNg̏ꍇ
							strncpy_s(dir, sizeof(dir), fname, sizeof(dir) - 1);

							pFname = pf + 1;
							while(*pFname) {
								if ((pf = strchr(pFname, sepa))) {
									*pf = '\0';
								}
								sprintf_s(path, sizeof(path), "%s\\%s", dir, pFname);

								//C[Wt@CƂă[hł邩`FbN
								if (Image.Load(path) == 0) {
									Image.Destroy();

									//C[Wt@CƂă[hł邩`FbNđ}
									SetFileToList(hWnd, idx, path, FALSE);
								}
								pFname = pf + 1;
							}
							strncpy_s(szDefaultDir, sizeof(szDefaultDir), dir, sizeof(szDefaultDir) - 1);
						} else {
							if (GetFullPathName(fname, sizeof(dir) / sizeof(TCHAR), dir, &pf) > 0) {
								if (pf) {
									*pf = NULL;
								}
								strncpy_s(szDefaultDir, sizeof(szDefaultDir), dir, sizeof(szDefaultDir) - 1);
							}
							//C[Wt@CƂă[hł邩`FbN
							if (Image.Load(fname) == 0) {
								Image.Destroy();

								//C[Wt@CƂă[hł邩`FbNđ}
								SetFileToList(hWnd, idx, fname, FALSE);
							}
						}
					}
				}
			}
			break;
		case IDC_BTN_ADD_DIR:
			{
				HWND	hWnd;
				int		idx, count;

				//XgBOX
				hWnd = GetDlgItem(hDlg, IDC_LIST_PICTURE_FILE);

				count = ListBox_GetCount(hWnd);

				if (count >= MAX_PICTURE_FILES) {
					return TRUE;
				}
				idx = (int)ListBox_GetCurSel(hWnd);
				if (idx < 0) {
					idx = count;
				}

				BROWSEINFO		inf;
				ITEMIDLIST		*pItmList = NULL;
				char			szFolder[MAX_PATH];
				char			strTitle[256];

				LoadString((HINSTANCE)GetModuleHandle(NULL), IDS_STR_SELECT_IMAGE_FOLDER, strTitle, sizeof(strTitle)-1);

				inf.hwndOwner      = hDlg;
				inf.pidlRoot       = NULL;
				inf.pszDisplayName = szFolder;
				inf.lpszTitle      = strTitle;
				inf.ulFlags        = BIF_RETURNONLYFSDIRS;
				inf.lpfn		   = BrowseCallbackProc;
				inf.lParam         = (LPARAM)szDefaultDir;
				inf.iImage         = 0;

				//tH_I_CAO
				pItmList = SHBrowseForFolder(&inf);
				if (pItmList) {
					//tH_擾
					if (SHGetPathFromIDList(pItmList, szFolder)) {
						//ITEMIDLIST̉
						CoTaskMemFree(pItmList);

						//tH_摜t@C̃Xgǉ
						SetDirToList(hWnd, idx, szFolder, NULL, FALSE);

						strncpy_s(szDefaultDir, sizeof(szDefaultDir), szFolder, sizeof(szDefaultDir) - 1);
						szDefaultDir[sizeof(szDefaultDir) - 1] = '\0';
					}
				}
			}
			break;
		case IDC_BTN_EDIT:
			{
				HWND	hWnd;
				int		idx;

				//XgBOX
				hWnd = GetDlgItem(hDlg, IDC_LIST_PICTURE_FILE);

				idx = (int)ListBox_GetCurSel(hWnd);
				if (idx < 0) {
					return TRUE;
				}
				//Ώۃt@C擾
				ListBox_GetText(hWnd, idx, szEditFile);

				LRESULT res = DialogBox(hMainInstance, MAKEINTRESOURCE(IDD_EDIT_DLG), hDlg, EditDialogProc);
			
				switch ((UINT)res) {
				case IDOK:
					//XgɃZbg
					SetItemToList(hWnd, idx, szEditFile, FALSE);
					break;
				case IDCANCEL:
					break;
				case IDC_BUTTON_UPDATE:
					//XgɃZbg
					SetItemToList(hWnd, idx, szEditFile, TRUE);
					break;
				}
			}
			break;
		case IDC_BTN_DEL:
			{
				HWND	hWnd;
				int		idx, count;
				char	fname[MAX_PATH];

				//Xg摜t@C폜
				hWnd = GetDlgItem(hDlg, IDC_LIST_PICTURE_FILE);
				idx = (int)ListBox_GetCurSel(hWnd);
				if (idx < 0) {
					return TRUE;
				}
				//Ώۃt@C擾
				ListBox_GetText(hWnd, idx, fname);

				//摜t@CXg폜
				ListBox_DeleteString(hWnd, idx);

				count = ListBox_GetCount(hWnd);

				if (idx >= count) {
					idx--;
				}
				if (idx >= 0) {
					ListBox_SetCurSel(hWnd, idx);
				}
			}
			break;
		case IDC_BTN_CLEAR:
			{
				HWND	hWnd;

				hWnd = GetDlgItem(hDlg, IDC_LIST_PICTURE_FILE);

				ListBox_ResetContent(hWnd);
			}
			break;
		default:
			break;
		}
		break;
	case WM_HELP:
		{
			HELPINFO *pHelpInfo = (LPHELPINFO)lParam;
			if (pHelpInfo->iContextType == HELPINFO_WINDOW) {
				switch (pHelpInfo->iCtrlId) {
				case IDC_EDIT_INTERVAL:				//XVԊu(GfBbgRg[)
				case IDC_SPIN_INTERVAL:				//XVԊu(Xs{^)
					break;
				case IDC_CHECK_ORG_RATIO:			//̉摜̏cێ(`FbNBOX)
					break;
				case IDC_CHECK_ALPHA_BLEND:			//tF[h\(`FbNBOX)
					break;
				case IDC_CHECK_SEPARATE_MONITOR:	//ʂƂɂP̉摜\(`FbNBOX)
					break;
				case IDC_CHECK_SAME_PICTURE:		//摜\(`FbNBOX)
					break;
				case IDC_CHECK_SLIDE:				//摜ŕ\(`FbNBOX)
					break;
				case IDC_BTN_ADD_FILE:				//t@Cǉ({^)
					break;
				case IDC_BTN_ADD_DIR:				//tH_ǉ({^)
					break;
				case IDC_BTN_EDIT:					//ҏW({^)
					break;
				case IDC_BTN_DEL:					//폜({^)
					break;
				case IDC_BTN_CLEAR:					//ׂč폜({^)
					break;
				case IDC_LIST_PICTURE_FILE:			//摜t@Cꗗ(Xg)
					break;
				case IDOK:							//OK({^)
					break;
				case IDCANCEL:						//LZ({^)
					break;
				default:
					break;
				}
			}
		}
		break;
	default:
		return FALSE;
		break;
	}
	return TRUE;
} 

BOOL	WINAPI RegisterDialogClasses(HANDLE hInst)
{
    DialogBox((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_CONFIG_DIALOG), 0, ScreenSaverConfigureDialog);

	return TRUE;
}
