////////////////////////////////////////////////////////////////////////
// PictSvr.cpp
////////////////////////////////////////////////////////////////////////

#include	<windows.h>
#include	<windowsx.h>
#include	<scrnsave.h>
#include	<time.h>
#include	<atlimage.h>
#include	<commctrl.h>
#include	<shlobj.h>
#include	"resource.h"

#define		TIMER_ID			(32767)
#define		BLEND_TIMER_ID		(32766)
#define		MAX_PICTURE_FILES	(1024)		//ő摜t@C
#define		MAX_MONITOR_NUM		(256)		//őʐ
#define		TEXT_MARGIN			(4)
#define		DEFAULT_FONT_SIZE	(16)		//ftHg̃tHgTCY

#define		INI_SECTION_NAME	"Setting"
#define		IMAGE_FILE_FILTER	"All Image File(*.jpg;*.jpeg;*.bmp;*.gif;*.png;*.tif;*.tiff)\0*.jpg;*.jpeg;*.bmp;*.gif;*.png;*.tif;*.tiff\0JPEG(*.jpg;*.jpeg)\0*.jpg;*.jpeg\0BITMAP(*.bmp)\0*.bmp\0GIF(*.gif)\0*.gif\0PNG(*.png)\0*.png\0TIFF(*.tif;*.tiff)\0*.tif;*.tiff\0All files(*.*)\0*.*\0\0"

enum {
	IMAGE_TYPE_JPEG = 0,
	IMAGE_TYPE_BMP,
	IMAGE_TYPE_GIF,
	IMAGE_TYPE_PNG,
	IMAGE_TYPE_TIFF
};

//ݒ荀
static UINT		nInterval = 10;					//\XVԊuibj
static UINT		nBlendInterval = 100;			//uh̕`XVԊui~bj
static char		szCnfPictureFiles[MAX_PICTURE_FILES][MAX_PATH];	//摜t@C̔z
static char		szPictureFiles[MAX_PICTURE_FILES][MAX_PATH];	//摜t@C̔z
static char		szEditFile[MAX_PATH];			//ҏWt@C
static int		nFilterIdx = 1;					//摜t@CĨftHg̃tB^CfbNX
static char		szDefaultDir[MAX_PATH];			//摜t@CĨftHgfBNg
static int		nOrgSizeRatio = 1;				//̏cێ
static int		nOrgSize = 0;					//̃TCYŕ\
static int		nSeparateMonitor = 1;			//ʖɉ摜\		
static int		nSamePicture = 0;				//Sʂɓ摜\
static int		nFontSize = 48;					//摜ꍇ̎\̕TCY
static COLORREF	TextColor = RGB(255, 255, 255);	//\̕F
static BOOL		bAlphaBlend = TRUE;				//tF[h\L^
static BOOL		bSlidePicture = TRUE;			//摜ŕ\
static BOOL		bSearchDir = FALSE;				//wfBNg̉摜t@C\
static BOOL		bShowFileName = FALSE;			//t@C\
static BOOL		bSpecifiedSize = TRUE;			//TCYwON/OFF
static SIZE		SpecifiedSize = { 160, 120 };	//wTCY
static int		nWidthCond = 1;					//TCY 0=v 1=ȏ 2=ȉ
static int		nHeightCond = 1;				//cTCY 0=v 1=ȏ 2=ȉ

static LOGFONT	lfFileNameFont;					//摜t@C\tHg
static COLORREF	FontColor = RGB(255,255,255);	//tHgF

//tH_̉摜^Cvi0=JPEG 1=BMP 2=GIF 3=PNG 4=TIFFj
static BOOL		bEnableImageType[] = { TRUE, TRUE, TRUE, TRUE, TRUE };

//̑
static int		nConfPictureFileNum = 0;		//摜t@C̐
static int		nPictureFileNum = 0;			//摜t@C̐
static UINT		nTimerID = 0;					//ݒ肳ꂽ^C}ID
static UINT		nBlendTimerID = 0;				//ݒ肳ꂽ^C}ID
static BOOL		bIntervalChangeFlag = FALSE;	//XVԊu̕ύXtO
static RECT		MonitorRect[MAX_MONITOR_NUM];	//j^`̈
static SIZE		MaxMonitorSize;					//ő僂j^TCY
static int		nPictureIdx[MAX_MONITOR_NUM];	//j^̉摜CfbNX
static int		MonitorNum = 0;					//j^
static int		BlendPercent = 0;				//tF[h\pAt@uh̃p[Ze[W
static int		BlendPitch = 2;					//tF[h\̃p[Ze[Wsb`

static HDC		hMemDC = NULL;
static HBITMAP	hMemBmp = NULL;
static HBITMAP	hOldMemBmp = NULL;

//vO𓾂
int GetModuleName(char *name, int max_len)
{
	char	module_fname[MAX_PATH];

	GetModuleFileName(hMainInstance, module_fname, sizeof(module_fname) - 1);
	
	_splitpath_s(module_fname, NULL, 0, NULL, 0, name, max_len, NULL, 0);

	return strlen(name);
}

//vŐNfBNg𓾂
int GetModuleDir(char *dir, int max_len)
{
	char	module_fname[MAX_PATH];
	char	full_path[MAX_PATH];
	char	*pFile;

	GetModuleFileName(hMainInstance, module_fname, sizeof(module_fname) - 1);
	GetFullPathName(module_fname, sizeof(full_path), full_path, &pFile);
	if (pFile) {
		*pFile = NULL;
	}
	strncpy_s(dir, max_len - 1, full_path, max_len - 1);
	dir[max_len - 1] = NULL;

	return strlen(dir);
}

//vŐNfBNgINIt@C𓾂
void	GetIniFileName(char *ini_filename, int max_len)
{
	char	module_dir[MAX_PATH];
	char	module_name[MAXFILELEN];

	GetModuleDir(module_dir, sizeof(module_dir));
	GetModuleName(module_name, sizeof(module_name));

	sprintf_s(ini_filename, max_len, "%s%s.ini", module_dir, module_name);
}

//ݒt@Cǂݍ
void	LoadConfig()
{
	char	key[32];
	char	buf[MAX_PATH];
	char	szIniFile[MAX_PATH];
	int		i, val;

	memset(&lfFileNameFont, 0, sizeof(lfFileNameFont));

	lfFileNameFont.lfCharSet = DEFAULT_CHARSET;
	lfFileNameFont.lfHeight = DEFAULT_FONT_SIZE;
	lfFileNameFont.lfWeight = FW_NORMAL;
	lfFileNameFont.lfItalic = 0;

	GetIniFileName(szIniFile, sizeof(szIniFile));

	//\̃tHgTCY
	val = GetPrivateProfileInt(INI_SECTION_NAME, "FONTSIZE", nFontSize, szIniFile);
	if (val > 0) {
		nFontSize = val; 
	}
	//摜t@C\̃tHgTCY
	val = GetPrivateProfileInt(INI_SECTION_NAME, "FILENAME_FONT_SIZE", lfFileNameFont.lfHeight, szIniFile);
	if (val != 0) {
		if (val < 0) {
			val *= -1;
		}
		lfFileNameFont.lfHeight = val; 
	}
	//摜t@C\̃tHg
	GetPrivateProfileString(INI_SECTION_NAME, "FILENAME_FONT_NAME", "", buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		strncpy_s(lfFileNameFont.lfFaceName, sizeof(lfFileNameFont.lfFaceName), buf, sizeof(lfFileNameFont.lfFaceName));
	}
	//摜t@C\̃tHg
	val = GetPrivateProfileInt(INI_SECTION_NAME, "FILENAME_FONT_WEIGHT", lfFileNameFont.lfWeight, szIniFile);
	if (val >= 0) {
		lfFileNameFont.lfWeight = val; 
	}
	//摜t@C\̃tHgΑ
	val = GetPrivateProfileInt(INI_SECTION_NAME, "FILENAME_FONT_ITALIC", lfFileNameFont.lfItalic, szIniFile);
	if (val >= 0) {
		lfFileNameFont.lfItalic = val; 
	}
	//摜t@C\̃tHg
	val = GetPrivateProfileInt(INI_SECTION_NAME, "FILENAME_FONT_UNDERLINE", lfFileNameFont.lfUnderline, szIniFile);
	if (val >= 0) {
		lfFileNameFont.lfUnderline = val; 
	}
	//摜t@C\̃tHg
	val = GetPrivateProfileInt(INI_SECTION_NAME, "FILENAME_FONT_STRIKEOUT", lfFileNameFont.lfStrikeOut, szIniFile);
	if (val >= 0) {
		lfFileNameFont.lfStrikeOut = val; 
	}
	//摜t@C\̃tHgF
	sprintf_s(buf, sizeof(buf), "%02x%02x%02x", GetRValue(FontColor), GetGValue(FontColor), GetBValue(FontColor));
	GetPrivateProfileString(INI_SECTION_NAME, "FILENAME_FONT_COLOR", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int	r, g, b;
		if (sscanf_s(buf, "%02x%02x%02x", &r, &g, &b) == 3) {
			FontColor = RGB(r, g, b); 
		}
	}
	//摜̍XVԊuibŎwj
	sprintf_s(buf, sizeof(buf), "%d", nInterval);
	GetPrivateProfileString(INI_SECTION_NAME, "INTERVAL", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val > 0) {
			nInterval = val; 
		}
	}
	//̃TCYŕ\邩
	sprintf_s(buf, sizeof(buf), "%d", nOrgSize);
	GetPrivateProfileString(INI_SECTION_NAME, "ORG_SIZE", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val <= 0) {
			nOrgSize = 0;
		} else {
			nOrgSize = 1;
		}
	}
	//̏cێ邩
	sprintf_s(buf, sizeof(buf), "%d", nOrgSizeRatio);
	GetPrivateProfileString(INI_SECTION_NAME, "ORG_SIZE_RETIO", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val <= 0) {
			nOrgSizeRatio = 0;
		} else {
			nOrgSizeRatio = 1;
		}
	}

	//tF[h\̗L^
	sprintf_s(buf, sizeof(buf), "%d", (bAlphaBlend ? 1 : 0));
	GetPrivateProfileString(INI_SECTION_NAME, "FADE_IN", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val <= 0) {
			bAlphaBlend = FALSE;
		} else {
			bAlphaBlend = TRUE;
		}
	}

	//ʖɉ摜\
	sprintf_s(buf, sizeof(buf), "%d", nSeparateMonitor);
	GetPrivateProfileString(INI_SECTION_NAME, "SEPARATE_MONITOR", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val <= 0) {
			nSeparateMonitor = 0;
		} else {
			nSeparateMonitor = 1;
		}
	}

	//Sʂɓ摜\
	sprintf_s(buf, sizeof(buf), "%d", nSamePicture);
	GetPrivateProfileString(INI_SECTION_NAME, "DISP_SAME_PICTURE", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val <= 0) {
			nSamePicture = 0;
		} else {
			nSamePicture = 1;
		}
	}

	//摜ŕ\
	sprintf_s(buf, sizeof(buf), "%d", (bSlidePicture ? 1 : 0));
	GetPrivateProfileString(INI_SECTION_NAME, "SLIDE_PICTURE", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val <= 0) {
			bSlidePicture = FALSE;
		} else {
			bSlidePicture = TRUE;
		}
	}
	//摜t@C\
	sprintf_s(buf, sizeof(buf), "%d", (bShowFileName ? 1 : 0));
	GetPrivateProfileString(INI_SECTION_NAME, "SHOW_FILENAME", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val <= 0) {
			bShowFileName = FALSE;
		} else {
			bShowFileName = TRUE;
		}
	}
	//TCYwON/OFF
	sprintf_s(buf, sizeof(buf), "%d", (bSpecifiedSize ? 1 : 0));
	GetPrivateProfileString(INI_SECTION_NAME, "SPEC_SIZE_ENABLE", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val <= 0) {
			bSpecifiedSize = FALSE;
		} else {
			bSpecifiedSize = TRUE;
		}
	}
	//TCYw
	sprintf_s(buf, sizeof(buf), "%d", SpecifiedSize.cx);
	GetPrivateProfileString(INI_SECTION_NAME, "SPEC_SIZE_WIDTH", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val > 0) {
			SpecifiedSize.cx = val; 
		}
	}
	//cTCYw
	sprintf_s(buf, sizeof(buf), "%d", SpecifiedSize.cy);
	GetPrivateProfileString(INI_SECTION_NAME, "SPEC_SIZE_HEIGHT", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val > 0) {
			SpecifiedSize.cy = val; 
		}
	}
	//TCYw 0=v 1=ȏ 2=ȉ
	sprintf_s(buf, sizeof(buf), "%d", nWidthCond);
	GetPrivateProfileString(INI_SECTION_NAME, "SPEC_WIDTH_COND", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (0 <= val && val <= 2) {
			nWidthCond = val; 
		}
	}
	//cTCYw 0=v 1=ȏ 2=ȉ
	sprintf_s(buf, sizeof(buf), "%d", nHeightCond);
	GetPrivateProfileString(INI_SECTION_NAME, "SPEC_HEIGHT_COND", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (0 <= val && val <= 2) {
			nHeightCond = val; 
		}
	}

	//tH_̉摜t@C(JPEG)
	sprintf_s(buf, sizeof(buf), "%d", (bEnableImageType[IMAGE_TYPE_JPEG] ? 1 : 0));
	GetPrivateProfileString(INI_SECTION_NAME, "ENABLE_JPEG", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val <= 0) {
			bEnableImageType[IMAGE_TYPE_JPEG] = FALSE;
		} else {
			bEnableImageType[IMAGE_TYPE_JPEG] = TRUE;
		}
	}
	//tH_̉摜t@C(BITMAP)
	sprintf_s(buf, sizeof(buf), "%d", (bEnableImageType[IMAGE_TYPE_BMP] ? 1 : 0));
	GetPrivateProfileString(INI_SECTION_NAME, "ENABLE_BMP", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val <= 0) {
			bEnableImageType[IMAGE_TYPE_BMP] = FALSE;
		} else {
			bEnableImageType[IMAGE_TYPE_BMP] = TRUE;
		}
	}
	//tH_̉摜t@C(GIF)
	sprintf_s(buf, sizeof(buf), "%d", (bEnableImageType[IMAGE_TYPE_GIF] ? 1 : 0));
	GetPrivateProfileString(INI_SECTION_NAME, "ENABLE_GIF", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val <= 0) {
			bEnableImageType[IMAGE_TYPE_GIF] = FALSE;
		} else {
			bEnableImageType[IMAGE_TYPE_GIF] = TRUE;
		}
	}
	//tH_̉摜t@C(PNG)
	sprintf_s(buf, sizeof(buf), "%d", (bEnableImageType[IMAGE_TYPE_PNG] ? 1 : 0));
	GetPrivateProfileString(INI_SECTION_NAME, "ENABLE_PNG", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val <= 0) {
			bEnableImageType[IMAGE_TYPE_PNG] = FALSE;
		} else {
			bEnableImageType[IMAGE_TYPE_PNG] = TRUE;
		}
	}
	//tH_̉摜t@C(TIFF)
	sprintf_s(buf, sizeof(buf), "%d", (bEnableImageType[IMAGE_TYPE_TIFF] ? 1 : 0));
	GetPrivateProfileString(INI_SECTION_NAME, "ENABLE_TIFF", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val <= 0) {
			bEnableImageType[IMAGE_TYPE_TIFF] = FALSE;
		} else {
			bEnableImageType[IMAGE_TYPE_TIFF] = TRUE;
		}
	}

	//t@CI_CAÕftHgfBNg
	GetPrivateProfileString(INI_SECTION_NAME, "DEFAULT_DIR", "", buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		strncpy_s(szDefaultDir, sizeof(szDefaultDir), buf, sizeof(szDefaultDir) - 1);
		szDefaultDir[sizeof(szDefaultDir) - 1] = '\0';
	}

	//t@CI_CAÕftHg̃tB^̃CfbNX
	sprintf_s(buf, sizeof(buf), "%d", nFilterIdx);
	GetPrivateProfileString(INI_SECTION_NAME, "FILE_FILTER_INDEX", buf, buf, sizeof(buf), szIniFile);
	if (buf[0]) {
		int val = strtol(buf, NULL, 10);
		if (val > 0) {
			nFilterIdx = val;
		}
	}
	//INIt@Cݒ肳ꂽt@C擾
	nConfPictureFileNum = 0;
	for (i = 0; i < MAX_PICTURE_FILES; i++) {
		sprintf_s(key, sizeof(key), "PICTURE_FILE_%03d", i + 1);

		buf[0] = '\0';
		GetPrivateProfileString(INI_SECTION_NAME, key, "", buf, sizeof(buf), szIniFile);
		if (!buf[0]) {
			break;
		}
		//e[uɒǉ
		strncpy_s(&szCnfPictureFiles[nConfPictureFileNum][0], MAX_PATH, buf, MAX_PATH - 1);
		nConfPictureFileNum++;
	}
}

//ݒt@Cۑ
void	SaveConfig()
{
	int		i;
	char	key[32];
	char	buf[256];
	char	szIniFile[MAX_PATH];
	char	*bufp;

	GetIniFileName(szIniFile, sizeof(szIniFile));

	//\̃tHgTCY
	sprintf_s(buf, sizeof(buf), "%d", nFontSize);
	WritePrivateProfileString(INI_SECTION_NAME, "FONTSIZE", buf, szIniFile);

	//摜t@C\̃tHgTCY
	sprintf_s(buf, sizeof(buf), "%d", lfFileNameFont.lfHeight);
	WritePrivateProfileString(INI_SECTION_NAME, "FILENAME_FONT_SIZE", buf, szIniFile);

	//摜t@C\̃tHg
	WritePrivateProfileString(INI_SECTION_NAME, "FILENAME_FONT_NAME", lfFileNameFont.lfFaceName, szIniFile);

	//摜t@C\̃tHg
	sprintf_s(buf, sizeof(buf), "%d", lfFileNameFont.lfWeight);
	WritePrivateProfileString(INI_SECTION_NAME, "FILENAME_FONT_WEIGHT", buf, szIniFile);

	//摜t@C\̃tHgΑ
	sprintf_s(buf, sizeof(buf), "%d", lfFileNameFont.lfItalic);
	WritePrivateProfileString(INI_SECTION_NAME, "FILENAME_FONT_ITALIC", buf, szIniFile);

	//摜t@C\̃tHg
	sprintf_s(buf, sizeof(buf), "%d", lfFileNameFont.lfUnderline);
	WritePrivateProfileString(INI_SECTION_NAME, "FILENAME_FONT_UNDERLINE", buf, szIniFile);

	//摜t@C\̃tHg
	sprintf_s(buf, sizeof(buf), "%d", lfFileNameFont.lfStrikeOut);
	WritePrivateProfileString(INI_SECTION_NAME, "FILENAME_FONT_STRIKEOUT", buf, szIniFile);

	//摜t@C\̃tHgF
	sprintf_s(buf, sizeof(buf), "%02x%02x%02x", GetRValue(FontColor), GetGValue(FontColor), GetBValue(FontColor));
	WritePrivateProfileString(INI_SECTION_NAME, "FILENAME_FONT_COLOR", buf, szIniFile);

	//摜̍XVԊuibŎwj
	sprintf_s(buf, sizeof(buf), "%d", nInterval);
	WritePrivateProfileString(INI_SECTION_NAME, "INTERVAL", buf, szIniFile);

	//̃TCYŕ\邩
	sprintf_s(buf, sizeof(buf), "%d", nOrgSize);
	WritePrivateProfileString(INI_SECTION_NAME, "ORG_SIZE", buf, szIniFile);

	//̏cێ邩
	sprintf_s(buf, sizeof(buf), "%d", nOrgSizeRatio);
	WritePrivateProfileString(INI_SECTION_NAME, "ORG_SIZE_RETIO", buf, szIniFile);

	//tF[h\̗L^
	sprintf_s(buf, sizeof(buf), "%d", (bAlphaBlend ? 1 : 0));
	WritePrivateProfileString(INI_SECTION_NAME, "FADE_IN", buf, szIniFile);

	//ʖɉ摜\
	sprintf_s(buf, sizeof(buf), "%d", nSeparateMonitor);
	WritePrivateProfileString(INI_SECTION_NAME, "SEPARATE_MONITOR", buf, szIniFile);

	//Sʂɓ摜\
	sprintf_s(buf, sizeof(buf), "%d", nSamePicture);
	WritePrivateProfileString(INI_SECTION_NAME, "DISP_SAME_PICTURE", buf, szIniFile);

	//摜ŕ\
	sprintf_s(buf, sizeof(buf), "%d", (bSlidePicture ? 1 : 0));
	WritePrivateProfileString(INI_SECTION_NAME, "SLIDE_PICTURE", buf, szIniFile);

	//摜t@C\
	sprintf_s(buf, sizeof(buf), "%d", (bShowFileName ? 1 : 0));
	WritePrivateProfileString(INI_SECTION_NAME, "SHOW_FILENAME", buf, szIniFile);

	//TCYwON/OFF
	sprintf_s(buf, sizeof(buf), "%d", (bSpecifiedSize ? 1 : 0));
	WritePrivateProfileString(INI_SECTION_NAME, "SPEC_SIZE_ENABLE", buf, szIniFile);

	//TCYw
	sprintf_s(buf, sizeof(buf), "%d", SpecifiedSize.cx);
	WritePrivateProfileString(INI_SECTION_NAME, "SPEC_SIZE_WIDTH", buf, szIniFile);

	//cTCYw
	sprintf_s(buf, sizeof(buf), "%d", SpecifiedSize.cy);
	WritePrivateProfileString(INI_SECTION_NAME, "SPEC_SIZE_HEIGHT", buf, szIniFile);

	//TCYw 0=v 1=ȏ 2=ȉ
	sprintf_s(buf, sizeof(buf), "%d", nWidthCond);
	WritePrivateProfileString(INI_SECTION_NAME, "SPEC_WIDTH_COND", buf, szIniFile);

	//cTCYw 0=v 1=ȏ 2=ȉ
	sprintf_s(buf, sizeof(buf), "%d", nHeightCond);
	WritePrivateProfileString(INI_SECTION_NAME, "SPEC_HEIGHT_COND", buf, szIniFile);

	//tH_̉摜t@C(JPEG)
	sprintf_s(buf, sizeof(buf), "%d", (bEnableImageType[IMAGE_TYPE_JPEG] ? 1 : 0));
	WritePrivateProfileString(INI_SECTION_NAME, "ENABLE_JPEG", buf, szIniFile);

	//tH_̉摜t@C(BITMAP)
	sprintf_s(buf, sizeof(buf), "%d", (bEnableImageType[IMAGE_TYPE_BMP] ? 1 : 0));
	WritePrivateProfileString(INI_SECTION_NAME, "ENABLE_BMP", buf, szIniFile);

	//tH_̉摜t@C(GIF)
	sprintf_s(buf, sizeof(buf), "%d", (bEnableImageType[IMAGE_TYPE_GIF] ? 1 : 0));
	WritePrivateProfileString(INI_SECTION_NAME, "ENABLE_GIF", buf, szIniFile);

	//tH_̉摜t@C(PNG)
	sprintf_s(buf, sizeof(buf), "%d", (bEnableImageType[IMAGE_TYPE_PNG] ? 1 : 0));
	WritePrivateProfileString(INI_SECTION_NAME, "ENABLE_PNG", buf, szIniFile);

	//tH_̉摜t@C(TIFF)
	sprintf_s(buf, sizeof(buf), "%d", (bEnableImageType[IMAGE_TYPE_TIFF] ? 1 : 0));
	WritePrivateProfileString(INI_SECTION_NAME, "ENABLE_TIFF", buf, szIniFile);

	//t@CI_CAÕftHgfBNg
	WritePrivateProfileString(INI_SECTION_NAME, "DEFAULT_DIR", szDefaultDir, szIniFile);

	//t@CI_CAÕftHg̃tB^̃CfbNX
	sprintf_s(buf, sizeof(buf), "%d", nFilterIdx);
	WritePrivateProfileString(INI_SECTION_NAME, "FILE_FILTER_INDEX", buf, szIniFile);

	//INIt@Cɐݒ肳ꂽt@Cۑ
	for (i = 0; i < MAX_PICTURE_FILES; i++) {
		sprintf_s(key, sizeof(key), "PICTURE_FILE_%03d", i + 1);
		if (i < nConfPictureFileNum) {
			bufp = szCnfPictureFiles[i];
		} else {
			bufp = NULL;
		}
		WritePrivateProfileString(INI_SECTION_NAME, key, bufp, szIniFile);
	}
}

//摜t@C摜Xgɒǉ
BOOL AddPictureFile(int idx,  LPCTSTR lpFileName, BOOL bEnableCond)
{
	CImage		Image;
	const char	*p;
	int			i;
	const char	*ImgExt[] = {
		"jpg",
		"jpeg",
		"bmp",
		"gif",
		"png",
		"tif",
		"tiff"
	};
	const int	ImgType[] = {
		IMAGE_TYPE_JPEG,
		IMAGE_TYPE_JPEG,
		IMAGE_TYPE_BMP,
		IMAGE_TYPE_GIF,
		IMAGE_TYPE_PNG,
		IMAGE_TYPE_TIFF,
		IMAGE_TYPE_TIFF
	};
	if (idx >= MAX_PICTURE_FILES) {
		return FALSE;
	}
	//C[Wt@C̊gq`FbN
	if (!(p =strrchr(lpFileName, '.'))) {
		return FALSE;
	}
	p++;
	if (!(*p)) {
		return FALSE;
	}
	for (i = 0; i < sizeof(ImgExt) / sizeof(ImgExt[0]); i++) { 
		if (_stricmp(p, ImgExt[i]) == 0) {
			if (!bEnableCond || bEnableImageType[ImgType[i]]) { 
				break;
			}
		}
	}
	if (i >= sizeof(ImgExt) / sizeof(ImgExt[0])) {
		return FALSE;
	}
	//C[Wt@CƂă[hł邩`FbN
	if (Image.Load(lpFileName) == 0) {
		if (bEnableCond && bSpecifiedSize) {
			int w = Image.GetWidth();
			int	h = Image.GetHeight();

			switch (nWidthCond) {	//0=v 1=ȏ 2=ȉ
			case 0:
				if (w != SpecifiedSize.cx) {
					return FALSE;
				}
				break;
			case 1:
				if (w < SpecifiedSize.cx) {
					return FALSE;
				}
				break;
			case 2:
			default:
				if (w > SpecifiedSize.cx) {
					return FALSE;
				}
				break;
			}
			switch (nHeightCond) {
			case 0:
				if (h != SpecifiedSize.cy) {
					return FALSE;
				}
				break;
			case 1:
				if (h < SpecifiedSize.cy) {
					return FALSE;
				}
				break;
			case 2:
			default:
				if (h > SpecifiedSize.cy) {
					return FALSE;
				}
				break;
			}
		}
		Image.Destroy();

		strncpy_s(&szPictureFiles[idx][0], MAX_PATH - 1, lpFileName, MAX_PATH - 1);
		szPictureFiles[idx][MAX_PATH - 1] = '\0';

		return TRUE;
	}
	return FALSE;
}

//tH_摜t@C̃Xgǉ
int	AddPictureFileFromDir(int idx, LPCTSTR lpFolder, LPCTSTR lpPattern, BOOL bRecursive)
{
	int				count;
	char			buf[MAX_PATH];
	HANDLE			hFind;
	WIN32_FIND_DATA FindFileData;

	if (idx >= MAX_PICTURE_FILES) {
		return 0;
	}
	if (!lpFolder || !(*lpFolder)) {
		return 0;
	}
	if (lpPattern && *lpPattern) {
		sprintf_s(buf, sizeof(buf), "%s\\%s", lpFolder, lpPattern);
	} else {
		sprintf_s(buf, sizeof(buf), "%s\\%s", lpFolder, "*.*");
	}
	count = 0;

	hFind = FindFirstFile(buf, &FindFileData);
	if (hFind != INVALID_HANDLE_VALUE) {
		char	fname[MAX_PATH];
		CImage	Image;

		do {
			if (strncmp(FindFileData.cFileName, ".", 2) != 0 &&
						strncmp(FindFileData.cFileName, "..", 3) != 0) {
				//tpXgݗĂ
				sprintf_s(fname, sizeof(fname), "%s\\%s", lpFolder, FindFileData.cFileName);

				//fBNgł͂Ȃ
				if ((GetFileAttributes(fname) & FILE_ATTRIBUTE_DIRECTORY)) {
					if (bRecursive) {
						int	num = AddPictureFileFromDir(idx, fname, lpPattern, TRUE);
						count += num;
						idx += num;
						if (idx >= MAX_PICTURE_FILES) {
							break;
						}
					}
				} else {
					//C[Wt@CƂă[hł邩`FbNđ}
					if (AddPictureFile(idx, fname, TRUE)) {
						count++;
						idx++;
						if (idx >= MAX_PICTURE_FILES) {
							break;
						}
					}
				}
			}
		} while (FindNextFile(hFind, &FindFileData));

		FindClose(hFind);
	}
	return count;
}

//C[WXg̃`FbN
int	SetImageFileList()
{
	if (nConfPictureFileNum <= 0) {
		return 0;
	}
	int		i;
	int		count;
	char	*fname;
	char	*pat;
	BOOL	bRecurcive = TRUE;
	DWORD	dwAttr;
	int		idx = 0;

	for (i = 0; i < nConfPictureFileNum; i++) {
		pat = NULL;
		fname =  szCnfPictureFiles[i];
		dwAttr = GetFileAttributes(fname);

		if (dwAttr == (DWORD)-1) {
			char buf[MAX_PATH];
			if (GetFullPathName(fname, sizeof(buf), buf, &pat) > 0) {
				if (pat) {
					if (strchr(pat, '*') || strchr(pat, '?')) {
						if (*(pat - 1) == '\\') {
							*(pat - 1) = '\0';
						}
						//bRecurcive = FALSE;
						strncpy_s(fname, sizeof(fname), buf, sizeof(fname) - 1);
					}
				}
			}
		}
		if (GetFileAttributes(fname) & FILE_ATTRIBUTE_DIRECTORY) { //fBNg̏ꍇ
			//tH_摜t@C̃Xgǉ
			count = AddPictureFileFromDir(idx, fname, pat, bRecurcive);
			if (count > 0) {
				idx+= count;
			}
			if (idx >= MAX_PICTURE_FILES) {
				break;
			}
		} else {
			if (AddPictureFile(idx, fname, FALSE)) {
				idx++;
			}
		}
	}
	nPictureFileNum = idx;

	return nPictureFileNum;
}

//EnumDisplayMonitors̃R[obN
BOOL CALLBACK MonitorEnumProc(HMONITOR hMonitor, HDC hdcMonitor,
										LPRECT lprcMonitor, LPARAM dwData)
{
	int	max_num = sizeof(MonitorRect) / sizeof(MonitorRect[0]);

	if (MonitorNum < max_num) {
		int	w, h;
		MonitorRect[MonitorNum] = *lprcMonitor;

		w = MonitorRect[MonitorNum].right - MonitorRect[MonitorNum].left;
		h = MonitorRect[MonitorNum].bottom - MonitorRect[MonitorNum].top;
		if (w > MaxMonitorSize.cx) {
			MaxMonitorSize.cx = w;
		}
		if (h > MaxMonitorSize.cy) {
			MaxMonitorSize.cy = h;
		}
		MonitorNum++;
		return TRUE;
	}
	return FALSE;
}

void	GetMonitorRect(HWND hWnd)
{
	MonitorNum = 0;
	MaxMonitorSize.cx = 0;
	MaxMonitorSize.cy = 0;

	if (!EnumDisplayMonitors (NULL, NULL, MonitorEnumProc, NULL)) {
		GetClientRect(hWnd, &MonitorRect[0]);
		MaxMonitorSize.cx = MonitorRect[0].right - MonitorRect[0].left; 
		MaxMonitorSize.cy = MonitorRect[0].bottom - MonitorRect[0].top; 
		MonitorNum = 1;
	}
}

//摜t@CXgɃZbg
BOOL SetFileToList(HWND hListWnd, int idx, LPCTSTR lpFileName, BOOL bReplace)
{
	CImage	Image;

	//C[Wt@CƂă[hł邩`FbN
	if (Image.Load(lpFileName) == 0) {
		Image.Destroy();

		if (idx < 0) {
			bReplace = FALSE;

			idx = ListBox_GetCount(hListWnd);
			if (idx >= MAX_PICTURE_FILES) {
				return FALSE;
			}
		} else {
			if (bReplace) {
				ListBox_DeleteString(hListWnd, idx);
			}
		}
		//[hł摜t@CXgɑ}
		ListBox_InsertString(hListWnd, idx, lpFileName);

		return TRUE;
	}
	return FALSE;
}

//摜tH_XgɃZbg
BOOL SetDirToList(HWND hListWnd, int idx, LPCTSTR lpFolder, LPCTSTR lpPattern, BOOL bReplace)
{
	if (!lpFolder || !(*lpFolder)) {
		return FALSE;
	}
	if (idx < 0) {
		bReplace = FALSE;

		//}ʒu̎w肪Ȃꍇ̓Jg̑Iʒuɑ}
		idx = ListBox_GetCount(hListWnd);
		if (idx >= MAX_PICTURE_FILES) {
			return FALSE;
		}
	} else {
		if (bReplace) {
			ListBox_DeleteString(hListWnd, idx);
		}
	}
	char	buf[MAX_PATH];
	if (lpPattern && *lpPattern) {
		sprintf_s(buf, sizeof(buf), "%s\\%s", lpFolder, lpPattern);
	} else {
		sprintf_s(buf, sizeof(buf), "%s", lpFolder);
	}
	//[hł摜t@CXgɑ}
	ListBox_InsertString(hListWnd, idx, buf);

	return TRUE;
}

//摜t@C̓tH_XgɃZbg
void	SetItemToList(HWND hListWnd, int idx, LPCTSTR pszFname, BOOL bReplace)
{
	char	fname[MAX_PATH];
	char	*pat;

	strncpy_s(fname, sizeof(fname), pszFname, sizeof(fname));

	pat = NULL;
	if (GetFileAttributes(fname) == (DWORD)-1) {
		char buf[MAX_PATH];
		if (GetFullPathName(fname, sizeof(buf), buf, &pat) > 0) {
			if (pat) {
				if (strchr(pat, '*') || strchr(pat, '?')) {
					if (*(pat - 1) == '\\') {
						*(pat - 1) = '\0';
					}
					strncpy_s(fname, sizeof(fname), buf, sizeof(fname) - 1);
				}
			}
		}
	}
	if (GetFileAttributes(fname) & FILE_ATTRIBUTE_DIRECTORY) { //fBNg̏ꍇ
		//摜t@C̃tH_XgɃZbg
		SetDirToList(hListWnd, idx, fname, pat, bReplace);
	} else {
		//C[Wt@CƂă[hł邩`FbNđ}
		SetFileToList(hListWnd, idx, fname, bReplace);
	}
}

//Pʕ`揈
BOOL	DrawPicture(HDC hDC, LPRECT lpRect, int PictIdx)
{
	BOOL	bDrawFlag = FALSE;	//`ς݃tO
	char	buf[256];
	RECT	DrawRect;

	DrawRect.top = lpRect->top;
	DrawRect.left = lpRect->left;
	DrawRect.right = lpRect->right;
	DrawRect.bottom = lpRect->bottom;

	int		nWidth = DrawRect.right - DrawRect.left;
	int		nHeight = DrawRect.bottom - DrawRect.top;

	//摜t@Cݒ肳Ă邩
	if (nPictureFileNum > 0) {
		CImage	Image;

		//C[Wt@C[hărbg}bv쐬
		if (Image.Load(szPictureFiles[PictIdx]) == 0) {
			if (bShowFileName) {
				//t@C\
				SIZE	sz;
				HFONT	hFont, hOldFont = NULL;

				hFont = CreateFont(lfFileNameFont.lfHeight, 0, 0, 0,
									lfFileNameFont.lfWeight, lfFileNameFont.lfItalic,
									lfFileNameFont.lfUnderline, lfFileNameFont.lfStrikeOut, DEFAULT_CHARSET,
									OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
									DEFAULT_PITCH | FF_DONTCARE, lfFileNameFont.lfFaceName);

				if (hFont) {
					hOldFont = (HFONT)SelectObject(hDC, hFont);
				}

				::GetTextExtentPoint32(hDC, szPictureFiles[PictIdx], strlen(szPictureFiles[PictIdx]), &sz);

				int	w = sz.cx + TEXT_MARGIN;
				if (lfFileNameFont.lfItalic) {
					w += sz.cy / 4;
				}
				int	h = sz.cy + (TEXT_MARGIN * 2);
				int x = DrawRect.left + nWidth - w;
				int y = DrawRect.top + nHeight - h;

				//̔wiœhԂ
				HBRUSH hOldBrush = (HBRUSH)SelectObject(hDC, GetStockObject(BLACK_BRUSH));

				Rectangle(hDC, DrawRect.left, y, DrawRect.right, y + h);

				int			OldBkMode = SetBkMode(hDC, TRANSPARENT);
				COLORREF	OldTextColor = SetTextColor(hDC, FontColor);

				TextOut(hDC, x, y, szPictureFiles[PictIdx], strlen(szPictureFiles[PictIdx]));

				SetTextColor(hDC, OldTextColor);
				SetBkMode(hDC, OldBkMode);

				if (hOldFont) {
					SelectObject(hDC, hOldFont);
				}
				if (hFont) {
					DeleteObject(hFont);
				}
				SelectObject(hDC, hOldBrush);

				DrawRect.bottom -= (sz.cy + (TEXT_MARGIN * 2));
				nHeight -= (sz.cy + (TEXT_MARGIN * 2));
			}
			//ǂݍ񂾃rbg}bṽTCY擾
			int		src_w = Image.GetWidth();
			int		src_h = Image.GetHeight();
			int		dst_w = nWidth;
			int		dst_h = nHeight;
			int		x = DrawRect.left;
			int		y = DrawRect.top;
			int		frm_w = 0;
			int		frm_h = 0;

			if (nOrgSize) {					//̃TCYŕ\邩
				if (dst_w <= src_w) {
					x = 0;
				} else {
					x = (dst_w - src_w) / 2;
					dst_w = src_w;
					frm_w = (nWidth - dst_w) / 2;
				}
				if (dst_h <= src_h) {
					y = 0;
				} else {
					y = (dst_h - src_h) / 2;
					dst_h = src_h; 
					frm_h = (nHeight - dst_h) / 2;
				}
			} else if (nOrgSizeRatio) {		//cێ邩
				//c̃TCYvZ
				double x1 = (double)dst_w / (double)src_w;
				double x2 = (double)dst_h / (double)src_h;
				if (x1 < x2) {
					dst_w = (int)(src_w * x1);
					dst_h = (int)(src_h * x1);
				} else {
					dst_w = (int)(src_w * x2);
					dst_h = (int)(src_h * x2);
				}
				//\ʒuvZ
				if (dst_w < nWidth) {
					frm_w = (nWidth - dst_w) / 2;
					x = DrawRect.left + frm_w;
				}
				if (dst_h < nHeight) {
					frm_h = (nHeight - dst_h) / 2;
					y = DrawRect.top + frm_h;
				}
			}
			if (x > DrawRect.left || y > DrawRect.top) {
				if (hMemDC) {
					//]ꍇ͍œhԂ
					HBRUSH hOldBrush = (HBRUSH)SelectObject(hMemDC, GetStockObject(BLACK_BRUSH));
					Rectangle(hMemDC, 0, 0, MaxMonitorSize.cx, MaxMonitorSize.cy);

					//hԂɃC[W`
					StretchBlt(hMemDC, frm_w, frm_h, dst_w, dst_h, Image.GetDC(), 0, 0, src_w, src_h, SRCCOPY);

					//GetDCŎ擾foCX ReLXg
					Image.ReleaseDC(); 
					SelectObject(hMemDC, hOldBrush);
				} else {
					if (!bAlphaBlend || BlendPercent == 0) {
						HBRUSH hOldBrush = (HBRUSH)SelectObject(hDC, GetStockObject(BLACK_BRUSH));
						if (frm_w > 0) {
							Rectangle(hDC, DrawRect.left, DrawRect.top, x, DrawRect.bottom);
							Rectangle(hDC, DrawRect.right - frm_w, DrawRect.top, DrawRect.right, DrawRect.bottom);
						}
						if (frm_h > 0) {
							Rectangle(hDC, DrawRect.left, DrawRect.top, DrawRect.right, y);
							Rectangle(hDC, DrawRect.left, DrawRect.bottom - frm_h, DrawRect.right, DrawRect.bottom);
						}
						SelectObject(hDC, hOldBrush);
					}
				}
			} else {
				if (hMemDC) {
					StretchBlt(hMemDC, 0, 0, dst_w, dst_h, Image.GetDC(), 0, 0, src_w, src_h, SRCCOPY);
					//GetDCŎ擾foCX ReLXg
					Image.ReleaseDC(); 
				}
			}
			//ʂɃRs[
			if (bAlphaBlend && BlendPercent < 100) {
				BLENDFUNCTION blendFunc;

				blendFunc.BlendOp = AC_SRC_OVER;
				blendFunc.BlendFlags = 0;
				//blendFunc.AlphaFormat = AC_SRC_ALPHA;
				blendFunc.AlphaFormat = 0;
				blendFunc.SourceConstantAlpha = (BlendPercent * 255 / 100);

				if (hMemDC) {
					AlphaBlend(hDC, DrawRect.left, DrawRect.top, nWidth, nHeight,
									hMemDC, 0, 0, nWidth, nHeight, blendFunc);
				} else {
					AlphaBlend(hDC, x, y, dst_w, dst_h,
								Image.GetDC(), 0, 0, src_w, src_h, blendFunc);
					//GetDCŎ擾foCX ReLXg
					Image.ReleaseDC(); 
				}
#if	0
				sprintf_s(buf, sizeof(buf), "BlendPercent=%3d, SourceConstantAlpha=%3d", BlendPercent, blendFunc.SourceConstantAlpha);
				TextOut(hDC, 0, 0, buf, strlen(buf));
#endif
			} else {
				if (hMemDC) {
					StretchBlt(hDC, DrawRect.left, DrawRect.top, nWidth, nHeight, hMemDC, 0, 0, nWidth, nHeight, SRCCOPY);
				} else {
					StretchBlt(hDC, x, y, dst_w, dst_h, Image.GetDC(), 0, 0, src_w, src_h, SRCCOPY);
					//GetDCŎ擾foCX ReLXg
					Image.ReleaseDC(); 
				}
			}
			//rbg}bvj
			Image.Destroy();

			bDrawFlag = TRUE;
		}
	}
	//`悳Ȃꍇ͎\
	if (!bDrawFlag) {
		SIZE		sz;
		HFONT		hFont, hOldFont = NULL;
		time_t		t;
		struct tm	st;

		hFont = CreateFont(nFontSize, nFontSize / 2, 0, 0,
								FW_BOLD, FALSE, FALSE, FALSE, DEFAULT_CHARSET,
								OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
								DEFAULT_PITCH | FF_DONTCARE, NULL);

		if (hFont) {
			hOldFont = (HFONT)SelectObject(hDC, hFont);
		}

		//œhԂ
		HBRUSH hOldBrush = (HBRUSH)SelectObject(hDC, GetStockObject(BLACK_BRUSH));

		Rectangle(hDC, 0, 0, nWidth, nHeight);

		time(&t);

		localtime_s(&st, &t);
		sprintf_s(buf, sizeof(buf), "%04d/%02d/%02d %02d:%02d:%02d",
					st.tm_year + 1900, st.tm_mon + 1, st.tm_mday,
					st.tm_hour, st.tm_min, st.tm_sec);

		GetTextExtentPoint32(hDC, buf, strlen(buf), &sz);

		int			OldBkMode = SetBkMode(hDC, TRANSPARENT);;
		COLORREF	OldTextColor = SetTextColor(hDC, TextColor);

		TextOut(hDC, (nWidth / 2) - (sz.cx / 2), (nHeight / 2) - (sz.cy / 2), buf, strlen(buf));

		SetTextColor(hDC, OldTextColor);
		SetBkMode(hDC, OldBkMode);

		if (hOldFont) {
			SelectObject(hDC, hOldFont);
		}
		if (hFont) {
			DeleteObject(hFont);
		}
		SelectObject(hDC, hOldBrush);
	}
	return bDrawFlag;
}

//̏
void	OnCreate(HWND hWnd)
{
	int	i, idx;

	hMemDC = NULL;
	hMemBmp = NULL;
	hOldMemBmp = NULL;

	//ݒt@Cǂݍ
	LoadConfig();

	SetImageFileList();

	if ((nInterval * 1000 / 2) < (100 / BlendPitch) * nBlendInterval) {
		BlendPitch = 100 / ((nInterval * 1000 / 2) / nBlendInterval);
	}
	GetMonitorRect(hWnd);

	for (i = 0, idx = 0; i < MonitorNum; i++) {
		nPictureIdx[i] = idx++;
		if (idx >= nPictureFileNum) {
			idx = 0;
		}
	}
	//̕`s
	if (bAlphaBlend) {
		BlendPercent = 0;
		nBlendTimerID = SetTimer(hWnd, BLEND_TIMER_ID, nBlendInterval, NULL);
	}
	InvalidateRect(hWnd, NULL, FALSE);

	//摜XV^C}N
	bIntervalChangeFlag = FALSE;
	nTimerID = SetTimer(hWnd, TIMER_ID, nInterval * 1000, NULL);
}

//ʂ̕`
void	OnPaint(HWND hWnd)
{
	HDC	hDC;

	//XN[̃foCXReLXg𓾂
	hDC = GetDC(hWnd);
	if (hDC) {
		SetStretchBltMode(hDC, COLORONCOLOR);

		if (!hMemDC) {
			hMemDC = CreateCompatibleDC(hDC);
			if (hMemDC) {
				hMemBmp = CreateCompatibleBitmap(hDC, MaxMonitorSize.cx, MaxMonitorSize.cy);
				if (!hMemBmp) {
					DeleteDC(hMemDC);
					hMemDC = NULL;
				} else {
					hOldMemBmp = (HBITMAP)SelectObject(hMemDC, hMemBmp);
					SetStretchBltMode(hMemDC, COLORONCOLOR);
				}
			}
		}
		if (nSeparateMonitor) {	//ʖɉ摜\
			int	i;

			GetMonitorRect(hWnd);

			for (i = 0; i < MonitorNum; i++) {
				if (nSamePicture) {
					//Pʕ`揈
					DrawPicture(hDC, &MonitorRect[i], nPictureIdx[0]);
				} else {
					//Pʕ`揈
					if (DrawPicture(hDC, &MonitorRect[i], nPictureIdx[i])) {
						//ʖɈقȂ摜\ꍇ
						if (!bAlphaBlend || BlendPercent >= 100) {
							if (bSlidePicture) {
								nPictureIdx[i]++;
							} else {
								nPictureIdx[i] += MonitorNum;
							}
							if (nPictureIdx[i] >= nPictureFileNum) {
								nPictureIdx[i] %= nPictureFileNum;
							}
						}
					}
				}
			}
			if (nSamePicture) {
				//Sʂœ摜\ꍇ
				if (!bAlphaBlend || BlendPercent >= 100) {
					nPictureIdx[0]++;
					if (nPictureIdx[0] >= nPictureFileNum) {
						nPictureIdx[0] = 0;
					}
				}
			}
		} else {	//ʂ܂Ƃ߂ĂPʂƂĂP̉摜\
			RECT	rect;

			//ʃTCY擾
			GetClientRect(hWnd, &rect);

			//Pʕ`揈
			if (DrawPicture(hDC, &rect, nPictureIdx[0])) {
				if (!bAlphaBlend || BlendPercent >= 100) {
					nPictureIdx[0]++;
					if (nPictureIdx[0] >= nPictureFileNum) {
						nPictureIdx[0] = 0;
					}
				}
			}
		}
		ReleaseDC(hWnd, hDC);
	}
}

//I
void	OnDestroy(HWND hWnd)
{
	//^C}~
	if (nTimerID) {
		KillTimer(hWnd, nTimerID);
	}
	if (hMemDC) {
		if (hMemBmp) {
			if (hOldMemBmp) {
				SelectObject(hMemDC, hOldMemBmp);
				hOldMemBmp = NULL;
			}
		}
		DeleteDC(hMemDC);
		hMemDC = NULL;

		if (hMemBmp) {
			DeleteObject(hMemBmp);
			hMemBmp = NULL;
		}
	}
	//ݒt@Cۑ
	SaveConfig();

	PostQuitMessage(0);
}

//^C}
void	OnTimer(HWND hWnd, UINT nTimerID)
{
	if (nTimerID == nBlendTimerID) {
		BlendPercent += BlendPitch;
		if (BlendPercent >= 100) {
			KillTimer(hWnd, nBlendTimerID);
			nBlendTimerID = 0;
		}
		InvalidateRect(hWnd, NULL, FALSE);
	} else {
		//`XVs
		if (bAlphaBlend) {
			BlendPercent = 0;
			nBlendTimerID = SetTimer(hWnd, BLEND_TIMER_ID, nBlendInterval, NULL);
		}
		InvalidateRect(hWnd, NULL, FALSE);

		//`XVԊuύXĂ^C}ZbgȂ
		if (bIntervalChangeFlag) {
			if (nTimerID) {
				KillTimer(hWnd, nTimerID);
			}
			nTimerID = SetTimer(hWnd, TIMER_ID, nInterval * 1000, NULL);
			bIntervalChangeFlag = FALSE;
		}
	}
}

//XN[Z[o[EbZ[W
LRESULT WINAPI ScreenSaverProc(HWND hWnd, UINT nMsg, WPARAM wParam, LPARAM lParam)
{
	switch (nMsg) {
	case WM_CREATE:
		//̏
		OnCreate(hWnd);
		break;
	case WM_TIMER:
		//^C}
		OnTimer(hWnd, (UINT)wParam);
		break;
		//return 0;
	case WM_PAINT:
		//ʂ̕`
		OnPaint(hWnd);
		break;
	case WM_DESTROY:
		//I
		OnDestroy(hWnd);
		return 0;
	default:
		break;
	}
	return DefScreenSaverProc(hWnd, nMsg, wParam, lParam);
}

//--------------------------------------------------------------------------------------

//tH_I_CAÕR[obN֐
int	CALLBACK BrowseCallbackProc(HWND hWnd, UINT nMsg, LPARAM lParam, LPARAM lpData)
{
    if (nMsg == BFFM_INITIALIZED) {
        SendMessage(hWnd, BFFM_SETSELECTION, (WPARAM)TRUE, lpData);
    }
    return 0;
}

// 摜t@CI_CAO\
void	OnButtonPictureFileRefEditDialog(HWND hwndDlg)
{
	char			buf[256];
	char			fname[MAX_PATH];
	char			strTitle[256];
	OPENFILENAME	ofn;

	buf[0] = '\0';
	fname[0] = '\0';

	LoadString((HINSTANCE)GetModuleHandle(NULL), IDS_STR_SELECT_IMAGE_FILE, strTitle, sizeof(strTitle)-1);

	memset(&ofn, 0, sizeof(OPENFILENAME));

	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hwndDlg;
	ofn.lpstrFilter = IMAGE_FILE_FILTER;
	ofn.nFilterIndex = nFilterIdx;
	ofn.lpstrInitialDir = szDefaultDir;
	ofn.lpstrFile = fname;
	ofn.lpstrFileTitle = buf;
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	ofn.lpstrDefExt = "bmp";
	ofn.lpstrTitle = strTitle;

	if (GetOpenFileName(&ofn)) {
		CImage Image;

		TCHAR	dir[MAX_PATH];
		TCHAR	*pf;

		nFilterIdx = ofn.nFilterIndex;

		if (GetFullPathName(fname, sizeof(dir) / sizeof(TCHAR), dir, &pf) > 0) {
			if (pf) {
				*pf = NULL;
			}
			strncpy_s(szDefaultDir, sizeof(szDefaultDir), dir, sizeof(szDefaultDir) - 1);
		}

		//C[Wt@CƂă[hł邩`FbN
		if (Image.Load(fname) == 0) {
			Image.Destroy();

			//GfBbgRg[ɃZbg
			SetDlgItemText(hwndDlg, IDC_EDIT_PICTURE_FILE, fname);
		}
	}
}

// tH_I_CAO\
void	OnButtonDirSelEditDialog(HWND hwndDlg)
{
	BROWSEINFO		inf;
	ITEMIDLIST		*pItmList = NULL;
	char			szFolder[MAX_PATH];
	char			strTitle[256];

	LoadString((HINSTANCE)GetModuleHandle(NULL), IDS_STR_SELECT_IMAGE_FOLDER, strTitle, sizeof(strTitle)-1);

	inf.hwndOwner      = hwndDlg;
	inf.pidlRoot       = NULL;
	inf.pszDisplayName = szFolder;
	inf.lpszTitle      = strTitle;
	inf.ulFlags        = BIF_RETURNONLYFSDIRS;
	inf.lpfn		   = BrowseCallbackProc;
	inf.lParam         = (LPARAM)szDefaultDir;
	inf.iImage         = 0;

	//tH_I_CAO
	pItmList = SHBrowseForFolder(&inf);
	if (pItmList) {
		//tH_擾
		if (SHGetPathFromIDList(pItmList, szFolder)) {
			//ITEMIDLIST̉
			CoTaskMemFree(pItmList);

			//GfBbgRg[ɃZbg
			SetDlgItemText(hwndDlg, IDC_EDIT_PICTURE_FILE, szFolder);

			//ftHgfBNgɃZbg
			strncpy_s(szDefaultDir, sizeof(szDefaultDir), szFolder, sizeof(szDefaultDir) - 1);
			szDefaultDir[sizeof(szDefaultDir) - 1] = '\0';
		}
	}
}

//ҏW_CAOER}h
void	OnCommandEditDialog(HWND hwndDlg, WPARAM wParam, LPARAM lParam)
{
	UINT	uiCmd = (UINT)LOWORD(wParam);

	switch (uiCmd) {
	case IDOK:
		GetDlgItemText(hwndDlg, IDC_EDIT_PICTURE_FILE, szEditFile, sizeof(szEditFile));
		if (!szEditFile[0]) {
			return;
		}
		EndDialog(hwndDlg, IDOK);
		break;
	case IDCANCEL:
		EndDialog(hwndDlg, IDCANCEL);
		break;
	case IDC_BUTTON_UPDATE:
		GetDlgItemText(hwndDlg, IDC_EDIT_PICTURE_FILE, szEditFile, sizeof(szEditFile));
		if (!szEditFile[0]) {
			return;
		}
		EndDialog(hwndDlg, IDC_BUTTON_UPDATE);
		break;
	case IDC_BTN_PICTURE_FILE_REF:
		// 摜t@CI_CAO\
		OnButtonPictureFileRefEditDialog(hwndDlg);
		break;
	case IDC_BTN_DIR_SEL:
		// tH_I_CAO\
		OnButtonDirSelEditDialog(hwndDlg);
		break;
	}
}

//ҏW_CAO
INT_PTR CALLBACK EditDialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	HWND	hParentWnd = GetParent(hwndDlg);

	switch (uMsg) {
	case WM_INITDIALOG:
		//lGfBbgRg[ɃZbg
		SetDlgItemText(hwndDlg, IDC_EDIT_PICTURE_FILE, szEditFile);
		break;
	case WM_COMMAND:
		//ҏW_CAOER}h
		OnCommandEditDialog(hwndDlg, wParam, lParam);
		break;
	}
	return 0;
}

//--------------------------------------------------------------------------------------

//摜_CAO
void	OnInitImageCondDialog(HWND hwndDlg)
{
	HWND	hWnd;
	LPARAM	lParam;

	//TCYwON/OFF
	hWnd = GetDlgItem(hwndDlg, IDC_CHECK_SPECIFIED_SIZE);
	Button_SetCheck(hWnd, bSpecifiedSize);
	SetWindowPos(hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);

	//TCYXs{^
	hWnd = GetDlgItem(hwndDlg, IDC_SPIN_WIDTH);
	lParam = (LPARAM)MAKELONG(9999, 1);
	SendMessage(hWnd, UDM_SETRANGE, (WPARAM)0, lParam);

	//cTCYXs{^
	hWnd = GetDlgItem(hwndDlg, IDC_SPIN_HEIGHT);
	lParam = (LPARAM)MAKELONG(9999, 1);
	SendMessage(hWnd, UDM_SETRANGE, (WPARAM)0, lParam);

	//TCYw
	SetDlgItemInt(hwndDlg, IDC_EDIT_WIDTH, (UINT)SpecifiedSize.cx, FALSE);

	//cTCYw
	SetDlgItemInt(hwndDlg, IDC_EDIT_HEIGHT, (UINT)SpecifiedSize.cy, FALSE);

	//TCYw 0=v 1=ȏ 2=ȉ
	hWnd = GetDlgItem(hwndDlg, IDC_RADIO_SIZE_W_PTN1);
	if (nWidthCond == 0) {
		Button_SetCheck(hWnd, 1);
	} else {
		Button_SetCheck(hWnd, 0);
	}
	hWnd = GetDlgItem(hwndDlg, IDC_RADIO_SIZE_W_PTN2);
	if (nWidthCond == 1) {
		Button_SetCheck(hWnd, 1);
	} else {
		Button_SetCheck(hWnd, 0);
	}
	hWnd = GetDlgItem(hwndDlg, IDC_RADIO_SIZE_W_PTN3);
	if (nWidthCond == 2) {
		Button_SetCheck(hWnd, 1);
	} else {
		Button_SetCheck(hWnd, 0);
	}

	//cTCYw 0=v 1=ȏ 2=ȉ
	hWnd = GetDlgItem(hwndDlg, IDC_RADIO_SIZE_H_PTN1);
	if (nHeightCond == 0) {
		Button_SetCheck(hWnd, 1);
	} else {
		Button_SetCheck(hWnd, 0);
	}
	hWnd = GetDlgItem(hwndDlg, IDC_RADIO_SIZE_H_PTN2);
	if (nHeightCond == 1) {
		Button_SetCheck(hWnd, 1);
	} else {
		Button_SetCheck(hWnd, 0);
	}
	hWnd = GetDlgItem(hwndDlg, IDC_RADIO_SIZE_H_PTN3);
	if (nHeightCond == 2) {
		Button_SetCheck(hWnd, 1);
	} else {
		Button_SetCheck(hWnd, 0);
	}

	//摜JPEG
	hWnd = GetDlgItem(hwndDlg, IDC_CHECK_TYPE_JPG);
	Button_SetCheck(hWnd, bEnableImageType[IMAGE_TYPE_JPEG]);

	//摜BITMAP
	hWnd = GetDlgItem(hwndDlg, IDC_CHECK_TYPE_BMP);
	Button_SetCheck(hWnd, bEnableImageType[IMAGE_TYPE_BMP]);

	//摜GIF
	hWnd = GetDlgItem(hwndDlg, IDC_CHECK_TYPE_GIF);
	Button_SetCheck(hWnd, bEnableImageType[IMAGE_TYPE_GIF]);

	//摜PNG
	hWnd = GetDlgItem(hwndDlg, IDC_CHECK_TYPE_PNG);
	Button_SetCheck(hWnd, bEnableImageType[IMAGE_TYPE_PNG]);

	//摜TIFF
	hWnd = GetDlgItem(hwndDlg, IDC_CHECK_TYPE_TIFF);
	Button_SetCheck(hWnd, bEnableImageType[IMAGE_TYPE_TIFF]);

}

//摜_CAOER}h
void	OnCommandImageCondDialog(HWND hwndDlg, WPARAM wParam, LPARAM lParam)
{
	UINT uiCmd = (UINT)LOWORD(wParam);

	switch (uiCmd) {
	case IDOK:
		{
			UINT	uiVal;
			BOOL	bStatus;
			HWND	hWnd;

			//TCYwON/OFF
			hWnd = GetDlgItem(hwndDlg, IDC_CHECK_SPECIFIED_SIZE);
			bSpecifiedSize = (Button_GetCheck(hWnd) == 1 ? TRUE : FALSE);

			//TCYw
			uiVal = GetDlgItemInt(hwndDlg, IDC_EDIT_WIDTH, &bStatus, FALSE);
			if (!bStatus || uiVal <= 0) {
				SetDlgItemInt(hwndDlg, IDC_EDIT_WIDTH, (UINT)SpecifiedSize.cx, FALSE);
				return;
			}
			if (SpecifiedSize.cx != (int)uiVal) {
				SpecifiedSize.cx = uiVal;
			}
			//cTCYw
			uiVal = GetDlgItemInt(hwndDlg, IDC_EDIT_HEIGHT, &bStatus, FALSE);
			if (!bStatus || uiVal <= 0) {
				SetDlgItemInt(hwndDlg, IDC_EDIT_HEIGHT, (UINT)SpecifiedSize.cy, FALSE);
				return;
			}
			if (SpecifiedSize.cy != (int)uiVal) {
				SpecifiedSize.cy = uiVal;
			}

			//TCYw 0=v 1=ȏ 2=ȉ
			hWnd = GetDlgItem(hwndDlg, IDC_RADIO_SIZE_W_PTN1);
			if (Button_GetCheck(hWnd)) {
				nWidthCond = 0;
			}
			hWnd = GetDlgItem(hwndDlg, IDC_RADIO_SIZE_W_PTN2);
			if (Button_GetCheck(hWnd)) {
				nWidthCond = 1;
			}
			hWnd = GetDlgItem(hwndDlg, IDC_RADIO_SIZE_W_PTN3);
			if (Button_GetCheck(hWnd)) {
				nWidthCond = 2;
			}

			//cTCYw 0=v 1=ȏ 2=ȉ
			hWnd = GetDlgItem(hwndDlg, IDC_RADIO_SIZE_H_PTN1);
			if (Button_GetCheck(hWnd)) {
				nHeightCond = 0;
			}
			hWnd = GetDlgItem(hwndDlg, IDC_RADIO_SIZE_H_PTN2);
			if (Button_GetCheck(hWnd)) {
				nHeightCond = 1;
			}
			hWnd = GetDlgItem(hwndDlg, IDC_RADIO_SIZE_H_PTN3);
			if (Button_GetCheck(hWnd)) {
				nHeightCond = 2;
			}

			//摜JPEG
			hWnd = GetDlgItem(hwndDlg, IDC_CHECK_TYPE_JPG);
			bEnableImageType[IMAGE_TYPE_JPEG] = Button_GetCheck(hWnd);

			//摜BITMAP
			hWnd = GetDlgItem(hwndDlg, IDC_CHECK_TYPE_BMP);
			bEnableImageType[IMAGE_TYPE_BMP] = Button_GetCheck(hWnd);

			//摜GIF
			hWnd = GetDlgItem(hwndDlg, IDC_CHECK_TYPE_GIF);
			bEnableImageType[IMAGE_TYPE_GIF] = Button_GetCheck(hWnd);

			//摜PNG
			hWnd = GetDlgItem(hwndDlg, IDC_CHECK_TYPE_PNG);
			bEnableImageType[IMAGE_TYPE_PNG] = Button_GetCheck(hWnd);

			//摜TIFF
			hWnd = GetDlgItem(hwndDlg, IDC_CHECK_TYPE_TIFF);
			bEnableImageType[IMAGE_TYPE_TIFF] = Button_GetCheck(hWnd);

			EndDialog(hwndDlg, IDOK);
		}
		break;
	case IDCANCEL:
		EndDialog(hwndDlg, IDCANCEL);
		break;
	}
}

//摜_CAO
INT_PTR CALLBACK ImageCondDialogProc(HWND hwndDlg,
							UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg) {
	case WM_INITDIALOG:
		//摜_CAO
		OnInitImageCondDialog(hwndDlg);
		break;
	case WM_COMMAND:
		//摜_CAOER}h
		OnCommandImageCondDialog(hwndDlg, wParam, lParam);
		break;
	}
	return 0;
}

//-----------------------------------------------------------------------

//XN[Z[o[ݒ_CAO
void	OnInitScreenSaverConfigureDialog(HWND hDlg)
{
	HWND	hWnd;
	LPARAM	lParam;
	int		i;

	//ݒt@Cǂݍ
	LoadConfig();

	//XVԊu\
	SetDlgItemInt(hDlg, IDC_EDIT_INTERVAL, (UINT)nInterval, FALSE);

	//XVԊũXsRg[͈̔͂ݒ
	hWnd = GetDlgItem(hDlg, IDC_SPIN_INTERVAL);
	lParam = (LPARAM)MAKELONG(3600, 1);
	SendMessage(hWnd, UDM_SETRANGE, (WPARAM)0, lParam);

	//̃TCYŕ\邩
	hWnd = GetDlgItem(hDlg, IDC_CHECK_ORG_SIZE);
	Button_SetCheck(hWnd, nOrgSize);

	//c̔䗦ێ邩
	hWnd = GetDlgItem(hDlg, IDC_CHECK_ORG_RATIO);
	Button_SetCheck(hWnd, nOrgSizeRatio);

	//tF[h\̗L^
	hWnd = GetDlgItem(hDlg, IDC_CHECK_ALPHA_BLEND);
	Button_SetCheck(hWnd, bAlphaBlend);

	//ʂƂɉ摜\
	hWnd = GetDlgItem(hDlg, IDC_CHECK_SEPARATE_MONITOR);
	Button_SetCheck(hWnd, nSeparateMonitor);

	//摜\
	hWnd = GetDlgItem(hDlg, IDC_CHECK_SAME_PICTURE);
	Button_SetCheck(hWnd, nSamePicture);

	//摜ŕ\
	hWnd = GetDlgItem(hDlg, IDC_CHECK_SLIDE);
	Button_SetCheck(hWnd, bSlidePicture);

	//摜t@C\
	hWnd = GetDlgItem(hDlg, IDC_CHECK_DISP_FILENAME);
	Button_SetCheck(hWnd, bShowFileName);

	//Xgɉ摜t@CZbg
	hWnd = GetDlgItem(hDlg, IDC_LIST_PICTURE_FILE);
	for (i = 0; i < nConfPictureFileNum; i++) {
		ListBox_InsertString(hWnd, i, szCnfPictureFiles[i]);
	}
}

//XN[Z[o[ݒ_CAOEOKR}h
void	OnOkScreenSaverConfigureDialog(HWND hDlg)
{
	UINT	uiVal;
	BOOL	bStatus;
	HWND	hWnd;
	int		i, count;

	//XVԊuZbg
	uiVal = GetDlgItemInt(hDlg, IDC_EDIT_INTERVAL, &bStatus, FALSE);
	if (!bStatus || (uiVal <= 0 || 3600 < uiVal)) {
		SetDlgItemInt(hDlg, IDC_EDIT_INTERVAL, (UINT)nInterval, FALSE);
		return;
	}
	if (nInterval != uiVal) {
		nInterval = uiVal;
		bIntervalChangeFlag = TRUE;
	}
	if ((nInterval * 1000) < (100 / BlendPitch) * nBlendInterval) {
		BlendPitch = (nInterval * 1000) / nBlendInterval;
	}

	//̃TCYŕ\邩
	hWnd = GetDlgItem(hDlg, IDC_CHECK_ORG_SIZE);
	nOrgSize = Button_GetCheck(hWnd);

	//c̔䗦ێ邩
	hWnd = GetDlgItem(hDlg, IDC_CHECK_ORG_RATIO);
	nOrgSizeRatio = Button_GetCheck(hWnd);

	//tF[h\̗L^
	hWnd = GetDlgItem(hDlg, IDC_CHECK_ALPHA_BLEND);
	bAlphaBlend = (Button_GetCheck(hWnd) == 1 ? TRUE : FALSE);

	//ʂƂɉ摜\
	hWnd = GetDlgItem(hDlg, IDC_CHECK_SEPARATE_MONITOR);
	nSeparateMonitor = Button_GetCheck(hWnd);

	//摜\
	hWnd = GetDlgItem(hDlg, IDC_CHECK_SAME_PICTURE);
	nSamePicture = Button_GetCheck(hWnd);

	//摜ŕ\
	hWnd = GetDlgItem(hDlg, IDC_CHECK_SLIDE);
	bSlidePicture = (Button_GetCheck(hWnd) == 1 ? TRUE : FALSE);

	//摜t@C\
	hWnd = GetDlgItem(hDlg, IDC_CHECK_DISP_FILENAME);
	bShowFileName = (Button_GetCheck(hWnd) == 1 ? TRUE : FALSE);

	//Xg摜t@C擾
	hWnd = GetDlgItem(hDlg, IDC_LIST_PICTURE_FILE);
	count = ListBox_GetCount(hWnd);

	memset(szCnfPictureFiles, 0, sizeof(szCnfPictureFiles));
	nConfPictureFileNum = 0;

	for (i = 0; i < count; i++) {
		//t@C擾
		ListBox_GetText(hWnd, i, szCnfPictureFiles[i]);
		nConfPictureFileNum++;
	}
	//ݒt@Cۑ
	SaveConfig();

	EndDialog(hDlg, IDOK);
}

//XN[Z[o[ݒ_CAOEt@Cǉ
void	OnBtnAddFileScreenSaverConfigureDialog(HWND hDlg)
{
	char			buf[256];
	char			fname[MAX_PATH * 256];
	char			strTitle[256];
	OPENFILENAME	ofn;

	buf[0] = '\0';
	fname[0] = '\0';

	LoadString((HINSTANCE)GetModuleHandle(NULL), IDS_STR_SELECT_IMAGE_FILE, strTitle, sizeof(strTitle)-1);

	memset(&ofn, 0, sizeof(OPENFILENAME));

	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hDlg;
	ofn.lpstrFilter = IMAGE_FILE_FILTER;
	ofn.nFilterIndex = nFilterIdx;
	ofn.lpstrInitialDir = szDefaultDir;
	ofn.lpstrFile = fname;
	ofn.lpstrFileTitle = buf;
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_EXPLORER | OFN_ALLOWMULTISELECT;
	ofn.lpstrDefExt = "bmp";
	ofn.lpstrTitle = strTitle;

	if (GetOpenFileName(&ofn)) {
		CImage	Image;
		TCHAR	dir[MAX_PATH];
		TCHAR	path[MAX_PATH];
		TCHAR	*pf;
		HWND	hWnd;
		int		idx, count;

		hWnd = GetDlgItem(hDlg, IDC_LIST_PICTURE_FILE);

		count = ListBox_GetCount(hWnd);

		if (count >= MAX_PICTURE_FILES) {
			return;
		}
		idx = (int)ListBox_GetCurSel(hWnd);
		if (idx < 0) {
			idx = count;
		}
		nFilterIdx = ofn.nFilterIndex;

		if ((pf = strchr(fname, '\0')) || (pf = strchr(fname, ' '))) {
			TCHAR	*pFname;
			TCHAR	sepa = *pf;

			*pf = '\0';
			if (GetFileAttributes(fname) & FILE_ATTRIBUTE_DIRECTORY) { //fBNg̏ꍇ
				strncpy_s(dir, sizeof(dir), fname, sizeof(dir) - 1);

				pFname = pf + 1;
				while(*pFname) {
					if ((pf = strchr(pFname, sepa))) {
						*pf = '\0';
					}
					sprintf_s(path, sizeof(path), "%s\\%s", dir, pFname);

					//C[Wt@CƂă[hł邩`FbN
					if (Image.Load(path) == 0) {
						Image.Destroy();

						//C[Wt@CƂă[hł邩`FbNđ}
						SetFileToList(hWnd, idx, path, FALSE);
					}
					pFname = pf + 1;
				}
				strncpy_s(szDefaultDir, sizeof(szDefaultDir), dir, sizeof(szDefaultDir) - 1);
			} else {
				if (GetFullPathName(fname, sizeof(dir) / sizeof(TCHAR), dir, &pf) > 0) {
					if (pf) {
						*pf = NULL;
					}
					strncpy_s(szDefaultDir, sizeof(szDefaultDir), dir, sizeof(szDefaultDir) - 1);
				}
				//C[Wt@CƂă[hł邩`FbN
				if (Image.Load(fname) == 0) {
					Image.Destroy();

					//C[Wt@CƂă[hł邩`FbNđ}
					SetFileToList(hWnd, idx, fname, FALSE);
				}
			}
		}
	}
}

//XN[Z[o[ݒ_CAOEtH_ǉ
void	OnBtnAddDirScreenSaverConfigureDialog(HWND hDlg)
{
	HWND	hWnd;
	int		idx, count;

	//XgBOX
	hWnd = GetDlgItem(hDlg, IDC_LIST_PICTURE_FILE);

	count = ListBox_GetCount(hWnd);

	if (count >= MAX_PICTURE_FILES) {
		return;
	}
	idx = (int)ListBox_GetCurSel(hWnd);
	if (idx < 0) {
		idx = count;
	}

	BROWSEINFO		inf;
	ITEMIDLIST		*pItmList = NULL;
	char			szFolder[MAX_PATH];
	char			strTitle[256];

	LoadString((HINSTANCE)GetModuleHandle(NULL), IDS_STR_SELECT_IMAGE_FOLDER, strTitle, sizeof(strTitle)-1);

	inf.hwndOwner      = hDlg;
	inf.pidlRoot       = NULL;
	inf.pszDisplayName = szFolder;
	inf.lpszTitle      = strTitle;
	inf.ulFlags        = BIF_RETURNONLYFSDIRS;
	inf.lpfn		   = BrowseCallbackProc;
	inf.lParam         = (LPARAM)szDefaultDir;
	inf.iImage         = 0;

	//tH_I_CAO
	pItmList = SHBrowseForFolder(&inf);
	if (pItmList) {
		//tH_擾
		if (SHGetPathFromIDList(pItmList, szFolder)) {
			//ITEMIDLIST̉
			CoTaskMemFree(pItmList);

			//tH_摜t@C̃Xgǉ
			SetDirToList(hWnd, idx, szFolder, NULL, FALSE);

			strncpy_s(szDefaultDir, sizeof(szDefaultDir), szFolder, sizeof(szDefaultDir) - 1);
			szDefaultDir[sizeof(szDefaultDir) - 1] = '\0';
		}
	}
}

//XN[Z[o[ݒ_CAOEҏW
void	OnBtnEditScreenSaverConfigureDialog(HWND hDlg)
{
	HWND	hWnd;
	int		idx;

	//XgBOX
	hWnd = GetDlgItem(hDlg, IDC_LIST_PICTURE_FILE);

	idx = (int)ListBox_GetCurSel(hWnd);
	if (idx < 0) {
		return;
	}
	//Ώۃt@C擾
	ListBox_GetText(hWnd, idx, szEditFile);

	LRESULT res = DialogBox(hMainInstance, MAKEINTRESOURCE(IDD_EDIT_DLG), hDlg, EditDialogProc);

	switch ((UINT)res) {
	case IDOK:
		//XgɃZbg
		SetItemToList(hWnd, idx, szEditFile, FALSE);
		break;
	case IDCANCEL:
		break;
	case IDC_BUTTON_UPDATE:
		//XgɃZbg
		SetItemToList(hWnd, idx, szEditFile, TRUE);
		break;
	}
}

//XN[Z[o[ݒ_CAOE폜
void	OnBtnDelScreenSaverConfigureDialog(HWND hDlg)
{
	HWND	hWnd;
	int		idx, count;
	char	fname[MAX_PATH];

	//Xg摜t@C폜
	hWnd = GetDlgItem(hDlg, IDC_LIST_PICTURE_FILE);
	idx = (int)ListBox_GetCurSel(hWnd);
	if (idx < 0) {
		return;
	}
	//Ώۃt@C擾
	ListBox_GetText(hWnd, idx, fname);

	//摜t@CXg폜
	ListBox_DeleteString(hWnd, idx);

	count = ListBox_GetCount(hWnd);

	if (idx >= count) {
		idx--;
	}
	if (idx >= 0) {
		ListBox_SetCurSel(hWnd, idx);
	}
}

//XN[Z[o[ݒ_CAOES폜
void	OnBtnClearScreenSaverConfigureDialog(HWND hDlg)
{
	HWND	hWnd;

	hWnd = GetDlgItem(hDlg, IDC_LIST_PICTURE_FILE);

	ListBox_ResetContent(hWnd);
}

//XN[Z[o[ݒ_CAOEtH_[摜ݒ菈
void	OnBtnFolderImageCondScreenSaverConfigureDialog(HWND hDlg)
{
	LRESULT res = DialogBox(hMainInstance, MAKEINTRESOURCE(IDD_IMAGE_COND_DLG), hDlg, ImageCondDialogProc);

	switch ((UINT)res) {
	case IDOK:
		break;
	case IDCANCEL:
		break;
	}
}

//XN[Z[o[ݒ_CAOEt@CtHgI
void	OnBtnFnameFontSelScreenSaverConfigureDialog(HWND hDlg)
{
	CHOOSEFONT	cf;
	HDC			hDC;

	memset(&cf, 0, sizeof(cf));

	hDC= GetDC(hDlg);

	cf.lStructSize = sizeof(cf); 
	cf.hDC = hDC;
	cf.hwndOwner = hDlg;
	cf.lpLogFont =&lfFileNameFont;
	cf.Flags = CF_SCREENFONTS | CF_EFFECTS | CF_INITTOLOGFONTSTRUCT;
	cf.rgbColors = FontColor; 
	cf.nFontType = SCREEN_FONTTYPE;

	if (ChooseFont(&cf)) {
		if (lfFileNameFont.lfHeight < 0) {
			lfFileNameFont.lfHeight *= -1;
		}
		FontColor = cf.rgbColors;
	}
	ReleaseDC(hDlg, hDC);
}

//XN[Z[o[ݒ_CAOER}h
void	OnCommandScreenSaverConfigureDialog(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
	UINT	uiCmd = (UINT)LOWORD(wParam);

	switch (uiCmd) {
	case IDOK:
		//摜_CAOEOKR}h
		OnOkScreenSaverConfigureDialog(hDlg);
		break;
	case IDCANCEL:
		EndDialog(hDlg, IDCANCEL);
		break;
	case IDC_BTN_ADD_FILE:
		//XN[Z[o[ݒ_CAOEt@Cǉ
		OnBtnAddFileScreenSaverConfigureDialog(hDlg);
		break;
	case IDC_BTN_ADD_DIR:
		//XN[Z[o[ݒ_CAOEtH_ǉ
		OnBtnAddDirScreenSaverConfigureDialog(hDlg);
		break;
	case IDC_BTN_EDIT:
		//XN[Z[o[ݒ_CAOEҏW
		OnBtnEditScreenSaverConfigureDialog(hDlg);
		break;
	case IDC_BTN_DEL:
		//XN[Z[o[ݒ_CAOE폜
		OnBtnDelScreenSaverConfigureDialog(hDlg);
		break;
	case IDC_BTN_CLEAR:
		//XN[Z[o[ݒ_CAOES폜
		OnBtnClearScreenSaverConfigureDialog(hDlg);
		break;
	case IDC_BUTTON_FOLDER_IMG_COND:
		//XN[Z[o[ݒ_CAOEtH_[摜ݒ菈
		OnBtnFolderImageCondScreenSaverConfigureDialog(hDlg);
		break;
	case IDC_BUTTON_FNAME_FONT_SEL:
		//XN[Z[o[ݒ_CAOEt@CtHgI
		OnBtnFnameFontSelScreenSaverConfigureDialog(hDlg);
		break;
	default:
		break;
	}
}

//XN[Z[o[ݒ_CAOEHELP
void	OnHelpScreenSaverConfigureDialog(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
	HELPINFO *pHelpInfo = (LPHELPINFO)lParam;

	if (pHelpInfo->iContextType == HELPINFO_WINDOW) {
		switch (pHelpInfo->iCtrlId) {
		case IDC_EDIT_INTERVAL:				//XVԊu(GfBbgRg[)
		case IDC_SPIN_INTERVAL:				//XVԊu(Xs{^)
			break;
		case IDC_CHECK_ORG_RATIO:			//̉摜̏cێ(`FbNBOX)
			break;
		case IDC_CHECK_ALPHA_BLEND:			//tF[h\(`FbNBOX)
			break;
		case IDC_CHECK_SEPARATE_MONITOR:	//ʂƂɂP̉摜\(`FbNBOX)
			break;
		case IDC_CHECK_SAME_PICTURE:		//摜\(`FbNBOX)
			break;
		case IDC_CHECK_SLIDE:				//摜ŕ\(`FbNBOX)
			break;
		case IDC_BTN_ADD_FILE:				//t@Cǉ({^)
			break;
		case IDC_BTN_ADD_DIR:				//tH_ǉ({^)
			break;
		case IDC_BTN_EDIT:					//ҏW({^)
			break;
		case IDC_BTN_DEL:					//폜({^)
			break;
		case IDC_BTN_CLEAR:					//ׂč폜({^)
			break;
		case IDC_LIST_PICTURE_FILE:			//摜t@Cꗗ(Xg)
			break;
		case IDOK:							//OK({^)
			break;
		case IDCANCEL:						//LZ({^)
			break;
		default:
			break;
		}
	}
}

//XN[Z[o[ݒ_CAO
BOOL	WINAPI ScreenSaverConfigureDialog(HWND hDlg, UINT nMsg, WPARAM wParam, LPARAM lParam)
{
	switch (nMsg) {
	case WM_INITDIALOG:
		//XN[Z[o[ݒ_CAO
		OnInitScreenSaverConfigureDialog(hDlg);
		break;
	case WM_COMMAND:
		//摜_CAOER}h
		OnCommandScreenSaverConfigureDialog(hDlg, wParam, lParam);
		break;
	case WM_HELP:
		//XN[Z[o[ݒ_CAOEHELP
		OnHelpScreenSaverConfigureDialog(hDlg, wParam, lParam);
		break;
	default:
		return FALSE;
		break;
	}
	return TRUE;
} 

BOOL	WINAPI RegisterDialogClasses(HANDLE hInst)
{
    DialogBox((HINSTANCE)hInst, MAKEINTRESOURCE(IDD_CONFIG_DIALOG), 0, ScreenSaverConfigureDialog);

	return TRUE;
}
