﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace SeekCamMon {
	public partial class FormSetting : Form {

		public CGlobal.stSettings m_Settings;

		public FormSetting() {
			InitializeComponent();
			int	i;

			m_Settings.TempUnit = "C";
			m_Settings.TrendRangeAuto = true;
			m_Settings.TrendRangeMax = 0.0;
			m_Settings.TrendRangeMin = 0.0;
			m_Settings.DataSaveDir = "";
			m_Settings.TempFileName = "SeekCamMon." + CGlobal.TEMP_FILE_EXT;
			m_Settings.VideoFileName = "SeekCamMon." + CGlobal.VIDEO_FILE_EXT;

			m_Settings.AlarmTemp = new CGlobal.stAlarm[CGlobal.PNT_IDX_NUM];

			for (i = 0; i < CGlobal.PNT_IDX_NUM; i++) {
				m_Settings.AlarmTemp[i].AlarmEnable = false;
				m_Settings.AlarmTemp[i].AlarmTemp = 0.0;
				m_Settings.AlarmTemp[i].AlarmUpLow = CGlobal.ALARM_TYPE_OVER;
				m_Settings.AlarmTemp[i].AlarmHold = CGlobal.ALARM_STATUS_CLEAR;
				m_Settings.AlarmTemp[i].AlarmBeep = false;
			}
		}

		private void FormSetting_Load(object sender, EventArgs e) {
			lbl_TrendMaxUnit.Text = m_Settings.TempUnit;
			lbl_TrendMinUnit.Text = m_Settings.TempUnit;
			lbl_AlarmMaxTempUnit.Text = m_Settings.TempUnit;
			lbl_AlarmMinTempUnit.Text = m_Settings.TempUnit;
			lbl_AlarmPnt1Unit.Text = m_Settings.TempUnit;

			chk_TrendAuto.Checked = m_Settings.TrendRangeAuto;
			num_TrendRangeMax.Value = Convert.ToDecimal(m_Settings.TrendRangeMax);
			num_TrendRangeMin.Value = Convert.ToDecimal(m_Settings.TrendRangeMin);

			chk_AlarmMaxTemp.Checked = m_Settings.AlarmTemp[CGlobal.PNT_MAX_IDX].AlarmEnable;
			num_AlarmMaxTemp.Value = Convert.ToDecimal(m_Settings.AlarmTemp[CGlobal.PNT_MAX_IDX].AlarmTemp);
			cmb_AlarmMaxUpLow.SelectedIndex = m_Settings.AlarmTemp[CGlobal.PNT_MAX_IDX].AlarmUpLow;
			cmb_AlarmMaxHold.SelectedIndex = m_Settings.AlarmTemp[CGlobal.PNT_MAX_IDX].AlarmHold;
			chk_AlarmMaxBeep.Checked = m_Settings.AlarmTemp[CGlobal.PNT_MAX_IDX].AlarmBeep;

			chk_AlarmMinTemp.Checked = m_Settings.AlarmTemp[CGlobal.PNT_MIN_IDX].AlarmEnable;
			num_AlarmMinTemp.Value = Convert.ToDecimal(m_Settings.AlarmTemp[CGlobal.PNT_MIN_IDX].AlarmTemp);
			cmb_AlarmMinUpLow.SelectedIndex = m_Settings.AlarmTemp[CGlobal.PNT_MIN_IDX].AlarmUpLow;
			cmb_AlarmMinHold.SelectedIndex = m_Settings.AlarmTemp[CGlobal.PNT_MIN_IDX].AlarmHold;
			chk_AlarmMinBeep.Checked = m_Settings.AlarmTemp[CGlobal.PNT_MIN_IDX].AlarmBeep;

			chk_AlarmPnt1.Checked = m_Settings.AlarmTemp[CGlobal.PNT_PNT1_IDX].AlarmEnable;
			num_AlarmPnt1.Value = Convert.ToDecimal(m_Settings.AlarmTemp[CGlobal.PNT_PNT1_IDX].AlarmTemp);
			cmb_AlarmPnt1UpLow.SelectedIndex = m_Settings.AlarmTemp[CGlobal.PNT_PNT1_IDX].AlarmUpLow;
			cmb_AlarmPnt1Hold.SelectedIndex = m_Settings.AlarmTemp[CGlobal.PNT_PNT1_IDX].AlarmHold;
			chk_AlarmPnt1Beep.Checked = m_Settings.AlarmTemp[CGlobal.PNT_PNT1_IDX].AlarmBeep;

			chk_AlarmPnt2.Checked = m_Settings.AlarmTemp[CGlobal.PNT_PNT2_IDX].AlarmEnable;
			num_AlarmPnt2.Value = Convert.ToDecimal(m_Settings.AlarmTemp[CGlobal.PNT_PNT2_IDX].AlarmTemp);
			cmb_AlarmPnt2UpLow.SelectedIndex = m_Settings.AlarmTemp[CGlobal.PNT_PNT2_IDX].AlarmUpLow;
			cmb_AlarmPnt2Hold.SelectedIndex = m_Settings.AlarmTemp[CGlobal.PNT_PNT2_IDX].AlarmHold;
			chk_AlarmPnt2Beep.Checked = m_Settings.AlarmTemp[CGlobal.PNT_PNT2_IDX].AlarmBeep;

			chk_AlarmPnt3.Checked = m_Settings.AlarmTemp[CGlobal.PNT_PNT3_IDX].AlarmEnable;
			num_AlarmPnt3.Value = Convert.ToDecimal(m_Settings.AlarmTemp[CGlobal.PNT_PNT3_IDX].AlarmTemp);
			cmb_AlarmPnt3UpLow.SelectedIndex = m_Settings.AlarmTemp[CGlobal.PNT_PNT3_IDX].AlarmUpLow;
			cmb_AlarmPnt3Hold.SelectedIndex = m_Settings.AlarmTemp[CGlobal.PNT_PNT3_IDX].AlarmHold;
			chk_AlarmPnt3Beep.Checked = m_Settings.AlarmTemp[CGlobal.PNT_PNT3_IDX].AlarmBeep;

			txt_SaveDir.Text = m_Settings.DataSaveDir;
			txt_TempFile.Text = m_Settings.TempFileName;
			txt_VideoFile.Text = m_Settings.VideoFileName;

			lbl_VideoFile.Text = CGlobal.VIDEO_FILE_TYPE;
			lbl_TempFile.Text = CGlobal.TEMP_FILE_TYPE;
		}

		private void btn_Apply_Click(object sender, EventArgs e) {
			if (!chk_TrendAuto.Checked) { 
				if (num_TrendRangeMax.Value <= num_TrendRangeMin.Value) {
					MessageBox.Show("Trend Range Max must be greater than Trend Range Min");
					return;
				}
			}
			m_Settings.TrendRangeAuto = chk_TrendAuto.Checked;
			m_Settings.TrendRangeMax = Decimal.ToDouble(num_TrendRangeMax.Value);
			m_Settings.TrendRangeMin = Decimal.ToDouble(num_TrendRangeMin.Value);

			m_Settings.AlarmTemp[CGlobal.PNT_MAX_IDX].AlarmEnable = chk_AlarmMaxTemp.Checked;
			m_Settings.AlarmTemp[CGlobal.PNT_MAX_IDX].AlarmTemp = Decimal.ToDouble(num_AlarmMaxTemp.Value);
			m_Settings.AlarmTemp[CGlobal.PNT_MAX_IDX].AlarmUpLow = cmb_AlarmMaxUpLow.SelectedIndex;
			m_Settings.AlarmTemp[CGlobal.PNT_MAX_IDX].AlarmHold = cmb_AlarmMaxHold.SelectedIndex;
			m_Settings.AlarmTemp[CGlobal.PNT_MAX_IDX].AlarmBeep = chk_AlarmMaxBeep.Checked;

			m_Settings.AlarmTemp[CGlobal.PNT_MIN_IDX].AlarmEnable = chk_AlarmMinTemp.Checked;
			m_Settings.AlarmTemp[CGlobal.PNT_MIN_IDX].AlarmTemp = Decimal.ToDouble(num_AlarmMinTemp.Value);
			m_Settings.AlarmTemp[CGlobal.PNT_MIN_IDX].AlarmUpLow = cmb_AlarmMinUpLow.SelectedIndex;
			m_Settings.AlarmTemp[CGlobal.PNT_MIN_IDX].AlarmHold = cmb_AlarmMinHold.SelectedIndex;
			m_Settings.AlarmTemp[CGlobal.PNT_MIN_IDX].AlarmBeep = chk_AlarmMinBeep.Checked;

			m_Settings.AlarmTemp[CGlobal.PNT_PNT1_IDX].AlarmEnable = chk_AlarmPnt1.Checked;
			m_Settings.AlarmTemp[CGlobal.PNT_PNT1_IDX].AlarmTemp = Decimal.ToDouble(num_AlarmPnt1.Value);
			m_Settings.AlarmTemp[CGlobal.PNT_PNT1_IDX].AlarmUpLow = cmb_AlarmPnt1UpLow.SelectedIndex;
			m_Settings.AlarmTemp[CGlobal.PNT_PNT1_IDX].AlarmHold = cmb_AlarmPnt1Hold.SelectedIndex;
			m_Settings.AlarmTemp[CGlobal.PNT_PNT1_IDX].AlarmBeep = chk_AlarmPnt1Beep.Checked;

			m_Settings.AlarmTemp[CGlobal.PNT_PNT2_IDX].AlarmEnable = chk_AlarmPnt2.Checked;
			m_Settings.AlarmTemp[CGlobal.PNT_PNT2_IDX].AlarmTemp = Decimal.ToDouble(num_AlarmPnt2.Value);
			m_Settings.AlarmTemp[CGlobal.PNT_PNT2_IDX].AlarmUpLow = cmb_AlarmPnt2UpLow.SelectedIndex;
			m_Settings.AlarmTemp[CGlobal.PNT_PNT2_IDX].AlarmHold = cmb_AlarmPnt2Hold.SelectedIndex;
			m_Settings.AlarmTemp[CGlobal.PNT_PNT2_IDX].AlarmBeep = chk_AlarmPnt2Beep.Checked;

			m_Settings.AlarmTemp[CGlobal.PNT_PNT3_IDX].AlarmEnable = chk_AlarmPnt3.Checked;
			m_Settings.AlarmTemp[CGlobal.PNT_PNT3_IDX].AlarmTemp = Decimal.ToDouble(num_AlarmPnt3.Value);
			m_Settings.AlarmTemp[CGlobal.PNT_PNT3_IDX].AlarmUpLow = cmb_AlarmPnt3UpLow.SelectedIndex;
			m_Settings.AlarmTemp[CGlobal.PNT_PNT3_IDX].AlarmHold = cmb_AlarmPnt3Hold.SelectedIndex;
			m_Settings.AlarmTemp[CGlobal.PNT_PNT3_IDX].AlarmBeep = chk_AlarmPnt3Beep.Checked;

			m_Settings.DataSaveDir = txt_SaveDir.Text;
			m_Settings.TempFileName = txt_TempFile.Text;
			m_Settings.VideoFileName = txt_VideoFile.Text;

			this.DialogResult = DialogResult.OK;
			Close();
		}

		private void btn_Cancel_Click(object sender, EventArgs e) {
			this.DialogResult = DialogResult.Cancel;
			Close();
		}

		private void btn_SaveFolderRef_Click(object sender, EventArgs e) {
            FolderBrowserDialog fbd = new FolderBrowserDialog();

            fbd.Description = "Select capture image save folder.\r\n" +
                                "Current :  " + m_Settings.DataSaveDir;
            fbd.RootFolder = Environment.SpecialFolder.Desktop;
            fbd.SelectedPath = m_Settings.DataSaveDir;
            fbd.ShowNewFolderButton = true;

            if (fbd.ShowDialog(this) == DialogResult.OK)
            {
                txt_SaveDir.Text = fbd.SelectedPath;
            }
		}

		private void btn_TempFileRef_Click(object sender, EventArgs e) {
			SaveFileDialog sfd = new SaveFileDialog();

			sfd.FileName = "SeekCamMon." + CGlobal.TEMP_FILE_EXT;
			sfd.InitialDirectory = m_Settings.DataSaveDir;
			sfd.Filter = CGlobal.TEMP_FILE_TYPE + "(*." + CGlobal.TEMP_FILE_EXT + ")|*." + 
													CGlobal.TEMP_FILE_EXT + "|All Files(*.*)|*.*";
			sfd.FilterIndex = 1;
			sfd.Title = "Select " + CGlobal.TEMP_FILE_TYPE;
			sfd.OverwritePrompt = true;
			sfd.CheckPathExists = true;
			sfd.RestoreDirectory = true;
			if (sfd.ShowDialog() == DialogResult.OK) {
				txt_TempFile.Text = System.IO.Path.GetFileName(sfd.FileName);
			}
		}

		private void btn_VideoFileRef_Click(object sender, EventArgs e) {
			SaveFileDialog sfd = new SaveFileDialog();

			sfd.FileName = "SeekCamMon." + CGlobal.VIDEO_FILE_EXT;
			sfd.InitialDirectory = m_Settings.DataSaveDir;
			sfd.Filter =  CGlobal.VIDEO_FILE_TYPE + "(*." + CGlobal.VIDEO_FILE_EXT + ")|*." + 
													CGlobal.VIDEO_FILE_EXT + "|All Files(*.*)|*.*";
			sfd.FilterIndex = 1;
			sfd.Title = "Select " + CGlobal.VIDEO_FILE_TYPE;
			sfd.OverwritePrompt = true;
			sfd.CheckPathExists = true;
			sfd.RestoreDirectory = true;
			if (sfd.ShowDialog() == DialogResult.OK) {
				txt_VideoFile.Text = System.IO.Path.GetFileName(sfd.FileName);
			}
		}
	}
}
